SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Sequence structure for product_bundles_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS product_bundles_seq;
CREATE SEQUENCE product_bundles_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for product_categories_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS product_categories_seq;
CREATE SEQUENCE product_categories_seq START WITH 9 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for vendors_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS vendors_seq;
CREATE SEQUENCE vendors_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for customers_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS customers_seq;
CREATE SEQUENCE customers_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for warehouses_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS warehouses_seq;
CREATE SEQUENCE warehouses_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for order_statuses_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS order_statuses_seq;
CREATE SEQUENCE order_statuses_seq START WITH 8 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for transaction_types_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS transaction_types_seq;
CREATE SEQUENCE transaction_types_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for products_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS products_seq;
CREATE SEQUENCE products_seq START WITH 23 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for bundle_items_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS bundle_items_seq;
CREATE SEQUENCE bundle_items_seq START WITH 5 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for contacts_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS contacts_seq;
CREATE SEQUENCE contacts_seq START WITH 19 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for inbound_orders_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS inbound_orders_seq;
CREATE SEQUENCE inbound_orders_seq START WITH 67 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for product_variants_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS product_variants_seq;
CREATE SEQUENCE product_variants_seq START WITH 5 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for inbound_order_items_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS inbound_order_items_seq;
CREATE SEQUENCE inbound_order_items_seq START WITH 142 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for inventory_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS inventory_seq;
CREATE SEQUENCE inventory_seq START WITH 61 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for inventory_transactions_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS inventory_transactions_seq;
CREATE SEQUENCE inventory_transactions_seq START WITH 181 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for order_tracking_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS order_tracking_seq;
CREATE SEQUENCE order_tracking_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for outbound_order_items_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS outbound_order_items_seq;
CREATE SEQUENCE outbound_order_items_seq START WITH 159 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for outbound_orders_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS outbound_orders_seq;
CREATE SEQUENCE outbound_orders_seq START WITH 75 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for product_offers_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS product_offers_seq;
CREATE SEQUENCE product_offers_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for sec_groups_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS sec_groups_seq;
CREATE SEQUENCE sec_groups_seq START WITH 2 INCREMENT BY 1;

-- ----------------------------
-- Table structure for product_bundles
-- ----------------------------
CREATE TABLE `product_bundles`  (
  `bundle_id` int NOT NULL AUTO_INCREMENT,
  `bundle_name` varchar(255) NOT NULL,
  `sku` varchar(100) NULL DEFAULT NULL,
  `barcode` varchar(50) NULL DEFAULT NULL,
  `description` text NULL,
  `bundle_price` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`bundle_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3;

-- ----------------------------
-- Records of product_bundles
-- ----------------------------
INSERT INTO `product_bundles` VALUES (1,'Bundle 1',NULL,'223456789001','Bundle containing Product A and Product B',1500.00,'2024-11-11 14:15:49','2025-03-17 13:30:01'), (2,'Bundle 2',NULL,'223456789002','Bundle containing Product B and Product C',450.00,'2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for table `product_categories`
-- ----------------------------
CREATE TABLE `product_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) NOT NULL,
  `description` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9;

-- ----------------------------
-- Dumping data for table `product_categories`
-- ----------------------------
INSERT INTO `product_categories` VALUES (1,'Electronics','Electronic devices and gadgets','2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,'Furniture','Various types of furniture','2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,'Tools','Tools for construction and repair','2024-11-11 14:15:49','2024-11-11 14:15:49'), (4,'Kitchenware','Kitchen appliances and utensils','2024-11-11 14:15:49','2024-11-11 14:15:49'), (5,'Sports','Sports and fitness equipment','2024-11-11 14:15:49','2024-11-11 14:15:49'), (6,'Toys','Toys for children of various ages','2024-11-11 14:15:49','2024-11-11 14:15:49'), (7,'Office Supplies','Office and stationery products','2024-11-11 14:15:49','2024-11-11 14:15:49'), (8,'Bundles','Multiple Items','2025-03-18 14:48:58','2025-03-18 14:48:58');


-- ----------------------------
-- Table structure for vendors
-- ----------------------------
CREATE TABLE `vendors`  (
  `vendor_id` int NOT NULL AUTO_INCREMENT,
  `vendor_name` varchar(255) NOT NULL,
  `contact_info` varchar(255) NULL DEFAULT NULL,
  `address` text NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`vendor_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4;

-- ----------------------------
-- Records of vendors
-- ----------------------------
INSERT INTO `vendors` VALUES (1,'Vendor Alpha','alpha@example.com','123 Alpha St, City A','2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,'Vendor Beta','beta@example.com','456 Beta St, City B','2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,'Vendor Gamma','gamma@example.com','789 Gamma St, City C','2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for customers
-- ----------------------------
CREATE TABLE `customers`  (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(255) NOT NULL,
  `contact_info` varchar(255) NULL DEFAULT NULL,
  `email` varchar(100) NULL DEFAULT NULL,
  `phone` varchar(50) NULL DEFAULT NULL,
  `address` text NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11;

-- ----------------------------
-- Records of customers
-- ----------------------------
INSERT INTO `customers` VALUES (1,'John Doe','contact_john@example.com','john@example.com','123-456-7890','123 Maple St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,'Jane Smith','contact_jane@example.com','jane@example.com','234-567-8901','456 Oak St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,'Alice Johnson','contact_alice@example.com','alice@example.com','345-678-9012','789 Pine St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (4,'Robert Brown','contact_robert@example.com','robert@example.com','456-789-0123','321 Elm St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (5,'Linda White','contact_linda@example.com','linda@example.com','567-890-1234','654 Birch St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (6,'Michael Harris','contact_michael@example.com','michael@example.com','678-901-2345','987 Cedar St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (7,'Emily Clark','contact_emily@example.com','emily@example.com','789-012-3456','147 Palm St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (8,'James Lewis','contact_james@example.com','james@example.com','890-123-4567','258 Maple St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (9,'Patricia Hall','contact_patricia@example.com','patricia@example.com','901-234-5678','369 Pine St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49'), (10,'David Allen','contact_david@example.com','david@example.com','012-345-6789','963 Oak St, Springfield','2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for warehouses
-- ----------------------------
CREATE TABLE `warehouses`  (
  `warehouse_id` int NOT NULL AUTO_INCREMENT,
  `warehouse_name` varchar(255) NOT NULL,
  `location` varchar(255) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`warehouse_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4;

-- ----------------------------
-- Records of warehouses
-- ----------------------------
INSERT INTO `warehouses` VALUES (1,'Warehouse A','New York','2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,'Warehouse B','Los Angeles','2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,'Warehouse C','Chicago','2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for order_statuses
-- ----------------------------
CREATE TABLE `order_statuses`  (
  `status_id` int NOT NULL AUTO_INCREMENT,
  `status_name` varchar(50) NOT NULL,
  `description` text NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`status_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11;

-- ----------------------------
-- Records of order_statuses
-- ----------------------------
INSERT INTO `order_statuses` VALUES (1,'Draft','Order has been created','2024-11-11 14:15:49','2024-12-30 13:15:24'), (2,'Pending','Waitng approval and payment','2024-11-11 14:15:49','2024-12-30 13:21:26'), (3,'Invoiced','Order has been invoiced','2024-11-11 14:15:49','2024-12-30 13:20:16'), (4,'Shipped','Order has been shipped','2024-11-11 14:15:49','2024-12-30 13:19:51'), (5,'Delivered','Order has been delivered','2024-11-11 14:15:49','2024-12-30 13:19:20'), (6,'Canceled','Order has been canceled','2024-11-11 14:15:49','2024-12-30 13:22:13'), (7,'Completed','Order has been completed','2024-11-11 14:15:49','2024-12-30 13:21:26');

-- ----------------------------
-- Table structure for transaction_types
-- ----------------------------
CREATE TABLE `transaction_types`  (
  `type_id` int NOT NULL AUTO_INCREMENT,
  `type_name` varchar(50) NOT NULL,
  `description` text NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`type_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4;

-- ----------------------------
-- Records of transaction_types
-- ----------------------------
INSERT INTO `transaction_types` VALUES (1,'inbound','Stock inbound transaction','2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,'outbound','Stock outbound transaction','2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,'adjustment','Inventory adjustment transaction','2024-11-11 14:15:49','2024-11-11 14:15:49');


-- ----------------------------
-- Table structure for products
-- ----------------------------
CREATE TABLE `products`  (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) NOT NULL,
  `category_id` int NULL DEFAULT NULL,
  `sku` varchar(100) NULL DEFAULT NULL,
  `barcode` varchar(50) NULL DEFAULT NULL,
  `description` text NULL,
  `cost_price` decimal(10, 2) NULL DEFAULT NULL,
  `price_gain` decimal(10, 2) NULL DEFAULT NULL,
  `base_price` decimal(10, 2) NOT NULL,
  `dimension` varchar(50) NULL DEFAULT NULL,
  `weight` decimal(10, 2) NULL DEFAULT NULL,
  `brand` varchar(100) NULL DEFAULT NULL,
  `unit_type` varchar(50) NULL DEFAULT NULL,
  `minimum_quantity` int NULL DEFAULT 0,
  `image_bin` longblob NULL,
  `image_name` varchar(255) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_id`) USING BTREE,
  UNIQUE INDEX `sku`(`sku`) USING BTREE,
  INDEX `category_id`(`category_id`) USING BTREE,
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`category_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 23;

-- ----------------------------
-- Records of products
-- ----------------------------
INSERT INTO `products` VALUES (1,'Smartphone X',1,'SKU101','1111111111111','High-end smartphone with 128GB storage',350.00,100.00,700.00,'14x7x1 cm',0.18,'Brand A','unit',50,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (2,'Laptop Pro',1,'SKU102','1111111111112','Lightweight laptop with 512GB SSD',600.00,100.00,1200.00,'35x24x2 cm',1.30,'Brand B','unit',30,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (3,'Coffee Maker',4,'SKU103','1111111111113','Automatic coffee maker with timer',42.50,100.00,85.00,'25x15x15 cm',2.00,'Brand C','unit',10,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (4,'Office Chair',2,'SKU104','1111111111114','Ergonomic office chair with adjustable height',75.00,100.00,150.00,'50x50x100 cm',12.00,'Brand D','unit',20,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (5,'Running Shoes',5,'SKU105','1111111111115','Comfortable running shoes for all terrain',45.00,100.00,90.00,'30x15x10 cm',0.60,'Brand E','pair',15,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (6,'Desk Lamp',7,'SKU106','1111111111116','LED desk lamp with adjustable brightness',17.50,100.00,35.00,'20x20x40 cm',0.50,'Brand F','unit',20,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (7,'Toy Car',6,'SKU107','1111111111117','Remote-controlled toy car for ages 6+',10.00,100.00,20.00,'15x10x10 cm',0.30,'Brand G','unit',25,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (8,'Tablet S',1,'SKU108','1111111111118','10-inch tablet with 64GB storage',200.00,100.00,400.00,'25x15x0.8 cm',0.50,'Brand A','unit',40,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (9,'Microwave Oven',4,'SKU109','1111111111119','700W microwave with digital display',60.00,100.00,120.00,'45x30x25 cm',15.00,'Brand H','unit',30,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (10,'Screwdriver Set',3,'SKU110','1111111111120','10-piece screwdriver set with magnetic tips',12.50,100.00,25.00,'10x10x2 cm',0.80,'Brand I','set',20,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (11,'Water Bottle',5,'SKU111','1111111111121','1L insulated stainless steel water bottle',10.00,100.00,20.00,'10x10x30 cm',0.40,'Brand J','unit',50,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (12,'Backpack',5,'SKU112','1111111111122','Waterproof backpack for hiking and travel',30.00,100.00,60.00,'45x30x15 cm',1.20,'Brand K','unit',20,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (13,'Printer',7,'SKU113','1111111111123','Multifunction printer with WiFi',100.00,100.00,200.00,'40x40x30 cm',7.50,'Brand L','unit',50,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (14,'Vacuum Cleaner',4,'SKU114','1111111111124','Cordless vacuum cleaner',75.00,100.00,150.00,'20x20x110 cm',2.50,'Brand M','unit',40,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (15,'Basketball',5,'SKU115','1111111111125','Official size and weight basketball',12.50,100.00,25.00,'25x25x25 cm',0.60,'Brand N','unit',30,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (16,'Stapler',7,'SKU116','1111111111126','Heavy-duty stapler with 100-sheet capacity',7.50,100.00,15.00,'10x5x3 cm',0.20,'Brand O','unit',10,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (17,'Helmet',5,'SKU117','1111111111127','Cycling helmet with adjustable fit',22.50,100.00,45.00,'30x20x20 cm',0.30,'Brand P','unit',10,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (18,'Camera',1,'SKU118','1111111111128','Digital camera with 24MP resolution',150.00,100.00,300.00,'15x10x8 cm',0.40,'Brand Q','unit',10,NULL,NULL,'2024-11-11 14:15:49','2025-03-18 11:24:47'), (19,'Notebook',7,'SKU119','1111111111129','100-page spiral notebook',1.00,100.00,2.00,'15x20x1 cm',0.20,'Brand R','unit',100,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (20,'Drill Machine',3,'SKU120','1111111111130','Electric drill machine',25.00,100.00,50.00,'30x10x10 cm',1.50,'Brand S','unit',10,NULL,NULL,'2024-11-11 14:15:49','2025-02-03 14:08:56'), (21,'Bundle 1',8,NULL,'223456789001','Bundle containing Product A and Product B',1500.00,0.00,1500.00,NULL,NULL,NULL,NULL,1,NULL,NULL,'2025-03-18 14:44:14','2025-03-18 14:49:08'), (22,'Bundle 2',8,NULL,'223456789002','Bundle containing Product B and Product C',450.00,0.00,450.00,NULL,NULL,NULL,NULL,1,NULL,NULL,'2025-03-18 14:45:27','2025-03-18 14:49:08');

-- ----------------------------
-- Table structure for bundle_items
-- ----------------------------
CREATE TABLE `bundle_items`  (
  `bundle_item_id` int NOT NULL AUTO_INCREMENT,
  `bundle_id` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`bundle_item_id`) USING BTREE,
  INDEX `bundle_id`(`bundle_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  CONSTRAINT `bundle_items_ibfk_1` FOREIGN KEY (`bundle_id`) REFERENCES `product_bundles` (`bundle_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `bundle_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5;

-- ----------------------------
-- Records of bundle_items
-- ----------------------------
INSERT INTO `bundle_items` VALUES (1,1,1,1,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,1,2,1,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,2,2,1,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (4,2,3,1,'2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for contacts
-- ----------------------------
CREATE TABLE `contacts`  (
  `contact_id` int NOT NULL AUTO_INCREMENT,
  `vendor_id` int NULL DEFAULT NULL,
  `contact_name` varchar(255) NOT NULL,
  `contact_position` varchar(100) NULL DEFAULT NULL,
  `contact_email` varchar(100) NULL DEFAULT NULL,
  `contact_phone` varchar(50) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`contact_id`) USING BTREE,
  INDEX `vendor_id`(`vendor_id`) USING BTREE,
  CONSTRAINT `contacts_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`vendor_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 19;

-- ----------------------------
-- Records of contacts
-- ----------------------------
INSERT INTO `contacts` VALUES (10,1,'Vendor Contact A','Manager','vendor_a@example.com','111-222-3333','2025-01-27 13:35:32','2025-01-27 13:35:32'), (11,2,'Vendor Contact B','Sales Representative','vendor_b@example.com','222-333-4444','2025-01-27 13:35:32','2025-01-27 13:35:32'), (12,3,'Vendor Contact C','Support','vendor_c@example.com','333-444-5555','2025-01-27 13:35:32','2025-01-27 13:35:32'), (16,1,'Robert Brown Jr.','Agent','robertjr@example.com','777-888-9999','2025-01-27 13:36:09','2025-01-27 13:36:09'), (17,2,'Linda White Jr.','Assistant Manager','lindajr@example.com','888-999-0000','2025-01-27 13:36:09','2025-01-27 13:36:09'), (18,3,'Michael Harris Jr.','Director','michaeljr@example.com','999-000-1111','2025-01-27 13:36:09','2025-01-27 13:36:09');


-- ----------------------------
-- Table structure for inbound_orders
-- ----------------------------
CREATE TABLE `inbound_orders`  (
  `inbound_order_id` int NOT NULL AUTO_INCREMENT,
  `warehouse_id` int NOT NULL,
  `login` varchar(255) NOT NULL,
  `vendor_id` int NOT NULL,
  `status_id` int NOT NULL,
  `delivery_agent` varchar(255) NULL DEFAULT NULL,
  `order_date` date NULL DEFAULT NULL,
  `item_total` decimal(10, 2) NULL DEFAULT NULL,
  `freight_cost` decimal(10, 2) NULL DEFAULT NULL,
  `discount` decimal(10, 2) NULL DEFAULT NULL,
  `order_total` decimal(10, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`inbound_order_id`) USING BTREE,
  INDEX `vendor_id`(`vendor_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `login`(`login`) USING BTREE,
  INDEX `status_id`(`status_id`) USING BTREE,
  CONSTRAINT `inbound_orders_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`vendor_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inbound_orders_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inbound_orders_ibfk_4` FOREIGN KEY (`status_id`) REFERENCES `order_statuses` (`status_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 67;

-- ----------------------------
-- Records of inbound_orders
-- ----------------------------
INSERT INTO `inbound_orders` VALUES (1,3,'user2',1,7,'','2024-08-03',2568.18,64.37,63.46,2569.09,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (8,2,'user2',2,7,'','2024-09-06',822.78,52.51,35.61,839.68,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (12,3,'user1',3,7,'','2024-10-03',1745.79,92.62,15.69,1822.72,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (21,2,'user1',3,7,'','2024-11-06',1955.94,117.88,89.73,1984.09,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (31,3,'user2',3,7,'','2024-11-22',802.44,88.82,10.93,880.33,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (33,3,'user3',1,7,'','2025-01-07',1700.78,64.39,47.59,1717.58,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (36,3,'user3',3,7,'','2025-02-03',752.11,146.02,89.00,809.13,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (40,1,'user1',2,7,'','2025-02-26',928.06,85.15,5.69,1007.52,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (48,2,'user2',1,7,'','2025-04-16',1176.44,52.06,46.94,1181.56,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (56,1,'user2',3,7,'','2025-04-30',1880.55,74.34,20.68,1934.21,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (61,1,'user2',3,7,'','2025-06-01',932.77,140.86,16.98,1056.65,'2024-11-14 12:00:52','2025-07-15 13:56:25'), (66,1,'user3',3,1,'','2025-07-15',551.13,64.87,23.45,592.55,'2024-11-14 12:00:52','2025-07-15 13:56:25');


-- ----------------------------
-- Table structure for product_variants
-- ----------------------------
CREATE TABLE `product_variants`  (
  `variant_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NULL DEFAULT NULL,
  `variant_name` varchar(255) NULL DEFAULT NULL,
  `variant_sku` varchar(100) NULL DEFAULT NULL,
  `additional_price` decimal(10, 2) NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`variant_id`) USING BTREE,
  UNIQUE INDEX `variant_sku`(`variant_sku`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  CONSTRAINT `product_variants_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5;

-- ----------------------------
-- Records of product_variants
-- ----------------------------
INSERT INTO `product_variants` VALUES (1,1,'Red','SKU001-R',10.00,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (2,1,'Blue','SKU001-B',15.00,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (3,2,'Large','SKU002-L',20.00,'2024-11-11 14:15:49','2024-11-11 14:15:49'), (4,3,'Small','SKU003-S',5.00,'2024-11-11 14:15:49','2024-11-11 14:15:49');

-- ----------------------------
-- Table structure for inbound_order_items
-- ----------------------------
CREATE TABLE `inbound_order_items`  (
  `inbound_order_item_id` int NOT NULL AUTO_INCREMENT,
  `inbound_order_id` int NULL DEFAULT NULL,
  `product_id` int NULL DEFAULT NULL,
  `variant_id` int NULL DEFAULT NULL,
  `warehouse_id` int NULL DEFAULT NULL,
  `quantity` int NULL DEFAULT NULL,
  `unit_price` decimal(10, 2) NULL DEFAULT NULL,
  `total_price` decimal(10, 2) NULL DEFAULT NULL,
  `received_date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`inbound_order_item_id`) USING BTREE,
  INDEX `inbound_order_id`(`inbound_order_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  INDEX `variant_id`(`variant_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  CONSTRAINT `inbound_order_items_ibfk_1` FOREIGN KEY (`inbound_order_id`) REFERENCES `inbound_orders` (`inbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inbound_order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inbound_order_items_ibfk_3` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`variant_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inbound_order_items_ibfk_4` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 143;

-- ----------------------------
-- Records of inbound_order_items
-- ----------------------------
INSERT INTO `inbound_order_items` VALUES (1,1,2,NULL,3,49,47.82,2343.18,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (2,1,5,NULL,3,5,45.00,225.00,NULL,'2024-11-14 12:01:14','2025-02-06 12:39:55'), (10,8,2,NULL,2,37,85.74,3172.38,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (11,8,3,NULL,2,32,73.34,2346.88,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (12,8,2,NULL,2,40,49.62,1984.80,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (13,8,2,NULL,2,31,19.82,614.42,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (14,8,1,NULL,2,25,67.75,1693.75,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (20,12,1,NULL,3,44,66.99,2947.56,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (21,12,1,NULL,3,16,30.07,481.12,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (22,12,3,NULL,3,11,48.56,534.16,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (23,12,2,NULL,3,36,65.51,2358.36,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (37,21,1,NULL,2,15,89.78,1346.70,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (38,21,3,NULL,2,43,84.06,3614.58,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (59,31,1,NULL,3,18,50.08,901.44,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (63,33,3,NULL,3,32,50.85,1627.20,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (64,33,1,NULL,3,25,97.72,2443.00,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (65,33,1,NULL,3,14,22.74,318.36,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (66,33,3,NULL,3,35,97.85,3424.75,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (67,33,1,NULL,3,16,31.90,510.40,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (73,36,2,NULL,3,17,68.12,1158.04,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (74,36,2,NULL,3,12,48.18,578.16,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (83,40,2,NULL,1,49,40.04,1961.96,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (84,40,1,NULL,1,38,62.45,2373.10,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (99,48,3,NULL,2,36,83.54,3007.44,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (100,48,3,NULL,2,27,57.44,1550.88,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (101,48,3,NULL,2,20,83.42,1668.40,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (102,48,3,NULL,2,25,38.55,963.75,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (103,48,3,NULL,2,31,72.19,2237.89,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (116,56,2,NULL,1,24,83.15,1995.60,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (117,56,1,NULL,1,20,67.63,1352.60,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (118,56,3,NULL,1,23,76.27,1754.21,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (119,56,1,NULL,1,42,84.56,3551.52,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (120,56,1,NULL,1,38,43.65,1658.70,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (131,61,1,NULL,1,49,35.21,1725.29,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (132,61,1,NULL,1,13,78.83,1024.79,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14'), (141,66,3,NULL,1,16,74.05,1184.80,NULL,'2024-11-14 12:01:14','2024-11-14 12:01:14');

-- ----------------------------
-- Table structure for inventory
-- ----------------------------
CREATE TABLE `inventory`  (
  `inventory_id` int NOT NULL AUTO_INCREMENT,
  `warehouse_id` int NOT NULL,
  `product_id` int NOT NULL,
  `variant_id` int NULL DEFAULT NULL,
  `quantity` int NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`inventory_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  INDEX `variant_id`(`variant_id`) USING BTREE,
  CONSTRAINT `inventory_ibfk_1` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_ibfk_3` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`variant_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 61;

-- ----------------------------
-- Records of inventory
-- ----------------------------
INSERT INTO `inventory` VALUES (1,1,1,1,31,'2024-11-08 14:47:07','2025-01-24 14:02:14'), (2,2,1,2,6,'2024-11-08 14:47:07','2025-01-24 14:02:24'), (3,3,1,2,3,'2024-11-08 14:47:07','2025-01-24 13:55:28'), (4,1,2,NULL,37,'2024-11-08 14:47:07','2025-01-24 14:03:00'), (5,2,2,NULL,134,'2024-11-08 14:47:07','2025-02-11 13:55:16'), (6,3,2,NULL,30,'2024-11-08 14:47:07','2025-03-28 20:14:52'), (7,1,3,NULL,62,'2024-11-08 14:47:07','2025-03-10 12:56:06'), (8,2,3,NULL,0,'2024-11-08 14:47:07','2025-02-12 13:20:05'), (9,3,3,NULL,50,'2024-11-08 14:47:07','2025-03-14 14:32:49'), (10,1,4,NULL,3,'2024-11-08 14:47:07','2025-02-12 13:21:20'), (11,2,4,NULL,5,'2024-11-08 14:47:07','2025-02-12 13:21:20'), (12,3,4,NULL,25,'2024-11-08 14:47:07','2025-02-12 13:21:20'), (13,1,5,NULL,45,'2024-11-08 14:47:07','2025-02-12 13:21:20'), (14,2,5,NULL,436,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (15,3,5,NULL,430,'2024-11-08 14:47:07','2025-02-12 13:16:21'), (16,1,6,NULL,235,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (17,2,6,NULL,67,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (18,3,6,NULL,213,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (19,1,7,NULL,286,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (20,2,7,NULL,192,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (21,3,7,NULL,500,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (22,1,8,NULL,421,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (23,2,8,NULL,262,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (24,3,8,NULL,69,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (25,1,9,NULL,180,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (26,2,9,NULL,406,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (27,3,9,NULL,349,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (28,1,10,NULL,100,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (29,2,10,NULL,469,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (30,3,10,NULL,497,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (31,1,11,NULL,469,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (32,2,11,NULL,358,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (33,3,11,NULL,417,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (34,1,12,NULL,450,'2024-11-08 14:47:07','2025-03-14 14:48:37'), (35,2,12,NULL,244,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (36,3,12,NULL,327,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (37,1,13,NULL,318,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (38,2,13,NULL,409,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (39,3,13,NULL,345,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (40,1,14,NULL,198,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (41,2,14,NULL,368,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (42,3,14,NULL,284,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (43,1,15,NULL,68,'2024-11-08 14:47:07','2025-03-14 14:32:28'), (44,2,15,NULL,276,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (45,3,15,NULL,109,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (46,1,16,NULL,422,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (47,2,16,NULL,225,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (48,3,16,NULL,72,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (49,1,17,NULL,420,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (50,2,17,NULL,126,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (51,3,17,NULL,223,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (52,1,18,NULL,232,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (53,2,18,NULL,434,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (54,3,18,NULL,444,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (55,1,19,NULL,257,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (56,2,19,NULL,262,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (57,3,19,NULL,199,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (58,1,20,NULL,213,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (59,2,20,NULL,428,'2024-11-08 14:47:07','2024-11-08 14:47:07'), (60,3,20,NULL,329,'2024-11-08 14:47:07','2024-11-08 14:47:07');

-- ----------------------------
-- Table structure for inventory_transactions
-- ----------------------------
CREATE TABLE `inventory_transactions`  (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `variant_id` int NULL DEFAULT NULL,
  `warehouse_id` int NOT NULL,
  `login` varchar(255) NOT NULL,
  `transaction_type_id` int NULL DEFAULT NULL,
  `quantity` int NULL DEFAULT NULL,
  `transaction_value` decimal(10, 2) NULL DEFAULT NULL,
  `transaction_date` date NULL DEFAULT NULL,
  `remarks` text NULL,
  `inbound_order_id` int NULL DEFAULT NULL,
  `outbound_order_id` int NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`transaction_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  INDEX `variant_id`(`variant_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `login`(`login`) USING BTREE,
  INDEX `transaction_type_id`(`transaction_type_id`) USING BTREE,
  INDEX `inbound_order_id`(`inbound_order_id`) USING BTREE,
  INDEX `outbound_order_id`(`outbound_order_id`) USING BTREE,
  CONSTRAINT `inventory_transactions_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_transactions_ibfk_2` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`variant_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_transactions_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_transactions_ibfk_5` FOREIGN KEY (`transaction_type_id`) REFERENCES `transaction_types` (`type_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_transactions_ibfk_6` FOREIGN KEY (`inbound_order_id`) REFERENCES `inbound_orders` (`inbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventory_transactions_ibfk_7` FOREIGN KEY (`outbound_order_id`) REFERENCES `outbound_orders` (`outbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 181;

-- ----------------------------
-- Records of inventory_transactions
-- ----------------------------
INSERT INTO `inventory_transactions` VALUES (1,2,NULL,3,'user2',1,49,2343.18,'2024-09-06','',8,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (2,1,NULL,3,'user2',1,48,2077.44,'2024-11-22','',31,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (3,3,NULL,3,'user2',2,18,932.40,'2025-02-24','',NULL,43,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (4,2,NULL,3,'user2',2,15,1201.05,'2025-02-24','',NULL,43,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (5,3,NULL,3,'user2',2,5,309.50,'2024-10-13','',NULL,19,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (6,3,NULL,3,'user2',2,1,24.25,'2025-04-08','',NULL,53,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (7,1,NULL,3,'user2',2,2,114.46,'2024-10-21','',NULL,25,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (8,3,NULL,3,'user2',2,11,468.60,'2025-01-21','',NULL,38,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (9,2,NULL,3,'user2',2,16,2159.36,'2024-11-06','',NULL,22,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (10,2,NULL,2,'user2',1,37,3172.38,'2024-09-06','',8,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (11,3,NULL,2,'user2',1,32,2346.88,'2025-04-30','',56,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (12,2,NULL,2,'user2',1,40,1984.80,'2024-10-03','',12,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (13,2,NULL,2,'user2',1,31,614.42,'2025-07-15','',66,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (14,1,NULL,2,'user2',1,25,1693.75,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (15,3,NULL,2,'user2',2,16,2341.60,'2025-06-09','',NULL,65,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (16,3,NULL,2,'user2',2,18,2204.64,'2025-07-01','',NULL,74,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (17,3,NULL,2,'user2',2,10,288.90,'2025-04-29','',NULL,59,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (18,2,NULL,2,'user2',2,1,80.32,'2024-11-06','',NULL,23,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (19,1,NULL,2,'user2',2,1,59.07,'2024-11-06','',NULL,23,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (20,1,NULL,3,'user1',1,44,2947.56,'2024-08-03','',1,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (21,1,NULL,3,'user1',1,16,481.12,'2025-02-03','',36,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (22,3,NULL,3,'user1',1,11,534.16,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (23,2,NULL,3,'user1',1,36,2358.36,'2024-10-03','',12,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (24,3,NULL,3,'user1',2,20,1309.20,'2024-07-24','',NULL,2,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (25,2,NULL,3,'user1',2,17,2215.61,'2024-07-24','',NULL,2,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (26,2,NULL,3,'user1',2,19,1059.06,'2024-09-19','',NULL,13,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (27,2,NULL,3,'user1',2,11,1317.58,'2025-03-11','',NULL,47,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (28,2,NULL,3,'user1',2,12,1782.12,'2024-11-06','',NULL,23,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (29,1,NULL,3,'user1',2,7,493.08,'2025-07-02','',NULL,69,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (30,1,NULL,3,'user1',2,16,338.08,'2024-07-24','',NULL,2,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (31,2,NULL,3,'user1',2,20,1451.60,'2024-10-20','',NULL,30,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (32,1,NULL,3,'user1',2,18,1622.70,'2025-07-01','',NULL,74,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (33,1,NULL,3,'user1',2,18,653.40,'2024-08-03','',NULL,4,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (34,3,NULL,3,'user1',2,13,994.76,'2024-07-24','',NULL,2,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (35,1,NULL,3,'user1',2,19,1875.87,'2025-01-21','',NULL,38,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (36,1,NULL,3,'user1',2,5,423.60,'2025-03-11','',NULL,47,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (37,1,NULL,2,'user1',1,15,1346.70,'2025-06-01','',61,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (38,3,NULL,2,'user1',1,43,3614.58,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (39,2,NULL,2,'user1',2,4,344.80,'2025-03-06','',NULL,44,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (40,1,NULL,2,'user1',2,19,1110.36,'2024-11-06','',NULL,23,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (41,3,NULL,2,'user1',2,6,496.68,'2025-07-15','',NULL,67,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (42,3,NULL,2,'user1',2,17,1547.00,'2025-01-30','',NULL,39,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (43,1,NULL,2,'user1',2,4,100.52,'2025-05-01','',NULL,57,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (44,2,NULL,2,'user1',2,2,286.88,'2024-10-20','',NULL,30,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (45,2,NULL,2,'user1',2,2,110.50,'2024-10-21','',NULL,25,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (46,1,NULL,2,'user1',2,3,185.67,'2025-03-06','',NULL,44,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (47,1,NULL,2,'user1',2,12,763.32,'2025-02-24','',NULL,43,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (48,3,NULL,2,'user1',2,15,1706.10,'2025-03-04','',NULL,42,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (49,1,NULL,2,'user1',2,5,351.35,'2024-10-04','',NULL,16,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (50,3,NULL,2,'user1',2,4,381.04,'2025-01-21','',NULL,38,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (51,3,NULL,2,'user1',2,12,1261.80,'2024-10-30','',NULL,26,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (52,2,NULL,2,'user1',2,5,193.90,'2024-08-28','',NULL,10,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (53,3,NULL,2,'user1',2,19,413.06,'2025-04-13','',NULL,49,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (54,2,NULL,2,'user1',2,7,507.99,'2024-11-06','',NULL,23,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (55,1,NULL,2,'user1',2,19,2547.52,'2024-10-17','',NULL,28,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (56,1,NULL,2,'user1',2,5,168.30,'2025-05-03','',NULL,60,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (57,3,NULL,2,'user1',2,9,1182.69,'2024-10-09','',NULL,20,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (58,2,NULL,2,'user1',2,17,1815.60,'2025-05-03','',NULL,60,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (59,1,NULL,3,'user2',1,18,901.44,'2024-09-06','',8,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (60,3,NULL,3,'user2',2,3,436.56,'2025-03-20','',NULL,50,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (61,3,NULL,3,'user2',2,8,779.92,'2025-02-25','',NULL,46,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (62,1,NULL,3,'user2',2,13,1197.82,'2025-01-30','',NULL,39,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (63,3,NULL,3,'user3',1,32,1627.20,'2024-11-22','',31,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (64,1,NULL,3,'user3',1,25,2443.00,'2025-04-16','',48,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (65,1,NULL,3,'user3',1,14,318.36,'2025-02-26','',40,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (66,3,NULL,3,'user3',1,35,3424.75,'2025-04-30','',56,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (67,1,NULL,3,'user3',1,16,510.40,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (68,1,NULL,3,'user3',2,18,380.34,'2025-01-21','',NULL,38,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (69,2,NULL,3,'user3',2,14,1157.38,'2024-10-30','',NULL,26,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (70,1,NULL,3,'user3',2,12,794.64,'2025-01-30','',NULL,39,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (71,3,NULL,3,'user3',2,17,1371.56,'2025-07-01','',NULL,74,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (72,2,NULL,3,'user3',2,13,585.00,'2024-08-19','',NULL,11,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (73,2,NULL,3,'user3',1,17,1158.04,'2024-09-06','',8,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (74,2,NULL,3,'user3',1,12,578.16,'2025-07-15','',66,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (75,2,NULL,3,'user3',2,13,601.25,'2025-05-01','',NULL,57,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (76,1,NULL,3,'user3',2,3,93.09,'2025-07-15','',NULL,67,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (77,2,NULL,3,'user3',2,14,933.24,'2025-07-10','',NULL,68,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (78,3,NULL,3,'user3',2,16,747.04,'2024-07-19','',NULL,6,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (79,1,NULL,3,'user3',2,12,1177.80,'2024-10-04','',NULL,16,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (80,3,NULL,3,'user3',2,12,1458.48,'2024-10-04','',NULL,15,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (81,2,NULL,3,'user3',2,8,187.20,'2025-04-02','',NULL,52,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (82,3,NULL,3,'user3',2,14,695.52,'2024-08-12','',NULL,3,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (83,2,NULL,1,'user1',1,49,1961.96,'2025-04-30','',56,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (84,1,NULL,1,'user1',1,38,2373.10,'2025-02-03','',36,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (85,2,NULL,1,'user1',2,18,728.46,'2024-10-30','',NULL,26,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (86,3,NULL,1,'user1',2,1,89.85,'2025-06-03','',NULL,64,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (87,2,NULL,1,'user1',2,16,1809.92,'2024-11-06','',NULL,22,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (88,1,NULL,1,'user1',2,17,1910.29,'2025-01-30','',NULL,39,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (89,3,NULL,1,'user1',2,8,289.36,'2024-12-31','',NULL,34,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (90,3,NULL,1,'user1',2,2,259.72,'2025-01-21','',NULL,38,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (91,1,NULL,1,'user1',2,11,985.16,'2024-10-22','',NULL,27,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (92,1,NULL,1,'user1',2,13,1357.20,'2025-04-13','',NULL,49,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (93,1,NULL,1,'user1',2,12,1345.92,'2024-09-18','',NULL,17,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (94,2,NULL,1,'user1',2,18,1594.80,'2025-06-07','',NULL,63,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (95,3,NULL,1,'user1',2,4,237.28,'2025-07-07','',NULL,73,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (96,2,NULL,1,'user1',2,13,1693.90,'2025-03-11','',NULL,47,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (97,2,NULL,1,'user1',2,15,1821.00,'2025-01-11','',NULL,35,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (98,3,NULL,1,'user1',2,19,1397.45,'2025-04-14','',NULL,51,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (99,3,NULL,2,'user2',1,36,3007.44,'2024-11-06','',21,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (100,3,NULL,2,'user2',1,27,1550.88,'2025-04-30','',56,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (101,3,NULL,2,'user2',1,20,1668.40,'2025-04-16','',48,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (102,3,NULL,2,'user2',1,25,963.75,'2025-06-01','',61,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (103,3,NULL,2,'user2',1,31,2237.89,'2024-10-03','',12,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (104,1,NULL,2,'user2',2,2,111.28,'2024-10-20','',NULL,24,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (105,3,NULL,2,'user2',2,8,411.84,'2025-01-26','',NULL,37,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (106,2,NULL,2,'user2',2,1,127.74,'2025-02-25','',NULL,46,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (107,2,NULL,2,'user2',2,7,252.56,'2025-07-07','',NULL,73,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (108,2,NULL,2,'user2',2,7,567.49,'2025-07-01','',NULL,74,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (109,2,NULL,2,'user2',2,20,1681.80,'2024-10-17','',NULL,28,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (110,1,NULL,2,'user2',2,4,208.80,'2025-03-20','',NULL,50,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (111,2,NULL,2,'user2',2,18,2471.40,'2024-10-12','',NULL,14,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (112,1,NULL,2,'user2',2,1,149.25,'2025-04-14','',NULL,51,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (113,3,NULL,2,'user2',2,15,328.50,'2024-10-12','',NULL,14,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (114,1,NULL,2,'user2',2,16,1508.80,'2025-07-02','',NULL,72,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (115,2,NULL,2,'user2',2,13,1139.97,'2024-10-04','',NULL,16,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (116,2,NULL,1,'user2',1,24,1995.60,'2025-07-15','',66,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (117,1,NULL,1,'user2',1,20,1352.60,'2025-07-15','',66,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (118,3,NULL,1,'user2',1,23,1754.21,'2025-02-26','',40,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (119,1,NULL,1,'user2',1,42,3551.52,'2024-10-03','',12,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (120,1,NULL,1,'user2',1,38,1658.70,'2024-09-06','',8,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (121,3,NULL,1,'user2',2,17,1273.30,'2025-05-03','',NULL,60,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (122,3,NULL,1,'user2',2,20,2194.80,'2025-07-02','',NULL,69,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (123,3,NULL,1,'user2',2,20,1498.00,'2024-08-19','',NULL,11,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (124,2,NULL,1,'user2',2,12,831.24,'2024-10-04','',NULL,15,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (125,3,NULL,1,'user2',2,4,278.04,'2024-12-31','',NULL,34,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (126,3,NULL,1,'user2',2,1,83.60,'2025-07-10','',NULL,70,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (127,2,NULL,1,'user2',2,19,1291.62,'2024-08-12','',NULL,3,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (128,3,NULL,1,'user2',2,20,2043.00,'2024-11-27','',NULL,32,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (129,1,NULL,1,'user2',2,5,451.00,'2024-09-19','',NULL,13,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (130,1,NULL,1,'user2',2,16,1456.96,'2024-09-19','',NULL,13,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (131,1,NULL,1,'user2',1,49,1725.29,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (132,1,NULL,1,'user2',1,13,1024.79,'2024-11-22','',31,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (133,1,NULL,1,'user2',2,10,384.80,'2024-10-04','',NULL,15,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (134,3,NULL,1,'user2',2,7,925.05,'2025-03-31','',NULL,55,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (135,1,NULL,1,'user2',2,19,467.59,'2024-10-09','',NULL,20,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (136,3,NULL,1,'user2',2,7,370.23,'2025-07-10','',NULL,70,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (137,3,NULL,1,'user2',2,13,731.64,'2024-08-09','',NULL,7,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (138,1,NULL,1,'user2',2,3,435.57,'2024-08-28','',NULL,10,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (139,3,NULL,1,'user2',2,20,1861.40,'2024-09-05','',NULL,9,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (140,2,NULL,1,'user2',2,12,839.04,'2025-07-12','',NULL,71,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (141,3,NULL,1,'user3',1,16,1184.80,'2025-01-07','',33,NULL,'2024-11-14 12:11:46','2025-07-15 13:56:36'), (142,3,NULL,1,'user3',2,4,279.48,'2024-10-20','',NULL,30,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (143,1,NULL,1,'user3',2,13,747.63,'2024-08-08','',NULL,5,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (144,2,NULL,1,'user3',2,12,1629.48,'2025-03-31','',NULL,55,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (145,2,NULL,1,'user3',2,7,962.15,'2025-06-03','',NULL,64,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (146,2,NULL,1,'user3',2,8,1179.44,'2024-10-09','',NULL,20,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (147,1,NULL,1,'user3',2,13,699.79,'2025-05-01','',NULL,57,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (148,1,NULL,1,'user3',2,16,1314.40,'2025-05-31','',NULL,62,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (149,1,NULL,1,'user3',2,11,309.32,'2025-05-31','',NULL,62,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (150,2,NULL,1,'user3',2,2,88.66,'2025-07-01','',NULL,74,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (151,1,NULL,1,'user3',2,15,1680.75,'2025-07-15','',NULL,67,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (152,1,NULL,1,'user3',2,4,222.12,'2025-03-06','',NULL,44,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (153,2,NULL,1,'user3',2,10,765.40,'2025-03-20','',NULL,50,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (154,3,NULL,1,'user3',2,2,188.18,'2024-11-27','',NULL,32,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (155,3,NULL,1,'user3',2,6,744.84,'2024-08-08','',NULL,5,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (156,1,NULL,1,'user3',2,10,380.40,'2025-07-12','',NULL,71,'2024-11-14 12:11:46','2025-07-15 13:56:38'), (157,2,NULL,3,'user2',1,49,2343.18,'2024-08-03',NULL,1,NULL,'2025-02-12 13:16:21','2025-07-15 13:56:36'), (158,5,NULL,3,'user2',1,5,225.00,'2024-08-03',NULL,1,NULL,'2025-02-12 13:16:21','2025-07-15 13:56:36'), (159,3,NULL,1,'user3',1,16,1184.80,'2025-07-15',NULL,66,NULL,'2025-03-10 12:56:06','2025-07-15 13:56:36'), (161,1,NULL,1,'user3',2,16,1314.40,'2025-07-12',NULL,NULL,71,'2025-03-12 14:42:10','2025-07-15 13:56:38'), (162,16,3,1,'user3',2,5,137.50,'2025-07-12',NULL,NULL,71,'2025-03-12 14:42:10','2025-07-15 13:56:38'), (163,1,NULL,1,'user3',2,16,1314.40,'2025-07-12',NULL,NULL,71,'2025-03-12 14:42:49','2025-07-15 13:56:38'), (164,16,3,1,'user3',2,15,412.50,'2025-07-12',NULL,NULL,71,'2025-03-12 14:42:49','2025-07-15 13:56:38'), (165,1,NULL,1,'user3',2,16,1314.40,'2025-07-12',NULL,NULL,71,'2025-03-12 14:43:18','2025-07-15 13:56:38'), (166,16,3,1,'user3',2,15,412.50,'2025-07-12',NULL,NULL,71,'2025-03-12 14:43:18','2025-07-15 13:56:38'), (167,1,NULL,1,'user3',2,13,747.63,'2025-07-10',NULL,NULL,68,'2025-03-12 14:45:47','2025-07-15 13:56:38'), (168,9,1,1,'user3',2,5,350.00,'2025-07-10',NULL,NULL,68,'2025-03-12 14:45:47','2025-07-15 13:56:38'), (169,2,NULL,3,'user2',2,15,1201.05,'2024-08-12',NULL,NULL,3,'2025-03-13 13:27:43','2025-07-15 13:56:38'), (170,12,1,1,'user2',2,5,200.00,'2024-08-12',NULL,NULL,3,'2025-03-13 13:27:43','2025-07-15 13:56:38'), (171,2,NULL,3,'user2',2,15,1201.05,'2024-08-12',NULL,NULL,3,'2025-03-13 13:30:56','2025-07-15 13:56:38'), (172,12,1,1,'user2',2,18,720.00,'2024-08-12',NULL,NULL,3,'2025-03-13 13:30:56','2025-07-15 13:56:38'), (173,3,NULL,3,'user2',2,18,932.40,'2024-07-24',NULL,NULL,2,'2025-03-14 14:18:21','2025-07-15 13:56:38'), (174,12,1,1,'user2',2,25,1000.00,'2024-07-24',NULL,NULL,2,'2025-03-14 14:18:21','2025-07-15 13:56:38'), (175,2,NULL,3,'user2',2,15,1201.05,'2024-08-12',NULL,NULL,3,'2025-03-14 14:24:30','2025-07-15 13:56:38'), (176,15,1,1,'user2',2,36,810.00,'2024-08-12',NULL,NULL,3,'2025-03-14 14:24:30','2025-07-15 13:56:38'), (177,2,NULL,3,'user2',2,15,1201.05,'2024-08-12',NULL,NULL,3,'2025-03-14 14:34:10','2025-07-15 13:56:38'), (178,15,1,1,'user2',2,18,405.00,'2024-08-12',NULL,NULL,3,'2025-03-14 14:34:10','2025-07-15 13:56:38'), (179,2,NULL,3,'user2',2,15,1201.05,'2024-08-12',NULL,NULL,3,'2025-03-14 14:48:37','2025-07-15 13:56:38'), (180,12,NULL,1,'user2',2,48,1440.00,'2024-08-12',NULL,NULL,3,'2025-03-14 14:48:37','2025-07-15 13:56:38');




-- ----------------------------
-- Table structure for order_tracking
-- ----------------------------
CREATE TABLE `order_tracking`  (
  `tracking_id` int NOT NULL AUTO_INCREMENT,
  `inbound_order_id` int NULL DEFAULT NULL,
  `outbound_order_id` int NULL DEFAULT NULL,
  `status_id` int NOT NULL,
  `tracking_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `handled_by` varchar(255) NULL DEFAULT NULL,
  `remarks` text NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tracking_id`) USING BTREE,
  INDEX `status_id`(`status_id`) USING BTREE,
  INDEX `inbound_order_id`(`inbound_order_id`) USING BTREE,
  INDEX `outbound_order_id`(`outbound_order_id`) USING BTREE,
  CONSTRAINT `order_tracking_ibfk_1` FOREIGN KEY (`status_id`) REFERENCES `order_statuses` (`status_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `order_tracking_ibfk_2` FOREIGN KEY (`inbound_order_id`) REFERENCES `inbound_orders` (`inbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `order_tracking_ibfk_3` FOREIGN KEY (`outbound_order_id`) REFERENCES `outbound_orders` (`outbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4;

-- ----------------------------
-- Records of order_tracking
-- ----------------------------
INSERT INTO `order_tracking` VALUES (2,NULL,71,4,'2025-01-07 13:32:28','','','2025-05-05 13:32:49',NULL), (3,NULL,67,4,'2025-04-07 20:34:46','Mark','Notes','2025-05-14 20:35:09',NULL);

-- ----------------------------
-- Table structure for outbound_order_items
-- ----------------------------
CREATE TABLE `outbound_order_items`  (
  `outbound_order_item_id` int NOT NULL AUTO_INCREMENT,
  `outbound_order_id` int NULL DEFAULT NULL,
  `product_id` int NULL DEFAULT NULL,
  `variant_id` int NULL DEFAULT NULL,
  `warehouse_id` int NULL DEFAULT NULL,
  `quantity` int NULL DEFAULT NULL,
  `unit_price` decimal(10, 2) NULL DEFAULT NULL,
  `total_price` decimal(10, 2) NULL DEFAULT NULL,
  `shipped_date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`outbound_order_item_id`) USING BTREE,
  INDEX `outbound_order_id`(`outbound_order_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  INDEX `variant_id`(`variant_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  CONSTRAINT `outbound_order_items_ibfk_1` FOREIGN KEY (`outbound_order_id`) REFERENCES `outbound_orders` (`outbound_order_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `outbound_order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `outbound_order_items_ibfk_3` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`variant_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `outbound_order_items_ibfk_4` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 159;

-- ----------------------------
-- Records of outbound_order_items
-- ----------------------------
INSERT INTO `outbound_order_items` VALUES (3,2,3,NULL,3,18,51.80,932.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (4,3,2,NULL,3,15,80.07,1201.05,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (5,4,3,NULL,3,5,61.90,309.50,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (6,5,3,NULL,3,1,24.25,24.25,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (7,5,1,NULL,3,2,57.23,114.46,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (8,6,3,NULL,3,11,42.60,468.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (9,7,2,NULL,3,16,134.96,2159.36,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (15,9,3,NULL,2,16,146.35,2341.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (16,9,3,NULL,2,18,122.48,2204.64,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (17,9,3,NULL,2,10,28.89,288.90,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (18,10,2,NULL,2,1,80.32,80.32,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (19,11,1,NULL,2,1,59.07,59.07,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (24,13,3,NULL,3,20,65.46,1309.20,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (25,14,2,NULL,3,17,130.33,2215.61,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (26,14,2,NULL,3,19,55.74,1059.06,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (27,14,2,NULL,3,11,119.78,1317.58,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (28,15,2,NULL,3,12,148.51,1782.12,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (29,16,1,NULL,3,7,70.44,493.08,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (30,17,1,NULL,3,16,21.13,338.08,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (31,17,2,NULL,3,20,72.58,1451.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (32,18,1,NULL,3,18,90.15,1622.70,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (33,18,1,NULL,3,18,36.30,653.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (34,18,3,NULL,3,13,76.52,994.76,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (35,19,1,NULL,3,19,98.73,1875.87,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (36,20,1,NULL,3,5,84.72,423.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (39,22,2,NULL,2,4,86.20,344.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (40,23,1,NULL,2,19,58.44,1110.36,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (41,23,3,NULL,2,6,82.78,496.68,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (42,24,3,NULL,2,17,91.00,1547.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (43,24,1,NULL,2,4,25.13,100.52,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (44,25,2,NULL,2,2,143.44,286.88,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (45,25,2,NULL,2,2,55.25,110.50,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (46,26,1,NULL,2,3,61.89,185.67,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (47,26,1,NULL,2,12,63.61,763.32,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (48,27,3,NULL,2,15,113.74,1706.10,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (49,27,1,NULL,2,5,70.27,351.35,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (50,27,3,NULL,2,4,95.26,381.04,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (51,28,3,NULL,2,12,105.15,1261.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (52,28,2,NULL,2,5,38.78,193.90,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (53,29,3,NULL,2,19,21.74,413.06,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (54,29,2,NULL,2,7,72.57,507.99,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (55,29,1,NULL,2,19,134.08,2547.52,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (56,30,1,NULL,2,5,33.66,168.30,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (57,30,3,NULL,2,9,131.41,1182.69,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (58,30,2,NULL,2,17,106.80,1815.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (60,32,3,NULL,3,3,145.52,436.56,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (61,32,3,NULL,3,8,97.49,779.92,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (62,32,1,NULL,3,13,92.14,1197.82,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (68,34,1,NULL,3,18,21.13,380.34,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (69,34,2,NULL,3,14,82.67,1157.38,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (70,34,1,NULL,3,12,66.22,794.64,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (71,35,3,NULL,3,17,80.68,1371.56,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (72,35,2,NULL,3,13,45.00,585.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (75,37,2,NULL,3,13,46.25,601.25,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (76,37,1,NULL,3,3,31.03,93.09,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (77,37,2,NULL,3,14,66.66,933.24,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (78,38,3,NULL,3,16,46.69,747.04,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (79,38,1,NULL,3,12,98.15,1177.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (80,39,3,NULL,3,12,121.54,1458.48,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (81,39,2,NULL,3,8,23.40,187.20,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (82,39,3,NULL,3,14,49.68,695.52,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (85,41,2,NULL,1,18,40.47,728.46,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (86,41,3,NULL,1,1,89.85,89.85,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (87,42,2,NULL,1,16,113.12,1809.92,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (88,42,1,NULL,1,17,112.37,1910.29,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (89,43,3,NULL,1,8,36.17,289.36,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (90,43,3,NULL,1,2,129.86,259.72,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (91,43,1,NULL,1,11,89.56,985.16,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (92,44,1,NULL,1,13,104.40,1357.20,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (93,44,1,NULL,1,12,112.16,1345.92,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (94,45,2,NULL,1,18,88.60,1594.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (95,45,3,NULL,1,4,59.32,237.28,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (96,46,2,NULL,1,13,130.30,1693.90,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (97,47,2,NULL,1,15,121.40,1821.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (98,47,3,NULL,1,19,73.55,1397.45,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (104,49,1,NULL,2,2,55.64,111.28,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (105,50,3,NULL,2,8,51.48,411.84,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (106,50,2,NULL,2,1,127.74,127.74,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (107,50,2,NULL,2,7,36.08,252.56,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (108,51,2,NULL,2,7,81.07,567.49,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (109,52,2,NULL,2,20,84.09,1681.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (110,53,1,NULL,2,4,52.20,208.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (111,53,2,NULL,2,18,137.30,2471.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (112,54,1,NULL,2,1,149.25,149.25,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (113,55,3,NULL,2,15,21.90,328.50,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (114,55,1,NULL,2,16,94.30,1508.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (115,55,2,NULL,2,13,87.69,1139.97,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (121,57,3,NULL,1,17,74.90,1273.30,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (122,58,3,NULL,1,20,109.74,2194.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (123,58,3,NULL,1,20,74.90,1498.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (124,58,2,NULL,1,12,69.27,831.24,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (125,59,3,NULL,1,4,69.51,278.04,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (126,59,3,NULL,1,1,83.60,83.60,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (127,59,2,NULL,1,19,67.98,1291.62,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (128,60,3,NULL,1,20,102.15,2043.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (129,60,1,NULL,1,5,90.20,451.00,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (130,60,5,NULL,1,16,91.06,1456.96,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (133,62,1,NULL,1,10,38.48,384.80,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (134,63,3,NULL,1,7,132.15,925.05,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (135,63,1,NULL,1,19,24.61,467.59,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (136,63,3,NULL,1,7,52.89,370.23,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (137,64,3,NULL,1,13,56.28,731.64,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (138,64,14,NULL,1,3,145.19,435.57,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (139,65,3,NULL,1,20,93.07,1861.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (140,65,2,NULL,1,12,69.92,839.04,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (142,67,3,NULL,1,4,69.87,279.48,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (143,68,1,NULL,1,13,57.51,747.63,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (144,68,9,1,1,5,60.00,350.00,NULL,'2024-11-14 12:01:57','2025-03-12 14:45:39'), (145,69,12,NULL,1,7,137.45,962.15,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (146,70,2,NULL,1,8,147.43,1179.44,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (147,70,1,NULL,1,13,53.83,699.79,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (148,71,17,NULL,1,16,82.15,1314.40,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (149,71,16,3,1,15,7.50,412.50,NULL,'2024-11-14 12:01:57','2025-03-12 14:43:54'), (150,72,2,NULL,1,2,44.33,88.66,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (151,72,1,NULL,1,15,112.05,1680.75,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (152,72,4,NULL,1,4,55.53,222.12,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (153,73,2,NULL,1,10,76.54,765.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (154,73,3,NULL,1,2,94.09,188.18,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (155,74,4,NULL,1,6,124.14,744.84,NULL,'2024-11-14 12:01:57','2025-04-04 11:46:50'), (156,74,1,NULL,1,10,38.04,380.40,NULL,'2024-11-14 12:01:57','2024-11-14 12:01:57'), (157,3,12,NULL,1,48,30.00,1440.00,NULL,'2025-03-13 13:27:15','2025-03-14 14:48:29'), (158,2,12,1,1,25,30.00,1000.00,NULL,'2025-03-14 14:17:54',NULL);

-- ----------------------------
-- Table structure for outbound_orders
-- ----------------------------
CREATE TABLE `outbound_orders`  (
  `outbound_order_id` int NOT NULL AUTO_INCREMENT,
  `warehouse_id` int NOT NULL,
  `login` varchar(255) NOT NULL,
  `customer_id` int NOT NULL,
  `status_id` int NOT NULL,
  `order_date` date NULL DEFAULT NULL,
  `item_total` decimal(10, 2) NULL DEFAULT NULL,
  `freight_cost` decimal(10, 2) NULL DEFAULT NULL,
  `discount` decimal(10, 2) NULL DEFAULT NULL,
  `order_total` decimal(10, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`outbound_order_id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE,
  INDEX `warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `login`(`login`) USING BTREE,
  INDEX `status_id`(`status_id`) USING BTREE,
  CONSTRAINT `outbound_orders_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `outbound_orders_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`warehouse_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `outbound_orders_ibfk_4` FOREIGN KEY (`status_id`) REFERENCES `order_statuses` (`status_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 75;

-- ----------------------------
-- Records of outbound_orders
-- ----------------------------
INSERT INTO `outbound_orders` VALUES (2,3,'user2',3,7,'2024-07-24',1932.40,40.82,44.31,1928.91,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (3,3,'user2',3,7,'2024-08-12',2641.05,98.11,0.47,2738.69,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (4,3,'user2',1,2,'2024-08-03',830.03,97.58,19.53,908.08,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (5,3,'user2',3,2,'2024-08-08',594.22,87.90,61.65,620.47,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (6,3,'user2',2,2,'2024-07-19',572.87,70.45,38.84,604.48,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (7,3,'user2',3,2,'2024-08-09',697.80,36.68,18.22,716.26,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (9,2,'user2',1,5,'2024-09-05',1221.71,97.19,18.35,1300.55,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (10,2,'user2',3,2,'2024-08-28',448.95,86.30,63.44,471.81,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (11,2,'user2',3,5,'2024-08-19',847.02,48.11,32.89,862.24,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (13,3,'user1',5,2,'2024-09-19',317.76,51.00,1.52,367.24,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (14,3,'user1',6,2,'2024-10-12',798.68,91.50,55.34,834.84,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (15,3,'user1',1,5,'2024-10-04',1105.63,77.43,30.08,1152.98,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (16,3,'user1',3,2,'2024-10-04',1155.17,57.33,41.25,1171.25,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (17,3,'user1',5,6,'2024-09-18',300.99,47.01,17.66,330.34,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (18,3,'user1',6,2,'2024-09-23',348.44,56.41,53.43,351.42,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (19,3,'user1',2,6,'2024-10-13',1238.14,95.01,56.38,1276.77,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (20,3,'user1',2,2,'2024-10-09',343.94,57.19,19.63,381.50,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (22,2,'user1',2,3,'2024-11-06',556.49,92.72,5.13,644.08,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (23,2,'user1',9,2,'2024-11-06',602.97,69.40,66.13,606.24,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (24,2,'user1',9,2,'2024-10-20',1150.19,40.17,36.79,1153.57,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (25,2,'user1',2,7,'2024-10-21',583.29,65.85,0.05,649.09,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (26,2,'user1',2,2,'2024-10-30',559.94,50.00,68.44,541.50,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (27,2,'user1',3,7,'2024-10-22',630.23,37.19,57.57,609.85,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (28,2,'user1',3,2,'2024-10-17',549.87,82.03,59.93,571.97,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (29,2,'user1',1,2,'2024-11-02',734.28,56.80,6.69,784.39,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (30,2,'user1',1,7,'2024-10-20',1062.72,38.57,53.53,1047.76,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (32,3,'user2',1,7,'2024-11-27',664.48,48.55,9.55,703.48,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (34,3,'user3',3,7,'2024-12-31',1325.23,52.28,72.38,1305.13,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (35,3,'user3',3,7,'2025-01-11',1125.42,73.42,3.43,1195.41,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (37,3,'user3',4,3,'2025-01-26',875.80,39.08,47.16,867.72,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (38,3,'user3',6,7,'2025-01-21',527.92,54.92,54.79,528.05,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (39,3,'user3',8,4,'2025-01-30',1462.27,72.01,17.27,1517.01,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (41,1,'user1',9,7,'2025-02-21',576.99,52.44,34.54,594.89,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (42,1,'user1',10,2,'2025-03-04',692.53,64.47,11.99,745.01,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (43,1,'user1',8,3,'2025-02-24',975.84,52.77,47.97,980.64,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (44,1,'user1',5,4,'2025-03-06',999.80,73.47,23.82,1049.45,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (45,1,'user1',7,7,'2025-02-20',1209.31,93.21,8.37,1294.15,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (46,1,'user1',8,2,'2025-02-25',500.40,32.21,67.18,465.43,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (47,1,'user1',2,7,'2025-03-11',1100.71,97.86,51.61,1146.96,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (49,2,'user2',10,2,'2025-04-13',924.59,73.19,46.48,951.30,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (50,2,'user2',2,2,'2025-03-20',1355.38,95.54,18.45,1432.47,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (51,2,'user2',10,7,'2025-04-14',1210.95,79.96,3.45,1287.46,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (52,2,'user2',3,7,'2025-04-02',924.72,94.36,38.25,980.83,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (53,2,'user2',10,2,'2025-04-08',910.24,94.21,51.74,952.71,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (54,2,'user2',6,7,'2025-03-27',1244.17,54.83,23.50,1275.50,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (55,2,'user2',1,7,'2025-03-31',1018.48,68.84,22.29,1065.03,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (57,1,'user2',4,4,'2025-05-01',588.34,88.57,4.08,672.83,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (58,1,'user2',7,7,'2025-05-05',539.40,40.62,63.67,516.35,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (59,1,'user2',7,7,'2025-04-29',677.60,94.92,41.52,731.00,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (60,1,'user2',2,4,'2025-05-03',421.74,58.15,39.36,440.53,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (62,1,'user2',3,4,'2025-05-31',528.62,56.01,46.48,538.15,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (63,1,'user2',3,4,'2025-06-07',1051.45,37.67,2.24,1086.88,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (64,1,'user2',6,4,'2025-06-03',312.34,80.36,36.40,356.30,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (65,1,'user2',2,5,'2025-06-09',942.78,60.27,4.04,999.01,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (67,1,'user3',7,1,'2025-07-15',505.95,86.97,23.14,569.78,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (68,1,'user3',5,7,'2025-07-10',1097.63,79.61,17.09,1160.15,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (69,2,'user3',3,7,'2025-07-02',979.28,76.90,25.54,1030.64,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (70,1,'user3',7,1,'2025-07-10',334.53,38.79,6.55,366.77,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (71,1,'user3',3,1,'2025-07-12',1726.90,92.72,54.83,1764.79,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (72,1,'user3',1,3,'2025-07-02',875.87,51.59,14.28,913.18,'2024-11-14 12:01:36','2025-07-15 13:54:46'), (73,1,'user3',2,7,'2025-07-07',631.72,81.29,16.33,696.68,'2024-11-14 12:01:36','2025-07-15 13:54:46');

-- ----------------------------
-- Table structure for product_offers
-- ----------------------------
CREATE TABLE `product_offers`  (
  `offer_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NULL DEFAULT NULL,
  `discount_percentage` decimal(5, 2) NOT NULL,
  `start_date` timestamp NOT NULL,
  `end_date` timestamp NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`offer_id`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE,
  CONSTRAINT `product_offers_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4;

-- ----------------------------
-- Records of product_offers
-- ----------------------------
INSERT INTO `product_offers` VALUES (1,1,10.00,'2025-01-01 03:00:00','2025-01-31 03:00:00','2024-11-11 14:15:49','2025-01-21 12:02:14'), (2,2,15.00,'2025-02-01 03:00:00','2025-02-15 03:00:00','2024-11-11 14:15:49','2025-01-21 12:02:14'), (3,3,20.00,'2025-03-01 03:00:00','2025-03-15 03:00:00','2024-11-11 14:15:49','2025-01-21 12:02:14');

-- ----------------------------
-- Table structure for sec_apps
-- ----------------------------
CREATE TABLE `sec_apps`  (
  `app_name` varchar(128) NOT NULL,
  `app_type` varchar(255) NULL DEFAULT NULL,
  `description` varchar(255) NULL DEFAULT NULL,
  PRIMARY KEY (`app_name`) USING BTREE
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_apps
-- ----------------------------
INSERT INTO `sec_apps` VALUES ('blank_kpis_outbound_status','blank',''), ('blank_kpis_stock','blank',''), ('chart_inventory','chart',''), ('chart_outbound_orders_last12m','chart',''), ('chart_sankey','chart',''), ('chart_top_sales_money','chart',''), ('chart_top_sales_qty','chart',''), ('ctrl_sel_bundle','contr',''), ('dashboard','container',''), ('form_bundle_items','form',''), ('form_contacts','form',''), ('form_customers','form',''), ('form_inbound_order_items','form',''), ('form_inbound_orders','form',''), ('form_inventory','form',''), ('form_inventory_transactions','form',''), ('form_order_statuses','form',''), ('form_order_tracking','form',''), ('form_outbound_order_items','form',''), ('form_outbound_orders','form',''), ('form_product_bundles','form',''), ('form_product_categories','form',''), ('form_product_offers','form',''), ('form_product_variants','form',''), ('form_products','form',''), ('form_transaction_types','form',''), ('form_vendors','form',''), ('form_warehouses','form',''), ('grid_contacts','cons',''), ('grid_customer_orders','cons',''), ('grid_customers','cons',''), ('grid_inbound_order_items','cons',''), ('grid_inbound_orders','cons',''), ('grid_inventory','cons',''), ('grid_inventory_transactions','cons',''), ('grid_list_price','cons',''), ('grid_list_price_detail_werehouses','cons',''), ('grid_order_tracking','cons',''), ('grid_outbound_orders','cons',''), ('grid_product_bundles','cons',''), ('grid_products','cons',''), ('grid_vendor_orders','cons',''), ('grid_vendors','cons',''), ('m_add_2fa','contr','Add 2FA to user'), ('m_change_pswd','contr','Change password'), ('m_control_2fa','cons','Control 2FA'), ('m_form_add_users','form','Add users'), ('m_form_edit_users','form','Edit users'), ('m_form_sec_apps','form','Add apps'), ('m_form_sec_groups','form','Show groups'), ('m_form_sec_groups_apps','form','Groups/Apps'), ('m_grid_sec_apps','cons','Show apps'), ('m_grid_sec_groups','cons','Show groups'), ('m_grid_sec_users','cons','Show users'), ('m_grid_sec_users_groups','form','Show users by groups'), ('m_link_social','contr','Link Social account'), ('m_Login','contr','Login - Initial Application'), ('m_my_info','form','Edit Profile'), ('m_retrieve_pswd','contr','Retrieve Password'), ('m_search_sec_groups','filter','Search Groups'), ('m_settings','contr','Settings'), ('m_sync_apps','contr','Resync Applications'), ('menu','menu2','');

-- ----------------------------
-- Table structure for sec_groups
-- ----------------------------
CREATE TABLE `sec_groups`  (
  `group_id` int NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NULL DEFAULT NULL,
  PRIMARY KEY (`group_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------
INSERT INTO `sec_groups` VALUES (1, 'Administrator'), (2, 'Netmake');

-- ----------------------------
-- Table structure for sec_groups_apps
-- ----------------------------
CREATE TABLE `sec_groups_apps`  (
  `group_id` int NOT NULL,
  `app_name` varchar(128) NOT NULL,
  `priv_access` varchar(1) NULL DEFAULT NULL,
  `priv_insert` varchar(1) NULL DEFAULT NULL,
  `priv_delete` varchar(1) NULL DEFAULT NULL,
  `priv_update` varchar(1) NULL DEFAULT NULL,
  `priv_export` varchar(1) NULL DEFAULT NULL,
  `priv_print` varchar(1) NULL DEFAULT NULL,
  PRIMARY KEY (`group_id`, `app_name`) USING BTREE,
  INDEX `sec_groups_apps_ibfk_2`(`app_name`) USING BTREE,
  CONSTRAINT `sec_groups_apps_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `sec_groups_apps_ibfk_2` FOREIGN KEY (`app_name`) REFERENCES `sec_apps` (`app_name`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------
INSERT INTO `sec_groups_apps` VALUES (1,'blank_kpis_outbound_status','Y','N','N','N','N','N'),
 (1,'blank_kpis_stock','Y','N','N','N','N','N'),
 (1,'chart_inventory','Y','N','N','N','Y','Y'),
 (1,'chart_outbound_orders_last12m','Y','N','N','N','Y','Y'),
 (1,'chart_sankey','Y','N','N','N','Y','Y'),
 (1,'chart_top_sales_money','Y','N','N','N','Y','Y'),
 (1,'chart_top_sales_qty','Y','N','N','N','Y','Y'),
 (1,'ctrl_sel_bundle','Y','N','N','N','N','N'),
 (1,'dashboard','Y','N','N','N','N','N'),
 (1,'form_bundle_items','Y','Y','Y','Y','N','N'),
 (1,'form_contacts','Y','Y','Y','Y','N','N'),
 (1,'form_customers','Y','Y','Y','Y','N','N'),
 (1,'form_inbound_order_items','Y','Y','Y','Y','N','N'),
 (1,'form_inbound_orders','Y','Y','Y','Y','N','N'),
 (1,'form_inventory','Y','Y','Y','Y','N','N'),
 (1,'form_inventory_transactions','Y','Y','Y','Y','N','N'),
 (1,'form_order_statuses','Y','Y','Y','Y','N','N'),
 (1,'form_order_tracking','Y','Y','Y','Y','N','N'),
 (1,'form_outbound_order_items','Y','Y','Y','Y','N','N'),
 (1,'form_outbound_orders','Y','Y','Y','Y','N','N'),
 (1,'form_product_bundles','Y','Y','Y','Y','N','N'),
 (1,'form_product_categories','Y','Y','Y','Y','N','N'),
 (1,'form_product_offers','Y','Y','Y','Y','N','N'),
 (1,'form_product_variants','Y','Y','Y','Y','N','N'),
 (1,'form_products','Y','Y','Y','Y','N','N'),
 (1,'form_transaction_types','Y','Y','Y','Y','N','N'),
 (1,'form_vendors','Y','Y','Y','Y','N','N'),
 (1,'form_warehouses','Y','Y','Y','Y','N','N'),
 (1,'grid_contacts','Y','N','N','N','Y','Y'),
 (1,'grid_customer_orders','Y','N','N','N','Y','Y'),
 (1,'grid_customers','Y','N','N','N','Y','Y'),
 (1,'grid_inbound_order_items','Y','N','N','N','Y','Y'),
 (1,'grid_inbound_orders','Y','N','N','N','Y','Y'),
 (1,'grid_inventory','Y','N','N','N','Y','Y'),
 (1,'grid_inventory_transactions','Y','N','N','N','Y','Y'),
 (1,'grid_list_price','Y','N','N','N','Y','Y'),
 (1,'grid_list_price_detail_werehouses','Y','N','N','N','Y','Y'),
 (1,'grid_order_tracking','Y','N','N','N','Y','Y'),
 (1,'grid_outbound_orders','Y','N','N','N','Y','Y'),
 (1,'grid_product_bundles','Y','N','N','N','Y','Y'),
 (1,'grid_products','Y','N','N','N','Y','Y'),
 (1,'grid_vendor_orders','Y','N','N','N','Y','Y'),
 (1,'grid_vendors','Y','N','N','N','Y','Y'),
 (1,'m_add_2fa','Y','N','N','N','N','N'),
 (1,'m_change_pswd','Y','N','N','N','N','N'),
 (1,'m_control_2fa','Y','N','N','N','Y','Y'),
 (1,'m_form_add_users','Y','Y','Y','Y','N','N'),
 (1,'m_form_edit_users','Y','N','N','N','N','N'),
 (1,'m_form_sec_apps','Y','N','N','N','N','N'),
 (1,'m_form_sec_groups','Y','N','N','N','N','N'),
 (1,'m_form_sec_groups_apps','Y','N','N','N','N','N'),
 (1,'m_grid_sec_apps','Y','N','N','N','Y','Y'),
 (1,'m_grid_sec_groups','Y','N','N','N','Y','Y'),
 (1,'m_grid_sec_users','Y','N','N','N','Y','Y'),
 (1,'m_grid_sec_users_groups','Y','N', 'N', 'N','N','N'),
 (1,'m_link_social','Y','N','N','N','N','N'),
 (1,'m_Login','Y','N','N','N','N','N'),
 (1,'m_my_info','Y','Y','Y','Y','N','N'),
 (1,'m_retrieve_pswd','Y','N','N','N','N','N'),
 (1,'m_search_sec_groups','Y','N','N','N','N','N'),
 (1,'m_settings','Y','N','N','N','N','N'),
 (1,'m_sync_apps','Y','N','N','N','N','N'), (1, 'menu', 'Y', 'N', 'N', 'N', 'N', 'N');

INSERT INTO `sec_groups_apps` VALUES (2,'blank_kpis_outbound_status','Y','N','N','N','N','N'),
 (2,'blank_kpis_stock','Y','N','N','N','N','N'),
 (2,'chart_inventory','Y','N','N','N','Y','Y'),
 (2,'chart_outbound_orders_last12m','Y','N','N','N','Y','Y'),
 (2,'chart_sankey','Y','N','N','N','Y','Y'),
 (2,'chart_top_sales_money','Y','N','N','N','Y','Y'),
 (2,'chart_top_sales_qty','Y','N','N','N','Y','Y'),
 (2,'ctrl_sel_bundle','Y','N','N','N','N','N'),
 (2,'dashboard','Y','N','N','N','N','N'),
 (2,'form_bundle_items','Y','Y','Y','Y','N','N'),
 (2,'form_contacts','Y','Y','Y','Y','N','N'),
 (2,'form_customers','Y','Y','Y','Y','N','N'),
 (2,'form_inbound_order_items','Y','Y','Y','Y','N','N'),
 (2,'form_inbound_orders','Y','Y','Y','Y','N','N'),
 (2,'form_inventory','Y','Y','Y','Y','N','N'),
 (2,'form_inventory_transactions','Y','Y','Y','Y','N','N'),
 (2,'form_order_statuses','Y','Y','Y','Y','N','N'),
 (2,'form_order_tracking','Y','Y','Y','Y','N','N'),
 (2,'form_outbound_order_items','Y','Y','Y','Y','N','N'),
 (2,'form_outbound_orders','Y','Y','Y','Y','N','N'),
 (2,'form_product_bundles','Y','Y','Y','Y','N','N'),
 (2,'form_product_categories','Y','Y','Y','Y','N','N'),
 (2,'form_product_offers','Y','Y','Y','Y','N','N'),
 (2,'form_product_variants','Y','Y','Y','Y','N','N'),
 (2,'form_products','Y','Y','Y','Y','N','N'),
 (2,'form_transaction_types','Y','Y','Y','Y','N','N'),
 (2,'form_vendors','Y','Y','Y','Y','N','N'),
 (2,'form_warehouses','Y','Y','Y','Y','N','N'),
 (2,'grid_contacts','Y','N','N','N','Y','Y'),
 (2,'grid_customer_orders','Y','N','N','N','Y','Y'),
 (2,'grid_customers','Y','N','N','N','Y','Y'),
 (2,'grid_inbound_order_items','Y','N','N','N','Y','Y'),
 (2,'grid_inbound_orders','Y','N','N','N','Y','Y'),
 (2,'grid_inventory','Y','N','N','N','Y','Y'),
 (2,'grid_inventory_transactions','Y','N','N','N','Y','Y'),
 (2,'grid_list_price','Y','N','N','N','Y','Y'),
 (2,'grid_list_price_detail_werehouses','Y','N','N','N','Y','Y'),
 (2,'grid_order_tracking','Y','N','N','N','Y','Y'),
 (2,'grid_outbound_orders','Y','N','N','N','Y','Y'),
 (2,'grid_product_bundles','Y','N','N','N','Y','Y'),
 (2,'grid_products','Y','N','N','N','Y','Y'),
 (2,'grid_vendor_orders','Y','N','N','N','Y','Y'),
 (2,'grid_vendors','Y','N','N','N','Y','Y'),
 (2,'m_add_2fa','Y','N','N','N','N','N'),
 (2,'m_change_pswd','Y','N','N','N','N','N'),
 (2,'m_control_2fa','Y','N','N','N','Y','Y'),
 (2,'m_form_add_users','Y','Y','Y','Y','N','N'),
 (2,'m_form_edit_users','Y','Y','Y','Y','N','N'),
 (2,'m_form_sec_apps','Y','Y','Y','Y','N','N'),
 (2,'m_form_sec_groups','Y','Y','Y','Y','N','N'),
 (2,'m_form_sec_groups_apps','Y','Y','Y','Y','N','N'),
 (2,'m_grid_sec_apps','Y','N','N','N','Y','Y'),
 (2,'m_grid_sec_groups','Y','N','N','N','Y','Y'),
 (2,'m_grid_sec_users','Y','N','N','N','Y','Y'),
 (2,'m_grid_sec_users_groups','Y','Y','Y','Y','N','N'),
 (2,'m_link_social','Y','N','N','N','N','N'),
 (2,'m_Login','Y','N','N','N','N','N'),
 (2,'m_my_info','Y','Y','Y','Y','N','N'),
 (2,'m_retrieve_pswd','Y','N','N','N','N','N'),
 (2,'m_search_sec_groups','Y','N','N','N','N','N'),
 (2,'m_settings','Y','N','N','N','N','N'),
 (2,'m_sync_apps','Y','N','N','N','N','N'), (2, 'menu', 'Y', 'N', 'N', 'N', 'N', 'N');

-- ----------------------------
-- Table structure for sec_settings
-- ----------------------------
CREATE TABLE `sec_settings`  (
  `set_name` varchar(255) NOT NULL,
  `set_value` varchar(255) NULL DEFAULT NULL,
  PRIMARY KEY (`set_name`) USING BTREE
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_settings
-- ----------------------------
INSERT INTO `sec_settings` VALUES ('auth_sn_fb', 'N'), ('auth_sn_fb_app_id', ''), ('auth_sn_fb_secret', ''), ('auth_sn_google', 'N'), ('auth_sn_google_client_id', ''), ('auth_sn_google_secret', ''), ('auth_sn_position', 'below'), ('auth_sn_x', 'N'), ('auth_sn_x_key', ''), ('auth_sn_x_secret', ''), ('brute_force', 'N'), ('brute_force_attempts', '5'), ('brute_force_time_block', '5'), ('captcha', 'N'), ('cookie_expiration_time', '30'), ('enable_2fa', 'N'), ('enable_2fa_api', ''), ('enable_2fa_api_type', 'email'), ('enable_2fa_expiration_time', '300'), ('enable_2fa_mode', 'individual'), ('group_administrator', '2'), ('group_default', '1'), ('language', 'N'), ('login_mode', 'username'), ('mfa_last_updated', '0'), ('new_users', 'N'), ('password_min', '8'), ('password_strength', 'uppercase_letter;lowercase_letter;numbers;special_chars'), ('pswd_last_updated', '0'), ('recover_pswd', 'send_link'), ('remember_me', 'N'), ('req_email_act', 'N'), ('retrieve_password', 'Y'), ('send_email_adm', 'N'), ('session_expire', 'N'), ('smtp_api', 'custom'), ('smtp_from_email', 'samples@scriptcase.com.br'), ('smtp_from_name', 'Samples Scriptcase'), ('smtp_pass', ''), ('smtp_port', '465'), ('smtp_security', 'ssl'), ('smtp_server', 'mail.google.com'), ('smtp_user', 'samples@scriptcase.com.br'), ('theme', 'Sc9_SoftCloud_sm');

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
CREATE TABLE `sec_users`  (
  `login` varchar(190) NOT NULL,
  `pswd` varchar(255) NOT NULL,
  `name` varchar(255) NULL DEFAULT NULL,
  `email` varchar(255) NULL DEFAULT NULL,
  `active` varchar(1) NULL DEFAULT NULL,
  `activation_code` varchar(32) NULL DEFAULT NULL,
  `priv_admin` varchar(1) NULL DEFAULT NULL,
  `mfa` varchar(255) NULL DEFAULT NULL,
  `picture` longblob NULL,
  `role` varchar(128) NULL DEFAULT NULL,
  `phone` varchar(64) NULL DEFAULT NULL,
  `pswd_last_updated` timestamp NULL DEFAULT NULL,
  `mfa_last_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`login`) USING BTREE
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO `sec_users` VALUES ('admin', '7fe997c8d3b2dd1a1ae5e76b0acc6084', 'Administrator', 'samples@scriptcase.com.br', 'Y', 'c34702052dd24f43df4777931ebae1ad', 'Y', NULL, NULL, NULL, NULL, '2025-09-05 10:09:08', NULL), ('scriptcase', 'abfb1f6bafb60754da143f69ee639fa8', 'Super Admin', 'bugs@scriptcase.com.br', 'Y', 'c34702052dd24f43df4777931ebae1ad', 'Y', NULL, NULL, NULL, NULL, '2025-09-05 10:09:08', NULL);

-- ----------------------------
-- Table structure for sec_users_groups
-- ----------------------------
CREATE TABLE `sec_users_groups`  (
  `login` varchar(190) NOT NULL,
  `group_id` int NOT NULL,
  PRIMARY KEY (`login`, `group_id`) USING BTREE,
  INDEX `sec_users_groups_ibfk_2`(`group_id`) USING BTREE,
  CONSTRAINT `sec_users_groups_ibfk_1` FOREIGN KEY (`login`) REFERENCES `sec_users` (`login`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `sec_users_groups_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------
INSERT INTO `sec_users_groups` VALUES ('admin', 1), ('scriptcase', 2);

-- ----------------------------
-- Table structure for sec_users_social
-- ----------------------------
CREATE TABLE `sec_users_social`  (
  `login` varchar(190) NOT NULL,
  `resource` varchar(190) NOT NULL,
  `resource_id` varchar(190) NOT NULL,
  PRIMARY KEY (`login`, `resource`, `resource_id`) USING BTREE
) ENGINE = InnoDB;

-- ----------------------------
-- Records of sec_users_social
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;

-- ----------------------------
-- View structure for view_product_inventory
-- ----------------------------
CREATE VIEW view_product_inventory AS
SELECT 
    product_id,
    product_name,
    description,
    variant_name,
    category_id,
    sku,
    barcode,
    brand,
    unit_type,
    image_bin,
    variant_id,
    SUM(quantity) AS total_quantity,
    minimum_quantity,
    base_price,
    additional_price,
    discount_percentage,
    total_price,
    category_name
FROM (
    SELECT
       p.product_id,
       p.product_name,
       p.description,
       pv.variant_name,
       p.category_id,
       COALESCE(pv.variant_sku, p.sku) AS sku,
       p.barcode,
       p.brand,
       p.unit_type,
       p.image_bin,
       i.variant_id,
       i.quantity,
       p.minimum_quantity,
       p.base_price,
       pv.additional_price,
       po.discount_percentage,
       p.base_price + COALESCE(pv.additional_price, 0) - (p.base_price * (COALESCE(po.discount_percentage, 0) / 100)) AS total_price, 
       pc.category_name
    FROM
       products p
       INNER JOIN product_categories pc ON p.category_id = pc.category_id
       LEFT JOIN product_variants pv ON p.product_id = pv.product_id
       LEFT JOIN inventory i ON i.product_id = p.product_id AND (i.variant_id = pv.variant_id OR i.variant_id IS NULL)
       LEFT JOIN product_offers po ON p.product_id = po.product_id AND (po.start_date < NOW() AND NOW() <= po.end_date)
) items
GROUP BY
    product_id,
    product_name,
    description,
    variant_name,
    category_id,
    sku,
    barcode,
    brand,
    unit_type,
    image_bin,
    variant_id,
    minimum_quantity,
    base_price,
    additional_price,
    discount_percentage,
    total_price,
    category_name;