<?php
/**
 * Template scriptcase.
 *
 * Cabecalho do template scriptcase.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2004/01/28
 * @copyright   NetMake Solucoes em Informatica
 * @author      Diogo Silva Toscano De Brito <diogo@ipadnet.com.br>
 *
 * $Id: body_form_ext_itens_menu.tpl.php,v 1.3 2011-10-24 16:59:37 luis Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

$arr_data  = $this->GetVar('field_data');

$arr_data['layouts_arr'] = [
    'desktop_h_resp' => [
        'name' => 'Desktop Horizontal Responsivo',
    ],
    'desktop_h_split' => [
        'name' => 'Desktop Horizontal Split',
    ],
    'desktop_v_toolbar' => [
        'name' => 'Desktop Vertical Toolbar',
    ],
    'desktop_v_user' => [
        'name' => 'Desktop Vertical Usuário',
    ],
    'desktop_v_user_toolbar' => [
        'name' => 'Desktop Vertical Usuário Toolbar',
    ],
];
$arr_data['layouts_arr'] = [
    'H' => [
        'name' => nm_get_text_lang("['horizontal']"),
    ],
    'V' => [
        'name' => nm_get_text_lang("['vertical']"),
    ],
];
$arr_data['fonts_arr'] = ["ABeeZee","Abel","Abhaya+Libre","Abril+Fatface","Aclonica","Acme","Actor","Adamina","Advent+Pro","Aguafina+Script","Akaya+Kanadaka","Akaya+Telivigala","Akronim","Aladin","Alata","Alatsi","Aldrich","Alef","Alegreya","Alegreya+SC","Alegreya+Sans","Alegreya+Sans+SC","Aleo","Alex+Brush","Alfa+Slab+One","Alice","Alike","Alike+Angular","Allan","Allerta","Allerta+Stencil","Allison","Allura","Almarai","Almendra","Almendra+Display","Almendra+SC","Alumni+Sans","Amarante","Amaranth","Amatic+SC","Amethysta","Amiko","Amiri","Amita","Anaheim","Andada+Pro","Andika","Andika+New+Basic","Angkor","Annie+Use+Your+Telescope","Anonymous+Pro","Antic","Antic+Didone","Antic+Slab","Anton","Antonio","Arapey","Arbutus","Arbutus+Slab","Architects+Daughter","Archivo","Archivo+Black","Archivo+Narrow","Are+You+Serious","Aref+Ruqaa","Arima+Madurai","Arimo","Arizonia","Armata","Arsenal","Artifika","Arvo","Arya","Asap","Asap+Condensed","Asar","Asset","Assistant","Astloch","Asul","Athiti","Atkinson+Hyperlegible","Atma","Atomic+Age","Aubrey","Audiowide","Autour+One","Average","Average+Sans","Averia+Gruesa+Libre","Averia+Libre","Averia+Sans+Libre","Averia+Serif+Libre","Azeret+Mono","B612","B612+Mono","Bad+Script","Bahiana","Bahianita","Bai+Jamjuree","Ballet","Baloo+2","Baloo+Bhai+2","Baloo+Bhaina+2","Baloo+Chettan+2","Baloo+Da+2","Baloo+Paaji+2","Baloo+Tamma+2","Baloo+Tammudu+2","Baloo+Thambi+2","Balsamiq+Sans","Balthazar","Bangers","Barlow","Barlow+Condensed","Barlow+Semi+Condensed","Barriecito","Barrio","Basic","Baskervville","Battambang","Baumans","Bayon","Be+Vietnam","Be+Vietnam+Pro","Bebas+Neue","Belgrano","Bellefair","Belleza","Bellota","Bellota+Text","BenchNine","Benne","Bentham","Berkshire+Swash","Besley","Beth+Ellen","Bevan","Big+Shoulders+Display","Big+Shoulders+Inline+Display","Big+Shoulders+Inline+Text","Big+Shoulders+Stencil+Display","Big+Shoulders+Stencil+Text","Big+Shoulders+Text","Bigelow+Rules","Bigshot+One","Bilbo","Bilbo+Swash+Caps","BioRhyme","BioRhyme+Expanded","Birthstone","Birthstone+Bounce","Biryani","Bitter","Black+And+White+Picture","Black+Han+Sans","Black+Ops+One","Blinker","Bodoni+Moda","Bokor","Bona+Nova","Bonbon","Bonheur+Royale","Boogaloo","Bowlby+One","Bowlby+One+SC","Brawler","Bree+Serif","Brygada+1918","Bubblegum+Sans","Bubbler+One","Buda","Buenard","Bungee","Bungee+Hairline","Bungee+Inline","Bungee+Outline","Bungee+Shade","Butcherman","Butterfly+Kids","Cabin","Cabin+Condensed","Cabin+Sketch","Caesar+Dressing","Cagliostro","Cairo","Caladea","Calistoga","Calligraffitti","Cambay","Cambo","Candal","Cantarell","Cantata+One","Cantora+One","Capriola","Caramel","Carattere","Cardo","Carme","Carrois+Gothic","Carrois+Gothic+SC","Carter+One","Castoro","Catamaran","Caudex","Caveat","Caveat+Brush","Cedarville+Cursive","Ceviche+One","Chakra+Petch","Changa","Changa+One","Chango","Charm","Charmonman","Chathura","Chau+Philomene+One","Chela+One","Chelsea+Market","Chenla","Cherish","Cherry+Cream+Soda","Cherry+Swash","Chewy","Chicle","Chilanka","Chivo","Chonburi","Cinzel","Cinzel+Decorative","Clicker+Script","Coda","Coda+Caption","Codystar","Coiny","Combo","Comfortaa","Comic+Neue","Coming+Soon","Commissioner","Concert+One","Condiment","Content","Contrail+One","Convergence","Cookie","Copse","Corben","Cormorant","Cormorant+Garamond","Cormorant+Infant","Cormorant+SC","Cormorant+Unicase","Cormorant+Upright","Courgette","Courier+Prime","Cousine","Coustard","Covered+By+Your+Grace","Crafty+Girls","Creepster","Crete+Round","Crimson+Pro","Crimson+Text","Croissant+One","Crushed","Cuprum","Cute+Font","Cutive","Cutive+Mono","DM+Mono","DM+Sans","DM+Serif+Display","DM+Serif+Text","Damion","Dancing+Script","Dangrek","Darker+Grotesque","David+Libre","Dawning+of+a+New+Day","Days+One","Dekko","Dela+Gothic+One","Delius","Delius+Swash+Caps","Delius+Unicase","Della+Respira","Denk+One","Devonshire","Dhurjati","Didact+Gothic","Diplomata","Diplomata+SC","Do+Hyeon","Dokdo","Domine","Donegal+One","Doppio+One","Dorsa","Dosis","DotGothic16","Dr+Sugiyama","Duru+Sans","Dynalight","EB+Garamond","Eagle+Lake","East+Sea+Dokdo","Eater","Economica","Eczar","El+Messiri","Electrolize","Elsie","Elsie+Swash+Caps","Emblema+One","Emilys+Candy","Encode+Sans","Encode+Sans+Condensed","Encode+Sans+Expanded","Encode+Sans+SC","Encode+Sans+Semi+Condensed","Encode+Sans+Semi+Expanded","Engagement","Englebert","Enriqueta","Ephesis","Epilogue","Erica+One","Esteban","Euphoria+Script","Ewert","Exo","Exo+2","Expletus+Sans","Explora","Fahkwang","Fanwood+Text","Farro","Farsan","Fascinate","Fascinate+Inline","Faster+One","Fasthand","Fauna+One","Faustina","Federant","Federo","Felipa","Fenix","Festive","Finger+Paint","Fira+Code","Fira+Mono","Fira+Sans","Fira+Sans+Condensed","Fira+Sans+Extra+Condensed","Fjalla+One","Fjord+One","Flamenco","Flavors","Fleur+De+Leah","Fondamento","Fontdiner+Swanky","Forum","Francois+One","Frank+Ruhl+Libre","Fraunces","Freckle+Face","Fredericka+the+Great","Fredoka+One","Freehand","Fresca","Frijole","Fruktur","Fugaz+One","Fuggles","GFS+Didot","GFS+Neohellenic","Gabriela","Gaegu","Gafata","Galada","Galdeano","Galindo","Gamja+Flower","Gayathri","Gelasio","Gemunu+Libre","Gentium+Basic","Gentium+Book+Basic","Geo","Georama","Geostar","Geostar+Fill","Germania+One","Gideon+Roman","Gidugu","Gilda+Display","Girassol","Give+You+Glory","Glass+Antiqua","Glegoo","Gloria+Hallelujah","Glory","Gluten","Goblin+One","Gochi+Hand","Goldman","Gorditas","Gothic+A1","Gotu","Goudy+Bookletter+1911","Gowun+Batang","Gowun+Dodum","Graduate","Grand+Hotel","Grandstander","Gravitas+One","Great+Vibes","Grechen+Fuemen","Grenze","Grenze+Gotisch","Grey+Qo","Griffy","Gruppo","Gudea","Gugi","Gupter","Gurajada","Habibi","Hachi+Maru+Pop","Hahmlet","Halant","Hammersmith+One","Hanalei","Hanalei+Fill","Handlee","Hanuman","Happy+Monkey","Harmattan","Headland+One","Heebo","Henny+Penny","Hepta+Slab","Herr+Von+Muellerhoff","Hi+Melody","Hina+Mincho","Hind","Hind+Guntur","Hind+Madurai","Hind+Siliguri","Hind+Vadodara","Holtwood+One+SC","Homemade+Apple","Homenaje","IBM+Plex+Mono","IBM+Plex+Sans","IBM+Plex+Sans+Arabic","IBM+Plex+Sans+Condensed","IBM+Plex+Sans+Devanagari","IBM+Plex+Sans+Hebrew","IBM+Plex+Sans+KR","IBM+Plex+Sans+Thai","IBM+Plex+Sans+Thai+Looped","IBM+Plex+Serif","IM+Fell+DW+Pica","IM+Fell+DW+Pica+SC","IM+Fell+Double+Pica","IM+Fell+Double+Pica+SC","IM+Fell+English","IM+Fell+English+SC","IM+Fell+French+Canon","IM+Fell+French+Canon+SC","IM+Fell+Great+Primer","IM+Fell+Great+Primer+SC","Ibarra+Real+Nova","Iceberg","Iceland","Imbue","Imprima","Inconsolata","Inder","Indie+Flower","Inika","Inknut+Antiqua","Inria+Sans","Inria+Serif","Inter","Irish+Grover","Istok+Web","Italiana","Italianno","Itim","Jacques+Francois","Jacques+Francois+Shadow","Jaldi","JetBrains+Mono","Jim+Nightshade","Jockey+One","Jolly+Lodger","Jomhuria","Jomolhari","Josefin+Sans","Josefin+Slab","Jost","Joti+One","Jua","Judson","Julee","Julius+Sans+One","Junge","Jura","Just+Another+Hand","Just+Me+Again+Down+Here","K2D","Kadwa","Kaisei+Decol","Kaisei+HarunoUmi","Kaisei+Opti","Kaisei+Tokumin","Kalam","Kameron","Kanit","Kantumruy","Karantina","Karla","Karma","Katibeh","Kaushan+Script","Kavivanar","Kavoon","Kdam+Thmor","Keania+One","Kelly+Slab","Kenia","Khand","Khmer","Khula","Kirang+Haerang","Kite+One","Kiwi+Maru","Klee+One","Knewave","KoHo","Kodchasan","Koh+Santepheap","Kosugi","Kosugi+Maru","Kotta+One","Koulen","Kranky","Kreon","Kristi","Krona+One","Krub","Kufam","Kulim+Park","Kumar+One","Kumar+One+Outline","Kumbh+Sans","Kurale","La+Belle+Aurore","Lacquer","Laila","Lakki+Reddy","Lalezar","Lancelot","Langar","Lateef","Lato","League+Script","Leckerli+One","Ledger","Lekton","Lemon","Lemonada","Lexend","Lexend+Deca","Lexend+Exa","Lexend+Giga","Lexend+Mega","Lexend+Peta","Lexend+Tera","Lexend+Zetta","Libre+Barcode+128","Libre+Barcode+128+Text","Libre+Barcode+39","Libre+Barcode+39+Extended","Libre+Barcode+39+Extended+Text","Libre+Barcode+39+Text","Libre+Barcode+EAN13+Text","Libre+Baskerville","Libre+Caslon+Display","Libre+Caslon+Text","Libre+Franklin","Life+Savers","Lilita+One","Lily+Script+One","Limelight","Linden+Hill","Literata","Liu+Jian+Mao+Cao","Livvic","Lobster","Lobster+Two","Londrina+Outline","Londrina+Shadow","Londrina+Sketch","Londrina+Solid","Long+Cang","Lora","Love+Ya+Like+A+Sister","Loved+by+the+King","Lovers+Quarrel","Luckiest+Guy","Lusitana","Lustria","M+PLUS+1p","M+PLUS+Rounded+1c","Ma+Shan+Zheng","Macondo","Macondo+Swash+Caps","Mada","Magra","Maiden+Orange","Maitree","Major+Mono+Display","Mako","Mali","Mallanna","Mandali","Manjari","Manrope","Mansalva","Manuale","Marcellus","Marcellus+SC","Marck+Script","Margarine","Markazi+Text","Marko+One","Marmelad","Martel","Martel+Sans","Marvel","Mate","Mate+SC","Material+Icons","Maven+Pro","McLaren","Meddon","MedievalSharp","Medula+One","Meera+Inimai","Megrim","Meie+Script","Merienda","Merienda+One","Merriweather","Merriweather+Sans","Metal","Metal+Mania","Metamorphous","Metrophobic","Michroma","Milonga","Miltonian","Miltonian+Tattoo","Mina","Miniver","Miriam+Libre","Mirza","Miss+Fajardose","Mitr","Modak","Modern+Antiqua","Mogra","Molengo","Molle","Monda","Monofett","Monoton","Monsieur+La+Doulaise","Montaga","MonteCarlo","Montez","Montserrat","Montserrat+Alternates","Montserrat+Subrayada","Moul","Moulpali","Mountains+of+Christmas","Mouse+Memoirs","Mr+Bedfort","Mr+Dafoe","Mr+De+Haviland","Mrs+Saint+Delafield","Mrs+Sheppards","Mukta","Mukta+Mahee","Mukta+Malar","Mukta+Vaani","Mulish","MuseoModerno","Mystery+Quest","NTR","Nanum+Brush+Script","Nanum+Gothic","Nanum+Gothic+Coding","Nanum+Myeongjo","Nanum+Pen+Script","Nerko+One","Neucha","Neuton","New+Rocker","New+Tegomin","News+Cycle","Newsreader","Niconne","Niramit","Nixie+One","Nobile","Nokora","Norican","Nosifer","Notable","Nothing+You+Could+Do","Noticia+Text","Noto+Kufi+Arabic","Noto+Music","Noto+Naskh+Arabic","Noto+Nastaliq+Urdu","Noto+Rashi+Hebrew","Noto+Sans","Noto+Sans+Adlam","Noto+Sans+Adlam+Unjoined","Noto+Sans+Anatolian+Hieroglyphs","Noto+Sans+Arabic","Noto+Sans+Armenian","Noto+Sans+Avestan","Noto+Sans+Balinese","Noto+Sans+Bamum","Noto+Sans+Bassa+Vah","Noto+Sans+Batak","Noto+Sans+Bengali","Noto+Sans+Bhaiksuki","Noto+Sans+Brahmi","Noto+Sans+Buginese","Noto+Sans+Buhid","Noto+Sans+Canadian+Aboriginal","Noto+Sans+Carian","Noto+Sans+Caucasian+Albanian","Noto+Sans+Chakma","Noto+Sans+Cham","Noto+Sans+Cherokee","Noto+Sans+Coptic","Noto+Sans+Cuneiform","Noto+Sans+Cypriot","Noto+Sans+Deseret","Noto+Sans+Devanagari","Noto+Sans+Display","Noto+Sans+Duployan","Noto+Sans+Egyptian+Hieroglyphs","Noto+Sans+Elbasan","Noto+Sans+Elymaic","Noto+Sans+Georgian","Noto+Sans+Glagolitic","Noto+Sans+Gothic","Noto+Sans+Grantha","Noto+Sans+Gujarati","Noto+Sans+Gunjala+Gondi","Noto+Sans+Gurmukhi","Noto+Sans+HK","Noto+Sans+Hanifi+Rohingya","Noto+Sans+Hanunoo","Noto+Sans+Hatran","Noto+Sans+Hebrew","Noto+Sans+Imperial+Aramaic","Noto+Sans+Indic+Siyaq+Numbers","Noto+Sans+Inscriptional+Pahlavi","Noto+Sans+Inscriptional+Parthian","Noto+Sans+JP","Noto+Sans+Javanese","Noto+Sans+KR","Noto+Sans+Kaithi","Noto+Sans+Kannada","Noto+Sans+Kayah+Li","Noto+Sans+Kharoshthi","Noto+Sans+Khmer","Noto+Sans+Khojki","Noto+Sans+Khudawadi","Noto+Sans+Lao","Noto+Sans+Lepcha","Noto+Sans+Limbu","Noto+Sans+Linear+A","Noto+Sans+Linear+B","Noto+Sans+Lisu","Noto+Sans+Lycian","Noto+Sans+Lydian","Noto+Sans+Mahajani","Noto+Sans+Malayalam","Noto+Sans+Mandaic","Noto+Sans+Manichaean","Noto+Sans+Marchen","Noto+Sans+Masaram+Gondi","Noto+Sans+Math","Noto+Sans+Mayan+Numerals","Noto+Sans+Medefaidrin","Noto+Sans+Meroitic","Noto+Sans+Miao","Noto+Sans+Modi","Noto+Sans+Mongolian","Noto+Sans+Mono","Noto+Sans+Mro","Noto+Sans+Multani","Noto+Sans+Myanmar","Noto+Sans+N+Ko","Noto+Sans+Nabataean","Noto+Sans+New+Tai+Lue","Noto+Sans+Newa","Noto+Sans+Nushu","Noto+Sans+Ogham","Noto+Sans+Ol+Chiki","Noto+Sans+Old+Hungarian","Noto+Sans+Old+Italic","Noto+Sans+Old+North+Arabian","Noto+Sans+Old+Permic","Noto+Sans+Old+Persian","Noto+Sans+Old+Sogdian","Noto+Sans+Old+South+Arabian","Noto+Sans+Old+Turkic","Noto+Sans+Oriya","Noto+Sans+Osage","Noto+Sans+Osmanya","Noto+Sans+Pahawh+Hmong","Noto+Sans+Palmyrene","Noto+Sans+Pau+Cin+Hau","Noto+Sans+Phags+Pa","Noto+Sans+Phoenician","Noto+Sans+Psalter+Pahlavi","Noto+Sans+Rejang","Noto+Sans+Runic","Noto+Sans+SC","Noto+Sans+Samaritan","Noto+Sans+Saurashtra","Noto+Sans+Sharada","Noto+Sans+Shavian","Noto+Sans+Siddham","Noto+Sans+Sinhala","Noto+Sans+Sogdian","Noto+Sans+Sora+Sompeng","Noto+Sans+Soyombo","Noto+Sans+Sundanese","Noto+Sans+Syloti+Nagri","Noto+Sans+Symbols","Noto+Sans+Symbols+2","Noto+Sans+Syriac","Noto+Sans+TC","Noto+Sans+Tagalog","Noto+Sans+Tagbanwa","Noto+Sans+Tai+Le","Noto+Sans+Tai+Tham","Noto+Sans+Tai+Viet","Noto+Sans+Takri","Noto+Sans+Tamil","Noto+Sans+Tamil+Supplement","Noto+Sans+Telugu","Noto+Sans+Thaana","Noto+Sans+Thai","Noto+Sans+Thai+Looped","Noto+Sans+Tifinagh","Noto+Sans+Tirhuta","Noto+Sans+Ugaritic","Noto+Sans+Vai","Noto+Sans+Wancho","Noto+Sans+Warang+Citi","Noto+Sans+Yi","Noto+Sans+Zanabazar+Square","Noto+Serif","Noto+Serif+Ahom","Noto+Serif+Armenian","Noto+Serif+Balinese","Noto+Serif+Bengali","Noto+Serif+Devanagari","Noto+Serif+Display","Noto+Serif+Dogra","Noto+Serif+Ethiopic","Noto+Serif+Georgian","Noto+Serif+Grantha","Noto+Serif+Gujarati","Noto+Serif+Gurmukhi","Noto+Serif+Hebrew","Noto+Serif+JP","Noto+Serif+KR","Noto+Serif+Kannada","Noto+Serif+Khmer","Noto+Serif+Lao","Noto+Serif+Malayalam","Noto+Serif+Myanmar","Noto+Serif+Nyiakeng+Puachue+Hmong","Noto+Serif+SC","Noto+Serif+Sinhala","Noto+Serif+TC","Noto+Serif+Tamil","Noto+Serif+Tangut","Noto+Serif+Telugu","Noto+Serif+Thai","Noto+Serif+Tibetan","Noto+Serif+Yezidi","Noto+Traditional+Nushu","Nova+Cut","Nova+Flat","Nova+Mono","Nova+Oval","Nova+Round","Nova+Script","Nova+Slim","Nova+Square","Numans","Nunito","Nunito+Sans","Odibee+Sans","Odor+Mean+Chey","Offside","Oi","Old+Standard+TT","Oldenburg","Oleo+Script","Oleo+Script+Swash+Caps","Open+Sans","Open+Sans+Condensed","Oranienbaum","Orbitron","Oregano","Orelega+One","Orienta","Original+Surfer","Oswald","Otomanopee+One","Over+the+Rainbow","Overlock","Overlock+SC","Overpass","Overpass+Mono","Ovo","Oxanium","Oxygen","Oxygen+Mono","PT+Mono","PT+Sans","PT+Sans+Caption","PT+Sans+Narrow","PT+Serif","PT+Serif+Caption","Pacifico","Padauk","Palanquin","Palanquin+Dark","Palette+Mosaic","Pangolin","Paprika","Parisienne","Passero+One","Passion+One","Pathway+Gothic+One","Patrick+Hand","Patrick+Hand+SC","Pattaya","Patua+One","Pavanam","Paytone+One","Peddana","Peralta","Permanent+Marker","Petit+Formal+Script","Petrona","Philosopher","Piazzolla","Piedra","Pinyon+Script","Pirata+One","Plaster","Play","Playball","Playfair+Display","Playfair+Display+SC","Podkova","Poiret+One","Poller+One","Poly","Pompiere","Pontano+Sans","Poor+Story","Poppins","Port+Lligat+Sans","Port+Lligat+Slab","Potta+One","Pragati+Narrow","Prata","Preahvihear","Press+Start+2P","Pridi","Princess+Sofia","Prociono","Prompt","Prosto+One","Proza+Libre","Public+Sans","Puritan","Purple+Purse","Qahiri","Quando","Quantico","Quattrocento","Quattrocento+Sans","Questrial","Quicksand","Quintessential","Qwigley","Racing+Sans+One","Radley","Rajdhani","Rakkas","Raleway","Raleway+Dots","Ramabhadra","Ramaraja","Rambla","Rammetto+One","Rampart+One","Ranchers","Rancho","Ranga","Rasa","Rationale","Ravi+Prakash","Recursive","Red+Hat+Display","Red+Hat+Text","Red+Rose","Redressed","Reem+Kufi","Reenie+Beanie","Reggae+One","Revalia","Rhodium+Libre","Ribeye","Ribeye+Marrow","Righteous","Risque","Roboto","Roboto+Condensed","Roboto+Mono","Roboto+Slab","Rochester","Rock+Salt","RocknRoll+One","Rokkitt","Romanesco","Ropa+Sans","Rosario","Rosarivo","Rouge+Script","Rowdies","Rozha+One","Rubik","Rubik+Beastly","Rubik+Mono+One","Ruda","Rufina","Ruge+Boogie","Ruluko","Rum+Raisin","Ruslan+Display","Russo+One","Ruthie","Rye","STIX+Two+Text","Sacramento","Sahitya","Sail","Saira","Saira+Condensed","Saira+Extra+Condensed","Saira+Semi+Condensed","Saira+Stencil+One","Salsa","Sanchez","Sancreek","Sansita","Sansita+Swashed","Sarabun","Sarala","Sarina","Sarpanch","Satisfy","Sawarabi+Gothic","Sawarabi+Mincho","Scada","Scheherazade","Scheherazade+New","Schoolbell","Scope+One","Seaweed+Script","Secular+One","Sedgwick+Ave","Sedgwick+Ave+Display","Sen","Sevillana","Seymour+One","Shadows+Into+Light","Shadows+Into+Light+Two","Shanti","Share","Share+Tech","Share+Tech+Mono","Shippori+Mincho","Shippori+Mincho+B1","Shojumaru","Short+Stack","Shrikhand","Siemreap","Sigmar+One","Signika","Signika+Negative","Simonetta","Single+Day","Sintony","Sirin+Stencil","Six+Caps","Skranji","Slabo+13px","Slabo+27px","Slackey","Smokum","Smythe","Sniglet","Snippet","Snowburst+One","Sofadi+One","Sofia","Solway","Song+Myung","Sonsie+One","Sora","Sorts+Mill+Goudy","Source+Code+Pro","Source+Sans+Pro","Source+Serif+Pro","Space+Grotesk","Space+Mono","Spartan","Special+Elite","Spectral","Spectral+SC","Spicy+Rice","Spinnaker","Spirax","Squada+One","Sree+Krushnadevaraya","Sriracha","Srisakdi","Staatliches","Stalemate","Stalinist+One","Stardos+Stencil","Stick","Stick+No+Bills","Stint+Ultra+Condensed","Stint+Ultra+Expanded","Stoke","Strait","Style+Script","Stylish","Sue+Ellen+Francisco","Suez+One","Sulphur+Point","Sumana","Sunflower","Sunshiney","Supermercado+One","Sura","Suranna","Suravaram","Suwannaphum","Swanky+and+Moo+Moo","Syncopate","Syne","Syne+Mono","Syne+Tactile","Tajawal","Tangerine","Taprom","Tauri","Taviraj","Teko","Telex","Tenali+Ramakrishna","Tenor+Sans","Text+Me+One","Texturina","Thasadith","The+Girl+Next+Door","Tienne","Tillana","Timmana","Tinos","Titan+One","Titillium+Web","Tomorrow","Tourney","Trade+Winds","Train+One","Trirong","Trispace","Trocchi","Trochut","Truculenta","Trykker","Tulpen+One","Turret+Road","Ubuntu","Ubuntu+Condensed","Ubuntu+Mono","Uchen","Ultra","Uncial+Antiqua","Underdog","Unica+One","UnifrakturCook","UnifrakturMaguntia","Unkempt","Unlock","Unna","Urbanist","VT323","Vampiro+One","Varela","Varela+Round","Varta","Vast+Shadow","Vesper+Libre","Viaoda+Libre","Vibes","Vibur","Vidaloka","Viga","Voces","Volkhov","Vollkorn","Vollkorn+SC","Voltaire","Waiting+for+the+Sunrise","Wallpoet","Walter+Turncoat","Warnes","Wellfleet","Wendy+One","WindSong","Wire+One","Work+Sans","Xanh+Mono","Yaldevi","Yanone+Kaffeesatz","Yantramanav","Yatra+One","Yellowtail","Yeon+Sung","Yeseva+One","Yesteryear","Yomogi","Yrsa","Yusei+Magic","ZCOOL+KuaiLe","ZCOOL+QingKe+HuangYou","ZCOOL+XiaoWei","Zen+Antique","Zen+Antique+Soft","Zen+Dots","Zen+Kaku+Gothic+Antique","Zen+Kaku+Gothic+New","Zen+Kurenaido","Zen+Loop","Zen+Maru+Gothic","Zen+Old+Mincho","Zen+Tokyo+Zoo","Zeyada","Zhi+Mang+Xing","Zilla+Slab","Zilla+Slab+Highlight"];
$arr_data['fonts_arr'] = ["Roboto","Open+Sans","Lato","Montserrat","Poppins","Nunito","Raleway","Roboto+Condensed","Oswald","Playfair+Display","Noto+Sans","Ubuntu","Titillium+Web","Fira+Sans","Source+Sans+Pro","Noto+Serif","Merriweather","PT+Sans","Lora","Alegreya","Roboto+Slab","Pacifico","Great+Vibes","Quicksand","Dancing+Script","Crimson+Text","Work+Sans","Alice","Archivo+Black","Anton"];
sort($arr_data['fonts_arr']);
$fonts_arr = $arr_data['fonts_arr'];

$str_form_modif = ('' == $nm_config['form_modif']) ? 'null' : $nm_config['form_modif'];
$themes_arr = $arr_data['themes_arr'];
$layouts_arr = $arr_data['layouts_arr'];
$val_arr = $arr_data['value'];
$target_opts = [
    'self',
    'blank',
//    'window',
    'parente'
];
?>
<link href='https://fonts.googleapis.com/css?family=<?php echo join('|', $arr_data['fonts_arr']);?>' rel='stylesheet' type='text/css'>
<tr>
    <td >
        <style>

            .actions-bar {
                height:50px;
                position: fixed;
                bottom:0;
                left:0;
                width:100%;
                border-top:1px solid #D4D5D6;
                background:#F3F4F5;
                padding:7px 0;
                z-index: 10;
            }
            #preview_frame{
                width: 100%;
                height: 500px;
                background: #eee;
            }
            .partitions_container {
                max-width: 100%;
                display: flex;
                flex-direction: row;
                align-items: flex-start;
                justify-content: center;
            }
            .partition {
                display: flex;
                flex-direction: column;
                align-items: flex-start;
                justify-content: center;
                padding: 10px 15px;
                width: 33%;
            }
            .partition.small {
                /*flex-grow: 1;*/
                width 30%;
            }
            .partition.big {
                /*flex-grow: 1;*/
                width: 40%;
            }
            .partition.full {
                /*flex-grow: 1;*/
                width: 100%;
            }
            .partition.free {
                /*flex-grow: 1;*/
                display: block;
                width: 100%;
            }
            .partition.push {
                flex-grow: 1;
            }
            .section {
                margin: 10px 0;
                width: 100% !important;
            }
            .color_preview {
                display: block;
            }
            .color_preview .nm_primary_preview {
                display: flex;
                flex-direction: row;
                justify-content: center;
                align-items: center;
                height: 40px;
                background: var(--nm-primary-color);
                border-radius: 4px;
                width: 100%;
                column-gap: 15px;
                box-shadow:  0 2px 6px var(--nm-box-shadow);
            }
            .color_preview .nm_secondary_preview {
                display: flex;
                flex-direction: row;
                justify-content: center;
                align-items: center;
                padding: 8px;
                margin: -8px;
                background: var(--nm-secondary-color);
                border-radius: 6px;
            }
            .color_preview .nm_fontcolor_preview {
                display: block;
                background: var(--nm-fontcolor-color);
                border-radius: 10px;
                width: 48px;
                height: 10px;
            }

            .button_row {
                display: flex;
                flex-direction: row;
                justify-content: flex-start;
                align-items: center;
                flex-wrap: wrap;
                gap: 5px;
            }
            .nm_menu_items_list {
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: stretch;
                margin: 10px 0;
                padding: 3px 10px;
                list-style: none;
                height: 380px;
                overflow-y: auto;
                overflow-x: auto;
            }
            .nm_menu_items_list ul {
                display:flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: stretch;
                padding: 0;
                list-style: none;
                width: 100%;
            }
            .nm_menu_items_list ul{
                margin-top: 5px;
            }
            .nm_menu_items_list ul:empty {
                margin-top: 0px !important;
            }
            .nm_menu_items_list .nm_menu_item {
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
                align-items: flex-start;
            }
            .nm_menu_items_list .item_content {
                display: flex;
                flex-direction: row;
                justify-content: flex-start;
                align-items: center;
                width: 100%;
                padding: 0 6px;
                column-gap: 8px;
                height: 30px;
                border-radius: 4px;
                color: #333;
                font-weight: bold;
            }
            .selected_item {
                outline: solid 3px #a7a7a7;
                outline-offset: -2px;
                border-radius: 4px;
            }
            .nm_menu_items_list > .nm_menu_item > .item_content {
                background: #e5e5e5;
            }
            .nm_menu_items_list > .nm_menu_item > ul > .nm_menu_item > .item_content {
                background: #e5e5e5;
                padding-left: 22px;
            }
            .nm_menu_items_list > .nm_menu_item > ul > .nm_menu_item > ul > .nm_menu_item > .item_content {
                background: #e5e5e5;
                padding-left: 38px;
            }
            .icon_field {
                display: flex;
                flex-direction: row;
                justify-content: flex-start;
                align-items: center;
                gap: 15px;
            }
            .inspire-tree .title-wrap .title.icon:before {
                display: none !important;

            }
            .inspire-tree .title-wrap .title {
                color: #666;
                font-weight: bold;

            }
            .tree_icon_pos  {
                position: absolute;
                top: 5px;
                left: 25px;

            }

            .icheck {
                border-color: #d1dde2!important;
                background-color: #eff3f5!important;
            }

            .icheck.icheck-checked {
                border-color: #1fb6ff!important;
                box-shadow: #1fb6ff 0px 0px 0px 16px inset!important;
                background-color: #1fb6ff!important;
                transition: border 0.4s, box-shadow 0.4s, background-color 1.2s!important;
                border-color: #1fb6ff!important;
            }

            .icheck.disabled {
                opacity: 0.3;
            }

            .sorter-wrapper {
                width: 100%;
                display: flex;
                flex-direction: column;
                align-items: stretch;
                justify-content: flex-start;
                gap: 5px;
                height: 400px;
                border: solid 1px rgba(0,0,0,.2);
                padding: 10px;
                overflow-y: auto;
            }
            .sorter-wrapper .sortingBlock {
                height: 50px;
                border: solid 1px rgba(0,0,0,.1);
                border-radius: 4px;
                display: flex;
                flex-direction: row;
                align-items: center;
                justify-content: flex-start;
                padding: 10px 20px;
                gap: 10px;
                cursor: pointer;
                color: #555;
            }
            .sorter-wrapper .sortingBlock.moving {
                background-color: rgba(0, 208, 255, 0.3);
            }
            .sorter-wrapper .sortingBlock:hover {
                border-color: rgba(0, 208, 255, 0.49);
            }
            .popover {
                position: absolute;
                top: 0;
                left: 0;
                z-index: 1060;
                display: none;
                max-width: 276px;
                padding: 1px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                font-size: 14px;
                font-style: normal;
                font-weight: 400;
                line-height: 1.42857143;
                text-align: left;
                text-align: start;
                text-decoration: none;
                text-shadow: none;
                text-transform: none;
                letter-spacing: normal;
                word-break: normal;
                word-spacing: normal;
                word-wrap: normal;
                white-space: normal;
                background-color: #fff;
                -webkit-background-clip: padding-box;
                background-clip: padding-box;
                border: 1px solid #ccc;
                border: 1px solid rgba(0,0,0,.2);
                border-radius: 6px;
                -webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
                box-shadow: 0 5px 10px rgba(0,0,0,.2);
                line-break: auto;
            }
            .form-control {
                display: block;
                width: 100%;
                height: 34px;
                padding: 6px 12px;
                font-size: 14px;
                line-height: 1.42857143;
                color: #555;
                background-color: #fff;
                background-image: none;
                border: 1px solid #ccc;
                border-radius: 4px;
                -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
                box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
                -webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s;
                -o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
                transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
            }
            .form-control:focus {
                border-color: #66afe9;
                outline: 0;
                -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6);
                box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6);
            }

            .tb_field.tb_separator {
                padding: 20px 0;
            }

            .tb_field.tb_padded {
                padding: 0 0 0 20px;
            }

            .tb_field.tb_separator hr {
                border: solid 1px rgba(0,0,0,.3);
                border-width: 0 0 1px 0;
            }
            .font-selector-item {
                border: solid 0px rgba(0, 0, 0, 0.1) !important;
                border-width: 0 0 1px 0 !important;

            }
            .font-selector-item-name {
                font-size: 1.2rem;
                text-decoration: none;
                padding: 5px 0px 10px 0px;
                font-weight: bold;
                color: #69848e;
            }
            .font-selector-item-name-custom {
                font-size: 1rem;
                text-decoration: none;
            }
            .font-selector-item-sample {
                font-size: 1rem;
                text-decoration: none;
                padding: 5px 0px 10px 0px;
                max-width: 35vw;
                white-space: normal;
                word-break: break-all;
                line-height: 18px;
            }
            span.mega_indicator {
                display: inline-flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                margin: 0 0 0 10px;
                padding: 0px 5px;
                vertical-align: middle;
                border-radius: 3px;
                font-size: 9px;
                height: 18px;
            }
            span.mega_indicator.mega_root {
                background: #3C4858;
                color: #fefefe;
            }
            span.mega_indicator.mega_column {
                background: #c2b779;
                color: #333;
            }
        </style>
        <style id="preview_swap">

        </style>
        <br />
        <div class="" style="padding: 20px;">
            <div class="ui top attached tabular menu" id="tabs-holder">
                <a class="active tab-item item" data-tab="menu"><?php echo nm_get_text_lang("['menu_items']"); ?></a>
                <a class="tab-item item" data-tab="user"> <?php echo nm_get_text_lang("['menu_editor_user_menu']"); ?></a>
                <a class="tab-item item" data-tab="tb"><?php echo nm_get_text_lang("['menu_editor_tb_menu_items']"); ?></a>
                <a class="tab-item item" data-tab="layout"><?php echo nm_get_text_lang("['menu_tree_layout']", 'Menu'); ?></a>
            </div>
            <div class="ui bottom attached tab segment" data-tab="layout">

                <div class="partitions_container">

                    <div class="partition full">
                        <div class="ui container section" id="layout_section">
                            <div class="content ui form">
                                <div class="three fields">

                                    <div class="field">
                                        <div class="ui checkbox">
                                            <?php
                                            $check = '';
                                            if ($arr_data['value']['should_reload'] == 'S') {
                                                $check = 'checked="checked"';
                                            }
                                            ?>
                                            <input <?php echo $check; ?> type="checkbox" name="should_reload" id="should_reload" onclick="updateValueArr(true);" />
                                            <label for="should_reload"><?php echo nm_get_text_lang("['should_reload']", 'App'); ?></label>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="ui checkbox">
                                            <?php
                                            $check = '';
                                            if ($arr_data['value']['check_use_loader'] == 'S') {
                                                $check = 'checked="checked"';
                                            }
                                            ?>
                                            <input <?php echo $check; ?> type="checkbox" name="check_use_loader" id="check_use_loader" onclick="updateValueArr(true);" />
                                            <label for="check_use_loader"><?php echo nm_get_text_lang("['menu_enable_loader']", 'App'); ?></label>
                                        </div>
                                    </div>
                                    <div class="field">

                                    </div>
                                </div>
                                <div class="two fields">
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['app_fld']['menu_orientacao']['title']", 'App'); ?></label>
                                        <select name="layout_list" id="layout_list" class="ui dropdown">
                                            <?php
                                            foreach ($layouts_arr as $k => $layout) {
                                                $sel = '';
                                                if ($arr_data['value']['layout'] == $k) {
                                                    $sel = 'selected="selected"';
                                                }
                                                ?>
                                                <option <?php echo $sel; ?> value="<?php echo $k; ?>"><?php echo $layout['name']; ?></option>
                                                <?php
                                            }
                                            ?>

                                        </select>
                                    </div>
                                    <div class="field" id="user_menu_pos">
                                        <label><?php echo nm_get_text_lang("['user_positioning']", 'App'); ?></label>
                                        <select name="layout_usr_pos" id="layout_usr_pos" class="ui dropdown">
                                            <?php
                                            $usr_pos = [
                                                'in' =>  nm_get_text_lang("['theme_main_menu']", 'ThemeMenu'),
                                                'out' => nm_get_text_lang("['titles_toolbar']", 'AppSchemaAdvanced'),
                                            ];
                                            foreach ($usr_pos as $k => $pos_op) {
                                                $sel = '';
                                                if ($arr_data['value']['layout_usr_pos'] == $k) {
                                                    $sel = 'selected="selected"';
                                                }
                                                ?>
                                                <option <?php echo $sel; ?> value="<?php echo $k; ?>"><?php echo $pos_op; ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="three fields">
                                    <div class="inline field" id="enable_split">
                                        <div class="ui checkbox">
                                            <?php
                                            $check = '';
                                            if ($arr_data['value']['check_split'] == 'S') {
                                                $check = 'checked="checked"';
                                            }
                                            ?>
                                            <input <?php echo $check; ?> type="checkbox" name="check_split" id="check_split" onclick="checkToolbar(true);" />
                                            <label for="check_split"><?php echo nm_get_text_lang("['menu_split_toolbar']", 'App'); ?></label>
                                        </div>
                                    </div>
                                    <div class="inline field" id="enable_toolbar">
                                        <div class="ui checkbox">
                                            <?php
                                            $check = '';
                                            if ($arr_data['value']['check_toolbar'] == 'S') {
                                                $check = 'checked="checked"';
                                            }
                                            ?>
                                            <input <?php echo $check; ?> type="checkbox" name="check_toolbar" id="check_toolbar" onclick="checkToolbar(true);" />
                                            <label for="check_toolbar"><?php echo nm_get_text_lang("['menu_enable_toolbar']", 'App'); ?></label>
                                        </div>

                                    </div>
                                    <div class="field" id="start_expanded">
                                        <div class="ui checkbox">
                                            <?php
                                            $check = '';
                                            if ($arr_data['value']['check_start_expanded'] == 'S') {
                                                $check = 'checked="checked"';
                                            }
                                            ?>
                                            <input <?php echo $check; ?> type="checkbox" name="check_start_expanded" id="check_start_expanded" onclick="updateValueArr(true);" />
                                            <label for="check_start_expanded"><?php echo nm_get_text_lang("['menu_start_expanded']", 'App'); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="two fields" id="enable_header_string">
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['header_string']", 'App'); ?></label>
                                        <div class="ui input">
                                            <input type="text" name="header_string" id="header_string" placeholder="[company_name]" value="<?php echo $arr_data['value']['header_string']; ?>" />
                                        </div>
                                    </div>
                                    <div class="field" id="enable_header_string_pos">
                                        <label><?php echo nm_get_text_lang("['header_string_pos']", 'App'); ?></label>
                                        <select name="header_string_pos" id="header_string_pos" class="ui dropdown">
                                            <?php

                                            $header_pos_list = [
                                                'M' => [
                                                    'name' => nm_get_text_lang("['theme_main_menu']", 'ThemeMenu'),
                                                ],
                                                'H' => [
                                                    'name' => nm_get_text_lang("['module_tpl_header']", 'AppTemplate'),
                                                ],
                                            ];
                                            foreach ($header_pos_list as $k => $item) {
                                                $sel = '';
                                                if ($arr_data['value']['header_string_pos'] == $k) {
                                                    $sel = 'selected="selected"';
                                                }
                                                ?>
                                                <option <?php echo $sel; ?> value="<?php echo $k; ?>"><?php echo $item['name']; ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="two fields">
                                    <div class="field">
                                        <label>
                                            <?php echo nm_get_text_lang("['menu_editor_font']"); ?>
                                            <?php
                                            $disabled_feature = '';
                                            $disabled_feature_popup = '';
                                            if (!$nm_config['flag_versao']['module_notification']['has']) {
                                                $disabled_feature = 'disabled';
                                                $disabled_feature_popup = "nmFrmScaseRunFunc('noPermission');";
                                                echo '<small class="upgradeOnlyInfo menuItem" style="display: inline-block; padding: 2px 5px;">'.nm_get_text_lang("['upgrade_desc']", 'Intro').'</small>';
                                            } else if ($nm_config['flag_versao']['module_notification']['show_new']) {
                                                echo '<span class="field-new-sticker">'.nm_get_text_lang("['menu_new_label']", 'Menu').'</span>';
                                            }
                                            ?>
                                        </label>
                                        <div class="ui scrolling search selection dropdown <?php echo $disabled_feature; ?>" onmousedown="<?php echo $disabled_feature_popup; ?>" style="pointer-events: all;">
                                            <input type="hidden" value="<?php echo (in_array(str_replace(' ', '+', $arr_data['value']['font_string']), $fonts_arr) || trim($arr_data['value']['font_string']) == '-') ? $arr_data['value']['font_string'] : ''; ?>" onchange="pickFont(this.value);">
                                            <i class="dropdown icon"></i>
                                            <div class="default text" style="width: 100%;">Font</div>
                                            <div class="menu">
                                                <div class="item font-selector-item" data-value="-">
                                                    <div class="font-selector-item-name-custom"><?php echo nm_get_text_lang("['str_default']"); ?></div>
                                                </div>
                                                <?php
                                                foreach ($fonts_arr as $k => $font) {
                                                    $sel = '';
                                                    $font_name = str_replace('+', ' ', $font);
                                                    if ($arr_data['value']['font_string'] == $font) {
//                                                        $sel = 'data-selected="selected"';
                                                    }
                                                    ?>
                                                    <div class="item font-selector-item" <?php echo $sel; ?> data-value="<?php echo $font_name; ?>">
                                                        <div class="font-selector-item-name"><?php echo $font_name; ?></div>
                                                        <div class="font-selector-item-sample" style='font-family: "<?php echo $font_name; ?>";'>AaBbCcDdEeFfGgHhIiJjLlMmNnPpQqRrSsTtUuWwXxYyZz</div>
                                                    </div>
                                                    <?php
                                                }
                                                ?>
                                                <div class="item font-selector-item" data-value="">
                                                    <div class="font-selector-item-name-custom"><?php echo nm_get_text_lang("['custom']"); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="field" id="enable_font_string" style="<?php echo (in_array(str_replace(' ', '+', $arr_data['value']['font_string']), $fonts_arr) || trim($arr_data['value']['font_string']) == '-') ? 'display: none;' : ''; ?>">
                                        <label><?php echo nm_get_text_lang("['menu_editor_custom_font']"); ?></label>
                                        <div class="ui input">
                                            <input type="text" name="font_string" id="font_string" placeholder="Custom font..."  value="<?php echo $arr_data['value']['font_string']; ?>" />
                                        </div>
                                    </div>
                                    <div class="field"></div>
                                </div>
                                <div class="three fields">
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['menu_editor_theme']"); ?></label>
                                        <select name="theme_list" id="theme_list" class="ui dropdown">
                                            <?php
                                            foreach ($themes_arr as $k => $theme) {
                                                $sel = '';
                                                if ($arr_data['value']['theme'] == $k) {
                                                    $sel = 'selected="selected"';
                                                }
                                                ?>
                                                <option <?php echo $sel; ?> value="<?php echo $k; ?>">[<?php echo scopeName($theme['scope']); ?>] <?php echo $theme['name']; ?></option>
                                                <?php
                                            }
                                            ?>

                                        </select>
                                    </div>
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['menu_editor_logo']"); ?></label>
                                        <div class="ui action input">
                                            <input type="text" name="full_logo" id="full_logo" placeholder="" value="<?php echo $arr_data['value']['logo']; ?>" />
                                            <button class="ui icon button" onclick="loadImagePicker(event)">
                                                <i class="picture icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['menu_editor_logo_min']"); ?></label>
                                        <div class="ui action input">
                                            <input type="text" name="small_logo" id="small_logo" placeholder="" value="<?php echo $arr_data['value']['logo_compact']; ?>" />
                                            <button class="ui icon button" onclick="loadImagePicker(event)">
                                                <i class="picture icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="three fields">
                                    <div class=" field color_preview">
                                        <div class="nm_primary_preview">
                                            <div class="nm_secondary_preview">
                                                <div class="nm_fontcolor_preview"></div>
                                            </div>
                                            <div class="nm_fontcolor_preview"></div>
                                            <div class="nm_fontcolor_preview"></div>
                                            <div class="nm_fontcolor_preview"></div>
                                        </div>
                                    </div>
                                    <div class="field"></div>
                                    <div class="field"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ui bottom attached active tab segment" data-tab="menu">
                <div class="partitions_container">
                    <div class="partition big">
                        <div class="ui container section" id="items_section">
                            <div class="content">
                                <div class="button_row">
                                    <div class="ui checkbox" style="display: none;">
                                        <input  type="checkbox" name="check_all" id="check_all" />
                                        <label for="check_all"></label>
                                    </div>
                                    <div class="ui small basic icon buttons">

                                        <button class="ui button" onclick="createItem(treeItens)" title="<?php echo nm_get_text_lang("['menu_application_add_item']"); ?>"><i class="plus icon"></i></button>
                                        <button class="ui button" onclick="createChild(treeItens)" title="<?php echo nm_get_text_lang("['menu_application_add_sub_item']"); ?>"><i class="level down alternate icon"></i></button>
                                        <button class="ui button" onclick="deleteItem(treeItens)" title="<?php echo nm_get_text_lang("['menu_application_delete']"); ?>"><i class="trash icon"></i></button>
                                    </div>
                                    <div class="ui small basic icon buttons">
                                        <button class="ui button" onclick="moveUpItems(treeItens)" title="<?php echo nm_get_text_lang("['menu_editor_move_up']"); ?>"><i class="angle up icon"></i></button>
                                        <button class="ui button" onclick="moveDownItems(treeItens)" title="<?php echo nm_get_text_lang("['menu_editor_move_down']"); ?>"><i class="angle down icon"></i></button>
                                        <button class="ui button" onclick="unIndentItems(treeItens)" title="<?php echo nm_get_text_lang("['menu_editor_move_left']"); ?>"><i class="angle left icon"></i></button>
                                        <button class="ui button" onclick="indentItems(treeItens)" title="<?php echo nm_get_text_lang("['menu_editor_move_right']"); ?>"><i class="angle right icon"></i></button>
                                    </div>
                                    <div class="ui small basic icon buttons">
                                        <button class="ui button" onclick="nmImportApp('checkbox', 'menu');" title="<?php echo nm_get_text_lang("['menu_application_import_apl']"); ?>"><i class="download icon"></i></button>
                                    </div>
                                </div>
                                <div class="nm_menu_items_list new_list menu_list">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="partition push">
                        <div class="ui container section stretch form_section menu_form_section">
                            <div class="content ui form" id="form_menu">
                                <input type="hidden" name="item_menu_id" id="item_menu_id" value="" />
                                <div class="field">
                                    <label><?php echo nm_get_text_lang("['menu_application_label_id']"); ?></label>
                                    <input type="text" name="item_menu_id_show" id="item_menu_id_show" disabled />
                                </div>
                                <div class="ui message warning" id="not_shown_message" >This item will not be shown in the menu.</div>
                                <div class="field">
                                    <label><?php echo nm_get_text_lang("['menu_application_label_label']"); ?></label>
                                    <input type="text" name="item_menu_name" id="item_menu_name" />
                                </div>
                                <div class="field">
                                    <label><?php echo nm_get_text_lang("['description']", 'edittoolbar'); ?></label>
                                    <input type="text" name="item_menu_hint" id="item_menu_hint" />
                                </div>
                                <div class="icon field">
                                    <label><?php echo nm_get_text_lang("['menu_application_label_link']"); ?>/<?php echo nm_get_text_lang("['applink_list_edit']", 'Fld'); ?></label>
                                    <div class="ui action input">

                                        <input type="text" name="item_menu_link" id="item_menu_link" />
                                        <button class="ui icon button">
                                            <i class="chain icon"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="icon field">
                                    <label><?php echo nm_get_text_lang("['menu_application_label_target']"); ?></label>
                                    <select name="item_menu_target" id="item_menu_target" class="ui dropdown">
                                        <?php
                                        foreach ($target_opts as $target) {
                                            ?>
                                            <option value="<?php echo $target; ?>"><?php echo nm_get_text_lang("['menu_application_label_target_".$target."']"); ?></option>
                                            <?php
                                        }
                                        ?>

                                    </select>
                                </div>
                                <div class="field">
                                    <div class="ui checkbox">
                                        <input checked type="checkbox" name="item_menu_check_mega" id="item_menu_check_mega" />
                                        <label for="item_menu_check_mega"><?php echo nm_get_text_lang("['menu_editor_define_megamenu']"); ?>
                                            <?php
                                            if ($nm_config['flag_versao']['megamenu']['has']) {
                                                if ($nm_config['flag_versao']['megamenu']['show_new']) {
                                                    ?>
                                                    <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']"); ?></small>
                                                <?php
                                            }
                                            ?>
                                        </label>
                                    </div>
                                </div>
                                <div class="field">
                                    <div class="ui checkbox">
                                        <input type="checkbox" name="item_menu_check_fav" id="item_menu_check_fav" />
                                        <label for="item_menu_check_fav"><?php echo nm_get_text_lang("['menu_editor_define_shortcut']"); ?></label>
                                    </div>
                                </div>
                                <div class="field">
                                    <div class="ui checkbox">
                                        <input checked type="checkbox" name="item_menu_check_icon" id="item_menu_check_icon" />
                                        <label for="item_menu_check_icon"><?php echo nm_get_text_lang("['toolbar_edit_display_option_text_img']"); ?></label>
                                    </div>
                                </div>
                                <div class="icon field">
                                    <label><?php echo nm_get_text_lang("['menu_application_label_icon']"); ?></label>
                                    <div class="ui icon input icon_field">
                                        <input onfocus="startFontAwesomeField('item_menu_icon', 'menu');" onchange="updateIconPreview($(this).val(),'menu');" type="text" id="item_menu_icon" name="item_menu_icon" style="max-width: calc(100% - 35px);" class="iconpicker-element">
                                        <i id="icon-menu-preview" class=""></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ui bottom attached tab segment" data-tab="user">

                <table class="nmTable nmTableStyled form_tab_id_blk_lnk_opn_desktop_itens_user" style="width: 100%;">
                    <tr class="nmTrAttrTitle" id="id_tr_title_">
                        <td class="nmPageTitle" style="text-align: right; vertical-align: middle; width: 200px;"><?php echo nm_get_text_lang("['app_col_attr']"); ?></td>
                        <td class="nmPageTitle" style="text-align: left; vertical-align: middle;"><?php echo nm_get_text_lang("['app_col_value']"); ?></td>
                        <td class="nmPageTitle" style="text-align: left; vertical-align: middle;"><?php echo nm_get_text_lang("['app_col_desc']"); ?></td>
                    </tr>
                    <tr class="nmTrAttr nmTrHover " id="id_tr_open_itens_tab" style="border-bottom: 1px solid #eff2f7;">
                        <td class="nmAttrTitle nmLineV3" style="text-align: right; vertical-align: top">
                            <?php echo nm_get_text_lang("['menu_editor_user_menu_title']"); ?>
                        </td>
                        <td class="nmAttrValue nmLineV3" style="text-align: left; vertical-align: top; white-space: nowrap">
                            <input class="sc_icheck" type="radio" name="user_check_enable" value="<?php echo $arr_data['value']['usercheck']; ?>" <?php echo ($arr_data['value']['usercheck'] == 'S') ? 'checked="checked"' : '' ; ?> id="user_check_enable" />
                            <span name="user_check_enable_toggle" id="user_check_enable_toggle" class="icheck <?php echo ($arr_data['value']['usercheck'] == 'S') ? 'icheck-checked' : '' ; ?>" onclick="nmiCheckToggle(this); checkUser(true);">
                    <small class="jack"></small>
                    <span class="infolabel">✔</span>
                </span>
                        <td class="nmLineDesc" style="text-align: left; vertical-align: top">
                            <?php echo nm_get_text_lang("['menu_editor_user_menu_desc']"); ?>
                        </td>

                    </tr>
                </table>
                <div colspan="3" id="user_partition_container">

                    <div class="partitions_container">

                        <div class="partition full">
                            <div class="ui container section" id="userdata_section">
                                <h4 class="ui dividing header">
                                    <?php echo nm_get_text_lang("['menu_user_data']", 'App'); ?>
                                </h4>
                                <div class="content ui form">
                                    <div class="three fields">
                                        <div class="field">
                                            <label><?php echo nm_get_text_lang("['menu_editor_user_menu_logo']"); ?></label>
                                            <div class="ui icon input">
                                                <i class="picture icon"></i>
                                                <input type="text" name="user_img_var" id="user_img_var" placeholder="[usr_picture]" value="<?php echo $arr_data['value']['userimage']; ?>" />
                                            </div>
                                        </div>
                                        <div class="field">
                                            <label><?php echo nm_get_text_lang("['menu_editor_user_menu_name']"); ?></label>
                                            <div class="ui icon input">
                                                <i class="user icon"></i>
                                                <input type="text" name="user_name_var" id="user_name_var" placeholder="[usr_name]" value="<?php echo $arr_data['value']['username']; ?>" />
                                            </div>
                                        </div>
                                        <div class="field">
                                            <label><?php echo nm_get_text_lang("['pagdef_desc']"); ?></label>
                                            <div class="ui icon input">
                                                <i class="address card icon"></i>
                                                <input type="text" name="user_desc_var" id="user_desc_var" placeholder="[usr_login] / [usr_email] / [usr_phone]" value="<?php echo $arr_data['value']['userdesc']; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="partitions_container">
                        <div class="partition free">
                            <h4 class="ui dividing header">
                                <?php echo nm_get_text_lang("['menu_editor_user_menu']"); ?>
                            </h4>
                        </div>
                    </div>
                    <div class="partitions_container">
                        <div class="partition big">
                            <div class="ui container section" id="items_section">
                                <style>
                                </style>
                                <div class="content">
                                    <div class="button_row">
                                        <div class="ui small basic icon buttons">
                                            <button class="ui button" onclick="createItem(treeUser)" title="<?php echo nm_get_text_lang("['menu_application_add_item']"); ?>"><i class="plus icon"></i></button>
                                            <button class="ui button" onclick="deleteItem(treeUser)" title="<?php echo nm_get_text_lang("['menu_application_delete']"); ?>"><i class="trash icon"></i></button>
                                        </div>
                                        <div class="ui small basic icon buttons">
                                            <button class="ui button" onclick="moveUpItems(treeUser)" title="<?php echo nm_get_text_lang("['menu_editor_move_up']"); ?>"><i class="angle up icon"></i></button>
                                            <button class="ui button" onclick="moveDownItems(treeUser)" title="<?php echo nm_get_text_lang("['menu_editor_move_down']"); ?>"><i class="angle down icon"></i></button>
                                        </div>
                                        <div class="ui small basic icon buttons">
                                            <button class="ui button" onclick="nmImportApp('checkbox', 'user');" title="<?php echo nm_get_text_lang("['menu_application_import_apl']"); ?>"><i class="download icon"></i></button>
                                        </div>
                                    </div>
                                    <div class="nm_menu_items_list new_list user_list">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="partition push">
                            <div class="ui container section stretch form_section user_form_section" >
                                <div class="content ui form" id="form_user">
                                    <input type="hidden" name="item_user_id" id="item_user_id" value="" />
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['menu_application_label_id']"); ?></label>
                                        <input type="text" name="item_user_id_show" id="item_user_id_show" disabled />
                                    </div>
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['menu_application_label_label']"); ?></label>
                                        <input type="text" name="item_user_name" id="item_user_name" />
                                    </div>
                                    <div class="field">
                                        <label><?php echo nm_get_text_lang("['description']", 'edittoolbar'); ?></label>
                                        <input type="text" name="item_user_hint" id="item_user_hint" />
                                    </div>
                                    <div class="icon field">
                                        <label><?php echo nm_get_text_lang("['menu_application_label_link']"); ?>/<?php echo nm_get_text_lang("['applink_list_edit']"); ?></label>
                                        <div class="ui action input">

                                            <input type="text" name="item_user_link" id="item_user_link" />
                                            <button class="ui icon button">
                                                <i class="chain icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="icon field">
                                        <label><?php echo nm_get_text_lang("['menu_application_label_target']"); ?></label>
                                        <select name="item_user_target" id="item_user_target" class="ui dropdown">
                                            <?php
                                            foreach ($target_opts as $target) {
                                                ?>
                                                <option value="<?php echo $target; ?>"><?php echo nm_get_text_lang("['menu_application_label_target_".$target."']"); ?></option>
                                                <?php
                                            }
                                            ?>

                                        </select>
                                    </div>
                                    <div class="field">
                                        <div class="ui checkbox">
                                            <input checked type="checkbox" name="item_user_check_icon" id="item_user_check_icon" />
                                            <label for="item_user_check_icon"><?php echo nm_get_text_lang("['toolbar_edit_display_option_text_img']"); ?></label>
                                        </div>
                                    </div>
                                    <div class="icon field">
                                        <label><?php echo nm_get_text_lang("['menulink_fld_icon']", 'App'); ?></label>
                                        <div class="ui icon input icon_field">
                                            <input onfocus="startFontAwesomeField('item_user_icon', 'user');" onchange="updateIconPreview($(this).val(),'user');" type="text" id="item_user_icon" name="item_user_icon" style="max-width: calc(100% - 35px);" class="iconpicker-element">
                                            <i id="icon-user-preview" class=""></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ui bottom attached tab segment" data-tab="tb">

                <div class="partitions_container">
                    <div class="partition big">
                        <div class="ui container section" id="items_section">
                            <div class="content">
                                <div class="button_row">
                                    <div class="ui checkbox" style="display: none;">
                                        <input  type="checkbox" name="check_all" id="check_all" />
                                        <label for="check_all"></label>
                                    </div>
                                    <div class="ui small basic icon buttons">
                                        <button class="ui button" onclick="moveUpItems(treeTB)" title="<?php echo nm_get_text_lang("['menu_editor_move_up']"); ?>"><i class="angle up icon"></i></button>
                                        <button class="ui button" onclick="moveDownItems(treeTB)" title="<?php echo nm_get_text_lang("['menu_editor_move_down']"); ?>"><i class="angle down icon"></i></button>
                                    </div>
                                </div>
                                <div class="nm_menu_items_list new_list tb_list">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="partition push">
                        <div class="ui container section stretch form_section tb_form_section" >
                            <h4 class="ui dividing header">
                                <?php echo nm_get_text_lang("['menu_editor_properties']"); ?>
                            </h4>
                            <div class="content ui form" id="form_tb">
                                <input type="hidden" name="item_tb_id" id="item_tb_id" value="" />
                                <div class="field" style="display: none">
                                    <label></label>
                                    <input type="text" name="item_tb_id_show" id="item_tb_id_show" disabled />
                                </div>
                                <div class="field">
                                    <div class="ui checkbox">
                                        <input checked type="checkbox" name="item_tb_display" id="item_tb_display" />
                                        <label for="item_tb_display"><?php echo nm_get_text_lang("['lbl_calend_repeat_true']"); ?></label>
                                    </div>
                                </div>

                                <div class="field tb_field tb_field_themes" style="display: none;">
                                    <label><?php echo nm_get_text_lang("['menu_available_themes']", 'App'); ?></label>
                                    <select name="themes_pick" multiple="" id="themes_pick" class="ui fluid dropdown" onchange="updateValueArr(true)">
                                        <?php
                                        foreach ($themes_arr as $k => $theme) {
                                            $sel = '';
                                            if (in_array($k, $arr_data['value']['pick_themes'])) {
                                                $sel = 'selected="selected"';
                                            }
                                            ?>
                                            <option <?php echo $sel; ?> value="<?php echo $k; ?>">[<?php echo scopeName($theme['scope']); ?>] <?php echo $theme['name']; ?></option>
                                            <?php
                                        }
                                        ?>

                                    </select>
                                    <br />
                                    <button class="ui icon button" id="themes-add-all-btn" >
                                        <?php echo nm_get_text_lang("['filt_ajax_campos_btn_all']"); ?>
                                        <i class="check icon"></i>
                                    </button>
                                    <button class="ui icon button" id="themes-remove-all-btn" >
                                        <?php echo nm_get_text_lang("['filt_ajax_campos_btn_none']"); ?>
                                        <i class="close icon"></i>
                                    </button>
                                </div>

                                <div class="field tb_field tb_field_search" style="display: none;">
                                    <div class="ui checkbox">
                                        <?php
                                        $check = '';
                                        if ($arr_data['value']['check_show_search_path'] == 'S') {
                                            $check = 'checked="checked"';
                                        }
                                        ?>
                                        <input <?php echo $check; ?> type="checkbox" name="check_show_search_path" id="check_show_search_path" />
                                        <label for="check_show_search_path"><?php echo nm_get_text_lang("['lbl_show_path_on_search']"); ?></label>
                                    </div>
                                </div>

                                <div class="field tb_field tb_field_shortcuts" style="display: none;">
                                    <div class="ui checkbox">
                                        <?php
                                        $check = '';
                                        if ($arr_data['value']['check_shortcut_label'] == 'S') {
                                            $check = 'checked="checked"';
                                        }
                                        ?>
                                        <input <?php echo $check; ?> type="checkbox" name="check_shortcut_label" id="check_shortcut_label" onclick="updateValueArr(true);" />
                                        <label for="check_shortcut_label"><?php echo nm_get_text_lang("['menu_enable_shortcuts_label']", 'App'); ?></label>
                                    </div>
                                </div>

                                <div class="field tb_field tb_field_shortcuts" style="display: none;">
                                    <label><?php echo nm_get_text_lang("['menu_shortcut_order']", 'App'); ?></label>
                                    <div class="sorter-wrapper" id="sort_shortcuts">

                                    </div>
                                </div>

                                <div class="icon field tb_field tb_field_notification">
                                    <label><?php echo nm_get_text_lang("['menu_editor_open_all_app']"); ?></label>
                                    <div class="ui action input">
                                        <input type="text" name="item_notif_open_all_app" id="item_notif_open_all_app" value="<?php echo $arr_data['value']['notif_open_all_app']; ?>" />
                                        <button class="ui icon button">
                                            <i class="chain icon"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="two fields tb_field tb_field_notification">
                                    <div class="field tb_field tb_field_notification">
                                        <label><?php echo nm_get_text_lang("['menu_editor_refresh_interval']"); ?></label>
                                        <div class="ui icon input">
                                            <i class="clock icon"></i>
                                            <input type="number" name="item_notif_refresh_interval" id="item_notif_refresh_interval" placeholder="10000" value="<?php echo $arr_data['value']['notif_refresh_interval']; ?>" />
                                        </div>
                                    </div>
                                    <div class="field tb_field tb_field_notification">
                                        <label><?php echo nm_get_text_lang("['menu_editor_notification_limit']"); ?></label>
                                        <div class="ui icon input">
                                            <i class="list icon"></i>
                                            <input type="number" name="item_notif_limit" id="item_notif_limit" placeholder="10" min="1" value="<?php echo $arr_data['value']['notif_limit']; ?>" />
                                        </div>
                                    </div>
                                </div>

                                <div class="two fields tb_field tb_field_notification">
                                    <div class="field tb_field tb_field_notification" style="display: none;">
                                        <label><?php echo nm_get_text_lang("['menu_notif_connection']", 'App'); ?></label>
                                        <select name="item_notif_connection" id="item_<?php echo 'notif_connection'; ?>" onchange="updateNotifConnection(this.value)" class="ui dropdown">
                                            <option value=""></option>
                                            <?php
                                            nm_load_class('page', 'PageAjaxFunction');
                                            $con_opts = array_keys($arr_data['obj_con']);
                                            //                                    var_dump($arr_data['obj_con']);
                                            $con_set = false;
                                            foreach ($con_opts as $conn_op) {
                                                $sel = '';
                                                if (isset($arr_data['value']['notif_data']['notif_connection']) && $arr_data['value']['notif_data']['notif_connection'] == $conn_op) {
                                                    $sel = 'selected="selected"';
                                                    $con_set = true;

                                                    $obj = new nmPageAjaxFunction();
                                                    $obj->params['conn'] = $arr_data['value']['notif_data']['notif_connection'];
                                                    $tables_list = $obj->getTables(true);
                                                }
                                                ?>
                                                <option <?php echo $sel; ?> value="<?php echo $conn_op; ?>"><?php echo $conn_op; ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="field tb_field tb_field_notification">
                                        <label><?php echo nm_get_text_lang("['menu_editor_login_var']"); ?></label>
                                        <div class="ui icon input">
                                            <i class="user icon"></i>
                                            <input type="text" name="item_notif_login_var" id="item_notif_login_var" placeholder="[usr_login]" value="<?php echo $arr_data['value']['notif_login_var']; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="field tb_field tb_separator tb_field_notification" style="display: none;">
                                    <hr />
                                </div>
                                <?php
                                $notif_data_arr = [
                                    'notif_table' => '',
                                    'notif_id' => 'notif_table',
                                    'notif_title' => 'notif_table',
                                    'notif_message' => 'notif_table',
                                    'notif_dtexpire' => 'notif_table',
                                    'notif_login_sender' => 'notif_table',
                                    'notif_categ' => 'notif_table',
                                    'notif_type' => 'notif_table',
                                    'notif_link' => 'notif_table',
                                    'sep1' => 'sep',
                                    'inbox_table' => '',
                                    'inbox_field_notif_id' => 'inbox_table',
                                    'inbox_field_ontop' => 'inbox_table',
                                    'inbox_field_userid' => 'inbox_table',
                                    'inbox_field_isread' => 'inbox_table',
                                    'inbox_field_read_date' => 'inbox_table',
                                    'inbox_field_sent_date' => 'inbox_table',
                                    'inbox_field_tag' => 'inbox_table',
                                    'inbox_field_important' => 'inbox_table',
                                    'sep2' => 'sep',
                                    'user_table' => '',
                                    'user_login' => 'user_table',
                                    'user_fullname' => 'user_table',
                                    'user_image' => 'user_table',
                                ];
                                $it_opts = [];

                                $tb_set = [
                                    'notif_table' => false,
                                    'inbox_table' => false,
                                    'user_table' => false,
                                ];
                                $tb_fields = [
                                    'notif_table' => [],
                                    'inbox_table' => [],
                                    'user_table' => [],
                                ];
                                foreach ($notif_data_arr as $k => $v) {
                                    if ($v == 'sep') {
                                        ?>
                                        <div class="field tb_field tb_separator tb_field_notification" style="display: none;">
                                            <hr />
                                        </div>
                                        <?php
                                    } else {
                                        $upd_from = '';
                                        $disabled = ' disabled="disabled"';
                                        $fld_class = '';
                                        $onchange = '';
                                        $it_opts = [];
                                        if ($v != '') {
                                            $upd_from = ' data-updated-from="'.$v.'"';
                                            $fld_class = 'tb_padded';
                                            if ($tb_set[$v]) {
                                                $it_opts = $tb_fields[$v];
                                                $disabled = '';
                                            }
                                        } else {
                                            $onchange = 'onchange="updateNotifTable(\''.$k.'\')"';
                                            if ($con_set) {
                                                $it_opts = array_keys($tables_list);
                                                $disabled = '';
                                            }
                                        }
                                        ?>
                                        <div class="field tb_field <?php echo $fld_class; ?> tb_field_notification" style="display: none;">
                                            <label><?php echo nm_get_text_lang("['menu_".$k."']", 'App'); ?></label>
                                            <select <?php echo $disabled; ?> name="item_<?php echo $k; ?>" id="item_<?php echo $k; ?>" class="ui dropdown" <?php echo $upd_from; ?> <?php echo $onchange; ?>>
                                                <?php
                                                foreach ($it_opts as $it_op) {
                                                    $sel = '';
                                                    if (isset($arr_data['value']['notif_data'][$k]) && $arr_data['value']['notif_data'][$k] == $it_op) {
                                                        $sel = 'selected="selected"';
                                                        if ($v == '') {
                                                            $tb_set[$k] = true;
                                                            $obj = new nmPageAjaxFunction();
                                                            $obj->params['conn'] = $arr_data['value']['notif_data']['notif_connection'];
                                                            $obj->params['table_usr'] = $it_op;
                                                            $tb_fields[$k] = array_keys($obj->getFields(true));
                                                        }
                                                    }
                                                    ?>
                                                    <option <?php echo $sel; ?> value="<?php echo $it_op; ?>"><?php echo $it_op; ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>

                            </div>
                            <div class="content ui form type_tb_item type_L" style="display: none">
                                <div class="field">
                                    <label></label>
                                    <input type="text" name="item_tb_name" id="item_tb_name" />
                                </div>
                                <div class="icon field">
                                    <label></label>
                                    <div class="ui action input">

                                        <input type="text" name="item_tb_link" id="item_tb_link" />
                                        <button class="ui icon button">
                                            <i class="chain icon"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="field">
                                    <div class="ui checkbox">
                                        <input checked type="checkbox" name="item_tb_check_icon" id="item_tb_check_icon" />
                                        <label for="item_check_icon"></label>
                                    </div>
                                </div>
                                <div class="icon field">
                                    <label></label>
                                    <div class="ui icon input icon_field">
                                        <input onfocus="startFontAwesomeField('item_tb_icon');" onchange="updateIconPreview($(this).val());" type="text" id="item_tb_icon" name="item_tb_icon" style="max-width: calc(100% - 35px);" class="iconpicker-element">
                                        <i id="icon-tb-preview" class=""></i>
                                    </div>
                                </div>
                            </div>
                            <div class="content ui form type_tb_item type_N"></div>
                            <div class="content ui form type_tb_item type_S"></div>
                        </div>
                        <div class="ui container section stretch" id="preview_section" style="display: none">
                            <h4 class="ui dividing header">

                            </h4>
                            <div class="content">
                                <iframe src="" frameborder="0" id="preview_frame"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br />
        </div>
        <div id="actions" class="actions-bar" style="display: none;">
            <div class="ui container">
                <div class="ui grid">
                    <div class="centered ten wide column textAlign-left">
                        <input type="submit" value="Save" class="ui button primary"">
                    </div>
                    <div class="centered five wide column textAlign-right">
                        <input type="button" value="Help" class="ui button" onclick="nm_window_manual('/scriptcase/devel/iface/download_doc.php');">
                    </div>
                </div>
            </div>
        </div>
        <div class="ui container section stretch" id="preview_section" style="display: none">
            <h4 class="ui dividing header">

            </h4>
            <div class="content">
                <iframe src="" frameborder="0" id="preview_frame"></iframe>
            </div>
        </div>
        <script>
            // var item_placeholder = $('#___NM___PLACEHOLDER').get()[0];
            var arr_placeholder = {
                text: '',
                app: '',
                icon: '',
                icon_check: 'S',
                children: [],
            };
            var arr_val = <?php echo json_encode($val_arr); ?>;
            var arr_items = arr_val.items;
            var arr_user = arr_val.user_items;
            var arr_tb = arr_val.tb_items;
            var themes_list = <?php echo json_encode($themes_arr); ?>;
            var layouts_list = <?php echo json_encode($layouts_arr); ?>;
            // item_placeholder.parentNode.removeChild(item_placeholder);
            // arr_items[0].itree = {};
            // arr_items[0].itree.icon = 'square';


            var treeItens = new InspireTree({
                data: arr_items,
                checkbox: {
                    autoCheckChildren: false,
                },
                selection: {
                    mode: 'default',
                    multiple: true,
                    disableDirectDeselection: true,
                    required: true,
                },
            });
            var treeUser = new InspireTree({
                data: arr_user,
                checkbox: {
                    autoCheckChildren: false,
                },
                selection: {
                    mode: 'default',
                    multiple: true,
                    disableDirectDeselection: true,
                    required: true,
                },
            });
            var treeTB = new InspireTree({
                data: arr_tb,
                checkbox: {
                    autoCheckChildren: false,
                },
                selection: {
                    mode: 'default',
                    multiple: true,
                    disableDirectDeselection: true,
                    required: true,
                },
            });

            var treeItemsDom = new InspireTreeDOM(treeItens, {
                target: '.new_list.menu_list',
                dragAndDrop: true,
            });


            var treeUserDom = new InspireTreeDOM(treeUser, {
                target: '.new_list.user_list',
                dragAndDrop: false,
            });


            var treeTBDom = new InspireTreeDOM(treeTB, {
                target: '.new_list.tb_list',
                dragAndDrop: false,
            });

            $(document).ready(function () {
                $('#tabs-holder .tab-item')
                    .tab()
                ;
                loadTheme();
                // loadTree(arr_items, item_placeholder);


                $('#user_name_var, #user_desc_var, #user_img_var, #full_logo, #small_logo, #header_string, #notif_login_var').on('input', function (ev) {
                    updateValueArr(true);
                });


                updateValueArr();

                checkUser(false);
                checkLayout(false);
                updateFavSort();
                $('#sort_shortcuts').sortable({
                    ghostClass: 'moving',
                    animation: 150,
                    onUpdate: function () {
                        arr_val.shortcuts = $('#sort_shortcuts').sortable('toArray');
                        updateValField(true);
                    }
                });
                if (!(parseInt($('#item_notif_limit').val()) >= 1)) {
                    $('#item_notif_limit').val(10);
                    updateValueArr(true);
                }
                $('#item_notif_limit').on('input.minval', function(ev) {
                    if (!(parseInt(ev.target.value) >= 1)) {
                        ev.target.value = 1;
                    }
                });
                $('#theme_list').on('change', function (ev) {
                    loadTheme(true);
                });
                $('#layout_list').on('change', function (ev) {
                    checkLayout(true);
                    loadLayout(true);
                });
                $('#layout_usr_pos').on('change', function (ev) {
                    updateValueArr(true);
                });
                $('#header_string_pos').on('change', function (ev) {
                    updateValueArr(true);
                });
                $('#themes-add-all-btn').on('click', function (ev) {
                    ev.preventDefault();
                    $('#themes_pick').closest('.ui.dropdown').dropdown('set selected', <?php echo json_encode(array_keys($themes_arr)); ?>);
                    updateValueArr(true);
                });
                $('#themes-remove-all-btn').on('click', function (ev) {
                    ev.preventDefault();
                    $('#themes_pick').closest('.ui.dropdown').dropdown('remove selected');
                    updateValueArr(true);
                });
                $('#check_show_search_path').on('click', function (ev) {
                    updateValueArr(true);
                });
                $('#font_string').on('input', function (ev) {
                    updateValueArr(true);
                });
                ['menu', 'user', 'tb'].forEach(function (treeName) {
                    $('#item_' + treeName + '_check_icon').on('click', function (ev) {
                        checkedIcon(treeName);
                    });
                    $('#item_' + treeName + '_check_fav').on('click', function (ev) {
                        checkedFav(treeName);
                    });
                    $('#item_' + treeName + '_check_mega').on('click', function (ev) {
                        <?php
                        if ($nm_config['flag_versao']['megamenu']['has']) {
                        ?>
                            checkedMega(treeName);
                        <?php } else { ?>
                            ev.preventDefault();
                            ev.stopPropagation();
                            $('#item_' + treeName + '_check_mega').prop('checked', false);
                            nmFrmScaseRunFunc("noPermission");
                        <?php } ?>
                    });
                    $('.'+treeName+'_form_section input').on('input', function (ev) {
                        editItem(treeName, true);
                    });
                    $('.'+treeName+'_form_section select').on('change', function (ev) {
                        editItem(treeName, true);
                    });
                    $('.'+treeName+'_form_section .icheck').on('click', function (ev) {
                        editItem(treeName, true);
                    });
                    $('input#item_notif_open_all_app + button').on('click', function (ev) {
                        ev.preventDefault();
                        nmImportApp("radio", "item_notif_open_all_app");
                    });
                    $('.'+treeName+'_form_section input#item_' + treeName + '_link + button').on('click', function (ev) {
                        ev.preventDefault();
                        nmImportApp("radio", "item_" + treeName + "_link");
                    });
                    $('.'+treeName+'_form_section input#item_' + treeName + '_link').on('change', function (ev) {
                        editItem(treeName, true);
                    });
                    $('input#item_notif_open_all_app').on('change', function (ev) {
                        editItem(treeName, true);
                    });
                    lockEditor(treeName);
                });

                $('.ui.dropdown').dropdown();
                $('.button_row button').on('click', function (ev) {
                    ev.preventDefault();
                });

                [treeItens, treeUser, treeTB].forEach(function (tree) {
                    updateTreeIcons(tree);
                    tree.on('node.click', function (ev, node) {
                        if (!ev.ctrlKey && !ev.shiftKey) {
                            tree.deselectDeep();
                            node.select();
                        } else if (ev.ctrlKey && node.selected()) {
                            setTimeout(function () {
                                node.deselect();
                            }, 1);
                        }
                    });
                    tree.on('node.focused', function (node) {
                        focusNode(node);
                    });
                    tree.on('changes.applied', function (node) {
                        // updateValueArr();
                    });
                    tree.on('node.drop', function (node) {
                        updateTreeIcons(tree);
                        updateValueArr(true);
                        tree.expandDeep();
                    });
                });

                [treeUser, treeTB, treeItens].forEach(function (tree) {
                    try {
                        focusNode(tree.selectFirstAvailableNode().focus());
                        tree.expandDeep();
                    } catch (e) {
                        // console.log(e);
                    }
                });
                $('body').scrollTop(0);

                updateValField(false);

            });
        </script>
    </td>
</tr>