CREATE ROLE RDB$ADMIN;

/* Add table "notif_inbox"                                                   */

CREATE TABLE NOTIFTABLE_INBOX (
    INBOX_ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NOTIF_ID INTEGER NOT NULL,
    LOGIN VARCHAR(255) NOT NULL,
    NOTIF_DTSENT TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    NOTIF_ONTOP INTEGER DEFAULT '0',
    NOTIF_ISREAD INTEGER DEFAULT '0',
    NOTIF_DTREAD TIMESTAMP DEFAULT NULL,
    NOTIF_TAGS VARCHAR(255) DEFAULT NULL,
    NOTIF_IMPORTANT INTEGER DEFAULT NULL,
    PRIMARY KEY (INBOX_ID)
)

/* Add table "notif_pref"                                            */

CREATE TABLE NOTIFTABLE_PREF (
    LOGIN VARCHAR(255) NOT NULL,
    RECEIVE_EMAIL INTEGER DEFAULT '0',
    RECEIVE_SMS INTEGER DEFAULT '0',
    PRIMARY KEY (LOGIN)
)

/* Add table "notif_tags"                                            */

CREATE TABLE NOTIFTABLE_TAGS (
    TAG_ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TAG_TITLE VARCHAR(50) NOT NULL,
    LOGIN VARCHAR(255) NOT NULL,
    TAG_COLOR VARCHAR(100) DEFAULT NULL,
    TAG_ACTIVE INTEGER DEFAULT '1',
    PRIMARY KEY (TAG_ID)
)


/* Add table "notif_notifications"                                            */

CREATE TABLE NOTIFTABLE_NOTIFICATIONS (
    NOTIF_ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NOTIF_TITLE VARCHAR(255) NOT NULL,
    NOTIF_MESSAGE VARCHAR(900) NOT NULL,
    NOTIF_DTCREATED TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    NOTIF_ONTOP INTEGER DEFAULT '0',
    NOTIF_DTEXPIRE TIMESTAMP DEFAULT NULL,
    NOTIF_CATEG VARCHAR(60) DEFAULT NULL,
    NOTIF_LOGIN_SENDER VARCHAR(255) NOT NULL,
    NOTIF_TYPE VARCHAR(60) DEFAULT NULL,
    NOTIF_LINK VARCHAR(255) DEFAULT NULL,
    DELETED_AT TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (NOTIF_ID)
)

/* Add table "notif_profiles"                                                   */

CREATE TABLE NOTIFTABLE_PROFILES (
    PROFILE_ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    PROFILE_NAME VARCHAR(255) NOT NULL,
    PROFILE_USERS VARCHAR(900) DEFAULT NULL,
    PROFILE_GROUPS VARCHAR(900) DEFAULT NULL,
    PROFILE_PUBLIC INTEGER DEFAULT '0',
    PROFILE_OWNER VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (PROFILE_ID)
)

/* Add table "notif_user_tags"                                                   */

CREATE TABLE NOTIFTABLE_USER_TAGS (
    USER_TAGS_ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    LOGIN VARCHAR(255) NOT NULL,
    LOGIN_SENDER VARCHAR(255) NOT NULL,
    TAGS VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (USER_TAGS_ID)
)
