SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Sequence structure for "public"."categories_categoryid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS categories_categoryid_seq;
CREATE SEQUENCE categories_categoryid_seq START WITH 7 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."customer_customerid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS customer_customerid_seq;
CREATE SEQUENCE customer_customerid_seq START WITH 56 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."kb_articles_articlesid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS kb_articles_articlesid_seq;
CREATE SEQUENCE kb_articles_articlesid_seq START WITH 51 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."kb_categories_categoryid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS kb_categories_categoryid_seq;
CREATE SEQUENCE kb_categories_categoryid_seq START WITH 20 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."languages_serial_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS languages_serial_seq;
CREATE SEQUENCE languages_serial_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."templateid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS templateid_seq;
CREATE SEQUENCE templateid_seq START WITH 14 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."staff_staffid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS staff_staffid_seq;
CREATE SEQUENCE staff_staffid_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."ticket_ticketid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS ticket_ticketid_seq;
CREATE SEQUENCE ticket_ticketid_seq START WITH 3979 INCREMENT BY 1;

-- ----------------------------
-- Table structure for `categories`
-- ----------------------------

create table `categories` (
  `categoryid` int(11) not null auto_increment,
  `categoryname` varchar(100) default null,
  primary key (`categoryid`)
) engine=innodb auto_increment=7 default charset=utf8;

-- ----------------------------
-- Records of categories
-- ----------------------------
INSERT INTO `categories` VALUES ('1', 'CRMAPPLICATION'), ('2', 'WEB SITE'), ('3', 'SALES'), ('4', 'WEB MAIL'), ('5', 'PERIPHERAL'), ('6', 'SOFTWARE');

-- ----------------------------
-- Table structure for `customer`
-- ----------------------------

create table `customer` (
  `customerid` int(11) not null auto_increment,
  `customername` varchar(150) default null,
  `customeremail` varchar(255) default null,
  `customerphone` varchar(20) default null,
  `customerlanguage` varchar(30) default null,
  `customerpassword` varchar(8) default null,
  `customertype` char(15) default null,
  `activationcode` varchar(32) default null,
  primary key (`customerid`)
) engine=innodb auto_increment=56 default charset=utf8;

-- ----------------------------
-- Records of customer
-- ----------------------------
INSERT INTO `customer` VALUES ('1', 'John smith', 'john@scriptcase.net', '55 88 987 987', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), ('2', 'Maria soza', 'maria@scriptcase.net', '55 88 987 666', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('3', 'Mary silva', 'mary.silva@scriptcase.net', '55 88 982 112', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), ('4', 'Mary Popins', 'mary.popins@scriptcase.net', '55 88 231 222', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('5', 'July jordan', 'july.jordan@scriptcase.net', '55 88 227 654', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('6', 'Albert Einstein', 'albert.einstein@scriptcase.net', '55 88 227678', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('7', 'Rick Flathmann', 'rick.flathmann@scriptcase.net', '55 88 227 911', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('8', 'Todd Huang', 'todd.huang@scriptcase.net', '55 88 227867', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('9', 'Alejandro Bailliet', 'alejandro.bailliet@scriptcase.net', '55 88 227453', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('10', 'Joseph Mallinson', 'joseph.mallinson@scriptcase.net', '55 88 227243', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('11', 'Elizabeth Workman', 'elizabeth.workman@scriptcase.net', '55 88 227867', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('12', 'Barry Steinke', 'barry.steinke@scriptcase.net', '55 88 227 910', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('13', 'Harry Sissman', 'harry.sissman@scriptcase.net', '55 88 232 332', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('14', 'Jonathan Foster', 'jonathan.foster@scriptcase.net', '55 88 227345', 'es;es_es', 'customer', 'NONSUBSCRIBER', null), ('15', 'Helen Bennett', 'helen.bennett@scriptcase.net', '55 88 227 645', 'es;es_es', 'customer', 'NONSUBSCRIBER', null), ('16', 'kathleen Flanagan', 'kathleen.flanagan@scriptcase.net', '', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('17', 'Charlotte Nassar', 'charlotte.nassar@scriptcase.net', '55 88 227900', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('18', 'Julie Hamilton', 'julie.hamilton@scriptcase.net', '55 88 227645', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('19', 'Bryan LeBlanc', 'bryan.leblanc@scriptcase.net', '55 88 227 223', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('20', 'Melanie Steinke', 'melanie.steinke@scriptcase.net', '55 88 227213', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('21', 'Art Blanton', 'art.blanton@scriptcase.net', '53 43 343 656', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('22', 'Toby Marshall', 'toby.marshall@scriptcase.net', '53 43 343 221', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('23', 'Suzanne Liston', 'suzanne.liston@scriptcase.net', '53 43 343443', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('24', 'Dennis Gartler', 'dennis.gartler@scriptcase.net', '53 43 343656', 'en_us;en_us', 'customer', 'NONSUBSCRIBER', null), ('25', 'Shirley LaWare', 'shirley.laware@scriptcase.net', '55 88 227645', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), ('26', 'Henry Wilson', 'henry.wilson@scriptcase.net', '55 88 227 909', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), ('27', 'Kristen Kaydos', 'kristen.kaydos@scriptcase.net', '55 88 227987', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('28', 'Chrissy Ralston', 'chrissy.ralston@scriptcase.net', '55 88 227876', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('29', 'Ruben Noyes', 'ruben.noyes@scriptcase.net', '55 88 227 645', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('30', 'Patricia Ratner', 'patricia.ratner@scriptcase.net', '55 88 227000', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('31', 'Tamara O Brien', 'tamara.obrien@scriptcase.net', '55 88 227654', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('32', 'Ryan Cazamias', 'ryan.cazamias@scriptcase.net', '55 88 227 223', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('33', 'Victor Spruell', 'victor.spruell@scriptcase.net', '55 88 227221', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('34', 'Allen Cromwell', 'allen.cromwell@scriptcase.net', '55 88 227908', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('35', 'Renee Staebel', 'renee.staebel@scriptcase.net', '55 88 227 765', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('36', 'Kathryn Crawford', 'kathryn.crawford@scriptcase.net', '55 88 227556', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('37', 'Crystal Trevas', 'crystal.trevas@scriptcase.net', '55 88 227675', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('38', 'Scot Drescher', 'scot.drescher@scriptcase.net', '55 88 227 234', 'es;es_es', 'customer', 'SUBSCRIBER', null), ('39', 'Natalie Neal', 'natalie.neal@scriptcase.net', '55 88 227 112', 'en_us;en_us', 'customer', 'SUBSCRIBER', null), ('40', 'Arlindo Vieira', 'arlindo.siqueira@gmail.coms', '', 'es;es_es', '123456', 'SUBSCRIBER', 'C5F026B6007C2A7F9330611A4FE2C0A3'), ('41', 'Joao Andre', 'joao@scriptcase.net', '55 88 987 987', 'pt_br;pt_br', 'customer', 'SUBSCRIBER', null);

-- ----------------------------
-- Table structure for `kb_articles`
-- ----------------------------

create table `kb_articles` (
  `articlesid` int(11) not null auto_increment,
  `categoryid` int(11) not null,
  `articlesubject` varchar(255) default null,
  `articlecontent` text,
  `articletypeid` varchar(10) default null,
  `articleview` int(11) default null,
  `votesqty` int(11) default null,
  `votestotal` int(11) default null,
  `articledate` datetime default null,
  primary key (`articlesid`),
  key `categoryid` (`categoryid`),
  key `articletypeid` (`articletypeid`),
  constraint `kb_articles_ibfk_1` foreign key (`articletypeid`) references `kb_articletype` (`articletypeid`),
  constraint `kb_articles_ibfk_2` foreign key (`categoryid`) references `kb_categories` (`categoryid`)
) engine=innodb auto_increment=51 default charset=utf8;

-- ----------------------------
-- Records of kb_articles
-- ----------------------------
INSERT INTO `kb_articles` VALUES ('1', '18', 'What is  the best way to start writing a PHP program?', '<p>Design, design, design. Figure out, on paper, exactly what you want to<br />do. Otherwise, you\'ll just be coding your way around with no real <br />goal.<br /><br />Plan on separating content from logic, it\'ll always assure cleaner, <br />more maintainable code. <br /><br />Usually the apps I write are DB-related, so to use that sort of<br />application as an example, the first step would be nailing down, with<br />fairly broad scope, what sort of data needs to be stored. This doesn\'t<br />have to mean tracking down every possible facet of information that <br />will ever be pertinent, just get a good idea. Part of the app design <br />may call for it to be extensible anyway, so you don\'t have to know<br />everything ahead of time.<br /><br />Once you have a good understanding of what data needs to be stored,<br />design your database. Flow charts are your friend. :) Having a<br />visualization of the structure of the DB will come in handy for<br />subsequent steps.<br /><br />Now it\'s time for an interface between your app and the database. I<br />generally avoid putting direct DB calls in my app as much as possible,<br />your feelings may vary. Now that Pear is around, I\'ve been using that<br />for my abstraction. There are other options, of course. I tend to<br />write three functions for each logical grouping of database fields. <br />For example, if it were a web log, there may be some groups of fields <br />such as Users, Entries, Categories, and Polls. For these, I would <br />write getEntry, setEntry, deleteEntry, getUser, setUser, deleteUser, <br />and so on. I may not find a need to use all these functions, but <br />being able to assume they\'re there if I come to that point later on is <br />handy.<br /><br />Usually for me the next step is the administrative portion of the app.<br />The screens involved in (using the web log example) logging in as a<br />user, posting a new entry, and perhaps adding a poll. The admin<br />interface tends to have three components to it: The navigation, the<br />forms for input, and the code for validating/DB access. Since<br />separating content from code is good, I tend to have these three<br />components thoroughly separated.<br /><br />The navigation can be done any number of ways, I tend to use button <br />menu screens (You log in, get a Main Menu, click on \'Manage Users\', <br />get a User Menu, click on \'Add User\', get an Add User form, etc.) For <br />form input, I like to make my forms dual-purpose. That is, the same <br />file can be used for adding a user as it can for editing. It\'s a <br />simple process, and it\'s handy for keeping maintenance hassles low. <br />These forms, of course, submit their data to the code that does <br />validation and DB access.<br /><br />So that\'s the admin side, more or less. Once that\'s all in place, the<br />only thing left to do is the actual web pages that people will be <br />using. I\'m no designer, so I don\'t relish this part. Thankfully, I <br />work with people who are designers, so often while I\'m coding the <br />admin side, they\'re doing up the templates for the site. Then <br />integration is just a matter of plugging in snippits of PHP to extract <br />a value here, interate through some DB fields there.. Pretty soon, <br />it\'s all done. (Okay, so it usually doesn\'t seen like \'pretty soon\' <br />when it actually gets finished).<br /><br />Okay, I\'ll stop rambling now.<br /><br />Also, choosing a PHP aware editor helps, and PHP developmental tools. <br />Zend.com is a company dedicated to PHP and offers many great products <br />and tools, check them out. As far as PHP friendly text editors and <br />related tools go, check out these links:<br /><br /><a href=http://www.websitecompanyindia.com/seo-Links.htm>http://www.websitecompanyindia.com/seo-Links.htm</a><br /><a href=http://www.webs4soft.com/web-hosting-india.htm>http://www.webs4soft.com/web-hosting-india.htm</a><br /><a href=http://indianjewelry.websitecompanyindia.com/Diamond-Bracelets.htm>http://indianjewelry.websitecompanyindia.com/Diamond-Bracelets.htm</a></p>', 'PUBLISHED', '147', '2', '4', '2009-06-11 15:30:00'), ('2', '18', 'authentication to my site with PHP', '<pre>For user authentication, you can use sessions to keep track whether a user is logged in or not, check out this faq :      I\'m new to sessions and cookies , where should I start?     -------------------------------------------------------     <a href=http://www.faqts.com/knowledge_base/view.phtml/aid/6621/fid/8>http://www.faqts.com/knowledge_base/view.phtml/aid/6621/fid/8</a>  You can check out a few existing PHP authentication scripts, some of  which are found here :      <a href=http://hotscripts.com/PHP/Scripts_and_Programs/User_Authentication/>http://hotscripts.com/PHP/Scripts_and_Programs/User_Authentication/</a></pre>', 'PUBLISHED', '48', '7', '17', '2009-06-11 16:00:00'), ('3', '18', 'How can I get in PHP the value of variable coming from a WML < input > or < select > ?', '<p>best is an example...<br /><br />WML:<br />&lt;card id=post title=TestPost&gt;<br />&lt;p&gt;<br />&lt;input type=text name=in1 /&gt;<br />&lt;anchor&gt;Senden<br />&lt;go href=yourscript.php&gt;<br />&lt;postfield name=Post1 value=$in1 /&gt;<br />&lt;/go&gt;<br />&lt;/anchor&gt;<br />&lt;/card&gt;<br /><br />PHP:<br />its like php with html,&nbsp; in yourscript.php there will<br />be a variable called $_POST[\'Post1\'] creeated automatically by php</p>', 'PUBLISHED', '183', '2', '5', '2009-06-11 09:20:00'), ('5', '18', 'How i can set a time expire page in PHP.', '<p>you can use the header  function like this:<br /><br />header (Expires: Mon, 26 Jul 1997 05:00:00 GMT);<br /><br />You can read more about this function here:<br /><br /><a href=http://php.net/header>http://php.net/header</a></p>', 'PUBLISHED', '68', null, null, '2009-06-11 11:02:00'), ('6', '19', 'Can you trap function keys to prevent their native operations?', '<p>I found a way to do it, but it only works in IE and I\'ve only tested it <br />in IE5 . Netscape doesn\'t seem to return anything for function keys. If <br />you trap the keyCode you want to disable and assign a new value to the <br />it, you can do whatever you want with the function keys. The keycodes <br />for them are 112 - 123. The only real use I\'ve found for this is in a <br />proprietary app I\'m developing for IE, but I guess you could also annoy <br />the heck out of some people with it.<br /><br />document.onkeydown = function(){<br /><br />if(window.event && window.event.keyCode == 116) <br />        { // Capture and remap F5<br />window.event.keyCode = 505;<br />  }<br /><br />if(window.event && window.event.keyCode == 505) <br />        { // New action for F5<br />alert(\'F5 key was pressed\');<br />return false; <br />        // Must return false or the browser will refresh anyway<br />}<br />}</p>', 'PUBLISHED', '193', '2', '3', '2009-06-11 08:10:00'), ('7', '19', 'How to set default home page in IE4', '<pre>open ur notepade,copy and paste below,save a *.reg file,it is ok!:)   REGEDIT4  [HKEY_CURRENT_USERSoftwareMicrosoftInternet ExplorerMain] Start Page = http://www.scriptcase.net</pre>', 'PUBLISHED', '171', null, null, '2009-06-11 09:50:00'), ('8', '19', 'How do I get a list of fonts available on a user\'s computer?', '<p>&gt; Since this would be a security hole, there is no way to find out what <br />&gt; fonts are installed on a users computer<br />&gt; If you want to use one very specific font and are not sure that <br />&gt; everybody has t installed, simply get a copy of the font on the <br />&gt; server of your webpage (or whereever you can access it via url) and <br />&gt; reference it through a CSS (please see CSS-manual for additional <br />&gt; info).<br />&gt; Otherwise I do propose to use font-families like arial, sans-serif <br />&gt; and the likes.<br /><br />I also want to find out what fonts are avalaible from a client. It is <br />to enable users to print reports off in any font they have available <br />from their browser. If anyone has any idea, please post.<br /><br />Well, in that case I\'d say you\'ll have to write an applet, since you <br />cannot:<br />a) find out what fonts are on a users computer via JS<br />b) tell the JS print() method which font to use<br />Java on the other side can do that and is just perfect for such tasks.<br /><br />HTH<br /><br />---------<br />See Identifying Installed Fonts at:<br /><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href=http://www.webreference.com/dhtml/column30/>http://www.webreference.com/dhtml/column30/</a></p>', 'PUBLISHED', '109', null, null, '2009-06-11 07:10:00'), ('9', '19', 'How to you mark a script as safe or trusted?1', '<p>Using HTA Applications all you need to do is mark your Frames Or <br />IFrames as APPLICATION=yes.<br /><br />First you must put all of the viewable content into frames.<br />Then in the frame tag itself insert APPLICATION=yes<br />Example:<br /><br />&lt;FRAMESET rows=20%,*&gt;<br />&nbsp; &lt;FRAME src=file.htm APPLICATION=yes&gt;<br />&lt;/FRAMESET&gt;<br /><br />This sets the frames content to Trusted.<br />Anything put in this Frame will be Trusted.</p>', 'PUBLISHED', '127', null, null, '2009-06-11 13:13:00'), ('10', '19', 'Can you refer to a javascript variable in an html tag?', '<p>Yes, you can, but only inside so-called event handlers, or as part of a<br />\'javascript:\' URL. The only limitation is that you should have assigned<br />the variable before using it in the HTML; either on the HEAD section, or<br />on a SCRIPT conveniently placed before your JavaScript-calling HTML.<br /><br />A simple example follows:<br /><br />Suppose you have this script:<br />&lt;script language=JavaScript&gt;&lt;!--<br />&nbsp; var foo=Don\'t click here!;<br />// --&gt;&lt;/script&gt;<br /><br />Then, you can use that variable in some event handler:<br />&lt;a href=# onMouseOver=alert(foo)&gt;Click me if you dare!&lt;/a&gt;<br /><br />\'javascript:\' URLs are a way to execute functions from clicks on links,<br />by means of the href attribute. Since functions may or may not return<br />values, and the final result of a javascript: URL depends upon the<br />returned value of the called function, it\'s usually easier and less<br />error prone to accomplish the same thing via the onClick event handler,<br />leaving href pointing to nowhere (a clean way to do that is using the<br />\'#\' symbol).<br /></p>', 'PUBLISHED', '100', null, null, '2009-06-11 14:00:00'), ('11', '21', 'Advanced MySQL Replication - Improving Performance', '<h2>method 1 - Use Multiple Slaves</h2> <p>One method would be to break up data into multiple slaves. This could be done database by database (schema by schema) creating one slave database. Each slave would be pointing to the same master, and using replicate_do_db and replicate_ignore_db statements to specify which data to capture for it\'s slave. However it may be that your applications are not broken up cleanly that way, or that load favors certain tables, rather than certain schemas. So for your site there may be reason to do it on a table-by-table basis. You would then use replicate_do_table and replicate_ignore_table. You\'ll also need to keep in mind that more slaves mean more threads on the master database, which could add load there. If you run into that problem, consider creating a distribution master, and then slaving off of that. As a further consideration, realize that if you are running backups off of slave databases, your backup scripts will obviously be more complicated in this arrangement, so document well.</p>', 'PUBLISHED', '209', '1', '2', '2009-06-11 22:02:00'), ('12', '21', 'Advanced MySQL Replication - Improving Performance', '<h2>method 2 - Priming the Cache</h2> <p><strong><span style=font-size: x-small;>By </span></strong><a href=http://189.42.204.140/feedback.php/http://www.databasejournal.com/features/mysql/article.php/3801281><strong><span style=font-size: x-small;>Sean Hull</span></strong></a></p> <p>A second method would be to do what\'s called priming the cache. Recall that each of the SQL statements, which executed on the master, is re-executed on the slave database. All the work involved in reading blocks of data, sorting, and caching query execution details has to happen again on the slave. However, what if we could do this all BEFORE the slave SQL thread gets to that query. That\'s what the maatkit mk-slave-prefetch tool was built to do. Some sites have had great success with this method, so it is worth investigating. As with anything, test, tweak, and evaluate before rolling out in production.</p>', 'PRIVATE', '77', '1', '3', '2009-06-11 23:05:00'), ('13', '21', 'Advanced MySQL Replication - Improving Performance', '<p><strong><span style=font-size: x-small;>By </span></strong><a href=../../../../feedback.php/http://www.databasejournal.com/features/mysql/article.php/3801281><strong><span style=font-size: x-small;>Sean Hull</span></strong></a></p> <p>&nbsp;</p> <h2>method 3 - Move Writes Outside of Replication</h2> <p>A third method would be to move writes outside of replication. What does that mean? Suppose you have tables that load apache logs into your primary database. You can then use replicate_ignore_tables option to skip these heavy archive tables, and then just run a separate data load process on the slave to get that data into your slave database. Since this can also be done in parallel, it may provide surprising speedups.</p>', 'PUBLISHED', '15', '1', '3', '2009-06-11 15:03:00'), ('15', '21', 'Query Optimizations in MySQL', '<h3>2. Beware of Character Set Conversions</h3> <p>The character set that your client or application is using may be different from that of the table itself.&nbsp; This will require MySQL to implicitly convert it on the fly.&nbsp; In addition, certain character sets such as UTF8 support multi-byte characters, so they make storage requirements greater. &nbsp;</p>', 'DRAFT', '173', null, null, '2009-06-11 23:59:00'), ('24', '25', 'What is a firewall? ', '<p>A firewall protects networked computers from intentional hostile intrusion that could compromise confidentiality or result in data corruption or denial of service. It may be a hardware device or a software program running on a secure host computer. In either case, it must have at least two network interfaces, one for the network it is intended to protect, and one for the network it is exposed to.</p> <p>A firewall sits at the junction point or gateway between the two networks, usually a private network and a public network such as the Internet. The earliest firewalls were simply routers. The term firewall comes from the fact that by segmenting a network into different physical subnetworks, they limited the damage that could spread from one subnet to another just like firedoors or firewalls. <a name=Figure1><strong>Figure 1: Hardware Firewall</strong></a><br />Hardware firewall providing protection to a Local Network</p>', 'PUBLISHED', '46', null, null, '2009-06-11 13:15:00'), ('25', '24', 'What can\'t a firewall do?', '<p>A firewall cannot prevent individual users with modems from dialling into or out of the network, bypassing the firewall altogether. Employee misconduct or carelessness cannot be controlled by firewalls. Policies involving the use and misuse of passwords and user accounts must be strictly enforced. These are management issues that should be raised during the planning of any security policy but that cannot be solved with firewalls alone.</p> <p>The arrest of the Phonemasters cracker ring brought these security issues to light. Although they were accused of breaking into information systems run by AT&amp;T Corp., British Telecommunications Inc., GTE Corp., MCI WorldCom, Southwestern Bell, and Sprint Corp, the group did not use any high tech methods such as IP spoofing (see question 10). They used a combination of social engineering and dumpster diving. Social engineering involves skills not unlike those of a confidence trickster. People are tricked into revealing sensitive information. Dumpster diving or garbology, as the name suggests, is just plain old looking through company trash. Firewalls cannot be effective against either of these techniques.</p>', 'PUBLISHED', '79', null, null, '2009-06-11 17:02:00'), ('27', '25', 'What different types of firewalls are there? ', '<p>Firewalls fall into four broad categories: packet filters, circuit level gateways, application level gateways and stateful multilayer inspection firewalls.</p> <p>Packet filtering firewalls work at the network level of the OSI model, or the IP layer of TCP/IP. They are usually part of a router. A router is a device that receives packets from one network and forwards them to another network. In a packet filtering firewall each packet is compared to a set of criteria before it is forwarded. Depending on the packet and the criteria, the firewall can drop the packet, forward it or send a message to the originator. Rules can include source and destination IP address, source and destination port number and protocol used. The advantage of packet filtering firewalls is their low cost and low impact on network performance. Most routers support packet filtering. Even if other firewalls are used, implementing packet filtering at the router level affords an initial degree of security at a low network layer. This type of firewall only works at the network layer however and does not support sophisticated rule based models Network Address Translation (NAT) routers offer the advantages of packet filtering firewalls but can also hide the IP addresses of computers behind the firewall, and offer a level of circuit-based filtering.</p>', 'PUBLISHED', '40', '1', '3', '2009-06-11 12:02:00'), ('28', '25', 'What is IP spoofing? ', '<p>Many firewalls examine the source IP addresses of packets to determine if they are legitimate. A firewall may be instructed to allow traffic through if it comes from a specific trusted host. A malicious cracker would then try to gain entry by spoofing the source IP address of packets sent to the firewall. If the firewall thought that the packets originated from a trusted host, it may let them through unless other criteria failed to be met. Of course the cracker would need to know a good deal about the firewall\'s rule base to exploit this kind of weakness. This reinforces the principle that technology alone will not solve all security problems. Responsible management of information is essential. One of Courtney\'s laws sums it up: There are management solutions to technical problems, but no technical solutions to management problems.</p> <p>An effective measure against IP spoofing is the use of a Virtual Private Network (VPN) protocol such as IPSec. This methodology involves encryption of the data in the packet as well as the source address. The VPN software or firmware decrypts the packet and the source address and performs a checksum. If either the data or the source address have been tampered with, the packet will be dropped. Without access to the encryption keys, a potential intruder would be unable to penetrate the firewall.</p>', 'PRIVATE', '129', null, null, '2009-06-11 13:00:00'), ('29', '25', 'Benefits of a firewall ', '<p>Firewalls protect private local area networks from hostile intrusion from the Internet. Consequently, many LANs are now connected to the Internet where Internet connectivity would otherwise have been too great a risk.</p> <p>Firewalls allow network administrators to offer access to specific types of Internet services to selected LAN users. This selectivity is an essential part of any information management program, and involves not only protecting private information assets, but also knowing who has access to what. Privileges can be granted according to job description and need rather than on an all-or-nothing basis.</p>', 'PUBLISHED', '45', null, null, '2009-06-11 14:05:00'), ('30', '24', 'Why is my wireless connection so slow? ', '<p>People often have problems with slow transfer speeds, so I decided to post this.<br /><br />The first thing you should understand is how speeds are measured and denoted. Speeds will be reported back in kilobits, kilobytes, megabits or megabytes per second. A common source of confusion is the difference between a bit and a byte. There are 8 bits in 1 byte, so if your transfer speeds are 12 megabits per second, you\'re really getting 1.5 megabytes per second (12 divided by 8). Some programs report back in bytes, some in bits, it\'s a matter of which program you\'re using.<br /><br />The second thing you need to understand, is you will never get the full advertised speed on your wireless router. If the router says it is 54 megabits per second, you will likely only see half of that in real life situations. This is because of overhead and interference, which you can not get rid of. Even on 100 megabit wired connections, you will likely never see it\'s full capacity. Most people will see around 2-3 megabytes per second (18-24Mbps) on their 54Mbps (802.11g) router/AP\'s.<br /><br />The third thing you need to do, is get a program that will tell you what your current transfer speeds are. You have lots of different options. One of the most commonly used programs is <a href=http://readerror.gmxhome.de/><span style=color: monitor, but I prefer using a third-party program.<br /><br />After you\'ve done all of that, actually try transferring a file while running NetMeter, or another transfer speed monitoring program. See what speeds you\'re currently getting, so you know what you\'re working with. Make sure the file you are testing with is large enough for an accurate speed result.<br /><br />Now you\'re ready to start troubleshooting slow wireless speeds.<br /></p> <hr /> <p><br />First, make note of your original transfer speed as a reference. You don\'t want to go through troubleshooting without remembering if your new speed was better than the old.<br /><br />Second, go into your router/AP\'s web-config and make sure it\'s set to Auto Negotiate connection speeds. Some routers are set out-of-the-box to only hand out connections at 1Mbps (I don\'t know why). Also, some of them randomly will change their auto-negotiation feature without user intervention. <br /><br />Third, try locating possible devices interfering with your network. There are lots of different types of devices that could be interfering with your network. To list a few, a neighbor\'s wireless network, microwaves and cordless phones. To determine if any other wireless networks are in your area, download <a href=http://www.netstumbler.com/downloads/netstumblerinstaller_0_4_0.exe><span style=color: #0000ff;>Netstumbler</span></a> and run it. It will report back any other wireless networks in your range. If there are other networks, make note of what channel they are operating on. If it\'s operating on channel 6, and you\'re also on channel 6, you will likely see interference that could result in slow speeds and/or frequent disconnections from your network, so try changing the wireless channel on your network. If you have 2.4 GHz wireless phones in your home, try finding the option to change the wireless channel they operate on. Many 2.4 GHz phones give you this option to lessen interference, but some may still not have that option. The easiest way to tell your (or your neighbor\'s) wireless phone is interfering with your network is if when the phone rings, you loose connectivity to the wireless network. If yours is the definite cause of your interference, and you can\'t change the channel, try buying another phone. You can either get one of the newer phones that operate at more than 5 GHz, or go with some older models that operate at 900 MHz. As odd as it may sound, microwaves operate at frequencies very close to 2.4 GHz and can cause interference. Make sure you don\'t put your AP near a microwave (who puts AP\'s in their kitchen anyways <img src=http://i.dslr.net/v2/lite/wink.gif border=0 alt= width=15 align=absBottom />). <br /><br />If you can\'t find any interfering devices in your area, try a different wireless card and/or AP. Either go to a friends house, or try buying another from the local store (then returning it after your testing is done). It\'s possible your original wireless card isn\'t very good and doesn\'t keep a very good link with the AP. It\'s just as likely your AP is the source of the problem because it has poor range. If you test with a different AP and your speeds are fixed, then you know the AP was the source of your problem. If you test with a different wireless card and your speeds have been fixed, then your wireless card was likely the problem child in your situation.<br /><br />If you\'ve tried a different wireless card and/or AP, and you still don\'t have acceptable speeds, try wiring your computer directly into the router. See what speeds it gets that way to make sure the computer isn\'t the problem. Some older computers may not be able to keep up with faster transfer rates because they can\'t process the data as fast as you\'re sending it. <br /><br />If the computer isn\'t the problem, make sure you\'re not trying to get unrealistic speeds. You\'re not going to get perfect speeds all the time. Wireless is completely different from wired connections and it isn\'t perfect.<br /><br />Another thing to take into consideration is what kind of encryption you are using. WEP supposedly takes away ~5-10% of speeds due to the encryption method used; WPA isn\'t as bad.<br /></p>', 'PUBLISHED', '76', null, null, '2009-06-11 11:03:00'), ('32', '24', 'What is Bluetooth and how does it compare to WiFi?', '<p class=Normal>Bluetooth (BT) is a separate set of wireless standards to the IEEE 802.11 suite. It is similar to WiFi in that it can connect two devices with radio signals. The differences:</p> <ul class=Normal> <li class=Normal><strong>Speed</strong>: BT speeds are ~ 720kbps, WiFi maxes out at 11mbps </li> <li class=Normal><strong>Distance</strong>: BT primarily was designed for short range, up to 30 feet; while WiFi theoretically can reach 500 feet. </li> <li class=Normal><strong>Applications</strong>: BT was designed as a cable replacement, essentially to connect devices point-to-point. WiFi is designed to hook up an entire network. </li> <li class=Normal><strong>Simplicity</strong>: BT devices advertise their capabilities to others, and a single device can be connected to up to seven other devices at the same time. </li> <li class=Normal><strong>Cost</strong>: A quick survey of prices indicates that BT devices are slightly more expensive than their WiFi counterparts. However, the total final cost for each individual user will depend largely on their intended usage. Those people that already have some BT devices (BT-enabled printers and cell phones, for example) will find it less expensive to add a BT CF card to their Axim X5 than to add network capabilities to their printer or a modem-cable for their cell phone. On the other hand, if the user wants to use WiFi hotspots in addition to a cell phone connection, they will still need to buy the WiFi CF card and thus the economics will change. With PPCs that have built-in BT and WiFi, the user can pick and choose which protocol is used with each potential application. </li> <li class=Normal><strong>Energy usage</strong>: BT uses less power than WiFi, making it a good choice for connecting multiple battery powered devices or from a battery powered device to other equipment. </li> <li class=Normal><strong>Other equipment</strong>: WiFi equipment is essentially limited to computers and a few auxilary devices (in particular, printers). Since Bluetooth is designed primarily as a cable replacement, many more devices are available for BT connectivity. This includes printers, cameras, cell phones, keyboards, headsets, radios, etc. While users have been successful communicating with cell phones and other computing devices (PC, laptops, other PDAs) with their BT-enabled Axims, it is really not known whether all the available BT equipment will function in concert with the Axim. </li> </ul> <p class=Normal>Even though they were designed for different purposes, the lines are somewhat blurry. Recent developments with BT include APs with 100-meter ranges.</p> <p class=Normal>Check <a href=http://www.aximsite.com/bluetooth/>Ted\'s Bluetooth Guide for Pocket PC Devices</a> for details on using BlueTooth with your PPC.</p>', 'PRIVATE', '206', null, null, '2009-06-11 15:12:00'), ('33', '24', 'How has Windows Mobile 2003 affected WiFi, its cards/drivers, etc?', '<p>WM03 was designed to be more user friendly when setting your Axim up on a wireless network. Time will tell if Microsoft and Dell have succeeded in this goal. In the current early period after WM03\'s release, some issues have been recognized. For example, most of the manufacturers have not released drivers for their CF WiFi cards in WM03. Current exceptions to this include the Socket low power card, Dell\'s TrueMobile, and Ambicom (which currently only has beta drivers available).</p>', 'DRAFT', '193', null, null, '2009-06-11 16:11:00'), ('34', '24', 'Are there browsers other than Pocket IE?', '<p class=Normal><a href=http://www.af.wakwak.com/~ftoshi/pocket/index_e.html>FtxPBrowser</a> is a freeware plug-in that improves some of the functionality of Pocket IE (PIE).</p> <p class=Normal>NetFront is payware - I find it much better for accessing many of the websites although it still doesn\'t work for most finacial institutions I\'ve tried. It\'s available from Handango, just do a search on their site.</p> <p class=Normal><a href=http://www.bitstream.com/wireless/?wireless-web>Thunderhawk</a> is a subscription service that does reformatting of the websites you access so they work better on PPC</p>', 'PUBLISHED', '140', null, null, '2009-06-11 13:02:00'), ('35', '27', 'What is the difference between the OCI8 and ORA extension modules?', '<p>PHP offers two extension modules that can be used to connect to Oracle:</p> <ul> <li>Oracle Call-Interface functions (OCI8) </li> <li>Oracle 7 functions (ORA) </li> </ul> <p>OCI8 should be used whenever possible since it is optimised and provides more options.</p> <p>ORA is deprecated and no longer included in supported versions of PHP. It is unstable, does not include support for CLOBs, BLOBs, BFILEs, ROWIDs, etc. and should not be used.</p> <ul> <li>PHP 5.2 contains OCI8 1.2. </li> <li>PHP 5.3 contains OCI8 1.3, which improves reliability and adds features such as DRCP connection pooling support, FAN support, and external authentication. </li> </ul> <p>You can <a class=external text title=http://pecl.php.net/package/oci8 rel=nofollow href=http://pecl.php.net/package/oci8>download OCI8 1.3 from PECL</a> and install in on PHP 4.3.9 onwards.</p>', 'PRIVATE', '226', null, null, '2009-06-11 10:05:00'), ('36', '27', 'How does one configure PHP to use Oracle?', '<p>Follow these steps to prepare your PHP installation for connecting to Oracle databases:</p> <ul> <li>Download PHP from <a class=external free title=http://www.php.net/ rel=nofollow href=http://www.php.net/>http://www.php.net/</a>, install as per the install.txt or INSTALL files, and test if everything is working. </li> </ul> <ul> <li>Install the Oracle Instant Client, Oracle Client, or Oracle Server software on your machine and configure Oracle Net to connect to your database(s). See the <a title=SQL*Net FAQ href=http://189.42.204.140/wiki/SQL%2ANet_FAQ>SQL*Net FAQ</a> for details. </li> </ul> <ul> <li>On Windows, edit your php.ini file and uncomment (remove the semi-colon) the following line: </li> </ul> <pre> extension = php_oci8.dll </pre> <ul> <li>Ensure that your extension_dir parameter (in php.ini) points to the location where the above extension file resides. </li> </ul> <p>... otherwise, compile PHP with the following option:</p> <pre>--with-oci8=shared,/path/to/oracle/home/dir </pre> <ul> <li>Write a small program to test connectivity - see the next question. </li> </ul> <p>Oracle Technology Network has an article on <a class=external text title=http://www.oracle.com/technology/pub/notes/technote_php_instant.html rel=nofollow href=http://www.oracle.com/technology/pub/notes/technote_php_instant.html>Installing PHP and Oracle using Oracle Instant Client</a>.</p>', 'PUBLISHED', '115', null, null, '2009-06-11 17:02:00'), ('37', '27', 'How does one connect to Oracle?', '<p>Using the <strong>OCI8 Extension Module</strong> -</p> <pre>&lt;?php  if ($c = oci_connect(hr, hr_password, localhost/XE)) {    echo Successfully connected to Oracle.n;    oci_close($c);  } else {    $err = oci_error();    echo Oracle Connect Error  . $err[\'text\'];  }  ?&gt; </pre> <p>NOTE: You might need to set Oracle environment variables such as ORACLE_HOME and NLS_LANG prior to starting your web server. Avoid setting variables in PHP because Oracle context may have been initialized by Apache prior to the execution of the script. However some variables used only at connection time are probably OK to set in scripts:</p> <pre>&lt;?php    PutEnv(ORACLE_SID=ORCL);    PutEnv(TNS_ADMIN=/var/opt/oracle);  ... </pre> <p>Please note that PHP will share/re-use connections if the same userid/password combination is used (more than once) on a particular page or httpd server session. One can use the oci_new_connect() function to ensure one gets a new session. Use the oci_pconnect() function to make persistent connections.</p>', 'PRIVATE', '41', null, null, '2009-06-11 18:15:00'), ('38', '27', 'Why do we get error Call to undefined function: oci_connect()?', '<p>PHP is not using the correct extension module. Try compiling PHP with the following options:</p> <pre>--with-oci8=/path/to/oracle/home/dir </pre> <p>On Windows systems one can just uncomment the following lines in the php.ini file:</p> <pre>;extension = php_oci8.dll </pre> <p>Check your PATH (on Windows) and LD_LIBRARY_PATH (Linux) or equivalent variable and make sure it is set to the location of the Oracle libraries</p>', 'PUBLISHED', '52', null, null, '2009-06-11 14:11:00'), ('42', '18', 'Where can I find a complete list of variables are available to me in PHP? ', '<dd><a name=faq.using.variables></a> <p class=para>Read the manual page on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.predefined.php>predefined variables</a> as it includes a partial list of predefined variables available to your script. A complete list of available variables (and much more information) can be seen by calling the <a class=function href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/function.phpinfo.php>phpinfo()</a> function. Be sure to read the manual section on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.external.php>variables from outside of PHP</a> as it describes common scenarios for external variables, like from a HTML form, a Cookie, and the URL.</p> <blockquote> <p><strong class=note>Note</strong>: <strong>register_globals: important note</strong><br />As of PHP 4.2.0, the default value for the PHP directive <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ini.core.php#ini.register-globals>register_globals</a> is <em class=emphasis>off</em>, and it was completely removed as of PHP 6.0.0. The PHP community discourages developers from relying on this directive, and encourages the use of other means, such as the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.predefined.php>superglobals</a>.</p> </blockquote></dd>', 'PUBLISHED', '38', null, null, '2009-06-11 00:10:00'), ('43', '18', 'PHP vs. ASP?', '<p class=para>ASP is not really a language in itself, but an acronym for Active Server Pages; the actual languages used to program ASP include Visual Basic Script, JScript, and C#, among others. The biggest drawback of ASP is that it\'s a proprietary system that is natively used only on the Microsoft Internet Information Server (IIS) platform. This limits its availability to Win32 based servers. There are a couple of projects in the works that allows ASP to function with other environments and webservers: <a class=link external href=http://www.stryon.com/products.asp?s=1>&raquo; InstantASP</a> from <a class=link external href=http://www.halcyonsoft.com/>&raquo; Halcyon</a> (commercial), Chili!Soft ASP from <a class=link external href=http://www.chilisoft.com/>&raquo; Chili!Soft</a> (commercial), and <a class=link external href=http://www.mono-project.com/>&raquo; Mono</a> (open-source). ASP is said to be a slower and more cumbersome language than PHP, with less overall stability. One of the pro\'s of ASP is that, since it primarily uses VBScript, it\'s relatively easy to pick up the language if you\'re already proficient in Visual Basic. ASP support is also enabled by default in IIS, making it easy to get up and running. However, the components built in ASP are really limited, so if you need to use advanced features (like interacting with FTP servers), you\'ll need to buy additional components.</p>', 'PRIVATE', '46', null, null, '2009-06-11 00:05:00'), ('44', '18', 'Migrating from PHP 4 to PHP 5 ', '<dd><a name=faq.migration5.php45></a> <p class=para>Although PHP 5 offers many new features, it\'s designed to be as compatible with earlier versions of PHP as possible with little functionality being broken in the process.</p> <p class=para>Be sure to read the appropriate <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/migration5.php>PHP 5 migration appendix</a> of this manual as it contains even more information on the topic of migrating to PHP 5.</p> </dd>', 'PUBLISHED', '214', '2', '6', '2009-06-11 01:00:00'), ('45', '18', 'Does MySQL work in PHP 5? It seemed to have disappeared. ', '<dd><a name=faq.migration5.mysql></a> <p class=para><a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ref.mysql.php>MySQL</a> is supported with the only change being that MySQL support is no longer enabled by <em class=emphasis>default</em> in PHP 5. This essentially means that PHP doesn\'t include the <span class=option>--with-mysql</span> option in the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/configuration.php>configure</a> line so that you must now manually do this when compiling PHP. Windows users will edit php.ini and enable the php_mysql.dll DLL as in PHP 4 no such DLL existed, it was simply built into your Windows PHP binaries.</p> <p class=para>Also, the MySQL client libraries are no longer bundled with PHP. More details on this topic are covered in <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/faq.databases.php#faq.databases.mysql.php5>the following FAQ</a> and be sure to read the <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/ref.mysql.php>MySQL section</a> for details on installing MySQL. An example configure line would be <span class=option>--with-mysql=/usr</span> while Windows users will need the libmySQL.dll available to the system.</p> </dd>', 'PUBLISHED', '84', null, null, '2009-06-11 02:00:00'), ('47', '18', 'After installing shared MySQL support, Apache dumps core as soon as libphp4.so is loaded. Can this be fixed? ', '<p class=para>If your MySQL libs are linked against pthreads this will happen. Check using ldd. If they are, grab the MySQL tarball and compile from source, or recompile from the source rpm and remove the switch in the spec file that turns on the threaded client code. Either of these suggestions will fix this. Then recompile PHP with the new MySQL libs.</p>', 'PUBLISHED', '195', '1', '3', '2009-06-11 04:00:00'), ('48', '18', 'How do I deal with register_globals? ', '<p class=para>For information about the security implications of <em>register_globals</em>, read the security chapter on <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/security.globals.php>Using register_globals</a>.</p> <p class=para>It\'s preferred to use <a class=link href=http://189.42.204.140/scriptcase4_en/app/sc_tickets/form_kb_articles/language.variables.superglobals.php>superglobals</a>, rather than relying upon <em>register_globals</em> being on.</p> <p class=para>If you are on a shared host with <em>register_globals</em> turned off and need to use some legacy applications, which require this option to be turned on, or you are on some hosting server, where this feature is turned on, but you would like to eliminate security risks, you might need to emulate the opposite setting with PHP. It is always a good idea to first ask if it would be possible to change the option somehow in PHP\'s configuration, but if it is not possible, then you can use these compatibility snippets.</p>', 'PRIVATE', '181', '1', '2', '2009-06-11 03:00:00'), ('49', '18', 'teste', '<p>teste</p>', 'DRAFT', '0', '0', '0', null), ('50', '18', 'teste2', '<p>teste2</p>', 'DRAFT', '4', '0', '0', '2009-06-26 14:52:38');

-- ----------------------------
-- Table structure for `kb_articletype`
-- ----------------------------

create table `kb_articletype` (
  `articletypeid` varchar(10) not null,
  `articletypename` varchar(255) default null,
  primary key (`articletypeid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of kb_articletype
-- ----------------------------
INSERT INTO `kb_articletype` VALUES ('DRAFT', 'The article is saved but not yet published. It can only be read bystaff'), ('PRIVATE', 'Private articles can only be read by staff.'), ('PUBLISHED', 'The article is viewable to everyone in the knowledgebase');

-- ----------------------------
-- Table structure for `kb_categories`
-- ----------------------------

create table `kb_categories` (
  `categoryid` int(11) not null auto_increment,
  `categoryname` varchar(255) default null,
  `categoryparent` int(11) default null,
  `categorylabel` varchar(255) default null,
  `categoryorder` int(11) default null,
  primary key (`categoryid`),
  key `categoryparent` (`categoryparent`),
  constraint `kb_categories_ibfk_1` foreign key (`categoryparent`) references `kb_categories` (`categoryid`)
) engine=innodb auto_increment=30 default charset=utf8;

-- ----------------------------
-- Records of kb_categories
-- ----------------------------
INSERT INTO `kb_categories` VALUES ('17', 'Programming', null, '  Programming', '1'), ('18', 'PHP', '17', '    PHP', '2'), ('19', 'JavaScript', '17', '    JavaScript', '3'), ('20', 'Databases', null, '  Databases', '4'), ('21', 'MYSQL', '20', '    MYSQL', '5'), ('22', 'Storedd Procedure', '21', '      Stored Procedure', '6'), ('23', 'Networking', null, '  Networking', '10'), ('24', 'Wireless', '23', '    Wireless', '11'), ('25', 'Firewall', '23', '    Firewall', '12'), ('26', 'UNION statement', '21', '      UNION statement', '7'), ('27', 'ORACLE', '20', '    ORACLE', '8'), ('28', 'NLS settings', '27', '      NLS settings', '9'), ('29', 'USB Modem', '23', '    USB Modem', '13');

-- ----------------------------
-- Table structure for `languages`
-- ----------------------------

create table `languages` (
  `serial` int(11) not null auto_increment,
  `languageid` varchar(30) default null,
  `languagename` varchar(100) default null,
  primary key (`serial`)
) engine=innodb auto_increment=3 default charset=utf8;

-- ----------------------------
-- Records of languages
-- ----------------------------
INSERT INTO `languages` VALUES ('1', 'en_us;en_us', 'English'), ('2', 'es;es_es', 'Spanish');

-- ----------------------------
-- Table structure for `message_templates`
-- ----------------------------

create table `message_templates` (
  `templateid` int(11) not null auto_increment,
  `categoryid` int(11) default null,
  `templatedescription` varchar(100) default null,
  `templatecontent` text,
  primary key (`templateid`),
  key `categoryid` (`categoryid`),
  constraint `message_templates_ibfk_1` foreign key (`categoryid`) references `categories` (`categoryid`)
) engine=innodb auto_increment=14 default charset=utf8;

-- ----------------------------
-- Records of message_templates
-- ----------------------------
INSERT INTO `message_templates` VALUES ('1', '1', 'Customers file display na error in the e-mail.', 'Check the entry format. It should be: abc@abc.abc'), ('2', '1', 'How to classify the customer by priority?', 'Check the user manual the topic How to configure the priority '), ('3', '1', 'How can I access  a client  last orders?', 'In the Reports menu open the subfolder Customers and click on Last Orders.'), ('4', '2', 'I can not download the technical standards  manual.', 'The file was temporarily removed for review. Soon it will be available for download.'), ('5', '2', 'Access to the site is very slow on weekends.', 'This acorre due to the larger data traffic during the weekend.'), ('6', '3', 'Can I pay my purchase in 12 instalments using the Visa?', 'The payment with 12 instalments is only allowed on mastercard'), ('7', '3', 'I want to cancel my order number xxxxx.', 'To cancel your order please contact the service and quality center'), ('8', '4', 'I can not open a message attachment. ', 'The file was blocked because it is an executable.'), ('9', '4', 'I can&#180;t sync my mail.', 'The server was out  at that time, but is already operational.'), ('10', '5', 'My desktop does not turn on', 'Make sure it is properly connected to the power supply.'), ('11', '5', 'The mouse does not move to the side', 'Make sure the mouse is not dirty and  contact the hardware support.'), ('12', '6', 'My Firefox browser  is displaying na Javascript error', 'Provavalmente an error occurred on the page you were accessing.'), ('13', '6', 'My  Office does not open, or word or excel ...', 'Please, try reinstalling the program.');

-- ----------------------------
-- Table structure for `staff`
-- ----------------------------

create table `staff` (
  `staffid` int(11) not null auto_increment,
  `staffname` varchar(100) default null,
  `staffemail` varchar(150) default null,
  `staffpassword` varchar(8) default null,
  `adminflag` char(1) default null,
  `stafflanguage` varchar(30) default null,
  `signature` varchar(255) default null,
  primary key (`staffid`)
) engine=innodb auto_increment=11 default charset=utf8;

-- ----------------------------
-- Records of staff
-- ----------------------------
INSERT INTO `staff` VALUES ('1', 'Raymond', 'raymond@scriptcase.net', 'admin', 'Y', 'en_us;en_us', '<p>----------------------------</p> <p>Raymond Voltz</p>'), ('2', 'Juan', 'gonzales@scriptcase.net', 'admin', 'Y', 'es;es_es', '<p>----------------------------</p>'), ('3', 'Logan McKinley', 'staff@scriptcase.net', 'admin', 'Y', 'en_us;en_us', '<p>----------------------------</p>'), ('4', 'Catherine Poddar', 'catherine@sctiptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), ('5', 'Don Parker', 'staff_es@sctiptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), ('6', 'Juan estevan', 'estevam@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>'), ('7', 'Maria Chong', 'staff@scriptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), ('8', 'Sean', 'rodrigo@scriptcase.net', 'staff', 'N', 'en_us;en_us', '<p>----------------------------</p>'), ('9', 'Margaret Royston', 'arlindo@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>'), ('10', 'Ruben Polking', 'staff@scriptcase.net', 'staff', 'N', 'es;es_es', '<p>----------------------------</p>');

-- ----------------------------
-- Table structure for `staff_categories`
-- ----------------------------

create table `staff_categories` (
  `categoryid` int(11) not null,
  `staff_staffid` int(11) not null,
  primary key (`categoryid`,`staff_staffid`),
  key `staff_staffid` (`staff_staffid`),
  constraint `staff_categories_ibfk_1` foreign key (`categoryid`) references `categories` (`categoryid`),
  constraint `staff_categories_ibfk_2` foreign key (`staff_staffid`) references `staff` (`staffid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of staff_categories
-- ----------------------------
INSERT INTO `staff_categories` VALUES ('1', '3'), ('2', '3'), ('3', '3'), ('4', '3'), ('5', '3'), ('6', '3'), ('1', '5'), ('2', '5'), ('3', '5'), ('4', '5'), ('5', '5'), ('6', '5'), ('1', '6'), ('2', '6'), ('3', '6'), ('4', '6'), ('5', '6'), ('6', '6'), ('1', '7'), ('2', '7'), ('3', '7'), ('4', '7'), ('5', '7'), ('6', '7'), ('1', '8'), ('2', '8'), ('3', '8'), ('4', '8'), ('5', '8'), ('6', '8'), ('1', '9'), ('2', '9'), ('3', '9'), ('4', '9'), ('5', '9'), ('6', '9'), ('1', '10'), ('2', '10'), ('3', '10'), ('4', '10'), ('5', '10'), ('6', '10');

-- ----------------------------
-- Table structure for `systemsettings`
-- ----------------------------

create table `systemsettings` (
  `id` int(11) not null,
  `smtpserver` varchar(255) default null,
  `smtpuser` varchar(100) default null,
  `smtppassword` varchar(100) default null,
  `emailaccount` varchar(100) default null,
  `assigmentmode` varchar(30) default null,
  `publicticketsopening` char(1) default null,
  `definedparameters` varchar(255) default 'null',
  `broadcastmessages` char(1) default null,
  `defaultpriority` int(1) default null,
  `smtpsecurityflag` char(1) default null,
  `smtpport` char(3) default null,
  `urltrackingscreen` varchar(255) default null,
  `urlconfirmationscreen` varchar(255) default null,
  `defaultlanguage` varchar(50) default null,
  `companyname` varchar(100) default null,
  `urlimgok` varchar(300) default null,
  `urlimgfail` varchar(300) default null,
  `sys_version` varchar(100) not null,
  primary key (`id`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of systemsettings
-- ----------------------------
INSERT INTO `systemsettings` VALUES ('1', 'smtp.example.com', '', null, 'example@example.com', 'Direct', 'Y', 'Y', 'N', '2', '', '25', 'http://localhost:83/scriptcase/app/sc_tickets/ctrl_tracking_tickets/ctrl_tracking_tickets.php', 'http://localhost:83/scriptcase/app/sc_tickets/ctrl_confirm_acount_creation/ctrl_confirm_acount_creation.php', 'en_us;en_us', 'ScriptCase', '<img src=\'../_lib/img/02.png\'>', '<img src=\'../_lib/img/01.png\'>', 'reg');

-- ----------------------------
-- Table structure for `ticket`
-- ----------------------------

create table `ticket` (
  `ticketid` int(11) not null auto_increment,
  `ticketpriorityid` int(11) not null,
  `statusid` varchar(30) not null,
  `ownerid` int(11) default null,
  `customerid` int(11) default null,
  `categoryid` int(11) default null,
  `subject` varchar(100) default null,
  `ticketdate` datetime default null,
  `customerrating` int(11) default null,
  `customercomments` varchar(255) default null,
  `ticketlastupdate` datetime default null,
  `ticketlastreplier` varchar(150) default null,
  `tickettrack` varchar(10) default null,
  primary key (`ticketid`),
  key `ticketpriorityid` (`ticketpriorityid`),
  key `statusid` (`statusid`),
  key `ownerid` (`ownerid`),
  key `customerid` (`customerid`),
  key `categoryid` (`categoryid`),
  constraint `ticket_ibfk_1` foreign key (`ticketpriorityid`) references `ticketpriority` (`ticketpriorityid`),
  constraint `ticket_ibfk_2` foreign key (`statusid`) references `ticketstatus` (`statusid`),
  constraint `ticket_ibfk_3` foreign key (`ownerid`) references `staff` (`staffid`),
  constraint `ticket_ibfk_4` foreign key (`customerid`) references `customer` (`customerid`),
  constraint `ticket_ibfk_5` foreign key (`categoryid`) references `categories` (`categoryid`)
) engine=innodb auto_increment=3980 default charset=utf8;

-- ----------------------------
-- Records of ticket
-- ----------------------------
INSERT INTO `ticket` VALUES ('1', '1', 'SOLVED', '10', '2', '5', 'Peripheral Issue', '2008-03-01 11:29:30', '4', null, '2008-03-14 14:40:08', 'STAFF', 'C4CA4238A0'), ('2', '2', 'SOLVED', '1', '35', '5', 'Peripheral Issue', '2008-03-01 08:27:40', '4', null, '2008-03-02 17:34:42', 'STAFF', 'C81E728D9D'), ('3', '3', 'SOLVED', '8', '34', '2', 'WEB Site Issue', '2008-03-01 08:34:55', '3', null, '2008-03-04 16:41:27', 'STAFF', 'ECCBC87E4B'), ('4', '3', 'CLOSED', '2', '19', '6', 'Sotfware Issue', '2008-03-01 10:57:54', '3', null, '2008-03-08 14:35:01', 'STAFF', 'A87FF679A2'), ('5', '2', 'SOLVED', '8', '1', '5', 'Peripheral Doubt', '2008-03-01 09:02:44', '3', null, '2008-03-04 16:32:15', 'STAFF', 'E4DA3B7FBB'), ('6', '2', 'SOLVED', '4', '35', '3', 'Sales Issue', '2008-03-01 08:43:03', '3', null, '2008-03-04 13:41:01', 'STAFF', '1679091C5A'), ('7', '2', 'SOLVED', '1', '22', '1', 'CRM Application Issue', '2008-03-02 07:33:45', '4', null, '2008-03-02 16:24:20', 'STAFF', '8F14E45FCE'), ('8', '2', 'CLOSED', '10', '40', '6', 'Software Doubt', '2008-03-02 12:18:02', '1', null, '2008-03-03 16:14:08', 'STAFF', 'C9F0F895FB'), ('9', '1', 'SOLVED', '3', '38', '2', 'WEB Site Issue', '2008-03-02 11:03:03', '4', null, '2008-03-05 14:23:54', 'STAFF', '45C48CCE2E'), ('10', '2', 'CLOSED', '5', '35', '1', 'CRM Application Issue', '2008-03-02 08:10:59', '3', null, '2008-03-19 15:37:23', 'STAFF', 'D3D9446802'), ('11', '3', 'SOLVED', '1', '34', '4', 'WEB Mail Issue', '2008-03-02 06:22:58', '4', null, '2008-03-10 18:28:53', 'STAFF', '6512BD43D9'), ('12', '2', 'SOLVED', '9', '40', '6', 'Software Issue', '2008-03-03 07:09:28', '3', null, '2008-03-14 17:04:41', 'STAFF', 'C20AD4D76F'), ('13', '2', 'SOLVED', '8', '11', '5', 'Peripheral Issue', '2008-03-03 10:21:58', '3', null, '2008-03-15 14:10:13', 'STAFF', 'C51CE410C1'), ('14', '2', 'SOLVED', '10', '38', '5', 'Peripheral Issue', '2008-03-03 06:14:02', '4', null, '2008-03-09 16:13:36', 'STAFF', 'AAB3238922'), ('15', '2', 'CLOSED', '2', '3', '1', 'CRM Application Issue', '2008-03-03 06:48:03', '1', null, '2008-03-06 14:15:09', 'STAFF', '9BF31C7FF0'), ('16', '1', 'SOLVED', '9', '33', '5', 'Peripheral Issue', '2008-03-03 08:57:55', '4', null, '2008-03-16 14:09:42', 'STAFF', 'C74D97B01E'), ('17', '2', 'SOLVED', '9', '29', '6', 'Sotfware Issue', '2008-03-03 08:14:34', '3', null, '2008-03-11 17:07:29', 'STAFF', '70EFDF2EC9'), ('18', '1', 'SOLVED', '8', '29', '6', 'Software Issue', '2008-03-04 11:44:21', '4', null, '2008-03-19 16:34:42', 'STAFF', '6F4922F455'), ('19', '3', 'SOLVED', '1', '1', '1', 'CRM Application Issue', '2008-03-04 10:22:22', '2', null, '2008-03-06 18:31:43', 'STAFF', '1F0E3DAD99'), ('20', '3', 'CLOSED', '6', '33', '3', 'Sales Doubt', '2008-03-04 12:32:58', '3', null, '2008-03-09 13:11:29', 'STAFF', '98F1370821'), ('21', '1', 'SOLVED', '6', '37', '5', 'Peripheral Doubt', '2008-03-04 07:28:24', '3', null, '2008-03-05 17:14:41', 'STAFF', '3C59DC048E'), ('22', '1', 'SOLVED', '5', '12', '2', 'WEB Site Issue', '2008-03-04 06:24:00', '3', null, '2008-03-04 14:08:01', 'STAFF', 'B6D767D2F8'), ('23', '2', 'SOLVED', '5', '11', '5', 'Peripheral Issue', '2008-03-04 11:27:57', '4', null, '2008-03-12 15:07:03', 'STAFF', '37693CFC74'), ('24', '1', 'SOLVED', '2', '19', '1', 'CRM Application Doubt', '2008-03-04 07:58:18', '3', null, '2008-03-13 14:11:34', 'STAFF', '1FF1DE7740'), ('25', '2', 'SOLVED', '2', '22', '4', 'WEB Mail Doubt', '2008-03-05 12:32:18', '3', null, '2008-03-06 14:26:41', 'STAFF', '8E296A067A'), ('26', '2', 'SOLVED', '3', '19', '1', 'CRM Application Issue', '2008-03-06 07:06:38', '2', null, '2008-03-08 17:18:18', 'STAFF', '4E732CED34'), ('27', '1', 'SOLVED', '10', '25', '4', 'WEB Mail Doubt', '2008-03-07 12:40:04', '4', null, '2008-03-17 14:06:10', 'STAFF', '02E74F10E0'), ('28', '1', 'SOLVED', '1', '1', '3', 'Sales Doubt', '2008-03-07 09:31:36', '4', null, '2008-03-18 15:48:02', 'STAFF', '33E75FF09D'), ('29', '2', 'SOLVED', '2', '33', '1', 'CRM Application Issue', '2008-03-07 11:05:07', '4', null, '2008-03-24 17:24:01', 'STAFF', '6EA9AB1BAA'), ('30', '1', 'SOLVED', '1', '29', '6', 'Sotfware Issue', '2008-03-07 07:07:10', '2', null, '2008-03-08 16:22:28', 'STAFF', '34173CB38F'), ('31', '2', 'CLOSED', '10', '28', '1', 'CRM Application Issue', '2008-03-07 06:21:54', '1', null, '2008-03-18 17:15:17', 'STAFF', 'C16A5320FA'), ('32', '2', 'SOLVED', '9', '33', '3', 'Sales Issue', '2008-03-07 06:29:28', '2', null, '2008-03-14 16:32:00', 'STAFF', '6364D3F0F4'), ('33', '2', 'CLOSED', '9', '10', '2', 'WEB Site Issue', '2008-03-07 06:02:34', '3', null, '2008-03-07 17:31:41', 'STAFF', '182BE0C5CD'), ('34', '1', 'SOLVED', '1', '3', '5', 'Peripheral Issue', '2008-03-07 12:07:45', '3', null, '2008-03-16 18:04:50', 'STAFF', 'E369853DF7'), ('35', '3', 'SOLVED', '1', '22', '3', 'Sales Doubt', '2008-03-08 09:57:45', '4', null, '2008-03-20 17:44:54', 'STAFF', '1C383CD30B'), ('36', '2', 'SOLVED', '5', '34', '1', 'CRM Application Issue', '2008-03-08 06:25:18', '3', null, '2008-03-12 13:59:47', 'STAFF', '19CA14E7EA'), ('37', '2', 'SOLVED', '7', '21', '4', 'WEB Mail Doubt', '2008-03-08 08:59:34', '3', null, '2008-03-17 16:44:37', 'STAFF', 'A5BFC9E079'), ('38', '1', 'SOLVED', '1', '37', '4', 'WEB Mail Issue', '2008-03-08 09:07:55', '3', null, '2008-03-12 13:00:15', 'STAFF', 'A5771BCE93'), ('39', '1', 'CLOSED', '3', '9', '5', 'Peripheral Doubt', '2008-03-09 06:37:09', '2', null, '2008-03-11 17:18:10', 'STAFF', 'D67D8AB4F4'), ('40', '2', 'SOLVED', '6', '40', '4', 'WEB Mail Doubt', '2008-03-09 10:05:48', '2', null, '2008-03-11 14:43:27', 'STAFF', 'D645920E39'), ('41', '2', 'SOLVED', '6', '39', '1', 'CRM Application Issue', '2008-03-09 06:49:20', '4', null, '2008-03-20 17:22:57', 'STAFF', '3416A75F4C'), ('42', '2', 'SOLVED', '10', '37', '6', 'Software Issue', '2008-03-09 06:51:18', '2', null, '2008-03-20 13:23:01', 'STAFF', 'A1D0C6E83F'), ('43', '1', 'SOLVED', '8', '22', '4', 'WEB Mail Doubt', '2008-03-09 10:39:45', '2', null, '2008-03-18 13:38:19', 'STAFF', '17E62166FC'), ('44', '1', 'SOLVED', '10', '19', '6', 'Sotfware Issue', '2008-03-09 07:13:18', '2', null, '2008-03-09 15:02:22', 'STAFF', 'F7177163C8'), ('45', '2', 'SOLVED', '1', '14', '4', 'WEB Mail Issue', '2008-03-09 08:00:10', '4', null, '2008-03-12 18:07:28', 'STAFF', '6C8349CC72'), ('46', '2', 'SOLVED', '1', '34', '4', 'WEB Mail Doubt', '2008-03-09 11:47:54', '4', null, '2008-03-20 18:50:25', 'STAFF', 'D9D4F495E8'), ('47', '2', 'SOLVED', '10', '33', '6', 'Software Doubt', '2008-03-09 06:31:25', '3', null, '2008-03-09 15:30:49', 'STAFF', '67C6A1E7CE'), ('48', '2', 'CLOSED', '6', '1', '3', 'Sales Issue', '2008-03-09 06:00:42', '3', null, '2008-03-16 13:48:52', 'STAFF', '642E92EFB7'), ('49', '3', 'SOLVED', '9', '11', '6', 'Software Issue', '2008-03-09 12:39:51', '3', null, '2008-03-13 17:02:23', 'STAFF', 'F457C545A9'), ('50', '2', 'SOLVED', '5', '11', '4', 'WEB Mail Issue', '2008-03-10 08:47:08', '4', null, '2008-03-21 14:36:36', 'STAFF', 'C0C7C76D30'), ('51', '3', 'SOLVED', '1', '13', '3', 'Sales Doubt', '2008-03-10 08:06:18', '2', null, '2008-03-11 13:54:04', 'STAFF', '2838023A77'), ('52', '1', 'SOLVED', '1', '35', '5', 'Peripheral Issue', '2008-03-10 11:51:52', '3', null, '2008-03-20 14:55:06', 'STAFF', '9A1158154D'), ('53', '3', 'SOLVED', '2', '14', '5', 'Peripheral Doubt', '2008-03-10 06:28:07', '2', null, '2008-03-16 13:15:01', 'STAFF', 'D82C8D1619'), ('54', '1', 'CLOSED', '10', '24', '5', 'Peripheral Issue', '2008-03-10 09:11:15', '2', null, '2008-03-14 15:26:41', 'STAFF', 'A684ECEEE7'), ('55', '3', 'SOLVED', '2', '37', '4', 'WEB Mail Doubt', '2008-03-10 11:02:11', '4', null, '2008-03-15 14:01:46', 'STAFF', 'B53B3A3D6A'), ('56', '3', 'SOLVED', '8', '12', '3', 'Sales Doubt', '2008-03-11 08:12:06', '3', null, '2008-03-15 18:32:19', 'STAFF', '9F61408E3A'), ('57', '2', 'SOLVED', '2', '5', '5', 'Peripheral Doubt', '2008-03-11 09:44:57', '3', null, '2008-03-16 15:59:36', 'STAFF', '72B32A1F75'), ('58', '3', 'SOLVED', '10', '36', '6', 'Software Issue', '2008-03-12 10:21:32', '3', null, '2008-03-14 18:50:26', 'STAFF', '66F041E16A'), ('59', '2', 'SOLVED', '10', '1', '6', 'Software Issue', '2008-03-12 11:25:36', '2', null, '2008-03-24 17:09:09', 'STAFF', '093F65E080'), ('60', '2', 'SOLVED', '3', '28', '4', 'WEB Mail Issue', '2008-03-12 06:29:08', '3', null, '2008-03-20 17:57:38', 'STAFF', '072B030BA1'), ('61', '2', 'SOLVED', '9', '19', '5', 'Peripheral Issue', '2008-03-14 10:11:42', '2', null, '2008-03-23 16:40:10', 'STAFF', '7F39F8317F'), ('62', '1', 'SOLVED', '10', '5', '4', 'WEB Mail Issue', '2008-03-14 12:15:06', '2', null, '2008-03-24 15:50:15', 'STAFF', '44F683A841'), ('63', '2', 'SOLVED', '10', '7', '6', 'Software Doubt', '2008-03-14 09:08:28', '2', null, '2008-03-19 17:14:14', 'STAFF', '03AFDBD66E'), ('64', '2', 'SOLVED', '10', '31', '6', 'Sotfware Issue', '2008-03-14 10:31:35', '2', null, '2008-03-22 16:36:46', 'STAFF', 'EA5D2F1C46'), ('65', '2', 'CLOSED', '4', '25', '3', 'Sales Doubt', '2008-03-14 06:32:40', '1', null, '2008-03-16 15:53:45', 'STAFF', 'FC490CA45C'), ('66', '2', 'SOLVED', '3', '5', '3', 'Sales Issue', '2008-03-14 08:55:11', '2', null, '2008-03-30 17:33:54', 'STAFF', '3295C76ACB'), ('67', '3', 'SOLVED', '1', '10', '6', 'Software Issue', '2008-03-14 12:57:52', '2', null, '2008-03-20 14:10:14', 'STAFF', '735B90B456'), ('68', '2', 'SOLVED', '10', '31', '6', 'Sotfware Issue', '2008-03-14 12:57:35', '2', null, '2008-03-25 18:16:29', 'STAFF', 'A3F390D88E'), ('69', '2', 'SOLVED', '5', '1', '3', 'Sales Doubt', '2008-03-15 09:27:27', '2', null, '2008-03-15 18:43:37', 'STAFF', '14BFA6BB14'), ('70', '3', 'CLOSED', '9', '37', '1', 'CRM Application Doubt', '2008-03-15 10:15:17', '2', null, '2008-03-23 18:33:24', 'STAFF', '7CBBC409EC'), ('71', '2', 'SOLVED', '4', '21', '5', 'Peripheral Issue', '2008-03-15 12:50:57', '3', null, '2008-03-23 17:16:22', 'STAFF', 'E2C420D928'), ('72', '2', 'SOLVED', '1', '10', '6', 'Sotfware Issue', '2008-03-15 11:29:09', '3', null, '2008-03-28 17:41:36', 'STAFF', '32BB90E897'), ('73', '3', 'SOLVED', '1', '25', '3', 'Sales Doubt', '2008-03-15 09:15:43', '3', null, '2008-03-16 18:16:38', 'STAFF', 'D2DDEA18F0'), ('74', '2', 'CLOSED', '6', '22', '6', 'Software Issue', '2008-03-15 10:36:17', '1', null, '2008-03-21 15:18:52', 'STAFF', 'AD61AB1432'), ('75', '1', 'SOLVED', '5', '1', '6', 'Sotfware Issue', '2008-03-16 12:12:27', '3', null, '2008-03-26 17:42:51', 'STAFF', 'D09BF41544'), ('76', '2', 'SOLVED', '5', '17', '6', 'Software Doubt', '2008-03-16 10:28:25', '3', null, '2008-03-17 14:57:28', 'STAFF', 'FBD7939D67'), ('77', '2', 'SOLVED', '1', '22', '4', 'WEB Mail Doubt', '2008-03-16 10:46:02', '2', null, '2008-03-30 18:55:56', 'STAFF', '28DD2C7955'), ('78', '2', 'CLOSED', '1', '19', '6', 'Software Doubt', '2008-03-16 10:03:22', '1', null, '2008-03-22 14:56:35', 'STAFF', '35F4A8D465'), ('79', '2', 'SOLVED', '2', '32', '6', 'Software Issue', '2008-03-16 06:48:53', '3', null, '2008-04-01 18:39:56', 'STAFF', 'D1FE173D08'), ('80', '3', 'SOLVED', '10', '22', '5', 'Peripheral Issue', '2008-03-16 07:38:37', '2', null, '2008-03-21 13:47:24', 'STAFF', 'F033AB37C3'), ('81', '1', 'SOLVED', '5', '21', '5', 'Peripheral Doubt', '2008-03-16 10:42:11', '3', null, '2008-03-25 17:26:17', 'STAFF', '43EC517D68'), ('82', '1', 'CLOSED', '10', '10', '4', 'WEB Mail Doubt', '2008-03-16 06:49:29', '2', null, '2008-03-16 17:01:36', 'STAFF', '9778D5D219'), ('83', '1', 'SOLVED', '4', '32', '6', 'Sotfware Issue', '2008-03-16 08:14:05', '3', null, '2008-03-19 13:40:01', 'STAFF', 'FE9FC289C3'), ('84', '2', 'SOLVED', '7', '38', '5', 'Peripheral Issue', '2008-03-16 11:59:30', '4', null, '2008-03-26 16:11:30', 'STAFF', '68D30A9594'), ('85', '2', 'SOLVED', '10', '19', '4', 'WEB Mail Issue', '2008-03-17 11:53:43', '4', null, '2008-03-22 13:41:51', 'STAFF', '3EF815416F'), ('86', '3', 'SOLVED', '10', '17', '6', 'Software Doubt', '2008-03-17 11:08:52', '4', null, '2008-03-26 15:43:46', 'STAFF', '93DB85ED90'), ('87', '2', 'SOLVED', '5', '28', '2', 'WEB Site Issue', '2008-03-17 10:01:10', '4', null, '2008-04-02 13:16:33', 'STAFF', 'C7E1249FFC'), ('88', '1', 'SOLVED', '1', '32', '2', 'WEB Site Issue', '2008-03-17 08:10:47', '3', null, '2008-03-19 14:47:26', 'STAFF', '2A38A4A931'), ('89', '2', 'SOLVED', '4', '10', '5', 'Peripheral Doubt', '2008-03-17 08:18:45', '2', null, '2008-03-30 16:41:36', 'STAFF', '7647966B73'), ('90', '1', 'SOLVED', '5', '17', '1', 'CRM Application Issue', '2008-03-17 06:27:06', '3', null, '2008-03-26 15:26:20', 'STAFF', '8613985EC4'), ('91', '3', 'SOLVED', '2', '5', '4', 'WEB Mail Doubt', '2008-03-18 10:29:52', '3', null, '2008-03-30 17:14:16', 'STAFF', '54229ABFCF'), ('92', '3', 'SOLVED', '1', '22', '2', 'WEB Site Doubt', '2008-03-18 11:47:43', '3', null, '2008-03-21 15:34:30', 'STAFF', '92CC227532'), ('93', '3', 'SOLVED', '1', '38', '2', 'WEB Site Issue', '2008-03-18 08:06:34', '2', null, '2008-03-26 15:07:53', 'STAFF', '98DCE83DA5'), ('94', '2', 'SOLVED', '8', '11', '2', 'WEB Site Issue', '2008-03-18 10:36:08', '4', null, '2008-03-31 13:41:46', 'STAFF', 'F4B9EC30AD'), ('95', '2', 'SOLVED', '6', '18', '6', 'Software Doubt', '2008-03-19 10:03:58', '4', null, '2008-03-27 18:23:27', 'STAFF', '812B4BA287'), ('96', '2', 'SOLVED', '9', '39', '5', 'Peripheral Issue', '2008-03-20 09:39:40', '2', null, '2008-03-28 13:01:29', 'STAFF', '26657D5FF9'), ('97', '2', 'SOLVED', '1', '22', '2', 'WEB Site Issue', '2008-03-20 07:01:05', '3', null, '2008-04-02 17:57:34', 'STAFF', 'E2EF524FBF'), ('98', '2', 'SOLVED', '9', '17', '4', 'WEB Mail Issue', '2008-03-21 08:15:42', '2', null, '2008-03-29 17:10:05', 'STAFF', 'ED3D2C2199'), ('99', '2', 'SOLVED', '5', '17', '3', 'Sales Issue', '2008-03-21 11:21:54', '2', null, '2008-04-03 14:35:33', 'STAFF', 'AC627AB1CC'), ('100', '2', 'SOLVED', '7', '37', '2', 'WEB Site Issue', '2008-03-21 12:43:17', '4', null, '2008-04-06 18:23:55', 'STAFF', 'F899139DF5'), ('101', '2', 'SOLVED', '3', '5', '5', 'Peripheral Doubt', '2008-03-21 07:29:31', '2', null, '2008-03-25 18:33:27', 'STAFF', '38B3EFF8BA'), ('102', '3', 'CLOSED', '7', '29', '5', 'Peripheral Issue', '2008-03-21 06:37:39', '2', null, '2008-04-02 17:58:14', 'STAFF', 'EC8956637A'), ('103', '3', 'SOLVED', '10', '37', '5', 'Peripheral Issue', '2008-03-21 08:45:42', '4', null, '2008-03-29 18:06:26', 'STAFF', '6974CE5AC6'), ('104', '2', 'SOLVED', '4', '1', '1', 'CRM Application Issue', '2008-03-21 07:19:50', '3', null, '2008-04-02 17:56:41', 'STAFF', 'C9E1074F5B'), ('105', '2', 'SOLVED', '1', '12', '2', 'WEB Site Issue', '2008-03-22 08:36:26', '3', null, '2008-04-06 18:20:23', 'STAFF', '65B9EEA6E1'), ('106', '3', 'CLOSED', '9', '19', '5', 'Peripheral Issue', '2008-03-22 07:48:27', '3', null, '2008-04-05 14:30:25', 'STAFF', 'F0935E4CD5'), ('107', '1', 'SOLVED', '2', '35', '6', 'Software Doubt', '2008-03-22 06:40:26', '2', null, '2008-04-10 14:36:17', 'STAFF', 'A97DA629B0'), ('108', '1', 'SOLVED', '9', '40', '5', 'Peripheral Doubt', '2008-03-22 06:44:00', '3', null, '2008-03-26 18:21:04', 'STAFF', 'A3C65C2974'), ('109', '1', 'SOLVED', '10', '35', '5', 'Peripheral Issue', '2008-03-22 07:19:09', '2', null, '2008-04-04 13:59:01', 'STAFF', '2723D092B6'), ('110', '2', 'SOLVED', '4', '38', '6', 'Sotfware Issue', '2008-03-23 10:10:08', '4', null, '2008-04-03 13:50:47', 'STAFF', '5F93F98352'), ('111', '2', 'SOLVED', '3', '20', '5', 'Peripheral Issue', '2008-03-23 12:26:29', '3', null, '2008-04-15 18:13:38', 'STAFF', '698D51A19D'), ('112', '3', 'SOLVED', '10', '38', '2', 'WEB Site Issue', '2008-03-23 12:12:38', '4', null, '2008-03-27 18:04:09', 'STAFF', '7F6FFAA6BB'), ('113', '1', 'SOLVED', '9', '3', '1', 'CRM Application Doubt', '2008-03-23 10:04:59', '2', null, '2008-03-26 15:17:13', 'STAFF', '73278A4A86'), ('114', '2', 'SOLVED', '10', '9', '5', 'Peripheral Issue', '2008-03-23 11:09:24', '4', null, '2008-04-02 13:46:50', 'STAFF', '5FD0B37CD7'), ('115', '2', 'SOLVED', '2', '10', '1', 'CRM Application Doubt', '2008-03-23 06:49:24', '4', null, '2008-04-06 15:56:13', 'STAFF', '2B44928AE1'), ('116', '1', 'SOLVED', '8', '5', '5', 'Peripheral Issue', '2008-03-23 12:58:33', '2', null, '2008-03-25 13:27:14', 'STAFF', 'C45147DEE7'), ('117', '2', 'SOLVED', '6', '17', '4', 'WEB Mail Doubt', '2008-03-24 06:14:08', '4', null, '2008-04-09 18:46:08', 'STAFF', 'EB160DE1DE'), ('118', '2', 'SOLVED', '1', '19', '2', 'WEB Site Issue', '2008-03-24 10:37:26', '4', null, '2008-03-29 14:56:36', 'STAFF', '5EF059938B'), ('119', '3', 'CLOSED', '7', '3', '4', 'WEB Mail Issue', '2008-03-24 10:08:17', '1', null, '2008-03-26 17:22:09', 'STAFF', '07E1CD7DCA'), ('120', '2', 'SOLVED', '6', '38', '3', 'Sales Doubt', '2008-03-24 11:58:52', '3', null, '2008-04-05 13:24:24', 'STAFF', 'DA4FB5C6E9'), ('121', '1', 'SOLVED', '8', '24', '2', 'WEB Site Issue', '2008-03-24 07:42:34', '2', null, '2008-04-06 18:25:12', 'STAFF', '4C56FF4CE4'), ('122', '2', 'SOLVED', '10', '23', '5', 'Peripheral Issue', '2008-03-25 09:32:23', '3', null, '2008-04-05 14:57:42', 'STAFF', 'A0A080F42E'), ('123', '2', 'SOLVED', '1', '25', '6', 'Software Issue', '2008-03-25 12:32:40', '2', null, '2008-04-05 13:44:42', 'STAFF', '202CB962AC'), ('124', '2', 'SOLVED', '9', '10', '4', 'WEB Mail Issue', '2008-03-25 09:34:58', '2', null, '2008-03-30 14:07:37', 'STAFF', 'C8FFE9A587'), ('125', '3', 'SOLVED', '9', '30', '5', 'Peripheral Issue', '2008-03-25 10:24:40', '3', null, '2008-03-26 13:15:25', 'STAFF', '3DEF184AD8'), ('126', '2', 'SOLVED', '2', '10', '6', 'Software Issue', '2008-03-26 12:30:16', '2', null, '2008-04-10 15:07:59', 'STAFF', '069059B7EF'), ('127', '2', 'SOLVED', '1', '14', '2', 'WEB Site Issue', '2008-03-26 10:24:23', '2', null, '2008-03-28 16:32:24', 'STAFF', 'EC5DECCA5E'), ('128', '3', 'SOLVED', '9', '22', '6', 'Sotfware Issue', '2008-03-26 08:55:48', '4', null, '2008-04-05 18:08:09', 'STAFF', '76DC611D6E'), ('129', '2', 'SOLVED', '10', '19', '5', 'Peripheral Doubt', '2008-03-26 11:13:41', '2', null, '2008-04-04 14:43:09', 'STAFF', 'D1F491A404'), ('130', '3', 'CLOSED', '2', '33', '6', 'Software Issue', '2008-03-26 08:17:14', '1', null, '2008-04-08 15:11:22', 'STAFF', '9B8619251A'), ('131', '3', 'SOLVED', '2', '4', '6', 'Software Issue', '2008-03-27 09:26:47', '4', null, '2008-04-11 18:57:40', 'STAFF', '1AFA34A7F9'), ('132', '2', 'SOLVED', '10', '22', '2', 'WEB Site Issue', '2008-03-28 10:40:00', '4', null, '2008-04-03 18:20:14', 'STAFF', '65DED5353C'), ('133', '2', 'SOLVED', '5', '1', '4', 'WEB Mail Doubt', '2008-03-28 06:13:08', '2', null, '2008-04-10 17:25:29', 'STAFF', '9FC3D7152B'), ('134', '2', 'SOLVED', '8', '33', '6', 'Sotfware Issue', '2008-03-28 07:14:28', '4', null, '2008-03-31 18:13:42', 'STAFF', '02522A2B27'), ('135', '1', 'SOLVED', '1', '23', '4', 'WEB Mail Doubt', '2008-03-28 10:01:52', '4', null, '2008-04-08 13:40:14', 'STAFF', '7F1DE29E6D'), ('136', '2', 'CLOSED', '9', '39', '5', 'Peripheral Issue', '2008-03-28 11:42:23', '1', null, '2008-04-05 15:20:29', 'STAFF', '42A0E188F5'), ('137', '2', 'SOLVED', '4', '35', '6', 'Software Doubt', '2008-03-28 11:34:03', '3', null, '2008-04-14 13:12:31', 'STAFF', '3988C7F88E'), ('138', '1', 'SOLVED', '10', '8', '5', 'Peripheral Doubt', '2008-03-28 10:37:52', '3', null, '2008-04-01 13:09:22', 'STAFF', '013D407166'), ('139', '1', 'SOLVED', '9', '9', '2', 'WEB Site Issue', '2008-03-29 08:11:19', '3', null, '2008-04-02 14:18:17', 'STAFF', 'E00DA03B68'), ('140', '2', 'CLOSED', '9', '29', '2', 'WEB Site Issue', '2008-03-29 10:01:15', '1', null, '2008-04-01 17:20:29', 'STAFF', '1385974ED5'), ('141', '3', 'SOLVED', '8', '30', '6', 'Sotfware Issue', '2008-03-29 12:49:51', '4', null, '2008-04-02 18:32:51', 'STAFF', '0F28B5D49B'), ('142', '1', 'SOLVED', '6', '27', '6', 'Sotfware Issue', '2008-03-29 06:57:04', '2', null, '2008-03-30 14:26:32', 'STAFF', 'A8BAA56554'), ('143', '1', 'SOLVED', '2', '36', '6', 'Software Issue', '2008-03-29 08:31:24', '2', null, '2008-04-15 15:26:50', 'STAFF', '903CE9225F'), ('144', '2', 'SOLVED', '2', '29', '2', 'WEB Site Issue', '2008-03-30 11:39:44', '3', null, '2008-04-16 18:26:01', 'STAFF', '0A09C8844B'), ('145', '1', 'SOLVED', '7', '10', '4', 'WEB Mail Doubt', '2008-03-30 06:39:06', '2', null, '2008-04-16 15:15:40', 'STAFF', '2B24D49505'), ('146', '2', 'CLOSED', '3', '32', '3', 'Sales Doubt', '2008-03-30 08:23:51', '2', null, '2008-04-04 14:54:40', 'STAFF', 'A5E0013237'), ('147', '1', 'CLOSED', '2', '23', '5', 'Peripheral Doubt', '2008-03-30 06:12:48', '2', null, '2008-04-16 16:03:04', 'STAFF', '8D5E957F29'), ('148', '2', 'SOLVED', '3', '37', '6', 'Software Issue', '2008-03-30 11:33:00', '4', null, '2008-04-10 17:17:20', 'STAFF', '47D1E99058'), ('149', '3', 'SOLVED', '5', '8', '6', 'Software Doubt', '2008-03-30 10:21:35', '4', null, '2008-04-01 17:09:21', 'STAFF', 'F2217062E9'), ('150', '1', 'SOLVED', '4', '28', '1', 'CRM Application Issue', '2008-03-30 10:16:47', '3', null, '2008-04-01 13:26:11', 'STAFF', '7EF605FC8D'), ('151', '2', 'SOLVED', '4', '31', '2', 'WEB Site Issue', '2008-03-31 11:59:58', '4', null, '2008-04-11 15:51:53', 'STAFF', 'A8F15EDA80'), ('152', '2', 'SOLVED', '7', '22', '2', 'WEB Site Doubt', '2008-03-31 10:04:44', '3', null, '2008-04-13 15:44:47', 'STAFF', '37A749D808'), ('153', '3', 'CLOSED', '3', '11', '5', 'Peripheral Doubt', '2008-03-31 11:53:01', '3', null, '2008-04-09 14:10:06', 'STAFF', 'B3E3E393C7'), ('154', '1', 'SOLVED', '8', '34', '4', 'WEB Mail Issue', '2008-03-31 11:22:22', '2', null, '2008-04-16 16:37:01', 'STAFF', '1D7F7ABC18'), ('155', '2', 'SOLVED', '4', '30', '5', 'Peripheral Doubt', '2008-03-31 12:32:04', '3', null, '2008-04-07 18:06:55', 'STAFF', '2A79EA27C2'), ('156', '3', 'SOLVED', '2', '25', '2', 'WEB Site Doubt', '2008-03-31 09:40:34', '3', null, '2008-04-05 16:53:15', 'STAFF', '1C9AC0159C'), ('157', '2', 'CLOSED', '4', '1', '6', 'Sotfware Issue', '2008-03-31 10:57:13', '2', null, '2008-04-02 13:38:50', 'STAFF', '6C4B761A28'), ('158', '3', 'SOLVED', '3', '31', '1', 'CRM Application Doubt', '2008-03-31 10:51:41', '4', null, '2008-04-11 13:02:31', 'STAFF', '0640966322'), ('159', '2', 'SOLVED', '9', '3', '2', 'WEB Site Issue', '2008-03-31 08:26:54', '3', null, '2008-04-07 17:32:24', 'STAFF', '140F6969D5'), ('160', '2', 'SOLVED', '6', '30', '3', 'Sales Doubt', '2008-04-01 07:42:02', '2', null, '2008-04-08 15:30:29', 'STAFF', 'B73CE398C3'), ('161', '3', 'SOLVED', '4', '21', '6', 'Software Doubt', '2008-04-01 12:00:45', '2', null, '2008-04-03 17:50:10', 'STAFF', 'BD4C9AB730'), ('162', '1', 'SOLVED', '2', '12', '6', 'Sotfware Issue', '2008-04-01 06:22:05', '2', null, '2008-04-11 18:29:45', 'STAFF', '82AA4B0AF3'), ('163', '3', 'SOLVED', '5', '2', '4', 'WEB Mail Doubt', '2008-04-01 06:22:11', '2', null, '2008-04-06 13:55:46', 'STAFF', '0777D5C17D'), ('164', '3', 'CLOSED', '10', '35', '2', 'WEB Site Issue', '2008-04-01 07:23:12', '3', null, '2008-04-12 16:01:48', 'STAFF', 'FA7CDFAD1A'), ('165', '3', 'CLOSED', '3', '25', '6', 'Software Issue', '2008-04-01 09:42:13', '2', null, '2008-04-04 13:53:37', 'STAFF', '9766527F2B'), ('166', '2', 'SOLVED', '8', '35', '1', 'CRM Application Issue', '2008-04-01 11:07:46', '3', null, '2008-04-05 14:01:41', 'STAFF', '7E7757B1E1'), ('167', '2', 'CLOSED', '4', '36', '1', 'CRM Application Issue', '2008-04-02 06:00:23', '1', null, '2008-04-06 14:40:36', 'STAFF', '5878A7AB84'), ('168', '1', 'SOLVED', '10', '6', '6', 'Software Issue', '2008-04-02 12:22:45', '2', null, '2008-04-06 13:30:44', 'STAFF', '006F52E910'), ('169', '1', 'SOLVED', '3', '27', '6', 'Software Doubt', '2008-04-03 12:30:59', '2', null, '2008-04-20 14:47:04', 'STAFF', '3636638817'), ('170', '1', 'SOLVED', '10', '22', '6', 'Software Doubt', '2008-04-03 06:28:08', '3', null, '2008-04-08 14:31:37', 'STAFF', '149E9677A5'), ('171', '1', 'SOLVED', '4', '32', '1', 'CRM Application Issue', '2008-04-04 07:59:05', '2', null, '2008-04-13 17:36:44', 'STAFF', 'A4A042CF4F'), ('172', '2', 'SOLVED', '10', '23', '5', 'Peripheral Issue', '2008-04-04 06:36:53', '2', null, '2008-04-12 13:30:25', 'STAFF', '1FF8A7B5DC'), ('173', '3', 'CLOSED', '1', '28', '2', 'WEB Site Issue', '2008-04-04 10:33:40', '1', null, '2008-04-13 16:14:42', 'STAFF', 'F7E6C85504'), ('174', '2', 'CLOSED', '4', '17', '5', 'Peripheral Doubt', '2008-04-04 09:53:46', '3', null, '2008-04-22 15:45:04', 'STAFF', 'BF8229696F'), ('175', '2', 'SOLVED', '8', '6', '1', 'CRM Application Doubt', '2008-04-04 08:03:23', '2', null, '2008-04-10 15:12:14', 'STAFF', '8216124282'), ('176', '1', 'SOLVED', '10', '10', '6', 'Sotfware Issue', '2008-04-04 09:43:10', '2', null, '2008-04-13 18:23:28', 'STAFF', '38AF86134B'), ('177', '2', 'SOLVED', '10', '11', '6', 'Software Doubt', '2008-04-05 07:20:53', '3', null, '2008-04-19 15:14:10', 'STAFF', '96DA2F590C'), ('178', '2', 'SOLVED', '5', '21', '1', 'CRM Application Doubt', '2008-04-05 08:04:41', '2', null, '2008-04-10 18:28:30', 'STAFF', '8F85517967'), ('179', '1', 'CLOSED', '5', '6', '6', 'Sotfware Issue', '2008-04-05 10:10:06', '2', null, '2008-04-22 14:55:30', 'STAFF', '8F53295A73'), ('180', '1', 'SOLVED', '10', '10', '2', 'WEB Site Issue', '2008-04-05 06:00:35', '4', null, '2008-04-09 18:27:37', 'STAFF', '045117B0E0'), ('181', '2', 'SOLVED', '9', '11', '6', 'Software Doubt', '2008-04-05 06:17:24', '2', null, '2008-04-09 14:46:34', 'STAFF', 'FC22130974'), ('182', '2', 'SOLVED', '9', '10', '5', 'Peripheral Doubt', '2008-04-05 08:01:45', '2', null, '2008-04-10 17:09:04', 'STAFF', '4C5BDE74A8'), ('183', '2', 'SOLVED', '4', '37', '1', 'CRM Application Doubt', '2008-04-05 07:40:55', '3', null, '2008-04-09 18:42:06', 'STAFF', 'CEDEBB6E87'), ('184', '2', 'SOLVED', '1', '26', '4', 'WEB Mail Issue', '2008-04-06 10:59:01', '4', null, '2008-04-25 15:37:25', 'STAFF', '6CDD60EA00'), ('185', '1', 'SOLVED', '9', '28', '5', 'Peripheral Doubt', '2008-04-06 09:43:59', '4', null, '2008-04-14 18:26:22', 'STAFF', 'EECCA5B636'), ('186', '2', 'CLOSED', '8', '21', '4', 'WEB Mail Issue', '2008-04-06 12:21:10', '2', null, '2008-04-15 16:37:15', 'STAFF', '9872ED9FC2'), ('187', '1', 'SOLVED', '3', '27', '6', 'Software Doubt', '2008-04-06 10:27:02', '4', null, '2008-04-08 13:37:00', 'STAFF', '31FEFC0E57'), ('188', '2', 'SOLVED', '10', '27', '4', 'WEB Mail Issue', '2008-04-06 09:17:58', '4', null, '2008-04-11 15:51:50', 'STAFF', '9DCB88E013'), ('189', '2', 'SOLVED', '9', '23', '5', 'Peripheral Doubt', '2008-04-06 10:58:53', '2', null, '2008-04-08 17:45:42', 'STAFF', 'A2557A7B2E'), ('190', '2', 'SOLVED', '4', '4', '4', 'WEB Mail Issue', '2008-04-06 09:33:40', '4', null, '2008-04-08 14:49:54', 'STAFF', 'CFECDB276F'), ('191', '3', 'SOLVED', '1', '35', '3', 'Sales Doubt', '2008-04-06 07:01:58', '2', null, '2008-04-20 14:31:21', 'STAFF', '0AA1883C64'), ('192', '2', 'CLOSED', '1', '10', '4', 'WEB Mail Issue', '2008-04-06 10:41:04', '3', null, '2008-04-24 15:10:40', 'STAFF', '58A2FC6ED3'), ('193', '1', 'SOLVED', '5', '38', '5', 'Peripheral Issue', '2008-04-06 12:25:17', '3', null, '2008-04-10 13:21:12', 'STAFF', 'BD686FD640'), ('194', '2', 'SOLVED', '8', '21', '4', 'WEB Mail Doubt', '2008-04-06 11:35:42', '3', null, '2008-04-12 14:59:20', 'STAFF', 'A597E50502'), ('195', '2', 'SOLVED', '5', '3', '5', 'Peripheral Issue', '2008-04-06 11:30:31', '2', null, '2008-04-09 14:57:30', 'STAFF', '0336DCBAB0'), ('196', '2', 'SOLVED', '4', '25', '3', 'Sales Issue', '2008-04-06 10:39:13', '3', null, '2008-04-12 16:16:24', 'STAFF', '084B6FBB10'), ('197', '2', 'SOLVED', '10', '26', '3', 'Sales Issue', '2008-04-07 10:13:26', '4', null, '2008-04-17 18:55:41', 'STAFF', '85D8CE590A'), ('198', '2', 'SOLVED', '6', '31', '4', 'WEB Mail Doubt', '2008-04-07 12:01:27', '2', null, '2008-04-23 17:04:47', 'STAFF', '0E65972DCE'), ('199', '1', 'SOLVED', '2', '13', '1', 'CRM Application Doubt', '2008-04-07 09:47:28', '2', null, '2008-04-19 15:55:16', 'STAFF', '84D9EE44E4'), ('200', '3', 'SOLVED', '2', '26', '3', 'Sales Doubt', '2008-04-07 10:21:09', '2', null, '2008-04-23 17:05:51', 'STAFF', '3644A684F9'), ('201', '3', 'CLOSED', '10', '32', '3', 'Sales Doubt', '2008-04-07 09:32:08', '2', null, '2008-04-15 14:21:18', 'STAFF', '757B505CFD'), ('202', '1', 'SOLVED', '10', '3', '4', 'WEB Mail Doubt', '2008-04-07 06:07:11', '4', null, '2008-04-11 15:33:49', 'STAFF', '854D6FAE5E'), ('203', '2', 'SOLVED', '2', '39', '1', 'CRM Application Issue', '2008-04-07 09:33:06', '2', null, '2008-04-09 18:49:48', 'STAFF', 'E2C0BE2456'), ('204', '1', 'CLOSED', '2', '18', '6', 'Software Issue', '2008-04-07 08:53:15', '3', null, '2008-04-07 15:40:26', 'STAFF', '274AD4786C'), ('205', '1', 'SOLVED', '9', '31', '5', 'Peripheral Issue', '2008-04-07 12:46:55', '4', null, '2008-04-23 18:41:42', 'STAFF', 'EAE27D77CA'), ('206', '3', 'SOLVED', '9', '26', '5', 'Peripheral Issue', '2008-04-08 11:04:30', '2', null, '2008-04-21 18:57:00', 'STAFF', '7EABE3A164'), ('207', '2', 'SOLVED', '8', '10', '4', 'WEB Mail Doubt', '2008-04-08 06:10:15', '3', null, '2008-04-23 15:12:06', 'STAFF', '69ADC1E107'), ('208', '2', 'SOLVED', '8', '38', '6', 'Software Issue', '2008-04-08 11:59:05', '2', null, '2008-04-15 18:01:42', 'STAFF', '091D584FCE'), ('209', '2', 'SOLVED', '6', '10', '6', 'Sotfware Issue', '2008-04-08 07:57:00', '4', null, '2008-04-12 14:05:25', 'STAFF', 'B1D10E7BAF'), ('210', '2', 'CLOSED', '10', '21', '2', 'WEB Site Issue', '2008-04-08 07:01:04', '1', null, '2008-04-17 15:53:22', 'STAFF', '6F3EF77AC0'), ('211', '3', 'SOLVED', '10', '28', '3', 'Sales Doubt', '2008-04-08 08:47:04', '2', null, '2008-04-12 17:11:58', 'STAFF', 'EB16372791'), ('212', '2', 'SOLVED', '1', '12', '6', 'Software Issue', '2008-04-08 07:36:49', '3', null, '2008-04-19 14:02:29', 'STAFF', '1534B76D32'), ('213', '3', 'SOLVED', '3', '21', '6', 'Software Doubt', '2008-04-08 06:57:11', '3', null, '2008-04-13 17:30:02', 'STAFF', '979D472A84'), ('214', '2', 'SOLVED', '10', '19', '6', 'Sotfware Issue', '2008-04-09 10:49:04', '3', null, '2008-04-23 16:02:23', 'STAFF', 'CA46C1B951'), ('215', '1', 'CLOSED', '3', '40', '6', 'Software Doubt', '2008-04-11 12:03:57', '1', null, '2008-04-13 14:16:42', 'STAFF', '3B8A614226'), ('216', '2', 'SOLVED', '9', '8', '6', 'Sotfware Issue', '2008-04-11 06:40:25', '2', null, '2008-04-28 14:49:17', 'STAFF', '45FBC6D3E0'), ('217', '1', 'SOLVED', '10', '30', '2', 'WEB Site Doubt', '2008-04-11 06:16:02', '2', null, '2008-04-24 13:19:00', 'STAFF', '63DC7ED101'), ('218', '2', 'SOLVED', '9', '33', '4', 'WEB Mail Doubt', '2008-04-11 09:38:29', '3', null, '2008-04-11 14:08:53', 'STAFF', 'E96ED478DA'), ('219', '2', 'CLOSED', '5', '37', '4', 'WEB Mail Doubt', '2008-04-11 10:51:02', '1', null, '2008-04-26 14:41:40', 'STAFF', 'C0E190D826'), ('220', '2', 'SOLVED', '6', '6', '6', 'Software Issue', '2008-04-11 08:56:35', '2', null, '2008-04-23 14:54:19', 'STAFF', 'EC8CE6ABB3'), ('221', '2', 'SOLVED', '9', '23', '5', 'Peripheral Issue', '2008-04-11 08:09:41', '2', null, '2008-04-22 17:17:58', 'STAFF', '060AD92489'), ('222', '2', 'SOLVED', '4', '31', '4', 'WEB Mail Doubt', '2008-04-11 06:01:47', '3', null, '2008-04-22 14:58:02', 'STAFF', 'BCBE3365E6'), ('223', '1', 'SOLVED', '5', '19', '4', 'WEB Mail Issue', '2008-04-12 12:24:44', '3', null, '2008-04-19 18:36:42', 'STAFF', '115F895031'), ('224', '2', 'SOLVED', '6', '11', '3', 'Sales Doubt', '2008-04-12 11:22:21', '3', null, '2008-04-15 17:10:03', 'STAFF', '13FE9D8431'), ('225', '2', 'CLOSED', '10', '15', '6', 'Sotfware Issue', '2008-04-12 11:10:40', '2', null, '2008-04-14 14:00:22', 'STAFF', 'D1C38A09AC'), ('226', '2', 'CLOSED', '6', '20', '3', 'Sales Issue', '2008-04-12 06:31:13', '3', null, '2008-04-22 16:00:42', 'STAFF', '9CFDF10E8F'), ('227', '2', 'SOLVED', '7', '38', '4', 'WEB Mail Issue', '2008-04-12 09:40:53', '2', null, '2008-04-19 13:41:29', 'STAFF', '705F217283'), ('228', '1', 'SOLVED', '1', '31', '2', 'WEB Site Issue', '2008-04-12 08:13:51', '2', null, '2008-04-15 14:30:22', 'STAFF', '74DB120F0A'), ('229', '2', 'CLOSED', '1', '33', '5', 'Peripheral Issue', '2008-04-12 12:29:46', '2', null, '2008-04-15 14:14:14', 'STAFF', '57AEEE35C9'), ('230', '1', 'SOLVED', '1', '17', '3', 'Sales Issue', '2008-04-12 07:27:23', '2', null, '2008-04-20 17:35:12', 'STAFF', '6DA9003B74'), ('231', '1', 'CLOSED', '1', '6', '1', 'CRM Application Doubt', '2008-04-12 09:17:23', '2', null, '2008-04-12 13:42:58', 'STAFF', '9B04D15284'), ('232', '2', 'SOLVED', '10', '32', '1', 'CRM Application Issue', '2008-04-12 12:42:20', '2', null, '2008-04-16 14:14:38', 'STAFF', 'BE83AB3ECD'), ('233', '2', 'CLOSED', '6', '32', '2', 'WEB Site Issue', '2008-04-13 11:14:17', '2', null, '2008-04-14 15:56:40', 'STAFF', 'E165421110'), ('234', '2', 'SOLVED', '6', '22', '5', 'Peripheral Doubt', '2008-04-13 07:31:01', '2', null, '2008-04-18 17:00:25', 'STAFF', '289DFF0766'), ('235', '3', 'SOLVED', '5', '15', '5', 'Peripheral Issue', '2008-04-13 12:15:27', '3', null, '2008-04-27 15:11:10', 'STAFF', '577EF1154F'), ('236', '3', 'SOLVED', '10', '27', '3', 'Sales Doubt', '2008-04-13 07:43:43', '3', null, '2008-04-13 16:24:51', 'STAFF', '01161AAA0B'), ('237', '1', 'SOLVED', '5', '38', '6', 'Software Issue', '2008-04-13 06:42:21', '2', null, '2008-04-18 13:02:47', 'STAFF', '539FD53B59'), ('238', '2', 'CLOSED', '10', '7', '5', 'Peripheral Issue', '2008-04-13 06:55:22', '1', null, '2008-04-22 16:18:55', 'STAFF', 'AC1DD209CB'), ('239', '2', 'SOLVED', '5', '31', '4', 'WEB Mail Issue', '2008-04-13 09:07:58', '2', null, '2008-04-15 14:02:15', 'STAFF', '555D6702C9'), ('240', '1', 'SOLVED', '1', '30', '4', 'WEB Mail Issue', '2008-04-13 12:39:09', '3', null, '2008-04-26 17:42:20', 'STAFF', '335F535208'), ('241', '3', 'SOLVED', '8', '5', '6', 'Software Doubt', '2008-04-13 09:55:39', '4', null, '2008-04-24 17:32:14', 'STAFF', 'F340F1B1F6'), ('242', '1', 'SOLVED', '10', '21', '2', 'WEB Site Issue', '2008-04-13 11:16:43', '3', null, '2008-04-25 15:10:03', 'STAFF', 'E4A6222CDB'), ('243', '1', 'SOLVED', '2', '36', '1', 'CRM Application Issue', '2008-04-13 12:17:45', '3', null, '2008-04-16 14:11:15', 'STAFF', 'CB70AB3756'), ('244', '2', 'SOLVED', '1', '37', '6', 'Software Doubt', '2008-04-13 07:32:57', '4', null, '2008-04-17 18:09:15', 'STAFF', '9188905E74'), ('245', '2', 'CLOSED', '5', '31', '4', 'WEB Mail Doubt', '2008-04-13 08:39:57', '2', null, '2008-04-19 16:11:17', 'STAFF', '0266E33D3F'), ('246', '1', 'SOLVED', '4', '28', '1', 'CRM Application Issue', '2008-04-13 09:32:03', '2', null, '2008-04-26 17:44:52', 'STAFF', '38DB3AED92'), ('247', '2', 'CLOSED', '9', '23', '6', 'Software Issue', '2008-04-13 12:03:28', '1', null, '2008-04-17 16:36:21', 'STAFF', '3CEC07E9BA'), ('248', '1', 'SOLVED', '2', '24', '6', 'Software Issue', '2008-04-14 12:30:11', '4', null, '2008-04-14 18:32:37', 'STAFF', '621BF66DDB'), ('249', '2', 'CLOSED', '6', '32', '2', 'WEB Site Issue', '2008-04-14 08:32:27', '1', null, '2008-04-16 17:20:21', 'STAFF', '077E29B11B'), ('250', '2', 'SOLVED', '7', '39', '1', 'CRM Application Doubt', '2008-04-14 11:14:54', '4', null, '2008-04-19 15:57:56', 'STAFF', '6C9882BBAC'), ('251', '2', 'SOLVED', '2', '40', '4', 'WEB Mail Issue', '2008-04-14 11:58:41', '3', null, '2008-04-19 14:14:45', 'STAFF', '19F3CD308F'), ('252', '3', 'SOLVED', '2', '11', '6', 'Software Issue', '2008-04-14 11:40:10', '4', null, '2008-04-14 17:45:29', 'STAFF', '03C6B06952'), ('253', '3', 'SOLVED', '10', '38', '5', 'Peripheral Doubt', '2008-04-14 12:02:56', '4', null, '2008-04-25 17:28:27', 'STAFF', 'C24CD76E1C'), ('254', '3', 'SOLVED', '3', '12', '2', 'WEB Site Issue', '2008-04-14 10:25:30', '4', null, '2008-04-23 13:01:07', 'STAFF', 'C52F1BD66C'), ('255', '2', 'CLOSED', '8', '37', '4', 'WEB Mail Issue', '2008-04-15 12:48:22', '3', null, '2008-04-25 15:13:51', 'STAFF', 'FE131D7F5A'), ('256', '3', 'CLOSED', '10', '5', '4', 'WEB Mail Doubt', '2008-04-15 09:32:56', '1', null, '2008-04-23 15:08:55', 'STAFF', 'F718499C1C'), ('257', '1', 'SOLVED', '7', '19', '1', 'CRM Application Doubt', '2008-04-15 08:09:34', '2', null, '2008-04-15 15:42:58', 'STAFF', 'D96409BF89'), ('258', '2', 'SOLVED', '2', '11', '5', 'Peripheral Issue', '2008-04-15 12:36:03', '4', null, '2008-04-23 13:45:17', 'STAFF', '502E4A1693'), ('259', '1', 'SOLVED', '10', '7', '1', 'CRM Application Issue', '2008-04-15 09:45:02', '2', null, '2008-04-20 13:08:50', 'STAFF', 'CFA0860E83'), ('260', '3', 'SOLVED', '9', '24', '6', 'Software Issue', '2008-04-15 09:04:37', '3', null, '2008-04-16 18:29:10', 'STAFF', 'A4F23670E1'), ('261', '1', 'SOLVED', '9', '11', '2', 'WEB Site Issue', '2008-04-15 08:24:38', '2', null, '2008-04-24 14:10:59', 'STAFF', 'B1A59B315F'), ('262', '1', 'SOLVED', '5', '23', '1', 'CRM Application Doubt', '2008-04-15 07:21:35', '4', null, '2008-04-22 16:46:09', 'STAFF', '36660E5985'), ('263', '1', 'SOLVED', '9', '39', '4', 'WEB Mail Doubt', '2008-04-16 11:28:49', '3', null, '2008-04-23 18:41:07', 'STAFF', '8C19F571E2'), ('264', '3', 'SOLVED', '1', '12', '4', 'WEB Mail Issue', '2008-04-16 10:02:39', '4', null, '2008-04-27 17:56:39', 'STAFF', 'D6BAF65E0B'), ('265', '2', 'SOLVED', '7', '21', '1', 'CRM Application Issue', '2008-04-16 09:44:25', '2', null, '2008-05-01 15:59:33', 'STAFF', 'E56954B4F6'), ('266', '3', 'SOLVED', '2', '38', '5', 'Peripheral Doubt', '2008-04-16 08:48:23', '2', null, '2008-04-18 17:28:12', 'STAFF', 'F7664060CC'), ('267', '1', 'SOLVED', '5', '25', '5', 'Peripheral Doubt', '2008-04-17 08:14:41', '2', null, '2008-04-25 14:07:42', 'STAFF', 'EDA80A3D5B'), ('268', '2', 'SOLVED', '5', '30', '5', 'Peripheral Issue', '2008-04-18 11:54:45', '3', null, '2008-04-24 14:07:28', 'STAFF', '8F121CE07D'), ('269', '2', 'SOLVED', '10', '37', '6', 'Software Issue', '2008-04-18 10:16:48', '2', null, '2008-04-19 13:42:51', 'STAFF', '06138BC5AF'), ('270', '3', 'SOLVED', '7', '31', '6', 'Software Issue', '2008-04-18 12:13:31', '2', null, '2008-05-04 17:13:37', 'STAFF', '39059724F7'), ('271', '2', 'CLOSED', '8', '11', '4', 'WEB Mail Issue', '2008-04-18 06:47:38', '3', null, '2008-04-23 16:12:51', 'STAFF', '7F100B7B36'), ('272', '2', 'SOLVED', '8', '10', '2', 'WEB Site Issue', '2008-04-18 10:56:55', '3', null, '2008-04-26 14:04:37', 'STAFF', '7A614FD06C'), ('273', '1', 'SOLVED', '6', '31', '4', 'WEB Mail Doubt', '2008-04-18 06:23:44', '2', null, '2008-04-19 17:01:25', 'STAFF', '4734BA6F3D'), ('274', '1', 'SOLVED', '6', '32', '1', 'CRM Application Doubt', '2008-04-18 08:02:53', '3', null, '2008-04-27 15:50:22', 'STAFF', 'D947BF06A8'), ('275', '2', 'SOLVED', '1', '27', '5', 'Peripheral Issue', '2008-04-19 06:10:52', '2', null, '2008-05-01 18:54:27', 'STAFF', '63923F49E5'), ('276', '1', 'CLOSED', '6', '37', '5', 'Peripheral Issue', '2008-04-19 06:32:43', '1', null, '2008-04-27 14:12:02', 'STAFF', 'DB8E1AF0CB'), ('277', '2', 'SOLVED', '2', '19', '5', 'Peripheral Doubt', '2008-04-19 10:17:09', '4', null, '2008-04-25 15:08:03', 'STAFF', '20F07591C6'), ('278', '3', 'SOLVED', '5', '15', '6', 'Software Issue', '2008-04-19 12:43:40', '2', null, '2008-05-02 13:16:43', 'STAFF', '07CDFD2337'), ('279', '3', 'SOLVED', '4', '7', '5', 'Peripheral Issue', '2008-04-19 10:18:34', '3', null, '2008-04-24 13:23:44', 'STAFF', 'D395771085'), ('280', '1', 'CLOSED', '10', '6', '3', 'Sales Doubt', '2008-04-19 08:13:03', '1', null, '2008-05-01 17:55:20', 'STAFF', '92C8C96E4C'), ('281', '2', 'CLOSED', '1', '8', '5', 'Peripheral Doubt', '2008-04-19 09:01:45', '3', null, '2008-04-21 18:29:39', 'STAFF', 'E3796AE838'), ('282', '2', 'SOLVED', '10', '9', '6', 'Sotfware Issue', '2008-04-19 07:26:25', '4', null, '2008-04-21 13:11:42', 'STAFF', '6A9AEDDFC6'), ('283', '2', 'SOLVED', '1', '38', '6', 'Software Doubt', '2008-04-20 09:17:57', '2', null, '2008-04-21 13:39:17', 'STAFF', '0F49C89D1E'), ('284', '2', 'SOLVED', '7', '26', '6', 'Software Issue', '2008-04-20 10:23:46', '4', null, '2008-04-20 16:19:38', 'STAFF', '46BA9F2A69'), ('285', '2', 'SOLVED', '8', '4', '2', 'WEB Site Issue', '2008-04-20 11:23:30', '3', null, '2008-04-28 17:59:57', 'STAFF', '0E01938FC4'), ('286', '2', 'SOLVED', '2', '27', '4', 'WEB Mail Doubt', '2008-04-20 11:41:57', '3', null, '2008-04-26 13:08:51', 'STAFF', '16A5CDAE36'), ('287', '3', 'SOLVED', '8', '11', '6', 'Software Doubt', '2008-04-20 07:34:01', '4', null, '2008-04-25 14:02:01', 'STAFF', '918317B579'), ('288', '2', 'CLOSED', '9', '11', '1', 'CRM Application Issue', '2008-04-20 09:09:26', '3', null, '2008-05-01 17:02:21', 'STAFF', '48AEDB8880'), ('289', '2', 'SOLVED', '9', '23', '4', 'WEB Mail Issue', '2008-04-20 11:25:13', '4', null, '2008-04-27 15:16:46', 'STAFF', '839AB46820'), ('290', '2', 'SOLVED', '1', '5', '5', 'Peripheral Doubt', '2008-04-20 10:57:38', '2', null, '2008-05-01 18:52:00', 'STAFF', 'F90F2ACA5C'), ('291', '3', 'SOLVED', '9', '6', '5', 'Peripheral Doubt', '2008-04-20 08:14:51', '2', null, '2008-04-23 15:04:09', 'STAFF', '9C838D2E45'), ('292', '2', 'CLOSED', '9', '21', '3', 'Sales Doubt', '2008-04-21 09:41:15', '2', null, '2008-04-26 14:54:26', 'STAFF', '1700002963'), ('293', '3', 'CLOSED', '10', '6', '5', 'Peripheral Issue', '2008-04-21 06:55:35', '2', null, '2008-04-22 13:24:32', 'STAFF', '53C3BCE66E'), ('294', '1', 'SOLVED', '8', '19', '6', 'Software Issue', '2008-04-21 11:33:47', '4', null, '2008-04-23 14:41:15', 'STAFF', '6883966FD8'), ('295', '2', 'CLOSED', '6', '36', '6', 'Software Doubt', '2008-04-21 11:11:38', '1', null, '2008-04-23 17:13:27', 'STAFF', '49182F81E6'), ('296', '1', 'SOLVED', '5', '23', '1', 'CRM Application Doubt', '2008-04-21 07:26:51', '4', null, '2008-05-01 14:42:29', 'STAFF', 'D296C101DA'), ('297', '2', 'SOLVED', '9', '38', '4', 'WEB Mail Doubt', '2008-04-21 07:05:51', '4', null, '2008-05-01 13:11:27', 'STAFF', '9FD81843AD'), ('298', '2', 'SOLVED', '7', '13', '2', 'WEB Site Issue', '2008-04-21 10:30:35', '3', null, '2008-04-23 15:17:39', 'STAFF', '26E359E838'), ('299', '3', 'SOLVED', '10', '22', '6', 'Software Issue', '2008-04-21 10:03:00', '2', null, '2008-04-23 16:06:59', 'STAFF', 'EF0D3930A7'), ('300', '2', 'SOLVED', '10', '32', '1', 'CRM Application Doubt', '2008-04-21 07:38:05', '4', null, '2008-05-04 13:44:20', 'STAFF', '94F6D7E04A'), ('301', '2', 'SOLVED', '5', '19', '5', 'Peripheral Issue', '2008-04-21 08:09:26', '2', null, '2008-05-06 13:41:39', 'STAFF', '34ED066DF3'), ('302', '2', 'SOLVED', '10', '16', '2', 'WEB Site Issue', '2008-04-22 12:58:46', '3', null, '2008-05-05 15:02:28', 'STAFF', '577BCC914F'), ('303', '3', 'SOLVED', '1', '36', '5', 'Peripheral Issue', '2008-04-22 07:47:00', '2', null, '2008-05-04 18:08:16', 'STAFF', '11B9842E0A'), ('304', '2', 'SOLVED', '10', '40', '5', 'Peripheral Issue', '2008-04-22 08:31:01', '3', null, '2008-05-06 17:05:47', 'STAFF', '37BC2F75BF'), ('305', '2', 'SOLVED', '6', '30', '5', 'Peripheral Issue', '2008-04-22 11:18:10', '4', null, '2008-05-05 18:23:31', 'STAFF', '496E05E1AE'), ('306', '2', 'SOLVED', '9', '36', '6', 'Software Issue', '2008-04-22 06:01:38', '2', null, '2008-05-04 16:40:03', 'STAFF', 'B2EB734903'), ('307', '2', 'CLOSED', '1', '30', '6', 'Software Doubt', '2008-04-22 06:12:57', '2', null, '2008-04-26 18:13:16', 'STAFF', '8E98D81F82'), ('308', '2', 'SOLVED', '7', '17', '6', 'Sotfware Issue', '2008-04-22 12:52:57', '4', null, '2008-05-02 13:38:08', 'STAFF', 'A8C88A0055'), ('309', '1', 'SOLVED', '6', '38', '4', 'WEB Mail Doubt', '2008-04-22 09:12:19', '3', null, '2008-04-27 18:12:52', 'STAFF', 'EDDEA82AD2'), ('310', '2', 'CLOSED', '5', '19', '6', 'Sotfware Issue', '2008-04-23 11:40:32', '2', null, '2008-05-05 14:08:06', 'STAFF', '06EB61B839'), ('311', '2', 'CLOSED', '2', '31', '5', 'Peripheral Issue', '2008-04-23 11:41:10', '1', null, '2008-04-25 13:15:24', 'STAFF', '9DFCD5E558'), ('312', '2', 'SOLVED', '9', '21', '6', 'Sotfware Issue', '2008-04-23 10:04:06', '4', null, '2008-05-01 18:42:40', 'STAFF', '950A4152C2'), ('313', '2', 'SOLVED', '9', '23', '1', 'CRM Application Issue', '2008-04-23 11:32:43', '2', null, '2008-04-27 18:58:53', 'STAFF', '158F3069A4'), ('314', '1', 'CLOSED', '9', '5', '6', 'Software Issue', '2008-04-24 09:59:42', '2', null, '2008-04-28 13:24:49', 'STAFF', '758874998F'), ('315', '2', 'SOLVED', '5', '28', '5', 'Peripheral Doubt', '2008-04-25 12:06:54', '4', null, '2008-04-25 14:26:58', 'STAFF', 'AD13A2A07C'), ('316', '2', 'SOLVED', '1', '27', '4', 'WEB Mail Doubt', '2008-04-25 09:09:46', '3', null, '2008-05-04 14:36:08', 'STAFF', '3FE94A0023'), ('317', '2', 'SOLVED', '10', '38', '6', 'Sotfware Issue', '2008-04-25 10:20:56', '2', null, '2008-05-06 18:59:49', 'STAFF', '5B8ADD2A5D'), ('318', '2', 'CLOSED', '1', '39', '4', 'WEB Mail Issue', '2008-04-25 06:42:46', '2', null, '2008-05-07 16:46:58', 'STAFF', '432ACA3A1E'), ('319', '2', 'SOLVED', '5', '23', '6', 'Software Doubt', '2008-04-25 08:01:57', '2', null, '2008-05-11 14:38:50', 'STAFF', '8D3BBA7425'), ('320', '2', 'SOLVED', '6', '32', '1', 'CRM Application Doubt', '2008-04-25 06:28:05', '2', null, '2008-05-06 15:38:06', 'STAFF', '320722549D'), ('321', '2', 'SOLVED', '1', '3', '4', 'WEB Mail Doubt', '2008-04-26 09:29:29', '3', null, '2008-05-15 17:53:14', 'STAFF', 'CAF1A3DFB5'), ('322', '2', 'CLOSED', '5', '38', '6', 'Software Issue', '2008-04-26 10:32:03', '3', null, '2008-04-27 17:24:32', 'STAFF', '5737C6EC2E'), ('323', '1', 'SOLVED', '1', '7', '2', 'WEB Site Doubt', '2008-04-26 12:34:36', '2', null, '2008-05-06 16:45:14', 'STAFF', 'BC6DC48B74'), ('324', '2', 'SOLVED', '9', '32', '4', 'WEB Mail Doubt', '2008-04-26 12:03:28', '4', null, '2008-05-08 18:50:44', 'STAFF', 'F2FC990265'), ('325', '2', 'SOLVED', '5', '33', '4', 'WEB Mail Doubt', '2008-04-26 09:33:55', '3', null, '2008-04-28 14:12:47', 'STAFF', '89F0FD5C92'), ('326', '2', 'SOLVED', '10', '28', '1', 'CRM Application Issue', '2008-04-27 12:46:22', '3', null, '2008-05-09 17:50:09', 'STAFF', 'A666587AFD'), ('327', '2', 'SOLVED', '1', '9', '5', 'Peripheral Issue', '2008-04-27 06:15:50', '3', null, '2008-05-01 16:48:04', 'STAFF', 'B83AAC23B9'), ('328', '2', 'SOLVED', '6', '31', '5', 'Peripheral Issue', '2008-04-27 09:35:36', '3', null, '2008-05-15 17:30:31', 'STAFF', 'CD00692C3B'), ('329', '3', 'SOLVED', '1', '19', '2', 'WEB Site Doubt', '2008-04-27 08:41:00', '3', null, '2008-05-08 18:41:39', 'STAFF', '6FAA8040DA'), ('330', '2', 'SOLVED', '9', '23', '4', 'WEB Mail Issue', '2008-04-27 07:53:49', '4', null, '2008-05-03 15:39:57', 'STAFF', 'FE73F687E5'), ('331', '1', 'SOLVED', '9', '33', '4', 'WEB Mail Issue', '2008-04-27 11:08:24', '2', null, '2008-05-04 15:08:26', 'STAFF', '6DA37DD313'), ('332', '2', 'SOLVED', '2', '3', '4', 'WEB Mail Issue', '2008-04-27 07:41:10', '4', null, '2008-05-02 17:12:53', 'STAFF', 'C042F4DB68'), ('333', '3', 'SOLVED', '8', '1', '6', 'Sotfware Issue', '2008-04-27 09:50:11', '2', null, '2008-04-27 18:28:17', 'STAFF', '310DCBBF4C'), ('334', '1', 'CLOSED', '10', '24', '6', 'Software Issue', '2008-04-27 11:54:53', '1', null, '2008-05-08 15:56:54', 'STAFF', '2F2B265625'), ('335', '2', 'SOLVED', '1', '2', '6', 'Software Issue', '2008-04-27 07:56:47', '2', null, '2008-05-02 16:59:17', 'STAFF', 'F9B902FC32'), ('336', '3', 'SOLVED', '5', '31', '5', 'Peripheral Doubt', '2008-04-27 10:47:52', '3', null, '2008-05-08 15:49:05', 'STAFF', '6855456E2F'), ('337', '2', 'SOLVED', '6', '19', '6', 'Software Doubt', '2008-04-27 07:49:29', '3', null, '2008-05-01 14:51:43', 'STAFF', '357A6FDF76'), ('338', '2', 'SOLVED', '10', '37', '5', 'Peripheral Doubt', '2008-04-28 06:40:09', '4', null, '2008-04-28 14:21:36', 'STAFF', '819F46E52C'), ('339', '2', 'SOLVED', '9', '37', '5', 'Peripheral Doubt', '2008-04-28 12:18:20', '2', null, '2008-05-01 17:32:48', 'STAFF', '04025959B1'), ('340', '2', 'SOLVED', '9', '1', '3', 'Sales Doubt', '2008-04-28 08:49:37', '3', null, '2008-05-14 13:10:59', 'STAFF', '40008B9A53'), ('341', '3', 'SOLVED', '10', '17', '6', 'Software Doubt', '2008-04-28 07:18:11', '4', null, '2008-05-01 18:20:00', 'STAFF', '3DD48AB31D'), ('342', '2', 'SOLVED', '5', '37', '3', 'Sales Doubt', '2008-04-28 06:41:16', '2', null, '2008-05-06 17:38:00', 'STAFF', '58238E9AE2'), ('343', '2', 'SOLVED', '10', '35', '4', 'WEB Mail Doubt', '2008-04-28 06:03:57', '4', null, '2008-05-10 15:38:00', 'STAFF', '3AD7C2EBB9'), ('344', '1', 'SOLVED', '5', '22', '2', 'WEB Site Issue', '2008-04-28 07:17:34', '4', null, '2008-05-02 17:09:54', 'STAFF', 'B3967A0E93'), ('345', '2', 'SOLVED', '6', '1', '4', 'WEB Mail Doubt', '2008-04-28 07:11:32', '2', null, '2008-05-06 17:46:36', 'STAFF', 'D81F9C1BE2'), ('346', '2', 'SOLVED', '2', '22', '4', 'WEB Mail Doubt', '2008-05-01 12:57:34', '4', null, '2008-05-01 13:19:58', 'STAFF', '13F9896DF6'), ('347', '2', 'SOLVED', '8', '38', '4', 'WEB Mail Doubt', '2008-05-01 12:18:37', '3', null, '2008-05-07 17:52:45', 'STAFF', 'C5FF2543B5'), ('348', '2', 'SOLVED', '3', '1', '6', 'Software Doubt', '2008-05-01 09:45:02', '2', null, '2008-05-01 14:46:08', 'STAFF', '01386BD6D8'), ('349', '2', 'SOLVED', '10', '1', '5', 'Peripheral Issue', '2008-05-01 10:17:32', '4', null, '2008-05-11 13:24:14', 'STAFF', '0BB4AEC171'), ('350', '2', 'SOLVED', '6', '2', '5', 'Peripheral Doubt', '2008-05-01 11:19:20', '2', null, '2008-05-04 16:08:09', 'STAFF', '9DE6D14FFF'), ('351', '2', 'SOLVED', '10', '37', '6', 'Software Doubt', '2008-05-01 07:04:52', '4', null, '2008-05-09 13:16:56', 'STAFF', 'EFE937780E'), ('352', '2', 'SOLVED', '2', '35', '6', 'Software Doubt', '2008-05-02 10:07:52', '2', null, '2008-05-07 16:15:30', 'STAFF', '371BCE7DC8'), ('353', '3', 'SOLVED', '2', '10', '3', 'Sales Doubt', '2008-05-03 10:32:41', '4', null, '2008-05-13 14:13:32', 'STAFF', '138BB06965'), ('354', '2', 'SOLVED', '5', '29', '6', 'Software Doubt', '2008-05-03 10:16:16', '3', null, '2008-05-17 13:16:05', 'STAFF', '8DD48D6A2E'), ('355', '1', 'CLOSED', '5', '1', '1', 'CRM Application Doubt', '2008-05-03 10:31:43', '3', null, '2008-05-09 17:59:27', 'STAFF', '82CEC96096'), ('356', '2', 'SOLVED', '6', '34', '5', 'Peripheral Issue', '2008-05-03 10:08:29', '2', null, '2008-05-05 16:02:53', 'STAFF', '6C524F9D5D'), ('357', '1', 'SOLVED', '9', '35', '2', 'WEB Site Issue', '2008-05-03 11:40:32', '2', null, '2008-05-14 13:15:24', 'STAFF', 'FB7B9FFA54'), ('358', '2', 'SOLVED', '10', '32', '6', 'Software Issue', '2008-05-03 07:56:30', '4', null, '2008-05-05 13:39:56', 'STAFF', 'AA942AB2BF'), ('359', '1', 'SOLVED', '7', '32', '2', 'WEB Site Doubt', '2008-05-03 07:02:37', '4', null, '2008-05-10 17:01:12', 'STAFF', 'C058F544C7'), ('360', '3', 'SOLVED', '1', '1', '1', 'CRM Application Issue', '2008-05-03 11:36:38', '3', null, '2008-05-13 14:06:28', 'STAFF', 'E7B24B112A'), ('361', '1', 'SOLVED', '2', '27', '3', 'Sales Doubt', '2008-05-03 06:44:49', '4', null, '2008-05-23 15:45:54', 'STAFF', '52720E0035'), ('362', '3', 'SOLVED', '10', '7', '6', 'Software Doubt', '2008-05-04 10:04:24', '3', null, '2008-05-17 14:25:58', 'STAFF', 'C3E878E27F'), ('363', '2', 'SOLVED', '10', '32', '3', 'Sales Doubt', '2008-05-04 08:58:40', '3', null, '2008-05-09 17:38:10', 'STAFF', '00411460F7'), ('364', '1', 'SOLVED', '2', '33', '2', 'WEB Site Doubt', '2008-05-04 06:41:56', '4', null, '2008-05-17 18:07:06', 'STAFF', 'BAC9162B47'), ('365', '3', 'CLOSED', '4', '38', '5', 'Peripheral Issue', '2008-05-04 07:10:59', '3', null, '2008-05-07 18:41:50', 'STAFF', '9BE40CEE5B'), ('366', '2', 'SOLVED', '6', '32', '4', 'WEB Mail Doubt', '2008-05-04 08:00:34', '4', null, '2008-05-11 13:35:40', 'STAFF', '5EF698CD9F'), ('367', '2', 'CLOSED', '10', '37', '6', 'Software Issue', '2008-05-05 09:55:23', '3', null, '2008-05-07 17:13:29', 'STAFF', '05049E90FA'), ('368', '1', 'SOLVED', '10', '8', '3', 'Sales Doubt', '2008-05-05 07:56:41', '3', null, '2008-05-11 14:47:56', 'STAFF', 'CF004FDC76'), ('369', '1', 'SOLVED', '5', '36', '4', 'WEB Mail Issue', '2008-05-05 11:57:46', '2', null, '2008-05-10 16:58:14', 'STAFF', '0C74B7F784'), ('370', '3', 'CLOSED', '9', '38', '6', 'Software Issue', '2008-05-05 06:58:31', '3', null, '2008-05-20 16:26:13', 'STAFF', 'D709F38EF7'), ('371', '3', 'SOLVED', '9', '24', '5', 'Peripheral Doubt', '2008-05-05 08:34:34', '2', null, '2008-05-11 18:30:36', 'STAFF', '41F1F19176'), ('372', '2', 'SOLVED', '10', '35', '3', 'Sales Doubt', '2008-05-05 11:01:43', '2', null, '2008-05-18 17:03:46', 'STAFF', '24B16FEDE9'), ('373', '3', 'SOLVED', '1', '27', '2', 'WEB Site Doubt', '2008-05-05 09:51:47', '3', null, '2008-05-09 18:43:25', 'STAFF', 'FFD52F3C7E'), ('374', '2', 'SOLVED', '7', '19', '3', 'Sales Doubt', '2008-05-05 06:19:16', '3', null, '2008-05-14 14:00:25', 'STAFF', 'AD972F10E0'), ('375', '2', 'SOLVED', '7', '27', '5', 'Peripheral Issue', '2008-05-05 12:12:59', '4', null, '2008-05-06 17:04:17', 'STAFF', 'F61D694746'), ('376', '2', 'SOLVED', '9', '20', '4', 'WEB Mail Doubt', '2008-05-05 11:07:02', '3', null, '2008-05-11 14:58:31', 'STAFF', '142949DF56'), ('377', '1', 'SOLVED', '8', '6', '4', 'WEB Mail Issue', '2008-05-05 06:19:16', '3', null, '2008-05-08 14:36:33', 'STAFF', 'D34AB169B7'), ('378', '2', 'SOLVED', '6', '1', '6', 'Software Doubt', '2008-05-05 12:01:18', '4', null, '2008-05-10 18:52:04', 'STAFF', '8BF1211FD4'), ('379', '2', 'SOLVED', '6', '6', '1', 'CRM Application Doubt', '2008-05-05 08:19:55', '4', null, '2008-05-07 17:26:46', 'STAFF', 'A02FFD91EC'), ('380', '1', 'SOLVED', '1', '5', '6', 'Software Issue', '2008-05-05 10:57:20', '4', null, '2008-05-16 15:36:59', 'STAFF', 'BCA82E41EE'), ('381', '2', 'SOLVED', '5', '19', '5', 'Peripheral Issue', '2008-05-05 10:41:03', '2', null, '2008-05-09 16:27:21', 'STAFF', '00EC53C468'), ('382', '2', 'SOLVED', '5', '38', '4', 'WEB Mail Issue', '2008-05-05 12:18:42', '3', null, '2008-05-14 18:11:35', 'STAFF', '4F6FFE13A5'), ('383', '2', 'SOLVED', '3', '27', '6', 'Sotfware Issue', '2008-05-05 09:12:27', '3', null, '2008-05-17 18:52:04', 'STAFF', 'BEED13602B'), ('384', '2', 'SOLVED', '10', '31', '3', 'Sales Doubt', '2008-05-06 07:58:45', '2', null, '2008-05-14 18:17:41', 'STAFF', '0584CE565C'), ('385', '2', 'SOLVED', '6', '28', '4', 'WEB Mail Doubt', '2008-05-06 09:20:47', '3', null, '2008-05-18 14:22:23', 'STAFF', 'DC912A253D'), ('386', '2', 'SOLVED', '1', '20', '4', 'WEB Mail Doubt', '2008-05-06 06:13:36', '4', null, '2008-05-17 16:16:34', 'STAFF', '39461A19E9'), ('387', '1', 'SOLVED', '9', '15', '5', 'Peripheral Doubt', '2008-05-06 07:17:41', '2', null, '2008-05-20 17:20:48', 'STAFF', '8EFB100A29'), ('388', '2', 'SOLVED', '5', '37', '3', 'Sales Doubt', '2008-05-06 11:50:45', '2', null, '2008-05-10 17:18:24', 'STAFF', 'D9FC5B73A8'), ('389', '2', 'SOLVED', '10', '22', '3', 'Sales Doubt', '2008-05-06 06:35:01', '3', null, '2008-05-13 15:19:15', 'STAFF', 'C86A7EE3D8'), ('390', '1', 'SOLVED', '1', '4', '5', 'Peripheral Issue', '2008-05-06 07:48:47', '4', null, '2008-05-07 17:37:25', 'STAFF', 'A01A0380CA'), ('391', '2', 'SOLVED', '2', '22', '5', 'Peripheral Issue', '2008-05-06 10:46:59', '4', null, '2008-05-17 17:38:10', 'STAFF', '5A4B25AAED'), ('392', '1', 'CLOSED', '5', '32', '6', 'Software Doubt', '2008-05-06 12:36:43', '1', null, '2008-05-23 14:16:00', 'STAFF', 'F73B76CE89'), ('393', '2', 'CLOSED', '8', '20', '5', 'Peripheral Doubt', '2008-05-06 07:27:06', '3', null, '2008-05-16 13:28:56', 'STAFF', '70C639DF5E'), ('394', '1', 'SOLVED', '6', '11', '6', 'Software Doubt', '2008-05-06 07:15:10', '2', null, '2008-05-11 14:28:01', 'STAFF', '28F0B86459'), ('395', '1', 'SOLVED', '10', '19', '1', 'CRM Application Issue', '2008-05-06 11:40:08', '3', null, '2008-05-11 14:01:36', 'STAFF', '1543843A47'), ('396', '2', 'CLOSED', '1', '34', '6', 'Software Doubt', '2008-05-07 09:25:27', '1', null, '2008-05-13 14:27:53', 'STAFF', 'F8C1F23D6A'), ('397', '1', 'SOLVED', '10', '10', '2', 'WEB Site Issue', '2008-05-07 09:34:01', '4', null, '2008-05-19 17:02:06', 'STAFF', 'E46DE7E1BC'), ('398', '2', 'SOLVED', '5', '31', '6', 'Software Doubt', '2008-05-07 10:04:30', '4', null, '2008-05-09 18:54:47', 'STAFF', 'B7B16ECF8C'), ('399', '1', 'SOLVED', '8', '29', '5', 'Peripheral Doubt', '2008-05-07 07:38:10', '4', null, '2008-05-18 16:15:51', 'STAFF', '352FE25DAF'), ('400', '1', 'CLOSED', '1', '10', '6', 'Sotfware Issue', '2008-05-07 06:56:40', '1', null, '2008-05-15 17:52:12', 'STAFF', '18D8042386'), ('401', '2', 'SOLVED', '9', '32', '2', 'WEB Site Doubt', '2008-05-07 09:19:57', '4', null, '2008-05-16 18:41:55', 'STAFF', '816B112C61'), ('402', '2', 'SOLVED', '9', '16', '3', 'Sales Doubt', '2008-05-07 11:43:29', '2', null, '2008-05-11 18:06:13', 'STAFF', '69CB3EA317'), ('403', '3', 'SOLVED', '8', '21', '5', 'Peripheral Issue', '2008-05-07 09:14:49', '4', null, '2008-05-12 16:51:34', 'STAFF', 'BBF94B34EB'), ('404', '3', 'CLOSED', '1', '19', '6', 'Software Issue', '2008-05-08 06:48:26', '3', null, '2008-05-08 13:48:26', 'STAFF', '4F4ADCBF8C'), ('405', '3', 'CLOSED', '4', '10', '5', 'Peripheral Issue', '2008-05-08 10:43:06', '1', null, '2008-05-17 18:37:20', 'STAFF', 'BBCBFF5C1F'), ('406', '3', 'SOLVED', '4', '12', '5', 'Peripheral Issue', '2008-05-08 12:14:42', '4', null, '2008-05-20 14:19:08', 'STAFF', '8CB22BDD0B'), ('407', '2', 'SOLVED', '2', '35', '6', 'Software Issue', '2008-05-08 09:17:24', '3', null, '2008-05-15 15:28:52', 'STAFF', 'F4F6DCE2F3'), ('408', '3', 'SOLVED', '3', '25', '6', 'Software Doubt', '2008-05-08 07:53:31', '4', null, '2008-05-09 14:18:50', 'STAFF', '0D0FD7C6E0'), ('409', '2', 'SOLVED', '2', '37', '2', 'WEB Site Issue', '2008-05-09 08:52:08', '3', null, '2008-05-24 18:29:27', 'STAFF', 'A96B65A721'), ('410', '3', 'SOLVED', '1', '39', '4', 'WEB Mail Doubt', '2008-05-09 10:32:28', '2', null, '2008-05-10 13:20:42', 'STAFF', '1068C6E4C8'), ('411', '1', 'SOLVED', '2', '29', '4', 'WEB Mail Doubt', '2008-05-10 07:39:38', '2', null, '2008-05-15 18:43:24', 'STAFF', '17D63B1625'), ('412', '2', 'SOLVED', '2', '10', '6', 'Software Issue', '2008-05-10 09:11:15', '2', null, '2008-05-12 14:13:20', 'STAFF', 'B9228E0962'), ('413', '2', 'SOLVED', '1', '9', '5', 'Peripheral Issue', '2008-05-10 07:12:17', '2', null, '2008-05-13 15:14:03', 'STAFF', '0DEB1C5481'), ('414', '1', 'SOLVED', '10', '20', '4', 'WEB Mail Doubt', '2008-05-10 11:32:59', '2', null, '2008-05-20 13:51:58', 'STAFF', '66808E327D'), ('415', '2', 'SOLVED', '10', '16', '5', 'Peripheral Issue', '2008-05-10 06:25:45', '4', null, '2008-05-13 18:10:41', 'STAFF', '42E7AAA88B'), ('416', '2', 'SOLVED', '9', '25', '6', 'Software Issue', '2008-05-10 12:07:07', '2', null, '2008-05-25 15:56:18', 'STAFF', '8FE0093BB3'), ('417', '3', 'SOLVED', '5', '35', '1', 'CRM Application Issue', '2008-05-10 08:04:19', '2', null, '2008-05-11 13:01:12', 'STAFF', '41AE36ECB9'), ('418', '1', 'SOLVED', '10', '10', '4', 'WEB Mail Doubt', '2008-05-10 09:14:18', '2', null, '2008-05-19 17:05:19', 'STAFF', 'D1F255A373'), ('419', '2', 'SOLVED', '8', '21', '1', 'CRM Application Issue', '2008-05-10 06:18:55', '3', null, '2008-05-15 15:47:06', 'STAFF', '7EACB53257'), ('420', '2', 'SOLVED', '6', '32', '4', 'WEB Mail Doubt', '2008-05-10 06:38:54', '3', null, '2008-05-22 14:56:17', 'STAFF', 'B6F0479AE8'), ('421', '2', 'SOLVED', '9', '33', '1', 'CRM Application Doubt', '2008-05-10 10:05:59', '4', null, '2008-05-20 14:18:18', 'STAFF', 'E0C641195B'), ('422', '1', 'SOLVED', '10', '31', '5', 'Peripheral Issue', '2008-05-10 12:24:17', '3', null, '2008-05-21 15:41:56', 'STAFF', 'F85454E827'), ('423', '2', 'SOLVED', '9', '7', '6', 'Software Doubt', '2008-05-11 06:58:24', '2', null, '2008-05-24 14:16:24', 'STAFF', 'FAA9AFEA49'), ('424', '2', 'SOLVED', '1', '38', '6', 'Sotfware Issue', '2008-05-11 12:21:18', '3', null, '2008-05-19 15:46:41', 'STAFF', '3C7781A36B'), ('425', '1', 'SOLVED', '7', '13', '4', 'WEB Mail Doubt', '2008-05-11 08:50:42', '2', null, '2008-05-19 16:49:51', 'STAFF', '25B2822C2F'), ('426', '2', 'CLOSED', '9', '38', '1', 'CRM Application Issue', '2008-05-11 08:04:52', '1', null, '2008-05-14 14:44:45', 'STAFF', '6ECBDD6EC8'), ('427', '2', 'SOLVED', '2', '18', '1', 'CRM Application Issue', '2008-05-11 07:50:45', '4', null, '2008-05-11 14:37:56', 'STAFF', '18997733EC'), ('428', '3', 'CLOSED', '5', '37', '5', 'Peripheral Issue', '2008-05-11 11:36:23', '2', null, '2008-05-20 15:38:45', 'STAFF', '8D7D8EE069'), ('429', '2', 'SOLVED', '1', '10', '6', 'Software Issue', '2008-05-12 08:51:52', '2', null, '2008-05-13 18:17:46', 'STAFF', '75FC093C0E'), ('430', '2', 'SOLVED', '4', '5', '2', 'WEB Site Issue', '2008-05-12 10:32:47', '2', null, '2008-05-18 16:10:56', 'STAFF', 'F74909ACE6'), ('431', '2', 'SOLVED', '1', '6', '6', 'Sotfware Issue', '2008-05-12 09:50:10', '3', null, '2008-05-28 14:04:19', 'STAFF', '66368270FF'), ('432', '3', 'CLOSED', '9', '26', '5', 'Peripheral Issue', '2008-05-12 08:31:16', '1', null, '2008-05-25 15:23:08', 'STAFF', '248E844336'), ('433', '1', 'CLOSED', '6', '28', '1', 'CRM Application Doubt', '2008-05-12 10:47:45', '3', null, '2008-05-18 14:32:55', 'STAFF', '019D385EB6'), ('434', '3', 'SOLVED', '4', '3', '6', 'Software Doubt', '2008-05-12 12:05:19', '2', null, '2008-05-19 17:29:09', 'STAFF', 'A49E9411D6'), ('435', '2', 'SOLVED', '1', '23', '6', 'Software Doubt', '2008-05-12 08:44:45', '3', null, '2008-05-17 18:00:33', 'STAFF', 'DDB30680A6'), ('436', '2', 'SOLVED', '4', '18', '2', 'WEB Site Issue', '2008-05-12 11:36:10', '3', null, '2008-05-22 13:47:12', 'STAFF', '2421FCB126'), ('437', '1', 'SOLVED', '1', '3', '5', 'Peripheral Doubt', '2008-05-12 07:08:29', '4', null, '2008-05-18 17:19:06', 'STAFF', 'FCCB60FB51'), ('438', '2', 'CLOSED', '9', '39', '1', 'CRM Application Issue', '2008-05-12 09:00:50', '3', null, '2008-05-17 18:09:09', 'STAFF', '1651CF0D2F'), ('439', '1', 'SOLVED', '9', '29', '5', 'Peripheral Doubt', '2008-05-12 09:34:25', '4', null, '2008-05-27 17:21:04', 'STAFF', 'EED5AF6ADD'), ('440', '1', 'SOLVED', '7', '2', '5', 'Peripheral Issue', '2008-05-12 10:14:00', '4', null, '2008-05-28 18:04:07', 'STAFF', 'A8ABB4BB28'), ('441', '1', 'SOLVED', '6', '1', '2', 'WEB Site Issue', '2008-05-13 07:26:27', '2', null, '2008-05-21 15:35:10', 'STAFF', '15D4E891D7'), ('442', '2', 'SOLVED', '3', '1', '2', 'WEB Site Issue', '2008-05-13 10:04:05', '3', null, '2008-05-20 14:27:44', 'STAFF', 'C203D8A151'), ('443', '3', 'SOLVED', '1', '21', '4', 'WEB Mail Doubt', '2008-05-13 12:38:47', '4', null, '2008-05-24 16:02:11', 'STAFF', '13F3CF8C53'), ('444', '1', 'SOLVED', '5', '9', '4', 'WEB Mail Issue', '2008-05-13 10:40:31', '4', null, '2008-05-14 18:40:58', 'STAFF', '550A141F12'), ('445', '3', 'SOLVED', '2', '38', '6', 'Software Doubt', '2008-05-13 08:53:21', '3', null, '2008-05-18 15:09:20', 'STAFF', '67F7FB873E'), ('446', '2', 'SOLVED', '5', '10', '1', 'CRM Application Doubt', '2008-05-13 12:54:28', '3', null, '2008-05-17 15:32:15', 'STAFF', '1A5B1E4DAA'), ('447', '2', 'SOLVED', '2', '23', '3', 'Sales Doubt', '2008-05-13 07:57:46', '4', null, '2008-05-22 17:38:52', 'STAFF', '9A96876E2F'), ('448', '3', 'CLOSED', '3', '20', '2', 'WEB Site Issue', '2008-05-13 06:15:33', '1', null, '2008-05-14 13:57:15', 'STAFF', '9B70E8FE62'), ('449', '3', 'CLOSED', '6', '19', '6', 'Software Doubt', '2008-05-13 07:47:16', '1', null, '2008-05-24 14:22:59', 'STAFF', 'D61E4BBD63'), ('450', '2', 'SOLVED', '8', '17', '6', 'Sotfware Issue', '2008-05-14 07:36:33', '4', null, '2008-05-22 15:39:18', 'STAFF', 'F5F8590CD5'), ('451', '2', 'SOLVED', '2', '38', '6', 'Software Doubt', '2008-05-14 08:28:17', '3', null, '2008-05-19 18:18:37', 'STAFF', '941E1AAABA'), ('452', '2', 'SOLVED', '5', '1', '6', 'Software Doubt', '2008-05-14 11:52:02', '2', null, '2008-05-15 14:12:23', 'STAFF', '9431C87F27'), ('453', '1', 'CLOSED', '1', '31', '6', 'Sotfware Issue', '2008-05-14 10:04:21', '2', null, '2008-05-26 15:07:44', 'STAFF', '49AE49A23F'), ('454', '2', 'SOLVED', '4', '36', '4', 'WEB Mail Issue', '2008-05-14 11:16:11', '4', null, '2008-05-25 18:04:59', 'STAFF', 'E44FEA3BEC'), ('455', '2', 'SOLVED', '2', '16', '2', 'WEB Site Issue', '2008-05-14 07:13:11', '3', null, '2008-05-28 13:37:40', 'STAFF', '821FA74B50'), ('456', '1', 'SOLVED', '5', '7', '2', 'WEB Site Doubt', '2008-05-14 06:26:42', '2', null, '2008-05-27 18:34:13', 'STAFF', '250CF8B51C'), ('457', '2', 'SOLVED', '10', '25', '6', 'Software Doubt', '2008-05-14 08:24:55', '4', null, '2008-05-17 17:49:06', 'STAFF', '42998CF32D'), ('458', '3', 'SOLVED', '10', '7', '5', 'Peripheral Doubt', '2008-05-14 09:15:28', '2', null, '2008-05-25 13:48:31', 'STAFF', 'D07E70EFCF'), ('459', '2', 'SOLVED', '1', '36', '6', 'Software Doubt', '2008-05-15 12:37:06', '4', null, '2008-05-25 17:44:15', 'STAFF', '7FE1F8ABAA'), ('460', '2', 'SOLVED', '9', '16', '4', 'WEB Mail Doubt', '2008-05-15 06:26:43', '3', null, '2008-05-19 15:43:46', 'STAFF', '98B2979500');
INSERT INTO `ticket` VALUES ('461', '3', 'SOLVED', '1', '35', '2', 'WEB Site Doubt', '2008-05-15 08:05:50', '2', null, '2008-05-31 15:25:02', 'STAFF', '0353AB4CBE'), ('462', '2', 'SOLVED', '2', '36', '3', 'Sales Doubt', '2008-05-15 06:45:26', '3', null, '2008-05-19 17:06:01', 'STAFF', '51D92BE1C6'), ('463', '1', 'SOLVED', '10', '17', '2', 'WEB Site Issue', '2008-05-16 07:53:48', '4', null, '2008-05-20 14:35:11', 'STAFF', '428FCA9BC1'), ('464', '3', 'SOLVED', '2', '20', '2', 'WEB Site Issue', '2008-05-16 12:21:30', '2', null, '2008-05-28 14:46:57', 'STAFF', 'F1B6F2857F'), ('465', '1', 'CLOSED', '1', '8', '2', 'WEB Site Issue', '2008-05-17 09:34:23', '2', null, '2008-05-17 15:43:48', 'STAFF', '68CE199EC2'), ('466', '3', 'SOLVED', '9', '6', '6', 'Software Issue', '2008-05-17 11:04:57', '4', null, '2008-05-28 18:21:07', 'STAFF', 'E836D813FD'), ('467', '3', 'SOLVED', '10', '36', '1', 'CRM Application Doubt', '2008-05-17 07:53:33', '2', null, '2008-05-27 16:51:20', 'STAFF', 'AB817C9349'), ('468', '2', 'SOLVED', '2', '28', '1', 'CRM Application Doubt', '2008-05-17 06:23:36', '4', null, '2008-06-02 13:54:18', 'STAFF', '877A9BA7A9'), ('469', '1', 'SOLVED', '10', '17', '5', 'Peripheral Issue', '2008-05-17 06:51:47', '2', null, '2008-06-04 17:27:59', 'STAFF', 'DC6A648964'), ('470', '2', 'SOLVED', '10', '34', '6', 'Software Issue', '2008-05-17 08:32:09', '2', null, '2008-06-01 14:04:53', 'STAFF', '26337353B7'), ('471', '2', 'CLOSED', '9', '27', '6', 'Software Doubt', '2008-05-17 11:37:05', '1', null, '2008-05-27 15:20:10', 'STAFF', '8E6B42F164'), ('472', '2', 'SOLVED', '3', '31', '2', 'WEB Site Issue', '2008-05-17 11:56:27', '2', null, '2008-05-31 16:48:49', 'STAFF', 'EF575E8837'), ('473', '3', 'SOLVED', '1', '28', '6', 'Software Issue', '2008-05-18 06:55:13', '4', null, '2008-06-02 14:56:40', 'STAFF', '2050E03CA1'), ('474', '2', 'CLOSED', '8', '9', '3', 'Sales Issue', '2008-05-18 06:21:52', '1', null, '2008-05-31 15:37:47', 'STAFF', '25DDC0F8C9'), ('475', '2', 'SOLVED', '6', '35', '2', 'WEB Site Issue', '2008-05-18 12:41:29', '2', null, '2008-05-29 15:12:56', 'STAFF', '5EF0B4EBA3'), ('476', '2', 'CLOSED', '5', '19', '4', 'WEB Mail Doubt', '2008-05-18 09:25:03', '3', null, '2008-06-02 18:46:12', 'STAFF', '598B3E71EC'), ('477', '1', 'SOLVED', '2', '10', '2', 'WEB Site Issue', '2008-05-18 06:01:22', '2', null, '2008-05-21 17:04:07', 'STAFF', '74071A6733'), ('478', '1', 'CLOSED', '3', '7', '4', 'WEB Mail Doubt', '2008-05-18 10:20:32', '2', null, '2008-05-31 13:09:20', 'STAFF', 'CFEE398643'), ('479', '2', 'SOLVED', '8', '30', '6', 'Software Doubt', '2008-05-18 11:12:43', '3', null, '2008-06-01 13:20:39', 'STAFF', 'D18F655C3F'), ('480', '2', 'SOLVED', '1', '12', '1', 'CRM Application Doubt', '2008-05-18 08:15:35', '3', null, '2008-05-22 18:36:12', 'STAFF', '6EA2EF7311'), ('481', '1', 'SOLVED', '10', '17', '1', 'CRM Application Issue', '2008-05-18 11:37:09', '4', null, '2008-05-19 13:16:10', 'STAFF', '9461CCE28E'), ('482', '3', 'SOLVED', '7', '10', '2', 'WEB Site Issue', '2008-05-18 08:18:18', '4', null, '2008-05-30 15:35:27', 'STAFF', 'F770B62BC8'), ('483', '3', 'SOLVED', '1', '20', '6', 'Software Issue', '2008-05-18 11:05:18', '4', null, '2008-05-27 18:11:24', 'STAFF', 'E1E32E235E'), ('484', '2', 'SOLVED', '6', '28', '3', 'Sales Doubt', '2008-05-19 11:29:10', '4', null, '2008-06-09 16:49:52', 'STAFF', 'EBA0DC302B'), ('485', '3', 'SOLVED', '5', '37', '6', 'Software Issue', '2008-05-19 09:09:50', '2', null, '2008-05-23 18:33:32', 'STAFF', '218A0AEFD1'), ('486', '2', 'SOLVED', '10', '10', '1', 'CRM Application Issue', '2008-05-19 11:14:09', '2', null, '2008-06-04 17:50:30', 'STAFF', '7D04BBBE54'), ('487', '1', 'SOLVED', '3', '11', '6', 'Software Issue', '2008-05-19 10:12:29', '4', null, '2008-05-21 13:36:02', 'STAFF', 'A516A87CFC'), ('488', '1', 'SOLVED', '6', '20', '6', 'Software Issue', '2008-05-19 09:11:00', '2', null, '2008-06-06 13:21:15', 'STAFF', 'C3C59E5F8B'), ('489', '2', 'SOLVED', '9', '37', '5', 'Peripheral Doubt', '2008-05-19 06:25:20', '4', null, '2008-06-08 18:34:28', 'STAFF', '854D9FCA60'), ('490', '2', 'SOLVED', '8', '19', '6', 'Sotfware Issue', '2008-05-19 11:04:21', '4', null, '2008-05-24 17:15:17', 'STAFF', 'C410003EF1'), ('491', '2', 'CLOSED', '10', '31', '5', 'Peripheral Issue', '2008-05-19 10:07:30', '2', null, '2008-06-01 15:27:11', 'STAFF', '559CB990C9'), ('492', '2', 'SOLVED', '10', '31', '2', 'WEB Site Issue', '2008-05-19 08:22:13', '2', null, '2008-05-23 13:37:05', 'STAFF', '55A7CF9C71'), ('493', '2', 'SOLVED', '10', '30', '6', 'Software Doubt', '2008-05-19 08:13:31', '3', null, '2008-05-28 13:56:06', 'STAFF', '2F55707D41'), ('494', '1', 'SOLVED', '9', '6', '5', 'Peripheral Issue', '2008-05-19 12:12:47', '4', null, '2008-06-05 14:38:12', 'STAFF', '1BE3BC32E6'), ('495', '2', 'SOLVED', '4', '28', '2', 'WEB Site Issue', '2008-05-19 09:09:41', '4', null, '2008-05-24 14:21:49', 'STAFF', '35051070E5'), ('496', '2', 'CLOSED', '8', '28', '1', 'CRM Application Doubt', '2008-05-19 08:27:12', '1', null, '2008-05-28 16:54:12', 'STAFF', 'B534BA6823'), ('497', '2', 'SOLVED', '5', '19', '5', 'Peripheral Issue', '2008-05-19 12:55:26', '2', null, '2008-05-26 18:04:08', 'STAFF', '7380AD8A67'), ('498', '2', 'SOLVED', '1', '8', '2', 'WEB Site Issue', '2008-05-20 10:55:35', '3', null, '2008-05-31 15:55:08', 'STAFF', '05F971B5EC'), ('499', '1', 'SOLVED', '10', '15', '2', 'WEB Site Doubt', '2008-05-20 08:36:00', '3', null, '2008-05-30 13:41:47', 'STAFF', '3CF166C6B7'), ('500', '1', 'CLOSED', '6', '23', '4', 'WEB Mail Issue', '2008-05-20 09:11:54', '3', null, '2008-05-29 13:34:15', 'STAFF', 'CEE631121C'), ('3501', '2', 'SOLVED', '1', '25', '1', 'CRM Application Issue', '2009-07-01 12:17:25', '3', '', '2009-07-11 14:26:20', 'STAFF', 'D494020FF8'), ('3502', '2', 'SOLVED', '10', '21', '1', 'CRM Application Issue', '2009-07-03 08:29:53', '3', '', '2009-07-21 17:15:51', 'STAFF', 'D2350A54D7'), ('3503', '2', 'CLOSED', '5', '31', '4', 'WEB Mail Issue', '2009-07-04 07:21:06', '3', '', '2009-07-19 14:11:20', 'STAFF', '87F7EE4FDB'), ('3504', '1', 'CLOSED', '10', '38', '6', 'Software Doubt', '2009-07-04 12:45:44', '2', '', '2009-07-08 17:16:19', 'STAFF', '73231E53EE'), ('3505', '2', 'SOLVED', '10', '1', '6', 'Sotfware Issue', '2009-07-04 09:23:39', '4', '', '2009-07-15 13:22:17', 'STAFF', '2A3D6D6CC4'), ('3506', '3', 'SOLVED', '9', '23', '3', 'Sales Doubt', '2009-07-04 07:47:30', '2', '', '2009-07-09 16:39:04', 'STAFF', 'E0126439E0'), ('3507', '2', 'SOLVED', '3', '33', '4', 'WEB Mail Doubt', '2009-07-04 12:40:47', '3', '', '2009-07-09 18:13:18', 'STAFF', '0E7C7D6C41'), ('3508', '2', 'UNASSIGNED', '10', '23', '4', 'WEB Mail Doubt', '2009-07-04 10:43:01', '0', '', '2009-07-04 10:43:01', 'CUSTOMER', '7D2BE41B1B'), ('3509', '2', 'SOLVED', '5', '37', '6', 'Software Issue', '2009-07-04 08:30:26', '3', '', '2009-07-15 15:47:10', 'STAFF', '0141A8AEDB'), ('3510', '2', 'SOLVED', '8', '35', '4', 'WEB Mail Doubt', '2009-07-04 08:19:01', '4', '', '2009-07-16 17:27:08', 'STAFF', '15E122E839'), ('3511', '3', 'CLOSED', '1', '34', '4', 'WEB Mail Doubt', '2009-07-04 10:53:27', '3', '', '2009-07-11 13:52:26', 'STAFF', '9A85C12A21'), ('3512', '1', 'UNASSIGNED', '1', '7', '6', 'Software Issue', '2009-07-04 10:20:58', '0', '', '2009-07-04 10:20:58', 'CUSTOMER', '0DBB3FB9A5'), ('3513', '2', 'SOLVED', '10', '21', '4', 'WEB Mail Doubt', '2009-07-04 06:59:03', '4', '', '2009-07-05 16:15:20', 'STAFF', '0FFACA95E3'), ('3514', '2', 'RETURNED', '9', '11', '3', 'Sales Issue', '2009-07-05 10:58:58', '0', '', '2009-07-12 07:40:44', 'CUSTOMER', '7288251B27'), ('3515', '2', 'SOLVED', '5', '33', '4', 'WEB Mail Doubt', '2009-07-05 11:39:38', '4', '', '2009-07-10 16:13:56', 'STAFF', '5FEF3EFF51'), ('3516', '2', 'SOLVED', '3', '9', '2', 'WEB Site Issue', '2009-07-05 08:48:59', '2', '', '2009-07-05 16:19:49', 'STAFF', 'CF1CF43CBA'), ('3517', '2', 'SOLVED', '10', '11', '3', 'Sales Doubt', '2009-07-05 11:49:33', '3', '', '2009-07-08 16:58:20', 'STAFF', 'B5B0DB7F3A'), ('3518', '2', 'SOLVED', '1', '8', '1', 'CRM Application Doubt', '2009-07-05 10:45:23', '4', '', '2009-07-10 14:33:10', 'STAFF', '5401ACFE63'), ('3519', '3', 'SOLVED', '5', '32', '6', 'Sotfware Issue', '2009-07-05 10:01:32', '3', '', '2009-07-22 16:21:39', 'STAFF', '1FD7B875D3'), ('3520', '3', 'SOLVED', '4', '1', '1', 'CRM Application Issue', '2009-07-05 07:53:30', '2', '', '2009-07-13 14:06:43', 'STAFF', '6C0958D82A'), ('3521', '3', 'SOLVED', '9', '36', '1', 'CRM Application Doubt', '2009-07-06 09:31:18', '4', '', '2009-07-10 17:04:19', 'STAFF', '98AFDCC1EB'), ('3522', '2', 'RETURNED', '2', '39', '5', 'Peripheral Doubt', '2009-07-06 12:48:12', '0', '', '2009-07-15 10:29:01', 'CUSTOMER', 'EE14C41E92'), ('3523', '3', 'UNASSIGNED', '1', '31', '6', 'Software Doubt', '2009-07-06 12:35:54', '0', '', '2009-07-06 12:35:54', 'CUSTOMER', '939314105C'), ('3524', '2', 'SOLVED', '8', '5', '5', 'Peripheral Doubt', '2009-07-06 12:01:14', '4', '', '2009-07-19 14:17:13', 'STAFF', 'A9DE093D06'), ('3525', '1', 'CLOSED', '1', '1', '5', 'Peripheral Issue', '2009-07-06 12:57:21', '1', '', '2009-07-08 18:33:02', 'STAFF', 'DA9E6A4A4A'), ('3526', '1', 'SOLVED', '9', '23', '3', 'Sales Doubt', '2009-07-06 12:45:11', '3', '', '2009-07-12 14:56:27', 'STAFF', '0E4F5CC9F4'), ('3527', '2', 'SOLVED', '9', '35', '6', 'Software Doubt', '2009-07-06 12:17:05', '2', '', '2009-07-18 18:50:39', 'STAFF', 'B874707824'), ('3528', '2', 'SOLVED', '2', '18', '3', 'Sales Doubt', '2009-07-06 06:33:41', '2', '', '2009-07-11 14:11:45', 'STAFF', 'EAD81FE8CF'), ('3529', '2', 'RETURNED', '9', '21', '4', 'WEB Mail Doubt', '2009-07-06 08:59:04', '0', '', '2009-07-14 08:21:20', 'CUSTOMER', '9BDB8B1FAF'), ('3530', '2', 'SOLVED', '1', '29', '2', 'WEB Site Issue', '2009-07-06 06:27:17', '3', '', '2009-07-19 15:15:16', 'STAFF', '30A0B73609'), ('3531', '1', 'SOLVED', '1', '34', '5', 'Peripheral Doubt', '2009-07-06 11:52:40', '3', '', '2009-07-20 16:31:54', 'STAFF', 'E52AD5C9F7'), ('3532', '2', 'SOLVED', '4', '22', '5', 'Peripheral Doubt', '2009-07-06 07:48:58', '2', '', '2009-07-09 17:13:47', 'STAFF', 'AFAB3E9707'), ('3533', '2', 'SOLVED', '9', '22', '4', 'WEB Mail Doubt', '2009-07-06 07:13:16', '2', '', '2009-07-10 18:47:41', 'STAFF', '5A9D8BF5B7'), ('3534', '1', 'SOLVED', '5', '22', '4', 'WEB Mail Doubt', '2009-07-06 07:14:52', '2', '', '2009-07-07 17:10:37', 'STAFF', 'AA97D58486'), ('3535', '1', 'SOLVED', '3', '11', '5', 'Peripheral Doubt', '2009-07-06 12:59:37', '2', '', '2009-07-08 14:58:04', 'STAFF', 'B99D193B66'), ('3536', '1', 'SOLVED', '2', '26', '3', 'Sales Doubt', '2009-07-06 07:31:22', '4', '', '2009-07-07 17:24:10', 'STAFF', '291D43C696'), ('3537', '2', 'CLOSED', '10', '25', '6', 'Sotfware Issue', '2009-07-07 06:56:21', '1', '', '2009-07-16 15:45:38', 'STAFF', '416849DA96'), ('3538', '2', 'SOLVED', '2', '29', '6', 'Software Issue', '2009-07-07 07:12:56', '4', '', '2009-07-20 16:42:14', 'STAFF', '1458E7509A'), ('3539', '2', 'SOLVED', '5', '15', '6', 'Software Issue', '2009-07-07 11:09:43', '2', '', '2009-07-11 15:41:10', 'STAFF', '142C65E00F'), ('3540', '1', 'SOLVED', '2', '2', '6', 'Software Issue', '2009-07-07 12:46:01', '3', '', '2009-07-18 16:47:43', 'STAFF', '8844C5F003'), ('3541', '2', 'SOLVED', '10', '26', '6', 'Sotfware Issue', '2009-07-07 09:11:20', '3', '', '2009-07-14 14:33:19', 'STAFF', 'C5F5C23BE1'), ('3542', '2', 'SOLVED', '1', '5', '1', 'CRM Application Issue', '2009-07-07 07:40:48', '4', '', '2009-07-11 16:19:19', 'STAFF', '8487E01FBA'), ('3543', '2', 'SOLVED', '10', '22', '5', 'Peripheral Issue', '2009-07-07 11:50:26', '3', '', '2009-07-08 13:19:26', 'STAFF', '196F5641AA'), ('3544', '2', 'SOLVED', '7', '32', '6', 'Software Issue', '2009-07-07 12:10:39', '2', '', '2009-07-16 16:26:45', 'STAFF', '147EBE6370'), ('3545', '1', 'SOLVED', '4', '6', '5', 'Peripheral Doubt', '2009-07-07 11:14:26', '3', '', '2009-07-14 15:37:54', 'STAFF', '06EE4C5C93'), ('3546', '3', 'SOLVED', '9', '15', '6', 'Software Issue', '2009-07-07 10:31:53', '3', '', '2009-07-23 13:20:44', 'STAFF', 'A8166DA05C'), ('3547', '3', 'CLOSED', '10', '37', '5', 'Peripheral Issue', '2009-07-07 06:44:23', '3', '', '2009-07-08 13:54:14', 'STAFF', 'E6BA70FC09'), ('3548', '1', 'SOLVED', '10', '23', '6', 'Software Issue', '2009-07-08 12:30:04', '3', '', '2009-07-12 15:03:16', 'STAFF', '50CF0763D8'), ('3549', '3', 'SOLVED', '3', '10', '5', 'Peripheral Doubt', '2009-07-08 10:36:50', '3', '', '2009-07-17 16:02:35', 'STAFF', 'DB98DC0DBA'), ('3550', '2', 'SOLVED', '1', '6', '4', 'WEB Mail Doubt', '2009-07-08 06:39:46', '4', '', '2009-07-17 13:47:14', 'STAFF', '018DD1E07A'), ('3551', '2', 'CLOSED', '5', '20', '6', 'Software Doubt', '2009-07-08 08:24:15', '3', '', '2009-07-28 14:19:28', 'STAFF', 'ABDEB6F575'), ('3552', '2', 'SOLVED', '1', '39', '3', 'Sales Doubt', '2009-07-08 10:04:01', '3', '', '2009-07-08 15:38:43', 'STAFF', '7C220A2091'), ('3553', '1', 'SOLVED', '1', '1', '1', 'CRM Application Doubt', '2009-07-08 10:55:48', '4', '', '2009-07-14 17:40:38', 'STAFF', 'E250C59336'), ('3554', '2', 'UNASSIGNED', '10', '33', '1', 'CRM Application Doubt', '2009-07-08 09:01:49', '0', '', '2009-07-08 09:01:49', 'CUSTOMER', '69B09198D4'), ('3555', '2', 'SOLVED', '1', '19', '6', 'Software Issue', '2009-07-08 08:10:40', '3', '', '2009-07-17 14:55:29', 'STAFF', '22B1CD168E'), ('3556', '1', 'SOLVED', '10', '38', '4', 'WEB Mail Issue', '2009-07-08 08:25:41', '4', '', '2009-07-22 13:32:31', 'STAFF', '656F0DBF93'), ('3557', '3', 'RETURNED', '7', '10', '5', 'Peripheral Doubt', '2009-07-08 12:48:15', '0', '', '2009-07-16 09:28:55', 'CUSTOMER', '51DA85A3C3'), ('3558', '3', 'SOLVED', '5', '1', '4', 'WEB Mail Doubt', '2009-07-09 08:37:33', '3', '', '2009-07-21 14:14:21', 'STAFF', '285A25C17F'), ('3559', '1', 'UNASSIGNED', '9', '8', '4', 'WEB Mail Doubt', '2009-07-09 09:12:24', '0', '', '2009-07-09 09:12:24', 'CUSTOMER', 'F11BEC1411'), ('3560', '2', 'SOLVED', '10', '9', '4', 'WEB Mail Doubt', '2009-07-09 09:12:25', '2', '', '2009-07-23 17:16:26', 'STAFF', '0AE1DD3954'), ('3561', '3', 'SOLVED', '1', '7', '3', 'Sales Issue', '2009-07-10 11:58:14', '4', '', '2009-07-26 14:44:33', 'STAFF', '414A749719'), ('3562', '2', 'SOLVED', '9', '27', '4', 'WEB Mail Issue', '2009-07-10 09:57:07', '2', '', '2009-07-20 15:11:59', 'STAFF', 'EBF12CB74E'), ('3563', '2', 'SOLVED', '7', '33', '5', 'Peripheral Issue', '2009-07-11 11:27:03', '4', '', '2009-07-19 13:26:17', 'STAFF', 'D04D42CDF1'), ('3564', '2', 'SOLVED', '8', '26', '4', 'WEB Mail Doubt', '2009-07-11 09:05:54', '3', '', '2009-07-13 13:44:25', 'STAFF', '05EDF455CB'), ('3565', '2', 'REPLIED', '5', '12', '1', 'CRM Application Doubt', '2009-07-11 06:50:42', '0', '', '2009-07-23 16:53:21', 'STAFF', 'E6E7132966'), ('3566', '1', 'SOLVED', '10', '32', '1', 'CRM Application Issue', '2009-07-11 12:22:37', '2', '', '2009-07-20 15:03:57', 'STAFF', '6346DC7233'), ('3567', '2', 'SOLVED', '6', '28', '1', 'CRM Application Doubt', '2009-07-11 10:19:38', '4', '', '2009-07-16 13:31:40', 'STAFF', 'DCCAB9BD9E'), ('3568', '2', 'SOLVED', '6', '1', '2', 'WEB Site Issue', '2009-07-11 06:52:31', '4', '', '2009-07-15 17:26:42', 'STAFF', '5481B2F34A'), ('3569', '2', 'CLOSED', '10', '31', '1', 'CRM Application Issue', '2009-07-11 12:18:47', '2', '', '2009-07-23 14:19:27', 'STAFF', '77C493EC14'), ('3570', '2', 'CLOSED', '1', '31', '6', 'Software Issue', '2009-07-11 06:39:19', '1', '', '2009-07-17 14:27:22', 'STAFF', '43B5284266'), ('3571', '2', 'SOLVED', '3', '34', '2', 'WEB Site Issue', '2009-07-11 07:54:37', '2', '', '2009-07-19 16:48:38', 'STAFF', 'F8F5161CF9'), ('3572', '2', 'SOLVED', '5', '29', '5', 'Peripheral Doubt', '2009-07-12 09:50:48', '2', '', '2009-07-13 14:08:32', 'STAFF', '842424A1D0'), ('3573', '1', 'CLOSED', '1', '35', '1', 'CRM Application Issue', '2009-07-12 09:18:05', '1', '', '2009-08-02 13:33:53', 'STAFF', '8BACA01B73'), ('3574', '3', 'CLOSED', '10', '31', '6', 'Software Doubt', '2009-07-12 08:26:47', '1', '', '2009-07-27 16:40:46', 'STAFF', '1B9F38268C'), ('3575', '2', 'SOLVED', '4', '36', '2', 'WEB Site Issue', '2009-07-12 09:09:27', '2', '', '2009-07-23 15:34:42', 'STAFF', 'C9F06BC7B4'), ('3576', '2', 'SOLVED', '5', '12', '2', 'WEB Site Issue', '2009-07-12 07:52:57', '4', '', '2009-07-24 15:24:46', 'STAFF', '3F647CADF5'), ('3577', '2', 'SOLVED', '10', '37', '1', 'CRM Application Doubt', '2009-07-12 09:08:41', '3', '', '2009-07-20 17:49:11', 'STAFF', '3E77A14629'), ('3578', '2', 'SOLVED', '9', '21', '1', 'CRM Application Issue', '2009-07-12 07:19:42', '4', '', '2009-07-13 17:35:46', 'STAFF', '252A3DBAEB'), ('3579', '2', 'CLOSED', '10', '30', '5', 'Peripheral Issue', '2009-07-12 12:10:16', '3', '', '2009-07-28 18:11:45', 'STAFF', '0D441DE759'), ('3580', '2', 'CLOSED', '6', '35', '5', 'Peripheral Doubt', '2009-07-13 06:45:46', '1', '', '2009-07-30 18:36:17', 'STAFF', '630B7D8DD4'), ('3581', '3', 'SOLVED', '5', '40', '5', 'Peripheral Doubt', '2009-07-13 07:35:53', '4', '', '2009-07-28 16:56:20', 'STAFF', '67606D48E3'), ('3582', '1', 'CLOSED', '9', '15', '1', 'CRM Application Doubt', '2009-07-13 12:01:31', '2', '', '2009-07-27 18:37:19', 'STAFF', '9D684C589D'), ('3583', '3', 'SOLVED', '10', '24', '5', 'Peripheral Issue', '2009-07-13 11:43:10', '4', '', '2009-07-15 16:52:59', 'STAFF', '69EBA34671'), ('3584', '2', 'RETURNED', '10', '37', '4', 'WEB Mail Issue', '2009-07-13 09:19:08', '0', '', '2009-07-18 09:59:17', 'CUSTOMER', '565767EB96'), ('3585', '2', 'REPLIED', '1', '19', '1', 'CRM Application Doubt', '2009-07-13 08:11:56', '0', '', '2009-07-28 16:57:06', 'STAFF', '2668A71059'), ('3586', '1', 'CLOSED', '2', '1', '3', 'Sales Doubt', '2009-07-13 08:34:27', '1', '', '2009-07-15 16:14:25', 'STAFF', '224E5E4981'), ('3587', '2', 'SOLVED', '10', '18', '5', 'Peripheral Doubt', '2009-07-13 12:22:25', '4', '', '2009-07-28 14:37:28', 'STAFF', 'ABA53DA2F6'), ('3588', '2', 'SOLVED', '6', '25', '6', 'Software Doubt', '2009-07-13 11:39:11', '2', '', '2009-07-14 16:17:45', 'STAFF', 'C2964CAAC0'), ('3589', '2', 'SOLVED', '9', '33', '1', 'CRM Application Issue', '2009-07-13 12:00:08', '2', '', '2009-07-16 14:46:35', 'STAFF', 'A385D7D1E5'), ('3590', '2', 'SOLVED', '10', '27', '6', 'Sotfware Issue', '2009-07-13 06:54:31', '3', '', '2009-07-16 16:17:39', 'STAFF', 'DA6EA77475'), ('3591', '3', 'CLOSED', '9', '6', '5', 'Peripheral Doubt', '2009-07-14 06:13:00', '2', '', '2009-07-19 18:34:19', 'STAFF', '9001CA4292'), ('3592', '3', 'REPLIED', '10', '22', '4', 'WEB Mail Doubt', '2009-07-14 09:17:51', '0', '', '2009-07-15 17:01:11', 'STAFF', '69F357FCC8'), ('3593', '1', 'SOLVED', '7', '36', '4', 'WEB Mail Doubt', '2009-07-14 08:00:52', '2', '', '2009-07-18 14:56:40', 'STAFF', 'CDD0500DC0'), ('3594', '1', 'SOLVED', '1', '9', '6', 'Sotfware Issue', '2009-07-14 10:46:10', '2', '', '2009-08-04 15:58:27', 'STAFF', 'DCE8AF15F0'), ('3595', '2', 'SOLVED', '4', '17', '4', 'WEB Mail Doubt', '2009-07-14 08:28:06', '3', '', '2009-07-22 16:25:05', 'STAFF', 'C0E8517B1F'), ('3596', '1', 'SOLVED', '3', '19', '6', 'Sotfware Issue', '2009-07-14 09:22:01', '4', '', '2009-07-21 13:06:31', 'STAFF', '52C409F157'), ('3597', '2', 'SOLVED', '3', '30', '4', 'WEB Mail Doubt', '2009-07-14 08:29:31', '2', '', '2009-07-24 17:18:55', 'STAFF', 'B89C30965E'), ('3598', '2', 'SOLVED', '9', '25', '1', 'CRM Application Doubt', '2009-07-15 10:47:37', '3', '', '2009-07-17 15:23:34', 'STAFF', '6A450490F2'), ('3599', '2', 'SOLVED', '3', '36', '1', 'CRM Application Issue', '2009-07-15 08:39:13', '3', '', '2009-07-24 16:31:36', 'STAFF', 'E7E69CDF28'), ('3600', '2', 'SOLVED', '4', '12', '1', 'CRM Application Issue', '2009-07-15 12:55:20', '4', '', '2009-07-24 13:53:31', 'STAFF', '8D7628DD7A'), ('3601', '1', 'SOLVED', '2', '35', '5', 'Peripheral Issue', '2009-07-15 06:18:40', '4', '', '2009-07-16 18:40:22', 'STAFF', '62E7F2E090'), ('3602', '3', 'SOLVED', '10', '37', '1', 'CRM Application Doubt', '2009-07-15 06:13:43', '4', '', '2009-07-19 18:54:09', 'STAFF', '228B255874'), ('3603', '2', 'CLOSED', '5', '1', '6', 'Sotfware Issue', '2009-07-15 11:05:08', '3', '', '2009-07-17 17:35:02', 'STAFF', '6A8018B3A0'), ('3604', '3', 'SOLVED', '10', '35', '4', 'WEB Mail Issue', '2009-07-15 06:14:10', '3', '', '2009-07-16 16:56:40', 'STAFF', 'C254E77530'), ('3605', '3', 'RETURNED', '4', '27', '2', 'WEB Site Doubt', '2009-07-15 07:25:34', '0', '', '2009-07-15 07:25:34', 'CUSTOMER', 'A05D886123'), ('3606', '3', 'SOLVED', '9', '19', '1', 'CRM Application Doubt', '2009-07-15 08:09:40', '4', '', '2009-07-24 13:16:22', 'STAFF', '774B0E0775'), ('3607', '1', 'RETURNED', '5', '6', '1', 'CRM Application Issue', '2009-07-16 09:45:16', '0', '', '2009-07-16 09:45:16', 'CUSTOMER', '967990DE5B'), ('3608', '2', 'REPLIED', '5', '5', '5', 'Peripheral Issue', '2009-07-16 12:52:47', '0', '', '2009-07-26 15:12:30', 'STAFF', '60A0575EE6'), ('3609', '2', 'CLOSED', '7', '15', '6', 'Software Doubt', '2009-07-16 12:32:16', '2', '', '2009-07-20 17:50:02', 'STAFF', '649A066D41'), ('3610', '1', 'SOLVED', '10', '34', '1', 'CRM Application Doubt', '2009-07-16 06:15:38', '4', '', '2009-08-01 18:59:01', 'STAFF', 'F95EC3DE39'), ('3611', '2', 'CLOSED', '9', '33', '5', 'Peripheral Issue', '2009-07-18 09:33:40', '2', '', '2009-07-29 14:52:12', 'STAFF', '4CF33E18ED'), ('3612', '3', 'REPLIED', '7', '20', '6', 'Software Issue', '2009-07-18 07:21:33', '0', '', '2009-07-21 16:16:18', 'STAFF', 'D87CA511E2'), ('3613', '2', 'SOLVED', '2', '9', '5', 'Peripheral Doubt', '2009-07-18 11:35:00', '2', '', '2009-07-20 17:50:24', 'STAFF', 'C4FA7AECED'), ('3614', '3', 'SOLVED', '1', '30', '4', 'WEB Mail Issue', '2009-07-18 11:17:59', '2', '', '2009-07-27 13:16:25', 'STAFF', '6ADD07CF50'), ('3615', '2', 'SOLVED', '5', '34', '1', 'CRM Application Issue', '2009-07-18 10:49:41', '4', '', '2009-08-01 13:35:33', 'STAFF', 'D8C9D05EC6'), ('3616', '2', 'SOLVED', '10', '7', '5', 'Peripheral Issue', '2009-07-18 06:59:12', '3', '', '2009-08-01 17:56:00', 'STAFF', '78D69F4090'), ('3617', '2', 'SOLVED', '6', '33', '6', 'Software Issue', '2009-07-18 06:29:19', '3', '', '2009-07-26 14:17:21', 'STAFF', 'DB68512896'), ('3618', '2', 'SOLVED', '1', '9', '3', 'Sales Doubt', '2009-07-18 06:00:21', '3', '', '2009-07-26 17:22:38', 'STAFF', '4DA9D7B6D1'), ('3619', '2', 'SOLVED', '5', '35', '3', 'Sales Doubt', '2009-07-18 06:17:57', '3', '', '2009-07-22 18:19:13', 'STAFF', '820E694038'), ('3620', '2', 'SOLVED', '8', '22', '5', 'Peripheral Issue', '2009-07-18 06:02:33', '3', '', '2009-07-29 17:54:52', 'STAFF', '4BAF54F369'), ('3621', '2', 'SOLVED', '3', '21', '2', 'WEB Site Issue', '2009-07-18 11:27:45', '4', '', '2009-07-18 15:04:12', 'STAFF', 'C5B270A763'), ('3622', '3', 'CLOSED', '10', '12', '6', 'Software Issue', '2009-07-18 07:45:36', '2', '', '2009-07-19 13:39:41', 'STAFF', '856B503E27'), ('3623', '1', 'SOLVED', '9', '25', '2', 'WEB Site Doubt', '2009-07-19 07:47:59', '4', '', '2009-07-23 14:30:35', 'STAFF', 'ECDCD675B3'), ('3624', '2', 'RETURNED', '1', '23', '4', 'WEB Mail Doubt', '2009-07-19 10:04:05', '0', '', '2009-08-01 08:04:48', 'CUSTOMER', '5EE0070C40'), ('3625', '2', 'SOLVED', '3', '12', '1', 'CRM Application Doubt', '2009-07-19 09:05:31', '3', '', '2009-07-28 17:47:25', 'STAFF', 'DD7970532B'), ('3626', '1', 'SOLVED', '5', '12', '4', 'WEB Mail Doubt', '2009-07-19 10:05:02', '4', '', '2009-07-24 15:28:18', 'STAFF', '0EE8B85A85'), ('3627', '2', 'SOLVED', '7', '30', '5', 'Peripheral Issue', '2009-07-19 12:00:15', '3', '', '2009-08-01 13:41:29', 'STAFF', '2BF283C05B'), ('3628', '2', 'RETURNED', '9', '31', '6', 'Software Issue', '2009-07-19 10:35:24', '0', '', '2009-08-02 10:16:47', 'CUSTOMER', '3E524BF740'), ('3629', '1', 'RETURNED', '10', '10', '4', 'WEB Mail Doubt', '2009-07-20 11:40:35', '0', '', '2009-07-28 11:10:03', 'CUSTOMER', '1305F6C705'), ('3630', '2', 'SOLVED', '4', '34', '6', 'Software Issue', '2009-07-20 11:51:57', '3', '', '2009-07-22 17:56:52', 'STAFF', '1A551829D5'), ('3631', '2', 'SOLVED', '7', '37', '4', 'WEB Mail Doubt', '2009-07-20 10:56:28', '4', '', '2009-07-31 15:00:27', 'STAFF', 'FD4C2DC64C'), ('3632', '1', 'SOLVED', '7', '30', '6', 'Software Doubt', '2009-07-20 07:37:20', '3', '', '2009-07-20 13:27:55', 'STAFF', '398475C83B'), ('3633', '2', 'CLOSED', '7', '13', '4', 'WEB Mail Doubt', '2009-07-20 07:00:47', '3', '', '2009-07-23 13:57:06', 'STAFF', 'ACF9221546'), ('3634', '3', 'CLOSED', '1', '3', '1', 'CRM Application Doubt', '2009-07-20 12:29:38', '3', '', '2009-07-25 18:04:19', 'STAFF', 'E2EABAF963'), ('3635', '3', 'SOLVED', '10', '35', '5', 'Peripheral Issue', '2009-07-20 06:15:03', '4', '', '2009-07-25 18:04:48', 'STAFF', 'A098B2EB31'), ('3636', '2', 'CLOSED', '7', '17', '5', 'Peripheral Doubt', '2009-07-20 07:19:39', '3', '', '2009-08-11 18:55:14', 'STAFF', '48042B1DAE'), ('3637', '1', 'SOLVED', '5', '10', '6', 'Software Issue', '2009-07-20 08:30:30', '3', '', '2009-07-25 15:44:57', 'STAFF', 'CAE82D4350'), ('3638', '3', 'SOLVED', '1', '27', '5', 'Peripheral Issue', '2009-07-20 08:29:28', '2', '', '2009-07-22 14:24:26', 'STAFF', '895DAA408F'), ('3639', '2', 'CLOSED', '1', '8', '4', 'WEB Mail Issue', '2009-07-20 12:54:38', '2', '', '2009-07-22 13:27:41', 'STAFF', 'BA304F3809'), ('3640', '3', 'SOLVED', '1', '5', '5', 'Peripheral Issue', '2009-07-20 10:23:21', '3', '', '2009-07-25 17:35:01', 'STAFF', '4F11B55F57'), ('3641', '3', 'RETURNED', '1', '37', '4', 'WEB Mail Doubt', '2009-07-20 12:14:58', '0', '', '2009-07-28 07:24:56', 'CUSTOMER', '22C5A90107'), ('3642', '2', 'SOLVED', '5', '35', '1', 'CRM Application Doubt', '2009-07-20 09:18:51', '3', '', '2009-07-30 17:36:15', 'STAFF', '300D1539C3'), ('3643', '1', 'RETURNED', '3', '8', '4', 'WEB Mail Issue', '2009-07-20 10:36:09', '0', '', '2009-07-20 10:36:09', 'CUSTOMER', '7AE11AF208'), ('3644', '1', 'SOLVED', '10', '1', '3', 'Sales Doubt', '2009-07-20 07:04:27', '2', '', '2009-07-27 14:54:55', 'STAFF', '8A057268A7'), ('3645', '3', 'SOLVED', '10', '24', '3', 'Sales Doubt', '2009-07-20 11:22:34', '2', '', '2009-07-28 13:26:06', 'STAFF', 'D0AA518D4D'), ('3646', '2', 'RETURNED', '2', '17', '4', 'WEB Mail Issue', '2009-07-21 06:56:38', '0', '', '2009-07-25 12:11:55', 'CUSTOMER', 'B5A1D92522'), ('3647', '2', 'CLOSED', '4', '28', '6', 'Software Issue', '2009-07-21 06:54:08', '3', '', '2009-07-21 14:29:31', 'STAFF', '0D8080853A'), ('3648', '3', 'SOLVED', '5', '31', '4', 'WEB Mail Doubt', '2009-07-21 06:10:15', '2', '', '2009-07-25 17:42:21', 'STAFF', 'CFF02A74DA'), ('3649', '2', 'SOLVED', '6', '18', '5', 'Peripheral Issue', '2009-07-21 08:59:42', '4', '', '2009-07-26 13:05:31', 'STAFF', '49C0FA7F96'), ('3650', '2', 'SOLVED', '9', '28', '6', 'Software Doubt', '2009-07-21 07:26:17', '2', '', '2009-07-22 15:59:00', 'STAFF', '45CEF8E5B9'), ('3651', '2', 'CLOSED', '5', '37', '2', 'WEB Site Issue', '2009-07-21 11:10:27', '1', '', '2009-07-23 14:29:36', 'STAFF', 'C203E4A1BD'), ('3652', '1', 'SOLVED', '3', '9', '4', 'WEB Mail Doubt', '2009-07-21 06:59:38', '4', '', '2009-08-02 16:21:04', 'STAFF', 'E1021D4391'), ('3653', '2', 'CLOSED', '1', '37', '6', 'Software Issue', '2009-07-21 10:58:24', '2', '', '2009-07-25 15:48:18', 'STAFF', '2DA6CC4A5D'), ('3654', '2', 'SOLVED', '10', '28', '4', 'WEB Mail Doubt', '2009-07-21 09:37:51', '3', '', '2009-08-08 17:11:42', 'STAFF', 'CF88118AA2'), ('3655', '3', 'SOLVED', '5', '39', '6', 'Software Issue', '2009-07-21 07:31:51', '2', '', '2009-07-21 13:53:57', 'STAFF', '310CC7CA5A'), ('3656', '2', 'SOLVED', '5', '10', '4', 'WEB Mail Doubt', '2009-07-21 12:25:23', '4', '', '2009-07-23 13:31:46', 'STAFF', '14678DB828'), ('3657', '1', 'SOLVED', '5', '17', '2', 'WEB Site Doubt', '2009-07-21 10:17:04', '4', '', '2009-07-23 14:50:20', 'STAFF', 'A22D33B4A0'), ('3658', '3', 'SOLVED', '5', '1', '4', 'WEB Mail Doubt', '2009-07-21 11:49:46', '4', '', '2009-07-23 14:30:06', 'STAFF', '30A237D18C'), ('3659', '2', 'REPLIED', '9', '36', '4', 'WEB Mail Doubt', '2009-07-22 10:07:44', '0', '', '2009-08-03 13:29:54', 'STAFF', '07845CD9AE'), ('3660', '2', 'SOLVED', '6', '22', '6', 'Sotfware Issue', '2009-07-22 11:28:57', '3', '', '2009-07-24 16:16:40', 'STAFF', '9627C45DF5'), ('3661', '3', 'SOLVED', '9', '19', '4', 'WEB Mail Doubt', '2009-07-22 06:26:40', '3', '', '2009-07-24 14:34:21', 'STAFF', 'E761813F83'), ('3662', '2', 'SOLVED', '1', '22', '6', 'Sotfware Issue', '2009-07-22 11:44:41', '2', '', '2009-07-28 17:25:22', 'STAFF', '2B346A0AA3'), ('3663', '3', 'RETURNED', '9', '33', '4', 'WEB Mail Issue', '2009-07-22 09:05:53', '0', '', '2009-07-25 08:10:08', 'CUSTOMER', 'DDF9029977'), ('3664', '3', 'SOLVED', '10', '31', '2', 'WEB Site Issue', '2009-07-22 12:53:34', '4', '', '2009-07-27 13:03:00', 'STAFF', 'B67FB3360A'), ('3665', '2', 'SOLVED', '6', '39', '2', 'WEB Site Issue', '2009-07-22 07:37:28', '4', '', '2009-07-25 18:15:34', 'STAFF', '6915849303'), ('3666', '2', 'SOLVED', '9', '22', '3', 'Sales Doubt', '2009-07-22 12:00:54', '3', '', '2009-07-25 14:49:29', 'STAFF', '1EA97DE85E'), ('3667', '1', 'CLOSED', '1', '8', '3', 'Sales Doubt', '2009-07-22 10:42:32', '2', '', '2009-08-07 13:49:51', 'STAFF', 'F095CEDD23'), ('3668', '2', 'SOLVED', '10', '20', '4', 'WEB Mail Issue', '2009-07-22 09:54:02', '2', '', '2009-07-31 13:40:25', 'STAFF', '1D2A48C55F'), ('3669', '2', 'SOLVED', '2', '19', '4', 'WEB Mail Doubt', '2009-07-23 12:27:03', '4', '', '2009-07-27 17:05:50', 'STAFF', 'E1228BE46D'), ('3670', '2', 'UNASSIGNED', '6', '11', '3', 'Sales Doubt', '2009-07-24 11:39:57', '0', '', '2009-07-24 11:39:57', 'CUSTOMER', '77EC6F21C8'), ('3671', '2', 'SOLVED', '7', '23', '2', 'WEB Site Issue', '2009-07-24 06:18:35', '2', '', '2009-08-01 18:42:58', 'STAFF', '54EBDFBBFE'), ('3672', '2', 'SOLVED', '7', '36', '4', 'WEB Mail Issue', '2009-07-25 12:02:47', '4', '', '2009-07-25 17:41:52', 'STAFF', 'F3C89B7BE3'), ('3673', '2', 'CLOSED', '1', '31', '1', 'CRM Application Doubt', '2009-07-25 11:56:56', '1', '', '2009-08-15 17:59:58', 'STAFF', '740A02D078'), ('3674', '3', 'SOLVED', '10', '31', '4', 'WEB Mail Doubt', '2009-07-25 12:12:38', '2', '', '2009-07-28 18:15:46', 'STAFF', 'F35FD56706'), ('3675', '2', 'SOLVED', '1', '21', '3', 'Sales Doubt', '2009-07-25 09:06:30', '4', '', '2009-08-09 17:08:09', 'STAFF', '845F3CB43A'), ('3676', '2', 'RETURNED', '5', '39', '4', 'WEB Mail Doubt', '2009-07-25 09:27:21', '0', '', '2009-07-25 09:27:21', 'CUSTOMER', '1133832659'), ('3677', '2', 'SOLVED', '3', '10', '2', 'WEB Site Doubt', '2009-07-25 09:53:40', '4', '', '2009-07-26 16:40:00', 'STAFF', '71D7232B9F'), ('3678', '2', 'SOLVED', '7', '29', '6', 'Sotfware Issue', '2009-07-25 07:23:55', '3', '', '2009-08-10 15:16:54', 'STAFF', '2151B4C76B'), ('3679', '1', 'SOLVED', '2', '31', '4', 'WEB Mail Doubt', '2009-07-25 08:47:56', '2', '', '2009-07-27 13:40:02', 'STAFF', '74791EDF1F'), ('3680', '3', 'SOLVED', '9', '19', '5', 'Peripheral Issue', '2009-07-25 11:27:28', '2', '', '2009-07-30 15:55:02', 'STAFF', '2122C699D5'), ('3681', '2', 'RETURNED', '1', '30', '6', 'Software Doubt', '2009-07-26 08:42:47', '0', '', '2009-08-05 09:24:07', 'CUSTOMER', '9426C311E7'), ('3682', '1', 'SOLVED', '1', '19', '3', 'Sales Doubt', '2009-07-26 12:30:06', '3', '', '2009-08-04 13:54:23', 'STAFF', '898AEF0932'), ('3683', '1', 'SOLVED', '10', '11', '4', 'WEB Mail Issue', '2009-07-26 07:54:27', '3', '', '2009-08-06 14:39:39', 'STAFF', 'ACB5D1120B'), ('3684', '2', 'SOLVED', '1', '22', '5', 'Peripheral Issue', '2009-07-26 11:24:25', '3', '', '2009-07-30 13:14:12', 'STAFF', 'C90E274D55'), ('3685', '2', 'SOLVED', '9', '23', '5', 'Peripheral Doubt', '2009-07-26 07:24:00', '3', '', '2009-08-08 18:03:05', 'STAFF', '55A0DF4B5A'), ('3686', '2', 'CLOSED', '1', '38', '2', 'WEB Site Doubt', '2009-07-26 10:32:58', '1', '', '2009-08-02 16:54:05', 'STAFF', 'DC727151E5'), ('3687', '2', 'SOLVED', '5', '32', '5', 'Peripheral Issue', '2009-07-26 12:43:58', '4', '', '2009-08-06 15:24:30', 'STAFF', '6754E06E46'), ('3688', '2', 'CLOSED', '5', '20', '6', 'Software Issue', '2009-07-26 06:06:59', '3', '', '2009-08-03 15:17:33', 'STAFF', 'D880067F87'), ('3689', '1', 'UNASSIGNED', '9', '7', '6', 'Software Doubt', '2009-07-26 06:54:31', '0', '', '2009-07-26 06:54:31', 'CUSTOMER', '39EA40E164'), ('3690', '1', 'RETURNED', '2', '26', '2', 'WEB Site Issue', '2009-07-27 12:45:05', '0', '', '2009-08-14 06:24:53', 'CUSTOMER', '781397BC06'), ('3691', '2', 'CLOSED', '7', '39', '6', 'Software Doubt', '2009-07-27 11:57:10', '1', '', '2009-08-03 14:20:43', 'STAFF', '8ABFE8AC9E'), ('3692', '3', 'REPLIED', '1', '10', '4', 'WEB Mail Issue', '2009-07-27 12:55:02', '0', '', '2009-08-09 18:37:58', 'STAFF', '882735CBDF'), ('3693', '2', 'SOLVED', '1', '34', '4', 'WEB Mail Doubt', '2009-07-27 07:25:11', '2', '', '2009-07-31 16:53:34', 'STAFF', 'F23D125DA1'), ('3694', '3', 'SOLVED', '9', '39', '4', 'WEB Mail Doubt', '2009-07-27 09:22:16', '3', '', '2009-07-31 15:13:53', 'STAFF', '4B26DC4663'), ('3695', '3', 'RETURNED', '5', '26', '6', 'Sotfware Issue', '2009-07-27 09:59:03', '0', '', '2009-07-27 09:59:03', 'CUSTOMER', 'AF1B575406'), ('3696', '2', 'SOLVED', '4', '23', '6', 'Software Doubt', '2009-07-27 12:25:08', '2', '', '2009-08-07 13:18:42', 'STAFF', '95C9D994F8'), ('3697', '1', 'SOLVED', '2', '5', '6', 'Software Doubt', '2009-07-27 10:41:09', '4', '', '2009-07-28 17:01:32', 'STAFF', '0B105CF150'), ('3698', '2', 'SOLVED', '5', '25', '3', 'Sales Doubt', '2009-07-27 10:26:38', '2', '', '2009-07-28 16:43:47', 'STAFF', '943AA0FCDA'), ('3699', '3', 'SOLVED', '1', '19', '6', 'Software Doubt', '2009-07-27 06:43:52', '4', '', '2009-08-06 18:52:18', 'STAFF', 'A18630AB1C'), ('3700', '2', 'SOLVED', '4', '17', '2', 'WEB Site Issue', '2009-07-27 10:09:58', '2', '', '2009-08-03 18:33:42', 'STAFF', 'F92586A25B'), ('3701', '2', 'CLOSED', '6', '17', '4', 'WEB Mail Issue', '2009-07-27 08:51:28', '1', '', '2009-08-05 14:14:00', 'STAFF', 'B181EAA49F'), ('3702', '1', 'SOLVED', '5', '39', '1', 'CRM Application Issue', '2009-07-27 09:37:47', '3', '', '2009-08-05 16:51:56', 'STAFF', 'A928731E10'), ('3703', '1', 'SOLVED', '6', '35', '4', 'WEB Mail Doubt', '2009-07-27 09:52:22', '4', '', '2009-07-30 17:31:26', 'STAFF', '7D2A383E54'), ('3704', '2', 'SOLVED', '9', '19', '3', 'Sales Doubt', '2009-07-27 11:38:35', '2', '', '2009-07-30 15:54:46', 'STAFF', '9308B0D6E5'), ('3705', '1', 'RETURNED', '6', '12', '1', 'CRM Application Issue', '2009-07-27 11:51:14', '0', '', '2009-08-07 12:40:07', 'CUSTOMER', '2CFA3753D6'), ('3706', '2', 'SOLVED', '10', '11', '1', 'CRM Application Doubt', '2009-07-27 06:43:41', '4', '', '2009-07-29 14:48:01', 'STAFF', '4764F37856'), ('3707', '3', 'SOLVED', '2', '3', '4', 'WEB Mail Doubt', '2009-07-27 08:45:05', '4', '', '2009-07-31 14:38:57', 'STAFF', '2AD9E5E943'), ('3708', '3', 'RETURNED', '1', '37', '1', 'CRM Application Issue', '2009-07-27 12:27:37', '0', '', '2009-07-27 12:27:37', 'CUSTOMER', '34FFEB359A'), ('3709', '1', 'SOLVED', '1', '7', '6', 'Software Doubt', '2009-07-28 09:07:07', '3', '', '2009-08-09 16:37:21', 'STAFF', '56DB57B4DB'), ('3710', '1', 'SOLVED', '7', '37', '2', 'WEB Site Doubt', '2009-07-28 11:23:49', '4', '', '2009-08-09 18:10:38', 'STAFF', '5505712229'), ('3711', '2', 'SOLVED', '7', '29', '2', 'WEB Site Issue', '2009-07-28 07:24:14', '2', '', '2009-08-06 16:01:31', 'STAFF', 'ABA18772FC'), ('3712', '2', 'RETURNED', '5', '6', '4', 'WEB Mail Doubt', '2009-07-28 08:14:24', '0', '', '2009-08-04 10:45:41', 'CUSTOMER', '87AE6FB631'), ('3713', '1', 'SOLVED', '7', '15', '4', 'WEB Mail Doubt', '2009-07-28 08:06:43', '3', '', '2009-08-06 15:52:38', 'STAFF', '7553E94D39'), ('3714', '2', 'SOLVED', '6', '12', '6', 'Sotfware Issue', '2009-07-28 08:40:08', '2', '', '2009-08-05 17:53:22', 'STAFF', 'E36286B94D'), ('3715', '1', 'SOLVED', '1', '5', '2', 'WEB Site Doubt', '2009-07-28 09:58:39', '3', '', '2009-08-11 18:20:07', 'STAFF', 'D2D2C6E244'), ('3716', '2', 'SOLVED', '9', '7', '1', 'CRM Application Issue', '2009-07-28 12:47:44', '4', '', '2009-08-07 15:28:59', 'STAFF', '1B32A022C5'), ('3717', '3', 'SOLVED', '10', '33', '3', 'Sales Doubt', '2009-07-29 06:50:15', '4', '', '2009-08-08 13:22:29', 'STAFF', '240C945BB7'), ('3718', '1', 'SOLVED', '5', '33', '5', 'Peripheral Issue', '2009-07-29 12:52:43', '4', '', '2009-08-09 13:03:16', 'STAFF', '9D068C869F'), ('3719', '1', 'CLOSED', '10', '40', '1', 'CRM Application Issue', '2009-07-29 07:13:39', '1', '', '2009-08-05 16:43:23', 'STAFF', '9E740B84BB'), ('3720', '2', 'CLOSED', '10', '38', '5', 'Peripheral Issue', '2009-07-29 08:07:44', '2', '', '2009-08-07 13:46:42', 'STAFF', '532B81FA22'), ('3721', '2', 'SOLVED', '10', '11', '5', 'Peripheral Issue', '2009-07-29 08:38:44', '3', '', '2009-08-03 15:55:19', 'STAFF', '9E406957D4'), ('3722', '2', 'RETURNED', '2', '35', '3', 'Sales Doubt', '2009-07-29 07:58:19', '0', '', '2009-07-29 07:58:19', 'CUSTOMER', '56E6A93212'), ('3723', '1', 'SOLVED', '3', '33', '5', 'Peripheral Issue', '2009-07-29 08:35:53', '2', '', '2009-08-02 14:09:42', 'STAFF', 'AFA299A4D1'), ('3724', '2', 'SOLVED', '1', '1', '3', 'Sales Doubt', '2009-07-30 11:45:23', '4', '', '2009-08-04 14:34:52', 'STAFF', '4172F31012'), ('3725', '3', 'SOLVED', '10', '32', '1', 'CRM Application Issue', '2009-07-30 10:32:52', '4', '', '2009-08-09 15:04:21', 'STAFF', '94EF7214C4'), ('3726', '3', 'SOLVED', '1', '15', '5', 'Peripheral Issue', '2009-07-30 12:58:13', '3', '', '2009-08-21 17:23:01', 'STAFF', '9FE77AC706'), ('3727', '1', 'REPLIED', '4', '7', '4', 'WEB Mail Issue', '2009-07-30 07:43:23', '0', '', '2009-08-10 16:24:48', 'STAFF', 'D3802B1DC0'), ('3728', '2', 'SOLVED', '1', '28', '3', 'Sales Doubt', '2009-08-01 11:01:57', '4', '', '2009-08-12 16:07:31', 'STAFF', '460B491B91'), ('3729', '2', 'RETURNED', '6', '11', '5', 'Peripheral Issue', '2009-08-01 07:04:51', '0', '', '2009-08-08 12:29:55', 'CUSTOMER', 'CB16B8498F'), ('3730', '3', 'RETURNED', '3', '16', '4', 'WEB Mail Issue', '2009-08-01 08:23:43', '0', '', '2009-08-10 09:08:53', 'CUSTOMER', 'D8C24CA8F2'), ('3731', '2', 'RETURNED', '7', '10', '5', 'Peripheral Issue', '2009-08-01 11:53:35', '0', '', '2009-08-05 09:28:18', 'CUSTOMER', '7EC3B3CF67'), ('3732', '2', 'SOLVED', '10', '37', '6', 'Sotfware Issue', '2009-08-01 11:34:34', '2', '', '2009-08-09 17:06:07', 'STAFF', 'EE23E7AD9B'), ('3733', '2', 'REPLIED', '7', '40', '5', 'Peripheral Issue', '2009-08-01 08:15:29', '0', '', '2009-08-05 15:46:39', 'STAFF', '64D52E08CC'), ('3734', '1', 'SOLVED', '4', '3', '2', 'WEB Site Issue', '2009-08-01 10:51:07', '3', '', '2009-08-08 14:59:48', 'STAFF', '9D752CB08E'), ('3735', '2', 'SOLVED', '10', '19', '5', 'Peripheral Doubt', '2009-08-01 06:08:03', '2', '', '2009-08-16 17:21:15', 'STAFF', 'DC0C398086'), ('3736', '1', 'SOLVED', '1', '22', '6', 'Software Issue', '2009-08-01 12:48:24', '2', '', '2009-08-08 14:19:42', 'STAFF', '3E195B0793'), ('3737', '2', 'SOLVED', '1', '3', '1', 'CRM Application Issue', '2009-08-02 10:21:41', '4', '', '2009-08-04 13:06:19', 'STAFF', '3DB11D259A'), ('3738', '2', 'REPLIED', '9', '22', '6', 'Software Doubt', '2009-08-02 09:59:33', '0', '', '2009-08-07 16:27:23', 'STAFF', '16738419B1'), ('3739', '1', 'REPLIED', '10', '37', '3', 'Sales Doubt', '2009-08-02 12:25:21', '0', '', '2009-08-12 13:19:04', 'STAFF', '20885C72CA'), ('3740', '3', 'SOLVED', '7', '10', '6', 'Software Issue', '2009-08-02 12:16:06', '3', '', '2009-08-13 18:37:33', 'STAFF', '33EF701C80'), ('3741', '2', 'RETURNED', '2', '6', '1', 'CRM Application Doubt', '2009-08-02 11:10:09', '0', '', '2009-08-10 11:06:33', 'CUSTOMER', '63CE12DCF1'), ('3742', '3', 'SOLVED', '9', '37', '3', 'Sales Doubt', '2009-08-02 12:32:28', '2', '', '2009-08-10 15:21:29', 'STAFF', '1F72E258FF'), ('3743', '1', 'SOLVED', '6', '17', '1', 'CRM Application Issue', '2009-08-02 12:10:17', '2', '', '2009-08-13 18:05:04', 'STAFF', '0937FB5864'), ('3744', '2', 'RETURNED', '5', '7', '1', 'CRM Application Issue', '2009-08-02 09:27:02', '0', '', '2009-08-15 06:02:16', 'CUSTOMER', '56517F19AA'), ('3745', '1', 'CLOSED', '2', '34', '2', 'WEB Site Doubt', '2009-08-02 08:45:20', '3', '', '2009-08-02 17:42:36', 'STAFF', '6D3A2D24EB'), ('3746', '2', 'SOLVED', '1', '33', '5', 'Peripheral Issue', '2009-08-02 09:19:21', '4', '', '2009-08-08 14:05:01', 'STAFF', 'E8542A04D7'), ('3747', '1', 'REPLIED', '5', '23', '5', 'Peripheral Doubt', '2009-08-02 12:48:52', '0', '', '2009-08-15 15:22:41', 'STAFF', 'D8847BE3F7'), ('3748', '2', 'RETURNED', '3', '38', '1', 'CRM Application Doubt', '2009-08-03 09:18:37', '0', '', '2009-08-11 11:55:49', 'CUSTOMER', 'AAACCD2766'), ('3749', '2', 'RETURNED', '9', '21', '4', 'WEB Mail Doubt', '2009-08-03 11:46:15', '0', '', '2009-08-19 09:35:12', 'CUSTOMER', 'F9BEB1E831'), ('3750', '3', 'CLOSED', '10', '26', '5', 'Peripheral Issue', '2009-08-03 07:49:31', '3', '', '2009-08-12 18:12:18', 'STAFF', '685AC8CADC'), ('3751', '1', 'SOLVED', '6', '22', '5', 'Peripheral Issue', '2009-08-03 11:05:15', '3', '', '2009-08-08 14:27:34', 'STAFF', '21CE689121'), ('3752', '3', 'SOLVED', '9', '23', '5', 'Peripheral Issue', '2009-08-03 09:47:44', '4', '', '2009-08-18 16:00:41', 'STAFF', '48DF7B8E8D'), ('3753', '1', 'SOLVED', '1', '7', '1', 'CRM Application Issue', '2009-08-03 12:11:06', '3', '', '2009-08-08 15:24:05', 'STAFF', '258E130476'), ('3754', '1', 'SOLVED', '5', '10', '4', 'WEB Mail Doubt', '2009-08-03 12:13:34', '4', '', '2009-08-03 17:42:24', 'STAFF', '2E3D2C4F33'), ('3755', '2', 'SOLVED', '8', '20', '3', 'Sales Issue', '2009-08-03 07:58:39', '4', '', '2009-08-07 13:45:40', 'STAFF', 'CD3BBC2D7C'), ('3756', '3', 'SOLVED', '5', '38', '6', 'Sotfware Issue', '2009-08-03 11:09:21', '2', '', '2009-08-23 16:24:58', 'STAFF', '91F9FEC9B0'), ('3757', '2', 'SOLVED', '6', '2', '6', 'Software Doubt', '2009-08-03 11:09:08', '3', '', '2009-08-05 13:00:14', 'STAFF', 'B4AFFA4F6B'), ('3758', '3', 'SOLVED', '5', '6', '3', 'Sales Doubt', '2009-08-03 10:46:07', '4', '', '2009-08-04 15:14:57', 'STAFF', '3DF07FDAE1'), ('3759', '2', 'RETURNED', '6', '24', '5', 'Peripheral Doubt', '2009-08-03 11:37:52', '0', '', '2009-08-03 11:37:52', 'CUSTOMER', 'CBF22AB286'), ('3760', '1', 'RETURNED', '9', '35', '5', 'Peripheral Doubt', '2009-08-03 12:51:34', '0', '', '2009-08-03 12:51:34', 'CUSTOMER', '27E8E17134'), ('3761', '2', 'SOLVED', '10', '23', '6', 'Software Doubt', '2009-08-03 09:32:45', '3', '', '2009-08-03 13:54:24', 'STAFF', '092CB13C22'), ('3762', '3', 'SOLVED', '3', '38', '1', 'CRM Application Doubt', '2009-08-03 10:04:39', '3', '', '2009-08-19 18:59:45', 'STAFF', '9332C513EF'), ('3763', '1', 'REPLIED', '10', '10', '4', 'WEB Mail Issue', '2009-08-03 09:52:01', '0', '', '2009-08-07 17:36:42', 'STAFF', '7BA6D33C37'), ('3764', '2', 'CLOSED', '6', '18', '2', 'WEB Site Issue', '2009-08-03 07:30:08', '1', '', '2009-08-03 17:22:39', 'STAFF', '641D77DD52'), ('3765', '2', 'SOLVED', '10', '35', '4', 'WEB Mail Doubt', '2009-08-04 07:27:04', '3', '', '2009-08-21 15:16:52', 'STAFF', '211A7A84D3'), ('3766', '3', 'SOLVED', '9', '34', '6', 'Software Doubt', '2009-08-04 09:21:16', '2', '', '2009-08-22 15:38:12', 'STAFF', '79CAE1BE0F'), ('3767', '3', 'REPLIED', '10', '28', '4', 'WEB Mail Issue', '2009-08-04 12:17:11', '0', '', '2009-08-14 18:17:09', 'STAFF', 'D74CB35426'), ('3768', '1', 'RETURNED', '10', '24', '1', 'CRM Application Issue', '2009-08-04 11:38:14', '0', '', '2009-08-04 11:38:14', 'CUSTOMER', '28D437661D'), ('3769', '2', 'SOLVED', '1', '40', '6', 'Software Doubt', '2009-08-04 11:34:45', '3', '', '2009-08-15 14:45:16', 'STAFF', '4625D8E31D'), ('3770', '3', 'SOLVED', '10', '1', '4', 'WEB Mail Doubt', '2009-08-04 08:33:33', '4', '', '2009-08-13 15:45:47', 'STAFF', '7F6CAF1F0B'), ('3771', '1', 'REPLIED', '8', '9', '2', 'WEB Site Issue', '2009-08-04 08:07:09', '0', '', '2009-08-09 18:01:43', 'STAFF', '201E5BACD6'), ('3772', '2', 'CLOSED', '9', '27', '6', 'Sotfware Issue', '2009-08-04 08:06:59', '3', '', '2009-08-07 13:38:57', 'STAFF', '83DDFBD1C4'), ('3773', '3', 'RETURNED', '2', '35', '4', 'WEB Mail Doubt', '2009-08-04 12:11:20', '0', '', '2009-08-13 11:07:08', 'CUSTOMER', '5C151C2A9B'), ('3774', '3', 'SOLVED', '2', '34', '4', 'WEB Mail Doubt', '2009-08-05 12:35:05', '2', '', '2009-08-08 15:46:22', 'STAFF', '73F104C9FB'), ('3775', '2', 'UNASSIGNED', '6', '21', '2', 'WEB Site Issue', '2009-08-05 07:05:57', '0', '', '2009-08-05 07:05:57', 'CUSTOMER', 'F2B93CE087'), ('3776', '2', 'CLOSED', '7', '10', '1', 'CRM Application Issue', '2009-08-05 12:01:44', '2', '', '2009-08-05 16:30:18', 'STAFF', '2119B8D43E'), ('3777', '3', 'SOLVED', '8', '35', '2', 'WEB Site Issue', '2009-08-05 11:03:42', '4', '', '2009-08-06 18:58:49', 'STAFF', 'ADD7A04804'), ('3778', '1', 'SOLVED', '1', '36', '6', 'Software Doubt', '2009-08-05 07:39:18', '2', '', '2009-08-09 13:35:58', 'STAFF', 'CAB070D53B'), ('3779', '1', 'UNASSIGNED', '1', '37', '2', 'WEB Site Doubt', '2009-08-05 06:44:14', '0', '', '2009-08-05 06:44:14', 'CUSTOMER', '8CE87BDDA8'), ('3780', '2', 'SOLVED', '9', '10', '5', 'Peripheral Issue', '2009-08-05 06:02:59', '2', '', '2009-08-17 16:33:22', 'STAFF', '3569DF159E'), ('3781', '2', 'SOLVED', '9', '6', '4', 'WEB Mail Issue', '2009-08-05 07:08:54', '3', '', '2009-08-15 18:25:59', 'STAFF', '9FC664916B'), ('3782', '2', 'RETURNED', '6', '1', '6', 'Software Doubt', '2009-08-06 09:09:34', '0', '', '2009-08-06 09:09:34', 'CUSTOMER', 'F87E955FD6'), ('3783', '3', 'SOLVED', '5', '1', '3', 'Sales Doubt', '2009-08-06 12:16:49', '2', '', '2009-08-16 16:33:38', 'STAFF', '1AA3D9C6CE'), ('3784', '2', 'RETURNED', '10', '23', '6', 'Sotfware Issue', '2009-08-07 06:50:54', '0', '', '2009-08-13 09:23:43', 'CUSTOMER', 'E16E74A635'), ('3785', '2', 'RETURNED', '9', '35', '1', 'CRM Application Issue', '2009-08-08 06:08:21', '0', '', '2009-08-08 06:08:21', 'CUSTOMER', '44FEB0096F'), ('3786', '1', 'RETURNED', '2', '4', '6', 'Software Doubt', '2009-08-08 06:27:38', '0', '', '2009-08-14 08:04:04', 'CUSTOMER', '34306D99C6'), ('3787', '1', 'RETURNED', '10', '37', '1', 'CRM Application Issue', '2009-08-08 10:07:38', '0', '', '2009-08-08 10:07:38', 'CUSTOMER', 'F3175210F9'), ('3788', '3', 'SOLVED', '7', '15', '4', 'WEB Mail Doubt', '2009-08-08 11:30:30', '2', '', '2009-08-09 14:09:03', 'STAFF', 'DEB74A85A4'), ('3789', '3', 'RETURNED', '1', '33', '5', 'Peripheral Issue', '2009-08-08 11:34:00', '0', '', '2009-08-21 09:10:44', 'CUSTOMER', '335D3D1CD7'), ('3790', '2', 'SOLVED', '10', '1', '1', 'CRM Application Issue', '2009-08-08 07:58:24', '3', '', '2009-08-13 15:14:51', 'STAFF', 'E73FECC08E'), ('3791', '3', 'RETURNED', '9', '28', '5', 'Peripheral Issue', '2009-08-08 09:40:18', '0', '', '2009-08-26 06:37:23', 'CUSTOMER', '690BB330E5'), ('3792', '2', 'SOLVED', '10', '7', '6', 'Software Issue', '2009-08-08 11:33:09', '2', '', '2009-08-12 15:02:19', 'STAFF', '4ECB679FD3'), ('3793', '2', 'SOLVED', '2', '38', '5', 'Peripheral Doubt', '2009-08-08 10:32:22', '2', '', '2009-08-11 14:55:00', 'STAFF', 'C157297D1A'), ('3794', '1', 'SOLVED', '8', '23', '6', 'Software Issue', '2009-08-09 08:40:03', '2', '', '2009-08-11 14:19:22', 'STAFF', '916D3891A2'), ('3795', '2', 'UNASSIGNED', '1', '25', '3', 'Sales Doubt', '2009-08-09 12:02:15', '0', '', '2009-08-09 12:02:15', 'CUSTOMER', '42547F5A44'), ('3796', '2', 'CLOSED', '1', '11', '1', 'CRM Application Doubt', '2009-08-09 12:12:48', '3', '', '2009-08-20 14:34:29', 'STAFF', '41C542DFE6'), ('3797', '2', 'SOLVED', '10', '7', '5', 'Peripheral Doubt', '2009-08-09 12:06:26', '3', '', '2009-08-11 17:42:41', 'STAFF', '36072923BF'), ('3798', '2', 'RETURNED', '7', '2', '4', 'WEB Mail Doubt', '2009-08-09 10:45:30', '0', '', '2009-08-09 10:45:30', 'CUSTOMER', 'C82836ED44'), ('3799', '2', 'REPLIED', '3', '27', '5', 'Peripheral Issue', '2009-08-09 07:52:57', '0', '', '2009-08-20 15:30:58', 'STAFF', '58521E4E2B'), ('3800', '3', 'RETURNED', '5', '18', '3', 'Sales Doubt', '2009-08-09 10:47:53', '0', '', '2009-08-17 08:51:36', 'CUSTOMER', '63C6598E9D'), ('3801', '2', 'RETURNED', '1', '19', '4', 'WEB Mail Doubt', '2009-08-09 06:06:39', '0', '', '2009-08-09 06:06:39', 'CUSTOMER', '95323660ED'), ('3802', '2', 'RETURNED', '2', '12', '2', 'WEB Site Issue', '2009-08-09 09:18:51', '0', '', '2009-08-09 09:18:51', 'CUSTOMER', 'D3614F463B'), ('3803', '2', 'SOLVED', '8', '38', '6', 'Software Issue', '2009-08-09 09:55:13', '2', '', '2009-08-09 17:57:58', 'STAFF', 'E97399278D'), ('3804', '1', 'SOLVED', '5', '25', '4', 'WEB Mail Doubt', '2009-08-09 10:34:35', '2', '', '2009-08-26 16:45:18', 'STAFF', '37968AD196'), ('3805', '2', 'SOLVED', '4', '26', '5', 'Peripheral Doubt', '2009-08-09 10:45:35', '2', '', '2009-08-09 14:04:20', 'STAFF', '98CAC9D33A'), ('3806', '1', 'RETURNED', '10', '22', '6', 'Software Doubt', '2009-08-09 06:15:25', '0', '', '2009-08-09 06:15:25', 'CUSTOMER', '5E7264477C'), ('3807', '1', 'REPLIED', '6', '6', '3', 'Sales Doubt', '2009-08-10 12:46:22', '0', '', '2009-08-22 13:43:33', 'STAFF', '43A115CBD6'), ('3808', '1', 'CLOSED', '1', '28', '5', 'Peripheral Doubt', '2009-08-10 06:34:09', '2', '', '2009-08-25 17:12:13', 'STAFF', 'CD8D5260C8'), ('3809', '2', 'SOLVED', '7', '24', '1', 'CRM Application Doubt', '2009-08-10 06:48:48', '4', '', '2009-08-10 16:28:13', 'STAFF', '38EF4B66CB'), ('3810', '2', 'SOLVED', '6', '32', '4', 'WEB Mail Doubt', '2009-08-10 12:48:00', '2', '', '2009-08-21 16:07:22', 'STAFF', '02AE6A786B'), ('3811', '2', 'SOLVED', '5', '22', '5', 'Peripheral Doubt', '2009-08-10 12:32:55', '4', '', '2009-08-24 17:13:38', 'STAFF', '8068FEE5F4'), ('3812', '1', 'CLOSED', '6', '13', '2', 'WEB Site Issue', '2009-08-10 06:19:41', '3', '', '2009-08-10 14:21:26', 'STAFF', '40DBA662FA'), ('3813', '1', 'RETURNED', '1', '5', '5', 'Peripheral Doubt', '2009-08-10 11:19:45', '0', '', '2009-08-10 11:19:45', 'CUSTOMER', '0A49E3C3A0'), ('3814', '1', 'RETURNED', '9', '31', '5', 'Peripheral Doubt', '2009-08-10 12:08:23', '0', '', '2009-08-10 12:08:23', 'CUSTOMER', 'C563C2C394'), ('3815', '2', 'RETURNED', '9', '23', '1', 'CRM Application Issue', '2009-08-10 06:25:40', '0', '', '2009-08-23 10:26:59', 'CUSTOMER', '143758EE65'), ('3816', '1', 'CLOSED', '8', '35', '2', 'WEB Site Issue', '2009-08-10 12:58:14', '3', '', '2009-08-17 18:50:33', 'STAFF', 'C911241D00'), ('3817', '2', 'SOLVED', '8', '8', '6', 'Software Doubt', '2009-08-10 08:45:12', '2', '', '2009-08-12 15:51:33', 'STAFF', 'FA6C94460E'), ('3818', '3', 'UNASSIGNED', '10', '11', '5', 'Peripheral Doubt', '2009-08-10 06:17:48', '0', '', '2009-08-10 06:17:48', 'CUSTOMER', 'B994697479'), ('3819', '1', 'SOLVED', '5', '7', '5', 'Peripheral Issue', '2009-08-10 12:16:28', '3', '', '2009-08-21 14:09:11', 'STAFF', 'EB1848290D'), ('3820', '3', 'REPLIED', '5', '37', '5', 'Peripheral Doubt', '2009-08-10 06:58:13', '0', '', '2009-08-12 16:06:44', 'STAFF', '91E50FE1E3'), ('3821', '2', 'SOLVED', '8', '35', '6', 'Software Issue', '2009-08-10 06:05:13', '4', '', '2009-08-15 15:50:21', 'STAFF', 'C04C19C2C2'), ('3822', '1', 'RETURNED', '9', '8', '2', 'WEB Site Issue', '2009-08-10 06:23:05', '0', '', '2009-08-25 06:08:56', 'CUSTOMER', '0E57098D03'), ('3823', '2', 'CLOSED', '2', '33', '1', 'CRM Application Issue', '2009-08-11 10:15:03', '3', '', '2009-08-15 17:24:17', 'STAFF', 'BCA382C814'), ('3824', '1', 'RETURNED', '1', '32', '5', 'Peripheral Issue', '2009-08-11 10:08:30', '0', '', '2009-08-11 10:08:30', 'CUSTOMER', '6797423391'), ('3825', '1', 'CLOSED', '7', '9', '1', 'CRM Application Doubt', '2009-08-11 12:01:59', '3', '', '2009-08-21 17:33:12', 'STAFF', 'C24FE9F765'), ('3826', '1', 'SOLVED', '4', '11', '2', 'WEB Site Doubt', '2009-08-11 09:14:14', '3', '', '2009-08-20 15:04:49', 'STAFF', 'A292F1C587'), ('3827', '1', 'SOLVED', '9', '17', '6', 'Software Doubt', '2009-08-11 10:42:46', '2', '', '2009-08-19 16:05:38', 'STAFF', 'B5B8C48482'), ('3828', '3', 'REPLIED', '6', '8', '2', 'WEB Site Issue', '2009-08-11 09:50:54', '0', '', '2009-08-16 14:35:19', 'STAFF', '46D3F6029F'), ('3829', '2', 'SOLVED', '9', '17', '6', 'Software Doubt', '2009-08-11 07:54:41', '2', '', '2009-08-17 14:06:26', 'STAFF', 'B7D0858D41'), ('3830', '3', 'RETURNED', '10', '33', '1', 'CRM Application Issue', '2009-08-11 08:45:44', '0', '', '2009-08-11 08:45:44', 'CUSTOMER', 'FCDE14913C'), ('3831', '2', 'SOLVED', '4', '39', '3', 'Sales Doubt', '2009-08-11 08:49:12', '3', '', '2009-08-21 17:34:39', 'STAFF', 'CAC8E13055'), ('3832', '2', 'SOLVED', '10', '36', '6', 'Software Issue', '2009-08-12 07:40:04', '2', '', '2009-08-17 18:29:47', 'STAFF', 'EA9268CB43'), ('3833', '3', 'SOLVED', '9', '36', '1', 'CRM Application Doubt', '2009-08-12 10:48:24', '3', '', '2009-09-02 15:11:38', 'STAFF', '65B1E92C58'), ('3834', '2', 'RETURNED', '4', '1', '3', 'Sales Doubt', '2009-08-12 06:34:04', '0', '', '2009-08-20 09:38:38', 'CUSTOMER', '243BE2818A'), ('3835', '2', 'SOLVED', '3', '8', '2', 'WEB Site Issue', '2009-08-12 11:59:24', '2', '', '2009-08-22 13:23:18', 'STAFF', '1C66F4627F'), ('3836', '1', 'SOLVED', '8', '39', '4', 'WEB Mail Doubt', '2009-08-12 08:24:56', '3', '', '2009-08-30 14:00:18', 'STAFF', '6E2EEC9CA1'), ('3837', '2', 'SOLVED', '6', '37', '5', 'Peripheral Issue', '2009-08-12 09:32:22', '3', '', '2009-08-17 14:30:18', 'STAFF', 'A6ADE5AA93'), ('3838', '2', 'CLOSED', '2', '32', '2', 'WEB Site Issue', '2009-08-12 08:06:12', '3', '', '2009-08-17 15:28:37', 'STAFF', 'F26DF67E81'), ('3839', '1', 'SOLVED', '4', '13', '6', 'Software Doubt', '2009-08-12 12:05:12', '2', '', '2009-08-12 15:44:06', 'STAFF', '9B2F00F373'), ('3840', '2', 'SOLVED', '8', '23', '5', 'Peripheral Issue', '2009-08-12 10:45:13', '3', '', '2009-08-16 16:01:06', 'STAFF', 'DFA037A53E'), ('3841', '1', 'SOLVED', '10', '24', '6', 'Sotfware Issue', '2009-08-12 11:59:42', '4', '', '2009-08-14 17:17:53', 'STAFF', '7DA18D0326'), ('3842', '3', 'RETURNED', '5', '25', '6', 'Sotfware Issue', '2009-08-12 11:42:14', '0', '', '2009-08-16 06:45:35', 'CUSTOMER', '7FA215C9EF'), ('3843', '2', 'RETURNED', '8', '26', '2', 'WEB Site Issue', '2009-08-13 06:56:02', '0', '', '2009-08-20 09:27:48', 'CUSTOMER', '9EAC167EC1'), ('3844', '3', 'SOLVED', '5', '35', '2', 'WEB Site Issue', '2009-08-13 06:38:22', '3', '', '2009-08-15 13:45:24', 'STAFF', '494C08F7A1'), ('3845', '3', 'SOLVED', '5', '31', '4', 'WEB Mail Issue', '2009-08-13 12:32:55', '3', '', '2009-08-20 16:21:23', 'STAFF', 'C6D6445D97'), ('3846', '2', 'REPLIED', '2', '39', '5', 'Peripheral Doubt', '2009-08-13 11:55:02', '0', '', '2009-08-27 13:09:16', 'STAFF', '6236C78E73'), ('3847', '2', 'RETURNED', '7', '38', '6', 'Software Issue', '2009-08-13 09:29:32', '0', '', '2009-08-13 09:29:32', 'CUSTOMER', 'A3048E4731'), ('3848', '2', 'SOLVED', '2', '19', '6', 'Software Issue', '2009-08-13 12:32:14', '3', '', '2009-09-04 13:43:31', 'STAFF', '42C8938E4C'), ('3849', '1', 'RETURNED', '1', '11', '4', 'WEB Mail Issue', '2009-08-15 09:04:36', '0', '', '2009-09-01 10:01:55', 'CUSTOMER', '4F5A97CF06'), ('3850', '2', 'SOLVED', '5', '9', '5', 'Peripheral Doubt', '2009-08-15 09:31:23', '2', '', '2009-08-29 18:36:33', 'STAFF', 'F550E0BA9E'), ('3851', '2', 'CLOSED', '2', '1', '6', 'Software Doubt', '2009-08-15 06:30:41', '1', '', '2009-08-30 13:06:22', 'STAFF', 'DC0439CAEB'), ('3852', '2', 'REPLIED', '8', '1', '6', 'Software Doubt', '2009-08-15 09:11:19', '0', '', '2009-08-27 14:26:25', 'STAFF', '582967E09F'), ('3853', '1', 'SOLVED', '8', '38', '5', 'Peripheral Issue', '2009-08-15 12:11:36', '3', '', '2009-08-17 14:18:07', 'STAFF', 'B9F35816F4'), ('3854', '2', 'CLOSED', '1', '35', '2', 'WEB Site Issue', '2009-08-15 11:17:53', '1', '', '2009-08-22 16:24:57', 'STAFF', '31C0B36AEF'), ('3855', '2', 'SOLVED', '4', '30', '2', 'WEB Site Issue', '2009-08-15 10:23:40', '3', '', '2009-08-16 18:53:31', 'STAFF', 'D58F855FDC'), ('3856', '2', 'CLOSED', '9', '17', '4', 'WEB Mail Doubt', '2009-08-15 08:09:26', '1', '', '2009-08-18 15:53:42', 'STAFF', '4C2E5EAAE9'), ('3857', '3', 'SOLVED', '1', '39', '6', 'Software Doubt', '2009-08-15 07:04:09', '2', '', '2009-08-15 17:41:22', 'STAFF', 'F269CB7796'), ('3858', '2', 'CLOSED', '6', '25', '4', 'WEB Mail Issue', '2009-08-16 10:48:58', '1', '', '2009-09-01 15:48:07', 'STAFF', '50DD7100BC'), ('3859', '3', 'SOLVED', '5', '37', '4', 'WEB Mail Doubt', '2009-08-16 08:18:54', '2', '', '2009-08-24 13:49:39', 'STAFF', '7171E95248'), ('3860', '2', 'UNASSIGNED', '5', '11', '5', 'Peripheral Issue', '2009-08-16 08:59:08', '0', '', '2009-08-16 08:59:08', 'CUSTOMER', '5A5EAB21CA'), ('3861', '3', 'CLOSED', '1', '37', '5', 'Peripheral Doubt', '2009-08-16 09:44:47', '2', '', '2009-08-29 15:57:44', 'STAFF', 'A6197A578F'), ('3862', '3', 'REPLIED', '6', '19', '6', 'Software Issue', '2009-08-16 08:02:26', '0', '', '2009-08-28 16:07:40', 'STAFF', '533FA796B4'), ('3863', '1', 'RETURNED', '6', '31', '6', 'Sotfware Issue', '2009-08-16 07:41:45', '0', '', '2009-08-27 07:15:20', 'CUSTOMER', 'C4D2CE3F3E'), ('3864', '2', 'CLOSED', '6', '33', '5', 'Peripheral Issue', '2009-08-16 10:21:38', '2', '', '2009-08-17 16:56:34', 'STAFF', '4F8BC5AC1D'), ('3865', '2', 'UNASSIGNED', '9', '28', '5', 'Peripheral Issue', '2009-08-16 09:55:00', '0', '', '2009-08-16 09:55:00', 'CUSTOMER', '866D90E092'), ('3866', '2', 'RETURNED', '5', '24', '6', 'Software Issue', '2009-08-16 10:43:14', '0', '', '2009-08-16 10:43:14', 'CUSTOMER', 'A9DF2255AD'), ('3867', '3', 'SOLVED', '10', '24', '1', 'CRM Application Issue', '2009-08-16 07:53:46', '2', '', '2009-08-27 13:53:14', 'STAFF', '8E54D6B523'), ('3868', '2', 'SOLVED', '10', '37', '4', 'WEB Mail Doubt', '2009-08-17 09:34:45', '4', '', '2009-08-19 16:38:08', 'STAFF', '70162FE655'), ('3869', '1', 'RETURNED', '5', '22', '2', 'WEB Site Issue', '2009-08-17 12:02:12', '0', '', '2009-08-28 07:52:05', 'CUSTOMER', '2C620A8C23'), ('3870', '1', 'SOLVED', '8', '20', '4', 'WEB Mail Doubt', '2009-08-17 08:11:30', '2', '', '2009-08-26 13:07:46', 'STAFF', 'C255C05246'), ('3871', '2', 'REPLIED', '1', '19', '5', 'Peripheral Doubt', '2009-08-17 10:57:40', '0', '', '2009-09-01 18:34:16', 'STAFF', '551CB238F4'), ('3872', '1', 'RETURNED', '4', '35', '4', 'WEB Mail Issue', '2009-08-17 09:16:50', '0', '', '2009-08-17 09:16:50', 'CUSTOMER', 'D35B05A832'), ('3873', '2', 'SOLVED', '6', '17', '6', 'Software Issue', '2009-08-17 07:28:43', '2', '', '2009-08-28 17:54:39', 'STAFF', 'DB346CCB62'), ('3874', '2', 'SOLVED', '7', '19', '1', 'CRM Application Issue', '2009-08-17 11:20:18', '3', '', '2009-08-21 18:41:56', 'STAFF', '2ED80F6311'), ('3875', '1', 'SOLVED', '5', '9', '3', 'Sales Issue', '2009-08-17 06:30:04', '3', '', '2009-09-06 17:30:02', 'STAFF', 'CCC81A97C1'), ('3876', '2', 'SOLVED', '5', '13', '1', 'CRM Application Doubt', '2009-08-17 07:18:19', '4', '', '2009-08-29 13:06:07', 'STAFF', '834A3BD235'), ('3877', '2', 'SOLVED', '1', '36', '5', 'Peripheral Issue', '2009-08-17 08:26:19', '2', '', '2009-09-01 15:07:35', 'STAFF', '8D9A6E908E'), ('3878', '2', 'SOLVED', '10', '23', '6', 'Sotfware Issue', '2009-08-17 12:38:03', '3', '', '2009-08-18 13:58:38', 'STAFF', '9854D7AFCE'), ('3879', '2', 'SOLVED', '3', '14', '2', 'WEB Site Doubt', '2009-08-17 09:26:04', '4', '', '2009-08-29 17:09:35', 'STAFF', 'CC58F7ABF0'), ('3880', '1', 'CLOSED', '1', '36', '6', 'Software Issue', '2009-08-17 12:40:39', '3', '', '2009-08-21 18:19:22', 'STAFF', '0DD1BC593A'), ('3881', '3', 'REPLIED', '4', '20', '2', 'WEB Site Doubt', '2009-08-17 09:21:27', '0', '', '2009-08-28 18:52:44', 'STAFF', 'A1C5AFF967'), ('3882', '3', 'RETURNED', '6', '10', '6', 'Software Doubt', '2009-08-17 10:55:58', '0', '', '2009-08-17 10:55:58', 'CUSTOMER', 'DF42E2244C'), ('3883', '1', 'SOLVED', '5', '7', '5', 'Peripheral Issue', '2009-08-17 07:37:31', '3', '', '2009-08-23 14:51:59', 'STAFF', '51F3EB940F'), ('3884', '3', 'CLOSED', '6', '37', '4', 'WEB Mail Doubt', '2009-08-18 10:31:33', '3', '', '2009-08-22 18:54:59', 'STAFF', '8DCF2420E7'), ('3885', '2', 'SOLVED', '1', '37', '4', 'WEB Mail Issue', '2009-08-18 06:47:05', '2', '', '2009-08-23 13:02:42', 'STAFF', '311ABB492A'), ('3886', '2', 'SOLVED', '10', '6', '4', 'WEB Mail Doubt', '2009-08-18 07:53:22', '3', '', '2009-08-21 18:31:07', 'STAFF', '5DB60C9820'), ('3887', '2', 'RETURNED', '10', '18', '5', 'Peripheral Doubt', '2009-08-18 09:39:53', '0', '', '2009-08-30 06:17:19', 'CUSTOMER', '9649DEC619'), ('3888', '1', 'RETURNED', '8', '28', '4', 'WEB Mail Doubt', '2009-08-18 09:24:33', '0', '', '2009-09-03 06:45:04', 'CUSTOMER', '97250EB325'), ('3889', '1', 'SOLVED', '7', '35', '1', 'CRM Application Doubt', '2009-08-18 12:20:58', '3', '', '2009-08-25 13:03:34', 'STAFF', '86098EF82C'), ('3890', '3', 'SOLVED', '9', '40', '4', 'WEB Mail Doubt', '2009-08-18 12:18:52', '3', '', '2009-08-22 17:20:11', 'STAFF', 'CBFE568136'), ('3891', '2', 'SOLVED', '2', '19', '2', 'WEB Site Issue', '2009-08-18 09:14:46', '4', '', '2009-08-29 15:53:04', 'STAFF', 'C2C2A04512'), ('3892', '2', 'UNASSIGNED', '6', '33', '5', 'Peripheral Issue', '2009-08-18 10:06:40', '0', '', '2009-08-18 10:06:40', 'CUSTOMER', 'FB0650FF38'), ('3893', '1', 'RETURNED', '6', '15', '5', 'Peripheral Issue', '2009-08-18 08:12:15', '0', '', '2009-08-18 08:12:15', 'CUSTOMER', 'E8D66338FA'), ('3894', '2', 'SOLVED', '9', '6', '4', 'WEB Mail Doubt', '2009-08-18 10:35:57', '3', '', '2009-08-29 13:54:40', 'STAFF', '5C8E07660E'), ('3895', '2', 'RETURNED', '1', '16', '5', 'Peripheral Doubt', '2009-08-18 07:46:54', '0', '', '2009-08-18 07:46:54', 'CUSTOMER', 'EE18846393'), ('3896', '3', 'SOLVED', '9', '10', '5', 'Peripheral Issue', '2009-08-18 08:17:40', '4', '', '2009-09-02 17:31:30', 'STAFF', '4175F2EBB2'), ('3897', '2', 'RETURNED', '10', '35', '2', 'WEB Site Issue', '2009-08-19 07:14:02', '0', '', '2009-08-24 09:35:43', 'CUSTOMER', 'B957D47523'), ('3898', '1', 'RETURNED', '1', '31', '2', 'WEB Site Issue', '2009-08-19 10:51:55', '0', '', '2009-08-30 10:16:46', 'CUSTOMER', '37DB6BB5F1'), ('3899', '2', 'REPLIED', '1', '27', '4', 'WEB Mail Issue', '2009-08-19 06:02:34', '0', '', '2009-08-20 18:41:01', 'STAFF', 'FD5AC6CE50'), ('3900', '3', 'SOLVED', '1', '37', '6', 'Software Doubt', '2009-08-19 09:17:09', '3', '', '2009-08-28 14:08:13', 'STAFF', '4837BA5CD4'), ('3901', '2', 'SOLVED', '10', '22', '4', 'WEB Mail Doubt', '2009-08-19 08:59:36', '2', '', '2009-08-29 15:50:03', 'STAFF', '4FC848051E'), ('3902', '1', 'SOLVED', '10', '26', '5', 'Peripheral Doubt', '2009-08-19 08:43:35', '3', '', '2009-08-24 17:22:29', 'STAFF', '1517C8664B'), ('3903', '2', 'RETURNED', '10', '20', '6', 'Software Doubt', '2009-08-19 06:45:45', '0', '', '2009-08-23 10:15:20', 'CUSTOMER', '9D949C3D8B'), ('3904', '2', 'RETURNED', '3', '12', '5', 'Peripheral Doubt', '2009-08-19 06:33:43', '0', '', '2009-08-29 06:31:54', 'CUSTOMER', 'C09F9CAF5E'), ('3905', '2', 'CLOSED', '6', '27', '4', 'WEB Mail Doubt', '2009-08-19 08:38:23', '1', '', '2009-08-30 15:34:25', 'STAFF', '63154D5661'), ('3906', '1', 'SOLVED', '10', '17', '2', 'WEB Site Issue', '2009-08-19 11:06:45', '3', '', '2009-09-03 16:07:07', 'STAFF', 'E593C56235'), ('3907', '3', 'SOLVED', '9', '36', '2', 'WEB Site Issue', '2009-08-20 08:03:15', '2', '', '2009-08-22 15:20:18', 'STAFF', '3341F6F048'), ('3908', '1', 'CLOSED', '1', '8', '5', 'WEB Mail Doubt', '2009-08-20 10:53:45', '0', '', '2010-03-25 11:17:07', 'STAFF', '576D026223'), ('3909', '1', 'REPLIED', '6', '21', '2', 'WEB Site Issue', '2009-08-20 06:07:03', '0', '', '2009-08-22 18:54:25', 'STAFF', '4175A4B46A'), ('3910', '1', 'SOLVED', '5', '5', '3', 'Sales Doubt', '2009-08-20 12:41:25', '4', '', '2009-08-21 17:34:01', 'STAFF', '1BE883EEC3'), ('3911', '2', 'SOLVED', '8', '37', '4', 'WEB Mail Doubt', '2009-08-20 06:35:30', '3', '', '2009-08-22 13:44:29', 'STAFF', '1BF50AAF14'), ('3912', '3', 'CLOSED', '7', '10', '2', 'WEB Site Issue', '2009-08-20 06:42:36', '3', '', '2009-08-23 16:44:30', 'STAFF', '27B587BBE8'), ('3913', '1', 'SOLVED', '2', '26', '6', 'Software Doubt', '2009-08-21 09:52:46', '4', '', '2009-09-09 16:24:12', 'STAFF', 'B085C4FA54'), ('3914', '3', 'CLOSED', '9', '23', '5', 'Peripheral Issue', '2009-08-22 12:49:06', '1', '', '2009-08-22 18:17:44', 'STAFF', 'B85D65C39E'), ('3915', '2', 'SOLVED', '10', '9', '5', 'Peripheral Issue', '2009-08-22 11:19:19', '3', '', '2009-08-26 16:53:14', 'STAFF', '39539F630A'), ('3916', '1', 'RETURNED', '1', '25', '5', 'Peripheral Issue', '2009-08-22 11:14:34', '0', '', '2009-08-28 07:34:18', 'CUSTOMER', '49CBB75927'), ('3917', '2', 'CLOSED', '2', '25', '5', 'Peripheral Doubt', '2009-08-22 07:39:59', '2', '', '2009-08-28 13:07:18', 'STAFF', '4D95D05A4F'), ('3918', '1', 'SOLVED', '4', '5', '4', 'WEB Mail Doubt', '2009-08-22 07:15:39', '3', '', '2009-08-23 16:17:46', 'STAFF', '859B00AEC8'), ('3919', '1', 'SOLVED', '1', '22', '3', 'Sales Doubt', '2009-08-22 11:14:09', '4', '', '2009-09-05 13:08:25', 'STAFF', '5FC7C9BD1F'), ('3920', '2', 'SOLVED', '4', '30', '4', 'WEB Mail Issue', '2009-08-22 10:08:21', '4', '', '2009-09-12 13:47:59', 'STAFF', 'D6525AA863'), ('3921', '3', 'SOLVED', '9', '38', '2', 'WEB Site Issue', '2009-08-22 12:50:32', '2', '', '2009-09-09 18:17:16', 'STAFF', '9B8F0779BA'), ('3922', '1', 'SOLVED', '3', '23', '6', 'Software Doubt', '2009-08-22 11:32:04', '3', '', '2009-08-22 14:09:39', 'STAFF', 'D90E5B6628'), ('3923', '1', 'REPLIED', '5', '5', '2', 'WEB Site Doubt', '2009-08-22 10:48:23', '0', '', '2009-08-30 18:42:50', 'STAFF', '97F081D3B1'), ('3924', '2', 'CLOSED', '4', '35', '4', 'WEB Mail Issue', '2009-08-23 07:38:13', '3', '', '2009-08-29 18:24:22', 'STAFF', '943B5FD1EF'), ('3925', '2', 'RETURNED', '9', '33', '6', 'Software Doubt', '2009-08-23 09:01:28', '0', '', '2009-09-01 06:02:48', 'CUSTOMER', '1340CCF247'), ('3926', '2', 'SOLVED', '3', '17', '6', 'Software Issue', '2009-08-23 08:34:54', '3', '', '2009-08-26 18:58:59', 'STAFF', '4FC28B7093'), ('3927', '2', 'SOLVED', '7', '35', '4', 'WEB Mail Doubt', '2009-08-23 06:41:31', '4', '', '2009-08-23 18:32:29', 'STAFF', 'D2DC636883'), ('3928', '3', 'RETURNED', '1', '1', '1', 'CRM Application Doubt', '2009-08-23 09:03:41', '0', '', '2009-09-03 11:39:15', 'CUSTOMER', '1597D21403'), ('3929', '2', 'SOLVED', '1', '22', '6', 'Software Issue', '2009-08-23 09:03:57', '3', '', '2009-08-30 16:34:14', 'STAFF', '79F6923035'), ('3930', '1', 'RETURNED', '10', '37', '4', 'WEB Mail Issue', '2009-08-23 08:49:12', '0', '', '2009-09-04 11:12:55', 'CUSTOMER', '679D8BBD77'), ('3931', '3', 'CLOSED', '9', '27', '5', 'Peripheral Issue', '2009-08-23 11:46:22', '3', '', '2009-08-23 17:35:25', 'STAFF', 'ACFF1AF62D'), ('3932', '2', 'REPLIED', '1', '15', '6', 'Software Doubt', '2009-08-23 07:03:49', '0', '', '2012-05-11 02:38:07', 'STAFF', 'C56A022B15'), ('3933', '2', 'UNASSIGNED', '8', '33', '1', 'CRM Application Doubt', '2009-08-23 11:03:03', '0', '', '2009-08-23 11:03:03', 'CUSTOMER', '298F587406'), ('3934', '2', 'SOLVED', '8', '33', '2', 'WEB Site Issue', '2009-08-23 12:53:46', '4', '', '2009-09-02 15:04:38', 'STAFF', 'F8F122D50E'), ('3935', '1', 'CLOSED', '8', '39', '2', 'WEB Site Issue', '2009-08-23 06:34:13', '3', '', '2009-08-25 15:18:19', 'STAFF', '13E36F06C6'), ('3936', '1', 'CLOSED', '5', '35', '2', 'WEB Site Issue', '2009-08-23 08:10:28', '3', '', '2009-09-04 13:59:53', 'STAFF', '70FC5F0432'), ('3937', '2', 'SOLVED', '1', '31', '5', 'Peripheral Issue', '2009-08-23 09:58:38', '2', '', '2009-08-28 15:02:24', 'STAFF', '3948684564'), ('3938', '2', 'SOLVED', '2', '15', '3', 'Sales Doubt', '2009-08-24 08:24:51', '2', '', '2009-09-02 14:04:21', 'STAFF', '74C407E263'), ('3939', '2', 'RETURNED', '5', '36', '6', 'Software Doubt', '2009-08-24 10:25:55', '0', '', '2009-08-24 10:25:55', 'CUSTOMER', 'E5AFB0F2DB'), ('3940', '1', 'SOLVED', '10', '5', '5', 'Peripheral Issue', '2009-08-24 10:49:13', '2', '', '2009-09-03 17:44:07', 'STAFF', '3FA146219C'), ('3941', '2', 'SOLVED', '2', '18', '6', 'Software Doubt', '2009-08-24 12:44:26', '2', '', '2009-09-04 17:56:46', 'STAFF', '29E1C59BE1'), ('3942', '2', 'CLOSED', '1', '2', '6', 'Software Issue', '2009-08-24 06:04:49', '1', '', '2009-09-10 15:31:04', 'STAFF', 'EC36E2BA64'), ('3943', '3', 'SOLVED', '6', '17', '1', 'CRM Application Issue', '2009-08-24 08:38:53', '3', '', '2009-08-28 18:34:14', 'STAFF', 'DA21BAE82C'), ('3944', '2', 'SOLVED', '2', '11', '5', 'Peripheral Doubt', '2009-08-24 10:15:29', '4', '', '2009-08-25 18:38:19', 'STAFF', 'F9FE83F1EA'), ('3945', '2', 'SOLVED', '5', '22', '5', 'Peripheral Doubt', '2009-08-24 11:51:51', '4', '', '2009-09-02 14:34:35', 'STAFF', 'C3810D4A95'), ('3946', '1', 'SOLVED', '2', '20', '4', 'WEB Mail Issue', '2009-08-24 12:08:22', '3', '', '2009-09-01 16:58:47', 'STAFF', '71A8B2FFE0'), ('3947', '3', 'SOLVED', '2', '7', '3', 'Sales Doubt', '2009-08-24 09:19:43', '4', '', '2009-08-27 14:32:16', 'STAFF', 'DA4F21D00B'), ('3948', '2', 'SOLVED', '5', '11', '2', 'WEB Site Issue', '2009-08-24 12:02:28', '2', '', '2009-08-25 14:20:38', 'STAFF', '6DF1825827'), ('3949', '3', 'REPLIED', '10', '40', '6', 'Software Issue', '2009-08-25 09:49:44', '0', '', '2009-08-27 16:33:01', 'STAFF', '2E5C2CB8D1'), ('3950', '2', 'REPLIED', '10', '7', '3', 'Sales Issue', '2009-08-25 11:34:17', '0', '', '2009-09-15 14:34:38', 'STAFF', 'BB702465F3'), ('3951', '1', 'CLOSED', '2', '10', '4', 'WEB Mail Issue', '2009-08-25 12:26:30', '3', '', '2009-09-08 18:58:56', 'STAFF', '7F278AD602'), ('3952', '3', 'UNASSIGNED', '9', '9', '3', 'Sales Doubt', '2009-08-25 11:13:19', '0', '', '2009-08-25 11:13:19', 'CUSTOMER', 'AF8D9C4E23'), ('3953', '2', 'SOLVED', '7', '1', '6', 'Software Issue', '2009-08-25 09:04:13', '4', '', '2009-08-29 16:31:53', 'STAFF', 'B928FEC593'), ('3954', '2', 'RETURNED', '10', '31', '4', 'WEB Mail Doubt', '2009-08-25 06:16:51', '0', '', '2009-09-05 10:23:54', 'CUSTOMER', '6E2D5D50A9'), ('3955', '2', 'SOLVED', '1', '22', '6', 'Software Doubt', '2009-08-25 10:47:20', '4', '', '2009-09-04 14:45:59', 'STAFF', '3F900DB260'), ('3956', '2', 'RETURNED', '3', '11', '4', 'WEB Mail Doubt', '2009-08-25 08:20:16', '0', '', '2009-09-03 07:02:55', 'CUSTOMER', '0F3C5D0C36'), ('3957', '1', 'RETURNED', '3', '21', '6', 'Sotfware Issue', '2009-08-25 11:11:45', '0', '', '2009-09-01 11:12:50', 'CUSTOMER', '86C5167835'), ('3958', '2', 'SOLVED', '2', '8', '6', 'Software Doubt', '2009-08-25 11:28:00', '4', '', '2009-08-25 13:00:29', 'STAFF', 'BF5CD8B250'), ('3959', '2', 'SOLVED', '9', '31', '3', 'Sales Doubt', '2009-08-25 11:52:57', '3', '', '2009-09-03 18:31:18', 'STAFF', '806D926414');
INSERT INTO `ticket` VALUES ('3960', '2', 'SOLVED', '10', '38', '4', 'WEB Mail Issue', '2009-08-26 09:11:47', '2', '', '2009-08-29 14:29:20', 'STAFF', 'AC52C626AF'), ('3961', '2', 'SOLVED', '8', '28', '4', 'WEB Mail Issue', '2009-08-26 07:32:31', '2', '', '2009-09-10 15:43:55', 'STAFF', '24E01830D2'), ('3962', '2', 'RETURNED', '5', '1', '5', 'Peripheral Issue', '2009-08-26 08:22:14', '0', '', '2009-10-29 15:21:48', 'CUSTOMER', '6F611188AD'), ('3963', '2', 'SOLVED', '8', '31', '3', 'Sales Doubt', '2009-08-26 09:41:07', '3', '', '2009-09-04 13:39:10', 'STAFF', 'F51238CD02'), ('3964', '3', 'SOLVED', '2', '15', '5', 'Peripheral Doubt', '2009-08-26 08:07:27', '3', '', '2009-08-26 15:07:36', 'STAFF', 'DD50E4D9C4'), ('3965', '1', 'SOLVED', '7', '39', '5', 'Peripheral Issue', '2009-08-26 10:14:06', '3', '', '2009-09-01 16:47:22', 'STAFF', 'DB9AD56C71'), ('3966', '2', 'SOLVED', '9', '11', '1', 'CRM Application Issue', '2009-08-26 12:42:01', '4', '', '2009-09-10 15:25:24', 'STAFF', '43D762CA73'), ('3967', '2', 'SOLVED', '7', '5', '6', 'Software Issue', '2009-08-26 08:20:27', '3', '', '2009-09-04 16:17:11', 'STAFF', 'B607BA543A'), ('3968', '2', 'SOLVED', '5', '32', '1', 'CRM Application Doubt', '2009-08-26 07:46:02', '4', '', '2009-09-10 16:12:20', 'STAFF', '0CBED40C0D'), ('3969', '2', 'SOLVED', '3', '24', '1', 'CRM Application Issue', '2009-08-26 11:42:41', '3', '', '2009-09-04 17:31:21', 'STAFF', 'F81DEE4258'), ('3970', '1', 'SOLVED', '4', '11', '3', 'Sales Doubt', '2009-08-26 12:16:52', '4', '', '2009-08-29 18:46:06', 'STAFF', '11BCD3C1D4'), ('3971', '2', 'CLOSED', '4', '38', '6', 'Software Issue', '2009-08-29 07:58:38', '3', '', '2009-09-01 15:15:28', 'STAFF', 'CBA0A4EE5C'), ('3972', '2', 'SOLVED', '2', '37', '4', 'WEB Mail Doubt', '2009-08-29 08:08:35', '4', '', '2009-09-02 13:08:46', 'STAFF', 'F2E84D98D6'), ('3973', '2', 'RETURNED', '4', '24', '6', 'Software Doubt', '2009-08-29 06:09:13', '0', '', '2009-09-11 10:07:38', 'CUSTOMER', '678004486C'), ('3974', '3', 'CLOSED', '10', '25', '2', 'WEB Site Issue', '2009-08-29 09:32:28', '1', '', '2009-09-05 14:44:59', 'STAFF', '9A32FF36C6'), ('3975', '1', 'SOLVED', '3', '12', '5', 'Peripheral Issue', '2009-08-29 09:05:51', '4', '', '2009-09-04 16:27:22', 'STAFF', '4F5A9BF135');

-- ----------------------------
-- Table structure for `ticket_email_tpl`
-- ----------------------------

create table `ticket_email_tpl` (
  `ticketlanguage` varchar(30) not null,
  `usertype` int(11) not null,
  `statusid` varchar(30) not null,
  `title` varchar(100) default null,
  `content` longtext,
  `enabled` char(1) default null,
  primary key (`ticketlanguage`,`usertype`,`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ticket_email_tpl
-- ----------------------------
INSERT INTO `ticket_email_tpl` VALUES ('en_us;en_us', '1', 'CLOSED', 'Ticket Closed', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#FF6600><span class=style1><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff;> <h2>ScriptCase Tickets System </h2></span></span></td><td width=236 bgcolor=#FF6600> </td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br />Dear: <strong>@@##CustomerName##@@</strong><br /><br />  This ticket is now closed. <br /> This is an automatic ticket message, please do not reply it. <em>.</em></span></td></tr><tr><td colspan=2 align=left valign=top><span style=font-family: Arial,Helvetica,sans-serif; color: colspan=2 align=left valign=top>     <p><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #666666;><br/></span></strong></p></td>   </tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@</td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color:bellow: </span></td></tr><tr><td colspan=2>       <div><span style=font-family: Arial,Helvetica,sans-serif; color: #000099; font-size:x-small;>@@##TrackingLink##@@ </span></div></td>     </tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bgcolor=#FF6600> </td></tr></tbody></table></td>       </tr></table></td>     </tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'CONFIRMATION', 'Confirmation', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bordercolor=#FF6600 bgcolor=#FF6600><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;><span style=font-size: medium;>  <h3>ScriptCase Tickets System</h3></span> </span></strong></td><td width=236 bordercolor=#FF6600 bgcolor=#FF6600> </td></tr><tr><td colspan=2><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;>Dear @@##CustomerName##@@, please click on the link bellow to confirm your account creation:</span></p><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br />  @@##ActivationLink##@@ <br /> </span></p></td></tr><tr><td align=left valign=top></td><td align=left valign=top></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;> </span></td></tr><tr><td colspan=2><div><span style=font-family: Arial,Helvetica,sans-serif; color: #000099; font-size: x-small;> </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bordercolor=#FF6600 bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bordercolor=#FF6600 bgcolor=#FF6600></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'FORGETPWD', 'Forget Password', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#FF6600><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><span style=font-size: medium;>ScriptCase Tickets System</span> </span></strong></td><td width=236 bgcolor=#FF6600> </td></tr><tr><td colspan=2><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>Dear @@##CustomerName##@@, as requested, your account info:</span></p><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>User: @@##CustomerEmail##@@<br />Password: @@##CustomerPassword##@@ <br /></span></p><p> </p></td></tr><tr><td align=left valign=top> </td><td align=left valign=top> </td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2> </td></tr><tr><td colspan=2></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#FF6600> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'FORGETTRACK', 'Your open tickets', '<table border=0 width=600px cellpadding=10 bgcolor=#fafaf8 ><tbody><tr><td><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#FF6600><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;><span style=font-size: medium;>ScriptCase Tickets System</span> </span></strong></td></tr><tr><td><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br> Dear <strong>@@##CustomerName##@@ </strong><br></span></p></td></tr><tr><td align=left valign=top><span style=font-family: Arial, Helvetica, sans-serif; color: #006666; font-size: small;><br> Those are your open tickets. </span></td></tr><tr><td><div><span style=font-family: Arial,Helvetica,sans-serif; color: #000099; font-size: x-small;> </span><span style=font-family: Courier New, Courier, monospace; color: #006666; font-size: small;><br> @@##CustomerOpennedTicketsList##@@</span><br></div></td></tr><tr><td><table border=0 cellspacing=0 width=100%><tbody><tr><td bordercolor=#FF9900 bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bgcolor=#FF6600> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'REPLIED', 'Ticket Replied', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#ff6600><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><h3>ScriptCase Tickets System</h3></span></strong></td><td width=236 bgcolor=#ff6600> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>Dear: <strong>@@##CustomerName##@@</strong><br /><br />Your ticket was replied, see the reply bellow.<br />This is an automatic confirmation message, please do not reply it. <br /><br />You can track this ticket using the number: <strong>@@##TrackingID##@@</strong></span></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@<br /></td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>You can track this ticket using the link bellow: </span></td></tr><tr><td colspan=2><div><span style=font-size: x-small; color: #000099; font-family: Arial, Helvetica, sans-serif;>@@##TrackingLink##@@ </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td width=94% bgcolor=#ff6600><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td width=6% bgcolor=#ff6600> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'RETURNED', 'Ticket Returned', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#FF6600><font face=Arial, Helvetica, sans-serif color=#FFFFFF><h3>ScriptCase Tickets System</h3></font></td><td width=236 bgcolor=#FF6600><div><span style=font-size: small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><br /><strong></strong></span></div></td></tr><tr><td colspan=2><p><span style=font-size: small; color: #008080; font-family: Arial,Helvetica,sans-serif;>Dear: <strong>@@##CustomerName##@@</strong></span></p><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>Ticket returned successfully.<br />This is an automatic message, please do not reply it. <br /> Your request will be handled <em>asap.</em></span><br></p></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br> Tracking ID: <strong><font color=#666666>@@##TrackingID##@@</font></strong></span></p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@</td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br> You can track this ticket using the link bellow: </span></td></tr><tr><td colspan=2><div><span style=font-size: x-small; color: #000099; font-family: Arial,Helvetica,sans-serif;>@@##TrackingLink##@@ </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#FF6600> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '1', 'UNASSIGNED', 'Ticket Submitted', '<table width=597 border=0 cellpadding=10 bgcolor=#FAFAF8> <tr> <td><table width=573 border=0 cellspacing=0 > <tr> <td width=311 nowrap bgcolor=#FF6600><strong><font face=Arial, Helvetica, sans-serif color=#FFFFFF><h3>ScriptCase Tickets System </h3></font></strong></td> <td width=258 bgcolor=#FF6600><div align=right></div></td> </tr> <tr> <td colspan=2><font face=Arial, Helvetica, sans-serif color=#006666 size=3>Dear: <strong>@@##CustomerName##@@</strong></font><font face=Arial, Helvetica, sans-serif color=#006666 size=3><br> <br> Your support ticket<strong><font color=#666666> </font></strong>has been submitted. We try to reply to all tickets as soon as possible, usually within 24 hours.<br> <br> </font></td> </tr> <tr> <td colspan=2 align=left valign=top><font face=Arial, Helvetica, sans-serif color=#006666 size=3>Your tracking ID: <strong>@@##TrackingID##@@<br> <br> </strong></font></td> </tr> <tr> <td colspan=2 align=left valign=top bgcolor=#EEF7D5><div align=justify> <p>@@##TicketMessage##@@<br> </p> </div></td> </tr><tr> <td colspan=2><font face=Arial, Helvetica, sans-serif color=#006666 size=3>You can view the status of your ticket using the link bellow: </font></td> </tr><tr> <td colspan=2><div align=left><font face=Arial, Helvetica, sans-serif color=#000099 size=2>@@##TrackingLink##@@ </font></div></td> </tr> <tr><td COLSPAN=2><table cellspacing=0 width=100%><tr> <td bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><font color=#FFFFFF size=2 face=Arial, Helvetica, sans-serif>www.scriptcase.net</font></a></td> <td bgcolor=#FF6600><div align=right></div></td></tr></table></td> </tr> </table></td></tr></table>', 'Y'), ('en_us;en_us', '2', 'ASSIGNED', 'Ticket Forwarded', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><h3>ScriptCase Tickets System </h3></span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br />A ticket opened by the customer <strong> @@##CustomerName##@@</strong> was forwarded to you by the operator <strong>@@##StaffName##@@</strong>. Please answer this request as soon as possible! <br /><br />This is an automatic message, please do not reply it. <br /></span></td></tr><tr><td colspan=2 align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>Tracking ID: <strong><font color=#666666>@@##TrackingID##@@</font></strong></span></td></tr><tr><td colspan=2 align=left valign=top><p> </p><p> </p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial,Helvetica,sans-serif;><strong></strong></span><div><p>@@##TicketMessage##@@</p></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '2', 'CLOSED', 'Ticket Closed', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><span style=color: #ffffff;><span class=style1><font face=Arial,Helvetica,sans-serif><h3>ScriptCase Tickets System</h3></font></span></span></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><p style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>Ticket Closed.<br /> This ticket was closed by the customer : <strong>@@##CustomerName##@@</strong><br /> <br>  This is an automatic ticket message, please do not reply it. <em>.</em></p> </td></tr><tr><td colspan=2 align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br />Tracking ID: <strong><font color=#666666>@@##TrackingID##@@</font></strong></span></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@</td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '2', 'FORGETPWD', 'Forget Password', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;><span style=font-size: medium;><h3>ScriptCase Tickets System</h3></span> </span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;>Dear @@##StaffName##@@, as requested, your account info:</span></p><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;>User: @@##StaffEmail##@@<br />Password: @@##StaffPassword##@@ <br /> </span></p></td></tr><tr><td align=left valign=top></td><td align=left valign=top></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;> </span></td></tr><tr><td colspan=2><div><span style=font-family: Arial,Helvetica,sans-serif; color: #000099; font-size: x-small;> </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bgcolor=#009933></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('en_us;en_us', '2', 'RETURNED', 'Ticket Returned', '<table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><font size=4><h3>ScriptCase Tickets System</h3></font> </span></strong></td><td width=236 bgcolor=#009933><div><span style=font-size: small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><br /><strong></strong></span></div></td></tr><tr><td colspan=2><p><span style=font-size: small; color: #008080; font-family: Arial,Helvetica,sans-serif;>The customer <strong>@@##CustomerName##@@</strong></span><span class=style1> </span><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>returned this ticket to support. <br /> This is an automatic message, please do not reply it. <br /> </span></p></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;>Tracking ID: <strong><font color=#666666>@@##TrackingID##@@</font></strong></span> </p><strong></strong></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@</td></tr><tr><td colspan=2><div></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr>', 'Y'), ('en_us;en_us', '2', 'UNASSIGNED', 'Ticket Submitted', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><font face=Arial, Helvetica, sans-serif color=#FFFFFF> <h3>ScriptCase Tickets System</h3></font></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br /> The customer <strong>@@##CustomerName##@@</strong></span><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;> </span><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;>submited a new ticket. <br /> <br /> This is an automatic message, please do not reply it. <br /> </span></td></tr><tr><td colspan=2 align=left valign=top><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br /> TrackingID :</span><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #666666;>@@##TrackingID##@@</span></strong><br /></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-family: Arial,Helvetica,sans-serif;>@@##TicketMessage##@@</span></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '1', 'CLOSED', 'Billete Cerrado.', '<style type=text/css><!--.style2 {color: #006666}--></style><table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#ff3300><span style=color: #ffffff;><span class=style1><span style=font-family: Arial,Helvetica,sans-serif;><span style=font-size: medium;><h2>ScriptCase Tickets System</h2></span> </span></span></span></td><td width=236 bgcolor=#ff3300> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><span style=font-size: 12pt; color: black; line-height: 115%; font-family:  lang=ES>Estimado</span>: <strong>@@##CustomerName##@@</strong><br /><br />Billete cerrado.<br /> �ste es un mensaje autom�tico, por favor, no responder. </span></td></tr><tr><td colspan=2 align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br />Su seguimiento ID<span class=style2>: <strong>@@##TrackingID##@@ </strong></span><strong><span style=color: #666666;><table border=0 cellspacing=0 width=573><tbody><tr><td colspan=2 align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><strong></strong></span></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><br /></span></p></td></tr></tbody></table></span></strong></span></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial,Helvetica,sans-serif;><strong><br /></strong></span><div>@@##TicketMessage##@@</div></td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><br /><span style=color: #000000;>Puede realizar el seguimiento de este billete a trav�s del v�nculo de abajo:</span> </span></td></tr><tr><td colspan=2><div><span style=font-size: x-small; color: #000099; font-family: Arial,Helvetica,sans-serif;>@@##TrackingLink##@@ </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#ff3300><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#ff3300> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '1', 'CONFIRMATION', 'Confirmacion', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bordercolor=#FF6600 bgcolor=#FF6600><strong><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;><span style=font-size: medium;>  <h3>ScriptCase Tickets System</h3></span> </span></strong></td><td width=236 bordercolor=#FF6600 bgcolor=#FF6600> </td></tr><tr><td colspan=2><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;>Estimado @@##CustomerName##@@, por favor haga clic en el enlace abajo para confirmar la creaci&oacute;n de su cuenta: </span></p><p><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;><br />  @@##ActivationLink##@@ <br /> </span></p></td></tr><tr><td align=left valign=top></td><td align=left valign=top></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2><span style=font-family: Arial,Helvetica,sans-serif; color: #006666; font-size: small;> </span></td></tr><tr><td colspan=2><div><span style=font-family: Arial,Helvetica,sans-serif; color: #000099; font-size: x-small;> </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bordercolor=#FF6600 bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-family: Arial,Helvetica,sans-serif; color: #ffffff; font-size: x-small;>www.scriptcase.net</span></a></td><td bordercolor=#FF6600 bgcolor=#FF6600></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '1', 'FORGETPWD', 'Ha olvidado contrasena', '<table border=0 cellpadding=1 bgcolor=#FFFFFF> <tr> <td><table width=573 border=0 cellpadding=0 cellspacing=0> <tr> <td width=324 bgcolor=#FF6600><font face=Arial, Helvetica, sans-serif color=#FFFFFF> <h3>ScriptCase Tickets System</h3> </font></td> <td width=236 bgcolor=#FF6600></td> </tr> <tr> <td colspan=2><p> <br /> Estimado @@##CustomerName##@@, la informaci�n de su cuenta como solicitado, </p> <p>Usuario: @@##CustomerEmail##@@<br /> Contrase�a : @@##CustomerPassword##@@ <br /> </p> <p> </p></td> </tr> <tr> <td align=left valign=top></td> <td align=left valign=top></td> </tr> <tr> <td colspan=2 align=left valign=top bgcolor=#eef7d5></td> </tr> <tr> <td colspan=2></td> </tr> <tr> <td colspan=2></td> </tr> <tr> <td colspan=2><table border=0 cellspacing=0 width=100%> <tr> <td bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank>www.scriptcase.net</a></td> <td bgcolor=#FF6600></td> </tr> </table></td> </tr> </table></td> </tr></table>', 'Y'), ('es;es_es', '1', 'FORGETTRACK', 'Seus tickets', '<table width=600px border=0 cellpadding=10 cellspacing=0 bgcolor=#fafaf8 > <tr> <td><table border=0 cellspacing=0 width=100%> <tr> <td bgcolor=#FF6600><h3><font color=#FFFFFF>ScriptCase Tickets System </font></h3></td> </tr> <tr> <td><p><br /> <strong>Estimado @@##CustomerName##@@ </strong><br /> </p></td> </tr> <tr> <td align=left valign=top><br /> Those are your open tickets.<br /> Estes son los billetes que est�n abiertas.</td> </tr> <tr> <td><br /> @@##CustomerOpennedTicketsList##@@<br /> </td> </tr> <tr> <td><table border=0 cellspacing=0 width=100%> <tr> <td bordercolor=#FF9900 bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank>www.scriptcase.net</a></td> <td bgcolor=#FF6600> </td> </tr> </table></td> </tr> </table></td> </tr></table>', 'Y'), ('es;es_es', '1', 'REPLIED', 'Billete respondido', '<!--CTYPE HTML PUBLIC -//W3C//DTD HTML 4.01 Transitional//EN http://www.w3.org/TR/html4/loose.dt--> <table border=0 cellpadding=10 bgcolor=#fafaf8> <tbody> <tr> <td> <table border=0 cellspacing=0 width=573> <tbody> <tr> <td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>ScriptCase Tickets System </span></strong></td> <td width=236 bgcolor=#009933> <div><span style=font-size: small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><span style=font-size: 12pt; color: black; line-height: 115%; font-family:  lang=ES>Estimado</span>: <strong>@@##CustomerName##@@</strong></span></div> </td> </tr> <tr> <td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><span style=font-family:  lang=ES><font color=#000000>Su billete fue respondido, por favor lea a continuaci�n la respuesta del operador. <br />�ste es un mensaje autom�tico, por favor, no responder. <br />Su solicitud ser� contestada en breve.</font></span></span></td> </tr> <tr> <td align=left valign=top> <p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>TicketID: <strong><font color=#666666>@@##TicketID##@@</font></strong></span></p> <p> </p> </td> <td align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>Asunto:</span><strong><span style=color: #666666; font-family: Arial, Helvetica, sans-serif;>@@##TicketSubject##@@</span></strong></td> </tr> <tr> <td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong><br /></strong></span> <div> <p>@@##TicketMessage##@@</p> </div> </td> </tr> <tr> <td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><font color=#000000>Para realizar el seguimiento de su billete use el siguiente v�nculo:</font></span></td> </tr> <tr> <td colspan=2> <div><span style=font-size: x-small; color: #000099; font-family: Arial, Helvetica, sans-serif;>@@##TrackingLink##@@ </span></div> </td> </tr> <tr> <td colspan=2> <table border=0 cellspacing=0 width=100%> <tbody> <tr> <td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td> <td bgcolor=#009933> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table>', 'Y'), ('es;es_es', '1', 'RETURNED', 'Billete devuelto', '<style type=text/css><!--.style2 {color: #006666}--></style><table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#FF6600><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;> <h2>ScriptCase Tickets System </h2></span></strong></td><td width=236 bgcolor=#FF6600><div></div></td></tr><tr> <td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;> </span><span style=font-size: small; font-family: Arial, Helvetica, sans-serif;> <div class=style2 id=result_box style=text-align: left; dir=ltr><span style=font-size: small; font-family: Arial, Helvetica, sans-serif;><span style=font-size: 12pt; line-height: 115%; font-family: lang=ES>Estimado</span>: <strong>@@##CustomerName##@@</strong></span><br> <br> Su boleto fue devuelto a lo soporte con �xito. <br /> �ste es un mensaje autom�tico, por favor, no responder. <br />Su solicitud ser� contestada en breve.<br> </div></span></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><br> TicketID: <strong><span style=color: #666666;>@@##TicketID##@@</span></strong></span></p><p> </p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong><br /></strong></span>@@##TicketMessage##@@</td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><span style=color: #000000;>Para realizar el seguimiento de su billete use el siguiente v�nculo:</span></span></td></tr><tr><td colspan=2><div><span style=font-size: x-small; color: #000099; font-family: Arial, Helvetica, sans-serif;>@@##TrackingLink##@@ </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bordercolor=#FF0000 bgcolor=#FF6600><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '1', 'UNASSIGNED', 'Billete Abierto', '<table border=0 cellpadding=10 width=597 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=311 bgcolor=#ff6600><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><h3>ScriptCase Tickets System </h3></span></strong></td><td width=258 bgcolor=#ff6600> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>Estimado: <strong>@@##CustomerName##@@</strong><br /><br />Su billete se ha presentado. Tratamos de responder a todos los billetes lo antes posible, normalmente en 24 horas. </font><br /></span></td></tr><tr><td colspan=2 align=left valign=top><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><br /><font color=#000000>Su seguimiento ID</font>: <strong>@@##TrackingID##@@<br /></strong></span></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong></strong></span><div><p>@@##TicketMessage##@@</p></div></td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><br /><font color=#000000>Puede realizar el seguimiento de este billete a trav�s del v�nculo de abajo:</font></span></td></tr><tr><td colspan=2><div><span style=font-size: x-small; color: #000099; font-family: Arial, Helvetica, sans-serif;>@@##TrackingLink##@@ </span></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#ff6600><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#ff6600> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '2', 'ASSIGNED', 'Billete enviado', '<html><table width=597 border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><h2>ScriptCase Tickets System</h2></span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><p>Un billete abierto por el cliente:<strong> @@##CustomerName##@@</strong><br /> fue remitida a usted por el operador: <strong>@@##StaffName##@@</strong> por favor responda a este mensaje tan pronto como pueda! <br /><br />Este es un mensaje autom�tico, por favor no responder.</p></span></td></tr><tr><td colspan=2 align=left valign=top><p style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;> </p> <p style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>Tracking ID: <strong><font color=#666666>@@##TrackingID##@@</font></strong></p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong></strong></span><div><p>@@##TicketMessage##@@</p><p> </p></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '2', 'CLOSED', 'Billete Cerrado', '<style type=text/css><!--.style2 {color: #006666}--></style><table width=597 border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><h3>ScriptCase Tickets System</h3> </span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><p class=style2><span style=font-size: small; font-family: Arial, Helvetica, sans-serif;>El cliente <span style=font-size: small; font-family: Arial, Helvetica, sans-serif;>Cliente: <strong>@@##CustomerName##@@</strong></span> cerr� �ste billete. </span><span style=font-size: small; font-family: Arial, Helvetica, sans-serif;>�ste es un mensaje autom�tico, por favor, no responder.</span></p></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><br> Tracking ID: <strong><font color=#666666>@@##</font></strong></span><span style=font-size: small; font-family: Arial, Helvetica, sans-serif;><strong><font color=#666666>Tracking</font></strong></span><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;><strong><font color=#666666>ID##@@</font></strong></span></p><p> </p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong><br /></strong></span>@@##TicketMessage##@@</td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '2', 'FORGETPWD', 'Ha olvidado contrasena', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;><span style=font-size: medium;>ScriptCase Tickets System</span> </span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><span style=font-size: 12pt; color: black; font-family: \'Courier New\'; mso-fareast-font-family: \'Times New Roman\'; mso-ansi-language: ES; mso-fareast-language: EN-CA; lang=ES>Estimado</span> @@##StaffName##@@, se abaixo <font face=Courier New color=#000000>a los datos de acceso:</font></span></p><p><span style=font-size: small; color: #006666; font-family: Arial,Helvetica,sans-serif;><font face=Courier New color=#000000>Usuario</font>: @@##StaffEmail##@@<br /><font face=Courier New color=#000000>Contrase�a</font>: @@##StaffPassword##@@ <br /></span></p></td></tr><tr><td align=left valign=top> </td><td align=left valign=top> </td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5> </td></tr><tr><td colspan=2> </td></tr><tr><td colspan=2> </td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial,Helvetica,sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '2', 'RETURNED', 'Billete devuelto', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;><h2>ScriptCase Tickets System </h2></span></strong></td><td width=236 bgcolor=#009933><div></div></td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>El cliente <strong>@@##CustomerName##@@</strong> lo devolvi� el billete al soporte. <br />�ste es un mensaje autom�tico, por favor, no responder. <br /></span></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>Tracking ID: <strong><span style=color: #666666;>@@##TrackingID##@@</span></strong></span></p><p> </p></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5><span style=font-size: small; color: #666666; font-family: Arial, Helvetica, sans-serif;><strong><br /></strong></span><div><p>@@##TicketMessage##@@</p></div></td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y'), ('es;es_es', '2', 'UNASSIGNED', 'Billete Abierto', '<table border=0 cellpadding=10 bgcolor=#fafaf8><tbody><tr><td><table border=0 cellspacing=0 width=573><tbody><tr><td width=324 bgcolor=#009933><strong><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>ScriptCase Tickets System </span></strong></td><td width=236 bgcolor=#009933> </td></tr><tr><td colspan=2><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>El cliente <strong>@@##CustomerName##@@</strong> abri� un billete. <br /> �ste es un mensaje autom�tico, por favor, no responder. </span></td></tr><tr><td colspan=2 align=left valign=top><p><span style=font-size: small; color: #006666; font-family: Arial, Helvetica, sans-serif;>TicketID: <strong><font color=#666666>@@##TicketID##@@</font></strong></span> </p><strong><span style=color: #666666; font-family: Arial, Helvetica, sans-serif;><strong><font face=Arial, Helvetica, sans-serif color=#666666><div id=result_box style=text-align: left; dir=ltr></div></font></strong></span></strong></td></tr><tr><td colspan=2 align=left valign=top bgcolor=#eef7d5>@@##TicketMessage##@@</td></tr><tr><td colspan=2><table border=0 cellspacing=0 width=100%><tbody><tr><td bgcolor=#009933><a href=http://www.scriptcase.net target=_blank><span style=font-size: x-small; color: #ffffff; font-family: Arial, Helvetica, sans-serif;>www.scriptcase.net</span></a></td><td bgcolor=#009933> </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>', 'Y');

-- ----------------------------
-- Table structure for `ticketmessage`
-- ----------------------------

create table `ticketmessage` (
  `ticketmessageid` int(11) not null,
  `ticketid` int(11) not null,
  `ticketdate` datetime default null,
  `ticketcontent` text,
  `ticketfile1` blob,
  `ticketfile2` blob,
  `ticketfile3` blob,
  `operatorid` int(11) default null,
  `messagetype` varchar(10) default null,
  `ticketfilename1` varchar(100) default null,
  `ticketfilename2` varchar(100) default null,
  `ticketfilename3` varchar(100) default null,
  `statusid` varchar(30) default null,
  `messagenote` varchar(255) default null,
  primary key (`ticketmessageid`,`ticketid`),
  key `operatorid` (`operatorid`),
  key `statusid` (`statusid`),
  key `ticketid` (`ticketid`),
  constraint `ticketmessage_ibfk_1` foreign key (`ticketid`) references `ticket` (`ticketid`) on delete cascade on update cascade,
  constraint `ticketmessage_ibfk_2` foreign key (`operatorid`) references `staff` (`staffid`),
  constraint `ticketmessage_ibfk_3` foreign key (`statusid`) references `ticketstatus` (`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ticketmessage
-- ----------------------------
INSERT INTO `ticketmessage` VALUES ('1', '1', '2008-03-01 11:29:30', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('2', '1', '2008-03-06 14:40:08', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('3', '1', '2008-03-07 09:59:28', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('4', '1', '2008-03-07 18:49:25', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('5', '1', '2008-03-10 09:44:23', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('6', '1', '2008-03-14 14:40:08', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('7', '2', '2008-03-01 08:27:40', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('8', '2', '2008-03-02 17:34:42', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('9', '3', '2008-03-01 08:34:55', 'Access to the site is very slow on weekends.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('10', '3', '2008-03-04 16:41:27', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('11', '4', '2008-03-01 10:57:54', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('12', '4', '2008-03-04 16:03:55', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('13', '4', '2008-03-05 06:17:56', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14', '4', '2008-03-08 14:35:01', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15', '5', '2008-03-01 09:02:44', 'My keyboard is not accepting uppercase.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('16', '5', '2008-03-04 16:32:15', 'Make sure the CapsLock led is on.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('17', '6', '2008-03-01 08:43:03', 'I made a payment and did not receive an email confirmation', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('18', '6', '2008-03-04 13:41:01', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('19', '7', '2008-03-02 07:33:45', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('20', '7', '2008-03-02 16:24:20', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('21', '8', '2008-03-02 12:18:02', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('22', '8', '2008-03-03 16:14:08', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('23', '9', '2008-03-02 11:03:03', 'Customers page is not found from the link on the main menu', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('24', '9', '2008-03-04 17:25:28', 'The problem has been resolved. Please access the site again.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('25', '9', '2008-03-05 06:02:46', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('26', '9', '2008-03-05 14:23:54', 'We already provided the fix.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('27', '10', '2008-03-02 08:10:59', 'The  generated are not being sent by email.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('28', '10', '2008-03-04 18:09:55', 'Check spam  filter.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('29', '10', '2008-03-09 09:55:31', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('30', '10', '2008-03-10 16:19:58', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('31', '10', '2008-03-14 11:17:22', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('32', '10', '2008-03-19 15:37:23', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('33', '11', '2008-03-02 06:22:58', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('34', '11', '2008-03-02 16:33:00', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('35', '11', '2008-03-06 08:50:02', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('36', '11', '2008-03-10 18:28:53', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('37', '12', '2008-03-03 07:09:28', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('38', '12', '2008-03-07 15:57:13', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('39', '12', '2008-03-11 10:33:43', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('40', '12', '2008-03-14 17:04:41', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('41', '13', '2008-03-03 10:21:58', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('42', '13', '2008-03-06 14:03:28', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('43', '13', '2008-03-10 10:58:41', 'My keyboard is not accepting uppercase.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('44', '13', '2008-03-10 17:17:36', 'Make sure the CapsLock led is on.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('45', '13', '2008-03-12 07:20:06', 'My battery does not charge any more.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('46', '13', '2008-03-15 14:10:13', 'Please inform the battery model and date of purchase.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('47', '14', '2008-03-03 06:14:02', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('48', '14', '2008-03-08 16:05:15', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('49', '14', '2008-03-09 06:44:45', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('50', '14', '2008-03-09 16:13:36', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('51', '15', '2008-03-03 06:48:03', 'I can not entry more than one phone to a contact.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('52', '15', '2008-03-06 14:15:09', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('53', '16', '2008-03-03 08:57:55', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('54', '16', '2008-03-08 13:25:05', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('55', '16', '2008-03-12 12:58:22', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('56', '16', '2008-03-16 14:09:42', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('57', '17', '2008-03-03 08:14:34', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('58', '17', '2008-03-03 16:54:05', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('59', '17', '2008-03-06 06:18:09', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('60', '17', '2008-03-11 17:07:29', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('61', '18', '2008-03-04 11:44:21', 'My Firefox browser is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('62', '18', '2008-03-08 15:41:48', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('63', '18', '2008-03-10 10:24:57', 'My Office does not open, or word or excel ...', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('64', '18', '2008-03-14 13:33:06', 'Please, try reinstalling the program.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('65', '18', '2008-03-17 09:28:00', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('66', '18', '2008-03-19 16:34:42', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('67', '19', '2008-03-04 10:22:22', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('68', '19', '2008-03-06 18:31:43', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('69', '20', '2008-03-04 12:32:58', 'I want to cancel my order number 22113121.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('70', '20', '2008-03-09 13:11:29', 'To cancel your order please contact the service and quality center', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('71', '21', '2008-03-04 07:28:24', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('72', '21', '2008-03-05 17:14:41', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('73', '22', '2008-03-04 06:24:00', 'Customers page is not found from the link on the main menu', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('74', '22', '2008-03-04 14:08:01', 'The problem has been resolved. Please access the site again.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('75', '23', '2008-03-04 11:27:57', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('76', '23', '2008-03-07 16:51:37', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('77', '23', '2008-03-12 08:40:35', 'My  keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('78', '23', '2008-03-12 15:07:03', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('79', '24', '2008-03-04 07:58:18', 'How to classify the customer by priority?', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('80', '24', '2008-03-07 18:16:35', 'Check the user manual the topic How to configure the priority', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('81', '24', '2008-03-08 11:31:50', 'My user has no access to the Costs by departments report.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('82', '24', '2008-03-09 17:02:21', 'This report can now be accessed only by users with manager profile .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('83', '24', '2008-03-11 12:50:23', 'I can not entry more than one phone to a contact.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('84', '24', '2008-03-13 14:11:34', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('85', '25', '2008-03-05 12:32:18', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('86', '25', '2008-03-06 14:26:41', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('87', '26', '2008-03-06 07:06:38', 'The generated are not being sent by email.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('88', '26', '2008-03-08 17:18:18', 'Check spam filter.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('89', '27', '2008-03-07 12:40:04', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('90', '27', '2008-03-08 18:45:06', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('91', '27', '2008-03-11 07:37:16', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('92', '27', '2008-03-12 15:58:22', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('93', '27', '2008-03-15 09:28:50', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('94', '27', '2008-03-17 14:06:10', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('95', '28', '2008-03-07 09:31:36', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('96', '28', '2008-03-10 14:20:41', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('97', '28', '2008-03-13 11:51:52', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('98', '28', '2008-03-15 17:30:44', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('99', '28', '2008-03-16 06:05:29', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('100', '28', '2008-03-18 15:48:02', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('101', '29', '2008-03-07 11:05:07', 'I can not entry more than one phone to a contact.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('102', '29', '2008-03-10 16:19:03', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('103', '29', '2008-03-13 08:17:37', 'My user has no access to the Costs by departments report.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('104', '29', '2008-03-15 15:32:31', 'This report can now be accessed only by users with manager profile .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('105', '29', '2008-03-19 09:40:53', 'How to classify the customer by priority?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('106', '29', '2008-03-24 17:24:01', 'Check the user manual the topic How to configure the priority', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('107', '30', '2008-03-07 07:07:10', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('108', '30', '2008-03-08 16:22:28', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('109', '31', '2008-03-07 06:21:54', 'The generatedare not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('110', '31', '2008-03-12 16:14:28', 'Check spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('111', '31', '2008-03-13 11:42:26', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('112', '31', '2008-03-18 17:15:17', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('113', '32', '2008-03-07 06:29:28', 'I made a payment and did not receive an email confirmation', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('114', '32', '2008-03-10 18:48:35', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('115', '32', '2008-03-11 10:33:38', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('116', '32', '2008-03-14 16:32:00', 'Only at the end of the year, a week before Christmas.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('117', '33', '2008-03-07 06:02:34', 'Access to the site is very slow on weekends.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('118', '33', '2008-03-07 17:31:41', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('119', '34', '2008-03-07 12:07:45', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('120', '34', '2008-03-09 15:56:39', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('121', '34', '2008-03-12 08:38:28', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('122', '34', '2008-03-16 18:04:50', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('123', '35', '2008-03-08 09:57:45', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('124', '35', '2008-03-12 13:47:58', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('125', '35', '2008-03-13 08:43:34', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('126', '35', '2008-03-14 14:37:10', 'The warranty may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('127', '35', '2008-03-19 10:36:19', 'I made a payment and did not receive an email confirmation', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('128', '35', '2008-03-20 17:44:54', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('129', '36', '2008-03-08 06:25:18', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('130', '36', '2008-03-12 13:59:47', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('131', '37', '2008-03-08 08:59:34', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('132', '37', '2008-03-10 16:32:47', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('133', '37', '2008-03-13 10:54:54', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('134', '37', '2008-03-17 16:44:37', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('135', '38', '2008-03-08 09:07:55', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('136', '38', '2008-03-12 13:00:15', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('137', '39', '2008-03-09 06:37:09', 'My battery does not charge any more.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('138', '39', '2008-03-11 17:18:10', 'Please inform the battery model and date of purchase.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('139', '40', '2008-03-09 10:05:48', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('140', '40', '2008-03-11 14:43:27', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('141', '41', '2008-03-09 06:49:20', 'I can not entry more than one phone to a contact.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('142', '41', '2008-03-09 17:30:34', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('143', '41', '2008-03-10 06:36:37', 'My user has no access to the Costs by departments report.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('144', '41', '2008-03-12 15:54:29', 'This report can now be accessed only by users with manager profile .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('145', '41', '2008-03-17 09:24:25', 'How can I access a client last orders?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('146', '41', '2008-03-20 17:22:57', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('147', '42', '2008-03-09 06:51:18', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('148', '42', '2008-03-14 16:10:07', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('149', '42', '2008-03-17 11:53:11', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('150', '42', '2008-03-20 13:23:01', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('151', '43', '2008-03-09 10:39:45', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('152', '43', '2008-03-10 17:40:42', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('153', '43', '2008-03-13 11:28:46', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('154', '43', '2008-03-18 13:38:19', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('155', '44', '2008-03-09 07:13:18', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('156', '44', '2008-03-09 15:02:22', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('157', '45', '2008-03-09 08:00:10', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('158', '45', '2008-03-12 18:07:28', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('159', '46', '2008-03-09 11:47:54', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('160', '46', '2008-03-13 14:19:13', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('161', '46', '2008-03-16 07:02:16', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('162', '46', '2008-03-16 15:20:32', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('163', '46', '2008-03-17 06:49:08', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('164', '46', '2008-03-20 18:50:25', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('165', '47', '2008-03-09 06:31:25', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('166', '47', '2008-03-09 15:30:49', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('167', '48', '2008-03-09 06:00:42', 'I made a payment and did not receive an email confirmation', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('168', '48', '2008-03-13 16:55:16', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('169', '48', '2008-03-15 07:21:12', 'I want to cancel my order number 22113121.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('170', '48', '2008-03-16 13:48:52', 'To cancel your order please contact the service and quality center', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('171', '49', '2008-03-09 12:39:51', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('172', '49', '2008-03-13 17:02:23', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('173', '50', '2008-03-10 08:47:08', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('174', '50', '2008-03-12 17:25:49', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('175', '50', '2008-03-15 09:45:25', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('176', '50', '2008-03-18 13:59:04', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('177', '50', '2008-03-20 11:52:44', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('178', '50', '2008-03-21 14:36:36', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('179', '51', '2008-03-10 08:06:18', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('180', '51', '2008-03-11 13:54:04', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('181', '52', '2008-03-10 11:51:52', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('182', '52', '2008-03-15 15:09:26', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('183', '52', '2008-03-16 06:35:26', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('184', '52', '2008-03-18 14:54:54', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('185', '52', '2008-03-19 11:50:22', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('186', '52', '2008-03-20 14:55:06', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('187', '53', '2008-03-10 06:28:07', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('188', '53', '2008-03-11 17:12:28', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('189', '53', '2008-03-12 07:25:05', 'My desktop does not turn on', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('190', '53', '2008-03-13 17:59:20', 'Make sure it is properly connected to the power supply.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('191', '53', '2008-03-16 08:40:31', 'The mouse does not move to the side', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('192', '53', '2008-03-16 13:15:01', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('193', '54', '2008-03-10 09:11:15', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('194', '54', '2008-03-14 15:26:41', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('195', '55', '2008-03-10 11:02:11', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('196', '55', '2008-03-11 15:15:25', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('197', '55', '2008-03-13 08:00:24', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('198', '55', '2008-03-15 14:01:46', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('199', '56', '2008-03-11 08:12:06', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('200', '56', '2008-03-11 15:00:32', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('201', '56', '2008-03-14 11:04:42', 'I made a payment and did not receive an email confirmation', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('202', '56', '2008-03-15 18:32:19', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('203', '57', '2008-03-11 09:44:57', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('204', '57', '2008-03-16 15:59:36', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('205', '58', '2008-03-12 10:21:32', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('206', '58', '2008-03-14 18:50:26', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('207', '59', '2008-03-12 11:25:36', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('208', '59', '2008-03-12 18:56:38', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('209', '59', '2008-03-16 11:09:48', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO `ticketmessage` VALUES ('210', '59', '2008-03-17 17:32:11', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('211', '59', '2008-03-22 11:55:53', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('212', '59', '2008-03-24 17:09:09', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('213', '60', '2008-03-12 06:29:08', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('214', '60', '2008-03-12 13:48:38', 'The server was out at that time, but is already operational.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('215', '60', '2008-03-17 06:01:35', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('216', '60', '2008-03-17 18:17:21', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('217', '60', '2008-03-19 09:02:27', 'A friend said he sent me an email but I did not receive', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('218', '60', '2008-03-20 17:57:38', 'Make sure this email is not on the blocked messages list .', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('219', '61', '2008-03-14 10:11:42', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('220', '61', '2008-03-16 14:30:44', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('221', '61', '2008-03-18 07:27:53', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('222', '61', '2008-03-23 16:40:10', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('223', '62', '2008-03-14 12:15:06', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('224', '62', '2008-03-18 14:46:00', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('225', '62', '2008-03-21 09:31:41', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('226', '62', '2008-03-22 14:19:16', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('227', '62', '2008-03-24 09:00:17', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('228', '62', '2008-03-24 15:50:15', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('229', '63', '2008-03-14 09:08:28', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('230', '63', '2008-03-19 17:14:14', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('231', '64', '2008-03-14 10:31:35', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('232', '64', '2008-03-16 17:27:39', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('233', '64', '2008-03-18 12:50:37', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('234', '64', '2008-03-22 16:36:46', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('235', '65', '2008-03-14 06:32:40', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('236', '65', '2008-03-16 15:53:45', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('237', '66', '2008-03-14 08:55:11', 'I made a payment and did not receive an email confirmation', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('238', '66', '2008-03-17 16:18:35', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('239', '66', '2008-03-21 10:28:52', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('240', '66', '2008-03-22 18:02:45', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('241', '66', '2008-03-26 10:40:35', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('242', '66', '2008-03-30 17:33:54', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('243', '67', '2008-03-14 12:57:52', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('244', '67', '2008-03-18 13:13:45', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('245', '67', '2008-03-20 08:25:35', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('246', '67', '2008-03-20 14:10:14', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('247', '68', '2008-03-14 12:57:35', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('248', '68', '2008-03-14 18:08:14', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('249', '68', '2008-03-15 11:19:35', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('250', '68', '2008-03-20 16:34:36', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('251', '68', '2008-03-21 07:03:06', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('252', '68', '2008-03-25 18:16:29', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('253', '69', '2008-03-15 09:27:27', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('254', '69', '2008-03-15 18:43:37', 'The order was sent and will be delivered in 2 working days.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('255', '70', '2008-03-15 10:15:17', 'My user has no access to the Costs by departments report.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('256', '70', '2008-03-16 16:13:45', 'This report can now be accessed only by users with manager profile .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('257', '70', '2008-03-20 12:21:27', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('258', '70', '2008-03-22 13:16:18', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('259', '70', '2008-03-23 08:44:34', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('260', '70', '2008-03-23 18:33:24', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('261', '71', '2008-03-15 12:50:57', 'My desktop does not turn on', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('262', '71', '2008-03-18 16:33:36', 'Make sure it is properly connected to the power supply.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('263', '71', '2008-03-20 11:35:02', 'The mouse does not move to the side', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('264', '71', '2008-03-23 17:16:22', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('265', '72', '2008-03-15 11:29:09', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('266', '72', '2008-03-20 18:54:05', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('267', '72', '2008-03-21 11:54:58', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('268', '72', '2008-03-21 13:54:50', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('269', '72', '2008-03-26 07:38:13', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('270', '72', '2008-03-28 17:41:36', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('271', '73', '2008-03-15 09:15:43', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('272', '73', '2008-03-16 18:16:38', 'Only at the end of the year, a week before Christmas.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('273', '74', '2008-03-15 10:36:17', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('274', '74', '2008-03-16 16:32:38', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('275', '74', '2008-03-21 07:25:49', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('276', '74', '2008-03-21 15:18:52', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('277', '75', '2008-03-16 12:12:27', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('278', '75', '2008-03-17 15:51:46', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('279', '75', '2008-03-18 09:12:48', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('280', '75', '2008-03-20 17:01:43', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('281', '75', '2008-03-21 12:59:51', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('282', '75', '2008-03-26 17:42:51', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('283', '76', '2008-03-16 10:28:25', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('284', '76', '2008-03-17 14:57:28', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('285', '77', '2008-03-16 10:46:02', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('286', '77', '2008-03-20 14:49:06', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('287', '77', '2008-03-23 07:52:57', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('288', '77', '2008-03-25 13:17:49', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('289', '77', '2008-03-28 06:01:32', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('290', '77', '2008-03-30 18:55:56', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('291', '78', '2008-03-16 10:03:22', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('292', '78', '2008-03-19 14:40:10', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('293', '78', '2008-03-20 09:02:07', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('294', '78', '2008-03-22 14:56:35', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('295', '79', '2008-03-16 06:48:53', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('296', '79', '2008-03-18 15:31:12', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('297', '79', '2008-03-23 08:26:48', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('298', '79', '2008-03-28 13:16:02', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('299', '79', '2008-03-29 12:24:02', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('300', '79', '2008-04-01 18:39:56', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('301', '80', '2008-03-16 07:38:37', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('302', '80', '2008-03-21 13:47:24', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('303', '81', '2008-03-16 10:42:11', 'My keyboard  is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('304', '81', '2008-03-18 15:40:42', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('305', '81', '2008-03-22 12:49:44', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('306', '81', '2008-03-25 17:26:17', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('307', '82', '2008-03-16 06:49:29', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('308', '82', '2008-03-16 17:01:36', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('309', '83', '2008-03-16 08:14:05', 'The word program is locking the file during save.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('310', '83', '2008-03-19 13:40:01', 'Make sure there is enough space on disk.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('311', '84', '2008-03-16 11:59:30', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('312', '84', '2008-03-19 17:56:04', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('313', '84', '2008-03-21 08:19:50', 'My battery does not charge any more.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('314', '84', '2008-03-26 16:11:30', 'Please inform the battery model and date of purchase.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('315', '85', '2008-03-17 11:53:43', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('316', '85', '2008-03-18 18:51:53', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('317', '85', '2008-03-21 12:15:50', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('318', '85', '2008-03-22 13:41:51', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('319', '86', '2008-03-17 11:08:52', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('320', '86', '2008-03-17 16:12:31', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('321', '86', '2008-03-22 06:22:51', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('322', '86', '2008-03-22 15:50:14', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('323', '86', '2008-03-23 11:09:54', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('324', '86', '2008-03-26 15:43:46', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('325', '87', '2008-03-17 10:01:10', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('326', '87', '2008-03-19 18:02:55', 'We already provided the fix.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('327', '87', '2008-03-21 09:17:56', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('328', '87', '2008-03-23 15:40:35', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('329', '87', '2008-03-28 07:07:53', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('330', '87', '2008-04-02 13:16:33', 'Sorry. There was an error and it now is corrected.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('331', '88', '2008-03-17 08:10:47', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('332', '88', '2008-03-19 14:47:26', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('333', '89', '2008-03-17 08:18:45', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('334', '89', '2008-03-17 16:39:32', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('335', '89', '2008-03-20 07:28:00', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('336', '89', '2008-03-24 16:55:30', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('337', '89', '2008-03-27 09:55:56', 'My desktop does not turn on', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('338', '89', '2008-03-30 16:41:36', 'Make sure it is properly connected to the power supply.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('339', '90', '2008-03-17 06:27:06', 'The generated  proposals are not being sent by email.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('340', '90', '2008-03-17 13:34:50', 'Check your client spam filter.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('341', '90', '2008-03-18 10:57:47', 'How to classify the customer by priority?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('342', '90', '2008-03-23 18:20:53', 'Check the user manual the topic How to configure the priority', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('343', '90', '2008-03-25 08:04:20', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('344', '90', '2008-03-26 15:26:20', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('345', '91', '2008-03-18 10:29:52', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('346', '91', '2008-03-19 13:13:34', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('347', '91', '2008-03-20 11:40:45', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('348', '91', '2008-03-23 15:26:02', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('349', '91', '2008-03-26 06:48:34', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('350', '91', '2008-03-30 17:14:16', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('351', '92', '2008-03-18 11:47:43', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('352', '92', '2008-03-21 15:34:30', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('353', '93', '2008-03-18 08:06:34', 'I can not download the technical standards manual.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('354', '93', '2008-03-18 18:59:50', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('355', '93', '2008-03-19 10:20:19', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('356', '93', '2008-03-23 13:47:05', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('357', '93', '2008-03-25 12:48:32', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('358', '93', '2008-03-26 15:07:53', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('359', '94', '2008-03-18 10:36:08', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('360', '94', '2008-03-20 16:02:05', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('361', '94', '2008-03-22 09:32:03', 'I can not download the technical standards manual.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('362', '94', '2008-03-22 13:57:52', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('363', '94', '2008-03-27 12:26:08', 'Access to the site is very slow on weekends.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('364', '94', '2008-03-31 13:41:46', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('365', '95', '2008-03-19 10:03:58', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('366', '95', '2008-03-21 18:54:24', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('367', '95', '2008-03-23 12:26:12', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('368', '95', '2008-03-26 14:52:31', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('369', '95', '2008-03-27 10:23:32', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('370', '95', '2008-03-27 18:23:27', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('371', '96', '2008-03-20 09:39:40', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('372', '96', '2008-03-23 16:13:59', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('373', '96', '2008-03-25 08:42:58', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('374', '96', '2008-03-28 13:01:29', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('375', '97', '2008-03-20 07:01:05', 'I can not download the technical standards manual.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('376', '97', '2008-03-25 15:03:31', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('377', '97', '2008-03-30 09:21:18', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('378', '97', '2008-04-02 17:57:34', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('379', '98', '2008-03-21 08:15:42', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('380', '98', '2008-03-23 16:47:27', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('381', '98', '2008-03-26 08:54:51', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('382', '98', '2008-03-26 15:35:22', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('383', '98', '2008-03-28 06:32:39', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('384', '98', '2008-03-29 17:10:05', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('385', '99', '2008-03-21 11:21:54', 'I made a payment and did not receive an email confirmation', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('386', '99', '2008-03-26 17:23:42', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('387', '99', '2008-03-28 12:40:59', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('388', '99', '2008-03-30 17:48:28', 'The order was sent and will be delivered in 2 working days.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('389', '99', '2008-04-03 08:53:29', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('390', '99', '2008-04-03 14:35:33', 'Only at the end of the year, a week before Christmas.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('391', '100', '2008-03-21 12:43:17', 'Customers page is not found from the link on the main menu', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('392', '100', '2008-03-24 16:16:12', 'The problem has been resolved. Please access the site again.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('393', '100', '2008-03-29 12:02:28', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('394', '100', '2008-03-31 16:31:27', 'Sorry. There was an error and it now is corrected.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('395', '100', '2008-04-02 06:00:28', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('396', '100', '2008-04-06 18:23:55', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('397', '101', '2008-03-21 07:29:31', 'My keyboard  is not accepting uppercase.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('398', '101', '2008-03-25 18:33:27', 'Make sure the CapsLock led is on.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('399', '102', '2008-03-21 06:37:39', 'My desktop does not turn on', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('400', '102', '2008-03-21 18:41:59', 'Make sure it is properly connected to the power supply.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('401', '102', '2008-03-22 11:11:22', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('402', '102', '2008-03-27 16:31:32', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('403', '102', '2008-03-31 10:31:52', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('404', '102', '2008-04-02 17:58:14', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('405', '103', '2008-03-21 08:45:42', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('406', '103', '2008-03-23 13:40:06', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('407', '103', '2008-03-26 06:58:36', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('408', '103', '2008-03-26 16:34:35', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('409', '103', '2008-03-28 10:50:00', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('410', '103', '2008-03-29 18:06:26', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('411', '104', '2008-03-21 07:19:50', 'I can not entry more than one phone to a contact.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('412', '104', '2008-03-22 18:55:43', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('413', '104', '2008-03-23 06:10:33', 'How to classify the customer by priority?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('414', '104', '2008-03-27 14:27:31', 'Check the user manual the topic How to configure the priority', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('415', '104', '2008-03-28 11:52:35', 'The generated  proposals are not being sent by email.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('416', '104', '2008-04-02 17:56:41', 'Check your client spam filter.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('417', '105', '2008-03-22 08:36:26', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('418', '105', '2008-03-26 17:13:56', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('419', '105', '2008-03-29 09:30:08', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('420', '105', '2008-04-02 15:27:28', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('421', '105', '2008-04-03 11:24:48', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('422', '105', '2008-04-06 18:20:23', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('423', '106', '2008-03-22 07:48:27', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('424', '106', '2008-03-24 16:56:14', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('425', '106', '2008-03-28 12:02:58', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('426', '106', '2008-04-01 13:58:01', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('427', '106', '2008-04-04 12:41:10', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('428', '106', '2008-04-05 14:30:25', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('429', '107', '2008-03-22 06:40:26', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('430', '107', '2008-03-27 14:48:49', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('431', '107', '2008-04-01 12:41:09', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('432', '107', '2008-04-05 13:36:05', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('433', '107', '2008-04-08 10:33:40', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('434', '107', '2008-04-10 14:36:17', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('435', '108', '2008-03-22 06:44:00', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('436', '108', '2008-03-24 14:23:19', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('437', '108', '2008-03-26 07:25:16', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('438', '108', '2008-03-26 18:21:04', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('439', '109', '2008-03-22 07:19:09', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('440', '109', '2008-03-24 17:50:47', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('441', '109', '2008-03-26 08:27:22', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('442', '109', '2008-03-30 13:24:24', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('443', '109', '2008-04-02 06:36:01', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('444', '109', '2008-04-04 13:59:01', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('445', '110', '2008-03-23 10:10:08', 'The word program is locking the file during save.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('446', '110', '2008-03-24 18:24:27', 'Make sure there is enough space on disk.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('447', '110', '2008-03-26 07:36:54', 'My Office does not open, or word or excel ...', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('448', '110', '2008-03-28 15:55:10', 'Please, try reinstalling the program.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('449', '110', '2008-04-01 06:45:24', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('450', '110', '2008-04-03 13:50:47', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('451', '111', '2008-03-23 12:26:29', 'The mouse does not move to the side', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('452', '111', '2008-03-28 14:08:40', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('453', '111', '2008-03-31 10:22:50', 'My keyboard  is not accepting uppercase.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('454', '111', '2008-04-05 15:42:47', 'Make sure the CapsLock led is on.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('455', '111', '2008-04-10 07:58:06', 'My desktop does not turn on', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('456', '111', '2008-04-15 18:13:38', 'Make sure it is properly connected to the power supply.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('457', '112', '2008-03-23 12:12:38', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('458', '112', '2008-03-27 18:04:09', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('459', '113', '2008-03-23 10:04:59', 'My user has no access to the Costs by departments report.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('460', '113', '2008-03-26 15:17:13', 'This report can now be accessed only by users with manager profile .', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('461', '114', '2008-03-23 11:09:24', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('462', '114', '2008-03-27 13:38:54', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('463', '114', '2008-03-31 07:01:28', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('464', '114', '2008-04-02 13:46:50', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('465', '115', '2008-03-23 06:49:24', 'How can I access a client last orders?', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('466', '115', '2008-03-24 17:08:30', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('467', '115', '2008-03-27 09:20:17', 'The generated  proposals are not being sent by email.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('468', '115', '2008-04-01 13:07:55', 'Check your client spam filter.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('469', '115', '2008-04-03 10:59:34', 'My user has no access to the Costs by departments report.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('470', '115', '2008-04-06 15:56:13', 'This report can now be accessed only by users with manager profile .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('471', '116', '2008-03-23 12:58:33', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('472', '116', '2008-03-25 13:27:14', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('473', '117', '2008-03-24 06:14:08', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('474', '117', '2008-03-29 18:23:43', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('475', '117', '2008-04-01 08:17:52', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('476', '117', '2008-04-06 16:27:21', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('477', '117', '2008-04-07 10:06:32', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('478', '117', '2008-04-09 18:46:08', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('479', '118', '2008-03-24 10:37:26', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('480', '118', '2008-03-29 14:56:36', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('481', '119', '2008-03-24 10:08:17', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('482', '119', '2008-03-26 17:22:09', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('483', '120', '2008-03-24 11:58:52', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('484', '120', '2008-03-26 17:30:45', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('485', '120', '2008-03-27 06:15:35', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('486', '120', '2008-03-28 18:30:15', 'The order was sent and will be delivered in 2 working days.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('487', '120', '2008-03-31 08:33:18', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('488', '120', '2008-04-05 13:24:24', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('489', '121', '2008-03-24 07:42:34', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('490', '121', '2008-03-27 18:47:37', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('491', '121', '2008-04-01 07:32:30', 'Customers page is not found from the link on the main menu', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('492', '121', '2008-04-06 18:25:12', 'The problem has been resolved. Please access the site again.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('493', '122', '2008-03-25 09:32:23', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('494', '122', '2008-03-26 15:12:46', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('495', '122', '2008-03-29 09:24:04', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('496', '122', '2008-03-29 18:23:28', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('497', '122', '2008-04-02 06:11:27', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('498', '122', '2008-04-05 14:57:42', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('499', '123', '2008-03-25 12:32:40', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('500', '123', '2008-03-25 16:43:46', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('501', '123', '2008-03-29 09:27:19', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('502', '123', '2008-03-31 17:35:36', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('503', '123', '2008-04-05 07:00:22', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('504', '123', '2008-04-05 13:44:42', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('505', '124', '2008-03-25 09:34:58', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('506', '124', '2008-03-27 16:25:50', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('507', '124', '2008-03-28 12:47:41', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('508', '124', '2008-03-30 14:07:37', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('509', '125', '2008-03-25 10:24:40', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('510', '125', '2008-03-26 13:15:25', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('511', '126', '2008-03-26 12:30:16', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('512', '126', '2008-03-31 14:46:24', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('513', '126', '2008-04-05 11:58:38', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('514', '126', '2008-04-06 13:58:02', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('515', '126', '2008-04-08 07:41:46', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('516', '126', '2008-04-10 15:07:59', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('517', '127', '2008-03-26 10:24:23', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('518', '127', '2008-03-28 16:32:24', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('519', '128', '2008-03-26 08:55:48', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('520', '128', '2008-03-27 16:31:34', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('521', '128', '2008-03-29 12:39:41', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('522', '128', '2008-03-29 14:13:28', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('523', '128', '2008-04-01 07:00:13', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('524', '128', '2008-04-05 18:08:09', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('525', '129', '2008-03-26 11:13:41', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('526', '129', '2008-03-31 13:33:32', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('527', '129', '2008-04-04 08:02:47', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('528', '129', '2008-04-04 14:43:09', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('529', '130', '2008-03-26 08:17:14', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('530', '130', '2008-03-29 14:51:49', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('531', '130', '2008-03-31 12:08:06', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('532', '130', '2008-03-31 13:04:16', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('533', '130', '2008-04-05 07:47:40', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('534', '130', '2008-04-08 15:11:22', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('535', '131', '2008-03-27 09:26:47', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('536', '131', '2008-03-27 16:28:11', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('537', '131', '2008-04-01 06:27:01', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('538', '131', '2008-04-05 15:23:16', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('539', '131', '2008-04-07 07:47:58', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('540', '131', '2008-04-11 18:57:40', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('541', '132', '2008-03-28 10:40:00', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('542', '132', '2008-03-29 13:38:31', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('543', '132', '2008-03-30 06:54:38', 'Access to the site is very slow on weekends.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('544', '132', '2008-03-31 18:52:15', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('545', '132', '2008-04-01 06:36:18', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('546', '132', '2008-04-03 18:20:14', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('547', '133', '2008-03-28 06:13:08', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('548', '133', '2008-03-28 13:23:23', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('549', '133', '2008-03-30 08:26:55', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('550', '133', '2008-04-03 17:48:56', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('551', '133', '2008-04-05 08:42:34', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('552', '133', '2008-04-10 17:25:29', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('553', '134', '2008-03-28 07:14:28', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('554', '134', '2008-03-31 18:13:42', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('555', '135', '2008-03-28 10:01:52', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('556', '135', '2008-03-31 13:30:11', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('557', '135', '2008-04-04 10:49:32', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('558', '135', '2008-04-05 14:09:50', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('559', '135', '2008-04-07 08:53:17', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('560', '135', '2008-04-08 13:40:14', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('561', '136', '2008-03-28 11:42:23', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('562', '136', '2008-03-31 16:08:21', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('563', '136', '2008-04-03 12:14:22', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('564', '136', '2008-04-05 15:20:29', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('565', '137', '2008-03-28 11:34:03', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('566', '137', '2008-04-01 17:50:26', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('567', '137', '2008-04-02 06:19:58', 'The word program is locking the file during save.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('568', '137', '2008-04-07 16:58:48', 'Make sure there is enough space on disk.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('569', '137', '2008-04-10 07:11:42', 'My Office does not open, or word or excel ...', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('570', '137', '2008-04-14 13:12:31', 'Please, try reinstalling the program.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('571', '138', '2008-03-28 10:37:52', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('572', '138', '2008-04-01 13:09:22', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('573', '139', '2008-03-29 08:11:19', 'Access to the site is very slow on weekends.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('574', '139', '2008-04-02 14:18:17', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('575', '140', '2008-03-29 10:01:15', 'Customers page is not found from the link on the main menu', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('576', '140', '2008-04-01 17:20:29', 'The problem has been resolved. Please access the site again.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('577', '141', '2008-03-29 12:49:51', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('578', '141', '2008-04-02 18:32:51', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('579', '142', '2008-03-29 06:57:04', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('580', '142', '2008-03-30 14:26:32', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('581', '143', '2008-03-29 08:31:24', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('582', '143', '2008-04-03 18:31:49', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('583', '143', '2008-04-07 07:04:01', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('584', '143', '2008-04-09 13:24:55', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('585', '143', '2008-04-11 06:22:07', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('586', '143', '2008-04-15 15:26:50', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('587', '144', '2008-03-30 11:39:44', 'Customers page is not found from the link on the main menu', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('588', '144', '2008-04-01 15:58:06', 'The problem has been resolved. Please access the site again.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('589', '144', '2008-04-03 06:34:38', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('590', '144', '2008-04-08 18:08:17', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('591', '144', '2008-04-11 11:36:55', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('592', '144', '2008-04-16 18:26:01', 'We already provided the fix.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('593', '145', '2008-03-30 06:39:06', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('594', '145', '2008-03-31 13:21:33', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('595', '145', '2008-04-01 12:11:03', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('596', '145', '2008-04-06 14:29:07', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('597', '145', '2008-04-11 08:12:12', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('598', '145', '2008-04-16 15:15:40', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('599', '146', '2008-03-30 08:23:51', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('600', '146', '2008-03-30 16:20:40', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('601', '146', '2008-04-03 12:05:27', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('602', '146', '2008-04-04 14:54:40', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('603', '147', '2008-03-30 06:12:48', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('604', '147', '2008-04-02 13:50:18', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('605', '147', '2008-04-04 11:07:48', 'The HD has the following error message: Reading Error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('606', '147', '2008-04-08 16:47:21', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('607', '147', '2008-04-13 10:25:49', 'My keyboard  is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('608', '147', '2008-04-16 16:03:04', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('609', '148', '2008-03-30 11:33:00', 'My Firefox browser is displaying na Javascript error', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('610', '148', '2008-04-02 18:34:33', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('611', '148', '2008-04-07 06:45:58', 'My Office does not open, or word or excel ...', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('612', '148', '2008-04-09 17:41:26', 'Please, try reinstalling the program.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('613', '148', '2008-04-10 09:11:53', 'The word program is locking the file during save.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('614', '148', '2008-04-10 17:17:20', 'Make sure there is enough space on disk.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('615', '149', '2008-03-30 10:21:35', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('616', '149', '2008-04-01 17:09:21', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('617', '150', '2008-03-30 10:16:47', 'Customers file display na error in the e-mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('618', '150', '2008-04-01 13:26:11', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('619', '151', '2008-03-31 11:59:58', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('620', '151', '2008-04-01 17:46:51', 'We already provided the fix.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('621', '151', '2008-04-06 07:57:13', 'Access to the site is very slow on weekends.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('622', '151', '2008-04-08 15:31:59', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('623', '151', '2008-04-10 07:13:12', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('624', '151', '2008-04-11 15:51:53', 'Sorry. There was an error and it now is corrected.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('625', '152', '2008-03-31 10:04:44', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('626', '152', '2008-04-05 14:49:09', 'Sorry. There was an error and it now is corrected.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('627', '152', '2008-04-08 07:47:25', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('628', '152', '2008-04-13 15:44:47', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('629', '153', '2008-03-31 11:53:01', 'My keyboard  is not accepting uppercase.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('630', '153', '2008-04-03 16:18:11', 'Make sure the CapsLock led is on.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('631', '153', '2008-04-08 07:53:19', 'My desktop does not turn on', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('632', '153', '2008-04-09 14:10:06', 'Make sure it is properly connected to the power supply.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('633', '154', '2008-03-31 11:22:22', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('634', '154', '2008-04-03 15:46:19', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('635', '154', '2008-04-07 06:30:29', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('636', '154', '2008-04-10 16:42:49', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('637', '154', '2008-04-14 09:26:26', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('638', '154', '2008-04-16 16:37:01', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('639', '155', '2008-03-31 12:32:04', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('640', '155', '2008-04-03 18:53:51', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('641', '155', '2008-04-06 10:29:43', 'My keyboard  is not accepting uppercase.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('642', '155', '2008-04-07 18:06:55', 'Make sure the CapsLock led is on.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('643', '156', '2008-03-31 09:40:34', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('644', '156', '2008-03-31 15:21:15', 'Sorry. There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('645', '156', '2008-04-03 06:13:24', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('646', '156', '2008-04-05 16:53:15', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('647', '157', '2008-03-31 10:57:13', 'The word program is locking the file during save.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('648', '157', '2008-04-02 13:38:50', 'Make sure there is enough space on disk.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('649', '158', '2008-03-31 10:51:41', 'My user has no access to the Costs by departments report.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('650', '158', '2008-04-05 16:18:30', 'This report can now be accessed only by users with manager profile .', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('651', '158', '2008-04-10 10:02:04', 'Customers file display na error in the e-mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('652', '158', '2008-04-11 13:02:31', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('653', '159', '2008-03-31 08:26:54', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('654', '159', '2008-04-01 15:22:47', 'We already provided the fix.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('655', '159', '2008-04-03 07:08:18', 'I can not download the technical standards manual.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('656', '159', '2008-04-07 17:32:24', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('657', '160', '2008-04-01 07:42:02', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('658', '160', '2008-04-01 17:12:18', 'Only at the end of the year, a week before Christmas.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('659', '160', '2008-04-05 06:30:34', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('660', '160', '2008-04-08 15:30:29', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('661', '161', '2008-04-01 12:00:45', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('662', '161', '2008-04-03 17:50:10', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('663', '162', '2008-04-01 06:22:05', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('664', '162', '2008-04-03 16:21:38', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('665', '162', '2008-04-07 11:45:03', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('666', '162', '2008-04-11 18:29:45', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('667', '163', '2008-04-01 06:22:11', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('668', '163', '2008-04-06 13:55:46', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('669', '164', '2008-04-01 07:23:12', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('670', '164', '2008-04-01 14:57:45', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('671', '164', '2008-04-04 06:12:09', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('672', '164', '2008-04-07 14:54:52', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('673', '164', '2008-04-09 06:20:13', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('674', '164', '2008-04-12 16:01:48', 'Sorry. There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('675', '165', '2008-04-01 09:42:13', 'My Office does not open, or word or excel ...', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('676', '165', '2008-04-04 13:53:37', 'Please, try reinstalling the program.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('677', '166', '2008-04-01 11:07:46', 'The generated  proposals are not being sent by email.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('678', '166', '2008-04-05 14:01:41', 'Check your client spam filter.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('679', '167', '2008-04-02 06:00:23', 'Customers file display na error in the e-mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('680', '167', '2008-04-02 14:52:28', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('681', '167', '2008-04-05 09:57:02', 'How can I access a client last orders?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('682', '167', '2008-04-06 14:40:36', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('683', '168', '2008-04-02 12:22:45', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('684', '168', '2008-04-06 13:30:44', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('685', '169', '2008-04-03 12:30:59', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('686', '169', '2008-04-08 15:37:02', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('687', '169', '2008-04-10 08:36:23', 'The word program is locking the file during save.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('688', '169', '2008-04-12 15:12:55', 'Make sure there is enough space on disk.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('689', '169', '2008-04-17 06:01:40', 'My Firefox browser is displaying na Javascript error', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('690', '169', '2008-04-20 14:47:04', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('691', '170', '2008-04-03 06:28:08', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('692', '170', '2008-04-08 14:31:37', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('693', '171', '2008-04-04 07:59:05', 'Customers file display na error in the e-mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('694', '171', '2008-04-07 15:33:24', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('695', '171', '2008-04-09 08:04:24', 'I can not entry more than one phone to a contact.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('696', '171', '2008-04-13 17:36:44', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('697', '172', '2008-04-04 06:36:53', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('698', '172', '2008-04-08 17:53:56', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('699', '172', '2008-04-10 07:41:51', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('700', '172', '2008-04-12 13:30:25', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('701', '173', '2008-04-04 10:33:40', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('702', '173', '2008-04-09 18:31:40', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('703', '173', '2008-04-10 07:30:00', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('704', '173', '2008-04-13 16:14:42', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('705', '174', '2008-04-04 09:53:46', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('706', '174', '2008-04-09 13:36:53', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('707', '174', '2008-04-12 11:12:37', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('708', '174', '2008-04-12 18:43:43', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', '');
INSERT INTO `ticketmessage` VALUES ('709', '174', '2008-04-17 10:45:11', 'My desktop does not turn on', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('710', '174', '2008-04-22 15:45:04', 'Make sure it is properly connected to the power supply.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('711', '175', '2008-04-04 08:03:23', 'My user has no access to the Costs by departments report.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('712', '175', '2008-04-04 13:07:26', 'This report can now be accessed only by users with manager profile .', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('713', '175', '2008-04-05 08:31:57', 'How to classify the customer by priority?', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('714', '175', '2008-04-10 15:12:14', 'Check the user manual the topic How to configure the priority', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('715', '176', '2008-04-04 09:43:10', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('716', '176', '2008-04-04 17:49:09', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('717', '176', '2008-04-09 06:26:48', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('718', '176', '2008-04-13 18:23:28', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('719', '177', '2008-04-05 07:20:53', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('720', '177', '2008-04-07 17:31:07', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('721', '177', '2008-04-08 06:17:56', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('722', '177', '2008-04-12 18:53:01', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('723', '177', '2008-04-17 10:05:47', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('724', '177', '2008-04-19 15:14:10', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('725', '178', '2008-04-05 08:04:41', 'How can I access a client last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('726', '178', '2008-04-10 18:28:30', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('727', '179', '2008-04-05 10:10:06', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('728', '179', '2008-04-09 17:56:38', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('729', '179', '2008-04-10 08:22:42', 'My Firefox browser is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('730', '179', '2008-04-13 15:42:06', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('731', '179', '2008-04-18 09:34:45', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('732', '179', '2008-04-22 14:55:30', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('733', '180', '2008-04-05 06:00:35', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('734', '180', '2008-04-09 18:27:37', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('735', '181', '2008-04-05 06:17:24', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('736', '181', '2008-04-09 14:46:34', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('737', '182', '2008-04-05 08:01:45', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('738', '182', '2008-04-10 17:09:04', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('739', '183', '2008-04-05 07:40:55', 'My user has no access to the Costs by departments report.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('740', '183', '2008-04-05 16:16:21', 'This report can now be accessed only by users with manager profile .', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('741', '183', '2008-04-08 08:28:33', 'The generated  proposals are not being sent by email.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('742', '183', '2008-04-09 18:42:06', 'Check your client spam filter.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('743', '184', '2008-04-06 10:59:01', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('744', '184', '2008-04-08 13:17:20', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('745', '184', '2008-04-13 08:04:58', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('746', '184', '2008-04-18 15:18:47', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('747', '184', '2008-04-21 12:14:38', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('748', '184', '2008-04-25 15:37:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('749', '185', '2008-04-06 09:43:59', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('750', '185', '2008-04-08 16:17:14', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('751', '185', '2008-04-10 12:42:12', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('752', '185', '2008-04-11 18:24:34', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('753', '185', '2008-04-14 09:08:17', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('754', '185', '2008-04-14 18:26:22', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('755', '186', '2008-04-06 12:21:10', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('756', '186', '2008-04-10 18:42:25', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('757', '186', '2008-04-13 06:37:05', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('758', '186', '2008-04-15 16:37:15', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('759', '187', '2008-04-06 10:27:02', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('760', '187', '2008-04-08 13:37:00', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('761', '188', '2008-04-06 09:17:58', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('762', '188', '2008-04-07 16:42:48', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('763', '188', '2008-04-09 09:05:50', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('764', '188', '2008-04-11 15:51:50', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('765', '189', '2008-04-06 10:58:53', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('766', '189', '2008-04-08 17:45:42', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('767', '190', '2008-04-06 09:33:40', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('768', '190', '2008-04-08 14:49:54', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('769', '191', '2008-04-06 07:01:58', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('770', '191', '2008-04-09 18:51:56', 'Only at the end of the year, a week before Christmas.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('771', '191', '2008-04-13 06:14:35', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('772', '191', '2008-04-16 16:06:10', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('773', '191', '2008-04-17 07:33:01', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('774', '191', '2008-04-20 14:31:21', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('775', '192', '2008-04-06 10:41:04', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('776', '192', '2008-04-09 15:31:23', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('777', '192', '2008-04-14 10:54:14', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('778', '192', '2008-04-16 17:10:14', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('779', '192', '2008-04-21 06:17:23', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('780', '192', '2008-04-24 15:10:40', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('781', '193', '2008-04-06 12:25:17', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('782', '193', '2008-04-10 13:21:12', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('783', '194', '2008-04-06 11:35:42', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('784', '194', '2008-04-09 18:23:19', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('785', '194', '2008-04-12 06:54:34', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('786', '194', '2008-04-12 14:59:20', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('787', '195', '2008-04-06 11:30:31', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('788', '195', '2008-04-09 14:57:30', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('789', '196', '2008-04-06 10:39:13', 'I made a payment and did not receive an email confirmation', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('790', '196', '2008-04-10 16:36:55', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('791', '196', '2008-04-11 12:36:03', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('792', '196', '2008-04-12 16:16:24', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('793', '197', '2008-04-07 10:13:26', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('794', '197', '2008-04-07 18:20:03', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('795', '197', '2008-04-10 12:29:51', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('796', '197', '2008-04-11 17:33:06', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('797', '197', '2008-04-13 12:08:57', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('798', '197', '2008-04-17 18:55:41', 'Only at the end of the year, a week before Christmas.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('799', '198', '2008-04-07 12:01:27', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('800', '198', '2008-04-08 15:57:42', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('801', '198', '2008-04-09 09:05:47', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('802', '198', '2008-04-14 13:06:36', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('803', '198', '2008-04-18 06:21:33', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('804', '198', '2008-04-23 17:04:47', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('805', '199', '2008-04-07 09:47:28', 'How to classify the customer by priority?', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('806', '199', '2008-04-11 18:13:02', 'Check the user manual the topic How to configure the priority', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('807', '199', '2008-04-14 10:32:44', 'I can not entry more than one phone to a contact.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('808', '199', '2008-04-19 15:55:16', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('809', '200', '2008-04-07 10:21:09', 'I want to cancel my order number 22113121.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('810', '200', '2008-04-09 18:08:39', 'To cancel your order please contact the service and quality center', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('811', '200', '2008-04-14 12:04:59', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('812', '200', '2008-04-17 13:01:59', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('813', '200', '2008-04-19 09:12:36', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('814', '200', '2008-04-23 17:05:51', 'The order was sent and will be delivered in 2 working days.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('815', '201', '2008-04-07 09:32:08', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('816', '201', '2008-04-08 13:25:51', 'Only at the end of the year, a week before Christmas.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('817', '201', '2008-04-09 09:33:42', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('818', '201', '2008-04-11 15:59:09', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('819', '201', '2008-04-14 10:21:25', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('820', '201', '2008-04-15 14:21:18', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('821', '202', '2008-04-07 06:07:11', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('822', '202', '2008-04-11 15:33:49', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('823', '203', '2008-04-07 09:33:06', 'Customers file display na error in the e-mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('824', '203', '2008-04-09 18:49:48', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('825', '204', '2008-04-07 08:53:15', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('826', '204', '2008-04-07 15:40:26', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('827', '205', '2008-04-07 12:46:55', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('828', '205', '2008-04-12 18:50:27', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('829', '205', '2008-04-17 06:34:08', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('830', '205', '2008-04-18 14:43:59', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('831', '205', '2008-04-22 09:51:22', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('832', '205', '2008-04-23 18:41:42', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('833', '206', '2008-04-08 11:04:30', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('834', '206', '2008-04-10 14:04:00', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('835', '206', '2008-04-12 12:50:06', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('836', '206', '2008-04-15 14:47:49', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('837', '206', '2008-04-19 12:38:07', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('838', '206', '2008-04-21 18:57:00', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('839', '207', '2008-04-08 06:10:15', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('840', '207', '2008-04-12 16:51:55', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('841', '207', '2008-04-17 06:47:12', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('842', '207', '2008-04-18 13:01:18', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('843', '207', '2008-04-23 10:58:57', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('844', '207', '2008-04-23 15:12:06', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('845', '208', '2008-04-08 11:59:05', 'My Firefox browser is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('846', '208', '2008-04-12 17:35:08', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('847', '208', '2008-04-13 11:19:15', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('848', '208', '2008-04-15 18:01:42', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('849', '209', '2008-04-08 07:57:00', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('850', '209', '2008-04-12 14:05:25', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('851', '210', '2008-04-08 07:01:04', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('852', '210', '2008-04-09 15:40:35', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('853', '210', '2008-04-10 06:27:37', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('854', '210', '2008-04-13 17:47:06', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('855', '210', '2008-04-16 09:54:46', 'Access to the site is very slow on weekends.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('856', '210', '2008-04-17 15:53:22', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('857', '211', '2008-04-08 08:47:04', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('858', '211', '2008-04-12 17:11:58', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('859', '212', '2008-04-08 07:36:49', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('860', '212', '2008-04-13 16:44:56', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('861', '212', '2008-04-17 12:08:11', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('862', '212', '2008-04-19 14:02:29', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('863', '213', '2008-04-08 06:57:11', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('864', '213', '2008-04-08 17:16:28', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('865', '213', '2008-04-12 11:17:29', 'My Office does not open, or word or excel ...', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('866', '213', '2008-04-13 17:30:02', 'Please, try reinstalling the program.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('867', '214', '2008-04-09 10:49:04', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('868', '214', '2008-04-13 16:40:20', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('869', '214', '2008-04-18 12:40:09', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('870', '214', '2008-04-19 15:59:12', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('871', '214', '2008-04-22 12:21:22', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('872', '214', '2008-04-23 16:02:23', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('873', '215', '2008-04-11 12:03:57', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('874', '215', '2008-04-13 14:16:42', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('875', '216', '2008-04-11 06:40:25', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('876', '216', '2008-04-16 14:33:27', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('877', '216', '2008-04-21 09:13:35', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('878', '216', '2008-04-25 14:37:52', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('879', '216', '2008-04-28 08:59:44', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('880', '216', '2008-04-28 14:49:17', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('881', '217', '2008-04-11 06:16:02', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('882', '217', '2008-04-12 13:04:46', 'Sorry. There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('883', '217', '2008-04-17 11:33:22', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('884', '217', '2008-04-21 16:00:03', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('885', '217', '2008-04-24 06:23:23', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('886', '217', '2008-04-24 13:19:00', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('887', '218', '2008-04-11 09:38:29', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('888', '218', '2008-04-11 14:08:53', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('889', '219', '2008-04-11 10:51:02', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('890', '219', '2008-04-11 15:50:16', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('891', '219', '2008-04-14 08:22:18', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('892', '219', '2008-04-19 15:54:04', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('893', '219', '2008-04-22 08:20:13', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('894', '219', '2008-04-26 14:41:40', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('895', '220', '2008-04-11 08:56:35', 'My Firefox browser is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('896', '220', '2008-04-15 15:26:04', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('897', '220', '2008-04-19 07:14:22', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('898', '220', '2008-04-23 14:54:19', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('899', '221', '2008-04-11 08:09:41', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('900', '221', '2008-04-11 17:05:00', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('901', '221', '2008-04-16 10:12:39', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('902', '221', '2008-04-18 16:49:54', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('903', '221', '2008-04-22 11:37:24', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('904', '221', '2008-04-22 17:17:58', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('905', '222', '2008-04-11 06:01:47', 'I can not open a message attachment.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('906', '222', '2008-04-13 17:48:34', 'The file was blocked because it is an executable.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('907', '222', '2008-04-15 12:37:01', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('908', '222', '2008-04-18 16:21:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('909', '222', '2008-04-21 07:34:32', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('910', '222', '2008-04-22 14:58:02', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('911', '223', '2008-04-12 12:24:44', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('912', '223', '2008-04-13 16:30:10', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('913', '223', '2008-04-14 11:48:52', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('914', '223', '2008-04-19 18:36:42', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('915', '224', '2008-04-12 11:22:21', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('916', '224', '2008-04-13 14:19:50', 'Only at the end of the year, a week before Christmas.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('917', '224', '2008-04-14 08:58:14', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('918', '224', '2008-04-15 17:10:03', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('919', '225', '2008-04-12 11:10:40', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('920', '225', '2008-04-14 14:00:22', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('921', '226', '2008-04-12 06:31:13', 'I made a payment and did not receive an email confirmation', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('922', '226', '2008-04-12 16:08:19', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('923', '226', '2008-04-13 09:05:46', 'I want to cancel my order number 22113121.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('924', '226', '2008-04-16 16:05:36', 'To cancel your order please contact the service and quality center', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('925', '226', '2008-04-20 06:33:36', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('926', '226', '2008-04-22 16:00:42', 'Only at the end of the year, a week before Christmas.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('927', '227', '2008-04-12 09:40:53', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('928', '227', '2008-04-13 15:34:30', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('929', '227', '2008-04-18 09:56:58', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('930', '227', '2008-04-19 13:41:29', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('931', '228', '2008-04-12 08:13:51', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('932', '228', '2008-04-15 14:30:22', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('933', '229', '2008-04-12 12:29:46', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('934', '229', '2008-04-15 14:14:14', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('935', '230', '2008-04-12 07:27:23', 'I made a payment and did not receive an email confirmation', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('936', '230', '2008-04-13 17:25:38', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('937', '230', '2008-04-16 06:44:06', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('938', '230', '2008-04-16 16:46:46', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('939', '230', '2008-04-20 07:27:20', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('940', '230', '2008-04-20 17:35:12', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('941', '231', '2008-04-12 09:17:23', 'My user has no access to the Costs by departments report.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('942', '231', '2008-04-12 13:42:58', 'This report can now be accessed only by users with manager profile .', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('943', '232', '2008-04-12 12:42:20', 'The generated  proposals are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('944', '232', '2008-04-16 14:14:38', 'Check your client spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('945', '233', '2008-04-13 11:14:17', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('946', '233', '2008-04-14 15:56:40', 'We already provided the fix.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('947', '234', '2008-04-13 07:31:01', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('948', '234', '2008-04-14 14:49:41', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('949', '234', '2008-04-16 06:11:55', 'The HD has the following error message: Reading Error', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('950', '234', '2008-04-18 17:00:25', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('951', '235', '2008-04-13 12:15:27', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('952', '235', '2008-04-18 16:26:44', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('953', '235', '2008-04-22 11:39:43', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('954', '235', '2008-04-22 14:23:11', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('955', '235', '2008-04-26 10:54:34', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('956', '235', '2008-04-27 15:11:10', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('957', '236', '2008-04-13 07:43:43', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('958', '236', '2008-04-13 16:24:51', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('959', '237', '2008-04-13 06:42:21', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('960', '237', '2008-04-14 14:51:26', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('961', '237', '2008-04-17 11:31:10', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('962', '237', '2008-04-18 13:02:47', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('963', '238', '2008-04-13 06:55:22', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('964', '238', '2008-04-15 17:58:57', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('965', '238', '2008-04-16 06:21:33', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('966', '238', '2008-04-16 13:38:52', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('967', '238', '2008-04-21 11:54:09', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('968', '238', '2008-04-22 16:18:55', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('969', '239', '2008-04-13 09:07:58', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('970', '239', '2008-04-15 14:02:15', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('971', '240', '2008-04-13 12:39:09', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('972', '240', '2008-04-18 15:08:08', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('973', '240', '2008-04-22 09:05:30', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('974', '240', '2008-04-26 17:42:20', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('975', '241', '2008-04-13 09:55:39', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('976', '241', '2008-04-16 17:11:05', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('977', '241', '2008-04-21 07:04:05', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('978', '241', '2008-04-24 17:32:14', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('979', '242', '2008-04-13 11:16:43', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('980', '242', '2008-04-17 16:58:06', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('981', '242', '2008-04-22 12:02:41', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('982', '242', '2008-04-23 18:52:13', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('983', '242', '2008-04-24 12:06:48', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('984', '242', '2008-04-25 15:10:03', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('985', '243', '2008-04-13 12:17:45', 'Customers file display na error in the e-mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('986', '243', '2008-04-13 16:10:05', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('987', '243', '2008-04-16 06:25:46', 'How can I access a client last orders?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('988', '243', '2008-04-16 14:11:15', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('989', '244', '2008-04-13 07:32:57', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('990', '244', '2008-04-17 18:09:15', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('991', '245', '2008-04-13 08:39:57', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('992', '245', '2008-04-18 13:28:22', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('993', '245', '2008-04-19 08:25:08', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('994', '245', '2008-04-19 16:11:17', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('995', '246', '2008-04-13 09:32:03', 'Customers file display na error in the e-mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('996', '246', '2008-04-18 15:32:34', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('997', '246', '2008-04-22 08:26:00', 'I can not entry more than one phone to a contact.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('998', '246', '2008-04-26 17:44:52', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('999', '247', '2008-04-13 12:03:28', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1000', '247', '2008-04-17 16:36:21', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1001', '248', '2008-04-14 12:30:11', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1002', '248', '2008-04-14 18:32:37', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1003', '249', '2008-04-14 08:32:27', 'Access to the site is very slow on weekends.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1004', '249', '2008-04-16 17:20:21', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1005', '250', '2008-04-14 11:14:54', 'How can I access a client last orders?', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1006', '250', '2008-04-19 15:57:56', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1007', '251', '2008-04-14 11:58:41', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1008', '251', '2008-04-15 18:35:51', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1009', '251', '2008-04-17 11:38:40', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1010', '251', '2008-04-19 14:14:45', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1011', '252', '2008-04-14 11:40:10', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1012', '252', '2008-04-14 17:45:29', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1013', '253', '2008-04-14 12:02:56', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1014', '253', '2008-04-16 17:29:34', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1015', '253', '2008-04-21 09:15:54', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1016', '253', '2008-04-21 18:31:45', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1017', '253', '2008-04-23 11:36:47', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1018', '253', '2008-04-25 17:28:27', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1019', '254', '2008-04-14 10:25:30', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1020', '254', '2008-04-17 16:42:10', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1021', '254', '2008-04-18 11:02:17', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1022', '254', '2008-04-23 13:01:07', 'We already provided the fix.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1023', '255', '2008-04-15 12:48:22', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1024', '255', '2008-04-18 13:49:53', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1025', '255', '2008-04-23 06:50:59', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1026', '255', '2008-04-25 15:13:51', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1027', '256', '2008-04-15 09:32:56', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1028', '256', '2008-04-17 18:46:04', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1029', '256', '2008-04-19 08:54:30', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1030', '256', '2008-04-23 15:08:55', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1031', '257', '2008-04-15 08:09:34', 'How can I access a client last orders?', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1032', '257', '2008-04-15 15:42:58', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1033', '258', '2008-04-15 12:36:03', 'The HD has the following error message: Reading Error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1034', '258', '2008-04-15 17:07:54', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1035', '258', '2008-04-20 10:09:23', 'My keyboard  is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1036', '258', '2008-04-23 13:45:17', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1037', '259', '2008-04-15 09:45:02', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1038', '259', '2008-04-18 17:24:40', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1039', '259', '2008-04-19 06:16:57', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1040', '259', '2008-04-20 13:08:50', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1041', '260', '2008-04-15 09:04:37', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1042', '260', '2008-04-16 18:29:10', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1043', '261', '2008-04-15 08:24:38', 'Access to the site is very slow on weekends.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1044', '261', '2008-04-17 17:06:09', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1045', '261', '2008-04-18 12:18:27', 'I can not download the technical standards manual.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1046', '261', '2008-04-19 17:25:44', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1047', '261', '2008-04-23 08:32:33', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1048', '261', '2008-04-24 14:10:59', 'Sorry. There was an error and it now is corrected.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1049', '262', '2008-04-15 07:21:35', 'How to classify the customer by priority?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1050', '262', '2008-04-18 17:13:06', 'Check the user manual the topic How to configure the priority', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1051', '262', '2008-04-21 11:46:59', 'The generated  proposals are not being sent by email.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1052', '262', '2008-04-22 16:46:09', 'Check your client spam filter.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1053', '263', '2008-04-16 11:28:49', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1054', '263', '2008-04-19 18:03:57', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1055', '263', '2008-04-22 11:58:12', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1056', '263', '2008-04-23 18:12:09', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1057', '263', '2008-04-23 11:17:00', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1058', '263', '2008-04-23 18:41:07', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1059', '264', '2008-04-16 10:02:39', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1060', '264', '2008-04-18 14:15:01', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1061', '264', '2008-04-19 07:57:52', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1062', '264', '2008-04-22 16:09:02', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1063', '264', '2008-04-24 06:22:17', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1064', '264', '2008-04-27 17:56:39', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1065', '265', '2008-04-16 09:44:25', 'Customers file display na error in the e-mail.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1066', '265', '2008-04-16 15:00:40', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1067', '265', '2008-04-21 11:45:55', 'The generated  proposals are not being sent by email.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1068', '265', '2008-04-25 13:13:39', 'Check your client spam filter.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1069', '265', '2008-05-01 07:16:52', 'How can I access a client last orders?', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1070', '265', '2008-05-01 15:59:33', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1071', '266', '2008-04-16 08:48:23', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1072', '266', '2008-04-17 17:40:23', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1073', '266', '2008-04-18 12:45:19', 'The mouse does not move to the side', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1074', '266', '2008-04-18 17:28:12', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1075', '267', '2008-04-17 08:14:41', 'My keyboard  is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1076', '267', '2008-04-20 15:19:36', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1077', '267', '2008-04-23 12:45:39', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1078', '267', '2008-04-25 14:07:42', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1079', '268', '2008-04-18 11:54:45', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1080', '268', '2008-04-18 13:54:34', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1081', '268', '2008-04-21 11:11:32', 'My keyboard  is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1082', '268', '2008-04-21 17:21:20', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1083', '268', '2008-04-23 11:55:58', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1084', '268', '2008-04-24 14:07:28', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1085', '269', '2008-04-18 10:16:48', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1086', '269', '2008-04-19 13:42:51', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1087', '270', '2008-04-18 12:13:31', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1088', '270', '2008-04-22 14:00:09', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1089', '270', '2008-04-23 10:17:02', 'My Firefox browser is displaying na Javascript error', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1090', '270', '2008-04-25 13:39:30', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1091', '270', '2008-05-01 06:42:36', 'I can´t write a file in Portuguese.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1092', '270', '2008-05-04 17:13:37', 'Make sure you installed the Portuguese language.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1093', '271', '2008-04-18 06:47:38', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1094', '271', '2008-04-23 16:12:51', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1095', '272', '2008-04-18 10:56:55', 'Customers page is not found from the link on the main menu', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1096', '272', '2008-04-20 16:29:51', 'The problem has been resolved. Please access the site again.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1097', '272', '2008-04-23 12:20:55', 'I can not download the technical standards manual.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1098', '272', '2008-04-26 14:04:37', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1099', '273', '2008-04-18 06:23:44', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1100', '273', '2008-04-19 17:01:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1101', '274', '2008-04-18 08:02:53', 'How to classify the customer by priority?', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1102', '274', '2008-04-23 18:13:04', 'Check the user manual the topic How to configure the priority', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1103', '274', '2008-04-26 12:03:10', 'My user has no access to the Costs by departments report.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1104', '274', '2008-04-27 15:50:22', 'This report can now be accessed only by users with manager profile .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1105', '275', '2008-04-19 06:10:52', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1106', '275', '2008-04-23 18:04:08', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1107', '275', '2008-04-24 10:16:24', 'My keyboard  is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1108', '275', '2008-05-01 18:54:27', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1109', '276', '2008-04-19 06:32:43', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1110', '276', '2008-04-21 14:01:08', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1111', '276', '2008-04-23 11:43:57', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1112', '276', '2008-04-25 13:49:33', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1113', '276', '2008-04-26 06:17:49', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1114', '276', '2008-04-27 14:12:02', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1115', '277', '2008-04-19 10:17:09', 'My keyboard  is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1116', '277', '2008-04-20 16:21:56', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1117', '277', '2008-04-21 11:13:26', 'My desktop does not turn on', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1118', '277', '2008-04-23 18:51:06', 'Make sure it is properly connected to the power supply.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1119', '277', '2008-04-23 09:23:47', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1120', '277', '2008-04-25 15:08:03', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1121', '278', '2008-04-19 12:43:40', 'My Firefox browser is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1122', '278', '2008-04-23 13:57:37', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1123', '278', '2008-04-24 07:41:39', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1124', '278', '2008-04-26 13:06:02', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1125', '278', '2008-05-01 08:21:10', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1126', '278', '2008-05-02 13:16:43', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1127', '279', '2008-04-19 10:18:34', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1128', '279', '2008-04-22 17:34:54', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1129', '279', '2008-04-23 11:05:14', 'The mouse does not move to the side', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1130', '279', '2008-04-24 13:23:44', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1131', '280', '2008-04-19 08:13:03', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1132', '280', '2008-04-23 13:27:31', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1133', '280', '2008-04-27 06:52:22', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1134', '280', '2008-05-01 17:55:20', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1135', '281', '2008-04-19 09:01:45', 'My keyboard  is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1136', '281', '2008-04-21 18:29:39', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1137', '282', '2008-04-19 07:26:25', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1138', '282', '2008-04-21 13:11:42', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1139', '283', '2008-04-20 09:17:57', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1140', '283', '2008-04-21 13:39:17', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1141', '284', '2008-04-20 10:23:46', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1142', '284', '2008-04-20 16:19:38', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1143', '285', '2008-04-20 11:23:30', 'Customers page is not found from the link on the main menu', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1144', '285', '2008-04-22 14:44:15', 'The problem has been resolved. Please access the site again.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1145', '285', '2008-04-23 07:01:03', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1146', '285', '2008-04-23 13:46:41', 'Sorry. There was an error and it now is corrected.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1147', '285', '2008-04-26 08:53:03', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1148', '285', '2008-04-28 17:59:57', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1149', '286', '2008-04-20 11:41:57', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1150', '286', '2008-04-21 16:58:07', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1151', '286', '2008-04-24 11:06:35', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1152', '286', '2008-04-26 13:08:51', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1153', '287', '2008-04-20 07:34:01', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1154', '287', '2008-04-23 18:00:25', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1155', '287', '2008-04-24 07:32:04', 'My Firefox browser is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1156', '287', '2008-04-25 14:02:01', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1157', '288', '2008-04-20 09:09:26', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1158', '288', '2008-04-22 16:09:42', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1159', '288', '2008-04-26 07:38:50', 'How can I access a client last orders?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1160', '288', '2008-05-01 17:02:21', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1161', '289', '2008-04-20 11:25:13', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1162', '289', '2008-04-20 16:46:16', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1163', '289', '2008-04-23 09:03:24', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1164', '289', '2008-04-27 15:16:46', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1165', '290', '2008-04-20 10:57:38', 'My keyboard  is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1166', '290', '2008-04-22 15:37:39', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1167', '290', '2008-04-23 07:53:36', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1168', '290', '2008-04-24 14:14:48', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1169', '290', '2008-04-27 08:31:53', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1170', '290', '2008-05-01 18:52:00', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1171', '291', '2008-04-20 08:14:51', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1172', '291', '2008-04-23 18:19:27', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1173', '291', '2008-04-23 09:47:45', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1174', '291', '2008-04-23 15:04:09', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1175', '292', '2008-04-21 09:41:15', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1176', '292', '2008-04-23 15:02:09', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1177', '292', '2008-04-24 10:24:15', 'I want to cancel my order number 22113121.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1178', '292', '2008-04-26 14:54:26', 'To cancel your order please contact the service and quality center', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1179', '293', '2008-04-21 06:55:35', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1180', '293', '2008-04-22 13:24:32', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1181', '294', '2008-04-21 11:33:47', 'My Office does not open, or word or excel ...', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1182', '294', '2008-04-23 14:41:15', 'Please, try reinstalling the program.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1183', '295', '2008-04-21 11:11:38', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1184', '295', '2008-04-21 13:26:51', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1185', '295', '2008-04-23 08:28:15', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1186', '295', '2008-04-23 17:13:27', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1187', '296', '2008-04-21 07:26:51', 'How to classify the customer by priority?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1188', '296', '2008-04-25 17:33:08', 'Check the user manual the topic How to configure the priority', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1189', '296', '2008-04-27 06:30:26', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1190', '296', '2008-05-01 14:42:29', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1191', '297', '2008-04-21 07:05:51', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1192', '297', '2008-04-21 17:51:57', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1193', '297', '2008-04-25 06:59:33', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1194', '297', '2008-04-25 13:29:11', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1195', '297', '2008-05-01 07:42:33', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1196', '297', '2008-05-01 13:11:27', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1197', '298', '2008-04-21 10:30:35', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1198', '298', '2008-04-21 14:17:26', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1199', '298', '2008-04-23 10:41:21', 'I can not download the technical standards manual.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1200', '298', '2008-04-23 15:17:39', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1201', '299', '2008-04-21 10:03:00', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1202', '299', '2008-04-23 16:06:59', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1203', '300', '2008-04-21 07:38:05', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1204', '300', '2008-04-23 13:07:08', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1205', '300', '2008-04-24 09:31:34', 'The generated  proposals are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1206', '300', '2008-04-25 18:43:57', 'Check your client spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1207', '300', '2008-05-01 10:57:59', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO `ticketmessage` VALUES ('1208', '300', '2008-05-04 13:44:20', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1209', '301', '2008-04-21 08:09:26', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1210', '301', '2008-04-22 18:46:49', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1211', '301', '2008-04-23 12:44:35', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1212', '301', '2008-04-27 18:49:33', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1213', '301', '2008-05-03 06:31:00', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1214', '301', '2008-05-06 13:41:39', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1215', '302', '2008-04-22 12:58:46', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1216', '302', '2008-04-26 13:32:51', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1217', '302', '2008-05-01 09:54:24', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1218', '302', '2008-05-05 15:02:28', 'Sorry. There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1219', '303', '2008-04-22 07:47:00', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1220', '303', '2008-04-26 18:20:14', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1221', '303', '2008-05-01 08:24:45', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1222', '303', '2008-05-01 13:36:52', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1223', '303', '2008-05-01 12:19:39', 'My keyboard  is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1224', '303', '2008-05-04 18:08:16', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1225', '304', '2008-04-22 08:31:01', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1226', '304', '2008-04-25 16:30:21', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1227', '304', '2008-04-28 11:02:10', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1228', '304', '2008-05-01 16:53:58', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1229', '304', '2008-05-04 12:55:32', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1230', '304', '2008-05-06 17:05:47', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1231', '305', '2008-04-22 11:18:10', 'The HD has the following error message: Reading Error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1232', '305', '2008-04-24 17:01:07', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1233', '305', '2008-04-27 06:12:55', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1234', '305', '2008-05-02 18:37:21', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1235', '305', '2008-05-04 09:55:01', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1236', '305', '2008-05-05 18:23:31', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1237', '306', '2008-04-22 06:01:38', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1238', '306', '2008-04-25 16:56:15', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1239', '306', '2008-05-01 09:03:19', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1240', '306', '2008-05-04 16:40:03', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1241', '307', '2008-04-22 06:12:57', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1242', '307', '2008-04-26 18:13:16', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1243', '308', '2008-04-22 12:52:57', 'The word program is locking the file during save.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1244', '308', '2008-04-24 18:40:03', 'Make sure there is enough space on disk.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1245', '308', '2008-04-28 09:17:13', 'I want to export my Outlook files to cvs.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1246', '308', '2008-05-02 13:38:08', 'Check the program menu the option to export', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1247', '309', '2008-04-22 09:12:19', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1248', '309', '2008-04-22 17:03:48', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1249', '309', '2008-04-23 11:18:07', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1250', '309', '2008-04-24 16:01:04', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1251', '309', '2008-04-27 12:06:22', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1252', '309', '2008-04-27 18:12:52', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1253', '310', '2008-04-23 11:40:32', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1254', '310', '2008-04-24 14:02:14', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1255', '310', '2008-04-27 08:18:43', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1256', '310', '2008-04-28 18:12:16', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1257', '310', '2008-05-01 06:16:23', 'My Firefox browser is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1258', '310', '2008-05-05 14:08:06', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1259', '311', '2008-04-23 11:41:10', 'My desktop does not turn on', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1260', '311', '2008-04-25 13:15:24', 'Make sure it is properly connected to the power supply.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1261', '312', '2008-04-23 10:04:06', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1262', '312', '2008-04-24 16:03:30', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1263', '312', '2008-04-27 06:51:19', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1264', '312', '2008-05-01 18:42:40', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1265', '313', '2008-04-23 11:32:43', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1266', '313', '2008-04-23 15:16:22', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1267', '313', '2008-04-25 08:46:44', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1268', '313', '2008-04-27 18:58:53', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1269', '314', '2008-04-24 09:59:42', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1270', '314', '2008-04-24 18:39:48', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1271', '314', '2008-04-27 08:26:35', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1272', '314', '2008-04-28 13:24:49', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1273', '315', '2008-04-25 12:06:54', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1274', '315', '2008-04-25 14:26:58', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1275', '316', '2008-04-25 09:09:46', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1276', '316', '2008-04-27 16:57:23', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1277', '316', '2008-05-01 11:18:00', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1278', '316', '2008-05-04 14:36:08', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1279', '317', '2008-04-25 10:20:56', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1280', '317', '2008-05-01 18:58:51', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1281', '317', '2008-05-03 08:49:42', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1282', '317', '2008-05-03 13:30:49', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1283', '317', '2008-05-04 12:51:42', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1284', '317', '2008-05-06 18:59:49', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1285', '318', '2008-04-25 06:42:46', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1286', '318', '2008-05-01 13:02:43', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1287', '318', '2008-05-04 12:51:39', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1288', '318', '2008-05-07 16:46:58', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1289', '319', '2008-04-25 08:01:57', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1290', '319', '2008-05-01 14:41:36', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1291', '319', '2008-05-05 07:16:46', 'My Firefox browser is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1292', '319', '2008-05-08 16:06:42', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1293', '319', '2008-05-11 12:14:41', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1294', '319', '2008-05-11 14:38:50', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1295', '320', '2008-04-25 06:28:05', 'How can I access a client last orders?', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1296', '320', '2008-05-01 13:03:34', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1297', '320', '2008-05-03 06:23:28', 'The generated  proposals are not being sent by email.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1298', '320', '2008-05-06 15:38:06', 'Check your client spam filter.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1299', '321', '2008-04-26 09:29:29', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1300', '321', '2008-04-28 16:32:09', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1301', '321', '2008-05-04 07:55:09', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1302', '321', '2008-05-08 15:31:00', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1303', '321', '2008-05-12 07:32:20', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1304', '321', '2008-05-15 17:53:14', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1305', '322', '2008-04-26 10:32:03', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1306', '322', '2008-04-27 17:24:32', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1307', '323', '2008-04-26 12:34:36', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1308', '323', '2008-05-02 14:23:59', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1309', '323', '2008-05-05 10:39:19', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1310', '323', '2008-05-06 16:45:14', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1311', '324', '2008-04-26 12:03:28', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1312', '324', '2008-05-02 18:20:34', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1313', '324', '2008-05-07 10:52:47', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1314', '324', '2008-05-08 18:50:44', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1315', '325', '2008-04-26 09:33:55', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1316', '325', '2008-04-28 14:12:47', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1317', '326', '2008-04-27 12:46:22', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1318', '326', '2008-05-03 13:31:42', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1319', '326', '2008-05-08 07:25:44', 'The generated  proposals are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1320', '326', '2008-05-09 17:50:09', 'Check your client spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1321', '327', '2008-04-27 06:15:50', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1322', '327', '2008-05-01 16:48:04', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1323', '328', '2008-04-27 09:35:36', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1324', '328', '2008-05-01 17:36:25', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1325', '328', '2008-05-03 10:28:33', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1326', '328', '2008-05-07 15:23:55', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1327', '328', '2008-05-12 09:02:43', 'The HD has the following error message: Reading Error', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1328', '328', '2008-05-15 17:30:31', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1329', '329', '2008-04-27 08:41:00', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1330', '329', '2008-05-02 17:25:39', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1331', '329', '2008-05-04 06:51:15', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1332', '329', '2008-05-08 18:41:39', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1333', '330', '2008-04-27 07:53:49', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1334', '330', '2008-04-27 16:25:09', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1335', '330', '2008-05-01 09:46:17', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1336', '330', '2008-05-03 15:39:57', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1337', '331', '2008-04-27 11:08:24', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1338', '331', '2008-04-27 13:00:09', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1339', '331', '2008-05-03 09:07:49', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1340', '331', '2008-05-04 15:08:26', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1341', '332', '2008-04-27 07:41:10', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1342', '332', '2008-05-02 17:12:53', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1343', '333', '2008-04-27 09:50:11', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1344', '333', '2008-04-27 18:28:17', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1345', '334', '2008-04-27 11:54:53', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1346', '334', '2008-05-03 18:25:04', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1347', '334', '2008-05-08 12:07:54', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1348', '334', '2008-05-08 15:56:54', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1349', '335', '2008-04-27 07:56:47', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1350', '335', '2008-04-28 18:10:24', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1351', '335', '2008-05-01 10:35:27', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1352', '335', '2008-05-02 16:59:17', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1353', '336', '2008-04-27 10:47:52', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1354', '336', '2008-04-27 18:36:57', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1355', '336', '2008-05-02 08:10:45', 'My keyboard  is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1356', '336', '2008-05-06 15:13:33', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1357', '336', '2008-05-08 11:16:39', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1358', '336', '2008-05-08 15:49:05', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1359', '337', '2008-04-27 07:49:29', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1360', '337', '2008-05-01 14:51:43', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1361', '338', '2008-04-28 06:40:09', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1362', '338', '2008-04-28 14:21:36', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1363', '339', '2008-04-28 12:18:20', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1364', '339', '2008-04-28 18:05:07', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1365', '339', '2008-05-01 11:57:23', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1366', '339', '2008-05-01 17:32:48', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1367', '340', '2008-04-28 08:49:37', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1368', '340', '2008-05-01 15:22:44', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1369', '340', '2008-05-02 12:18:03', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1370', '340', '2008-05-07 14:36:27', 'Only at the end of the year, a week before Christmas.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1371', '340', '2008-05-10 12:28:12', 'I want to cancel my order number 22113121.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1372', '340', '2008-05-14 13:10:59', 'To cancel your order please contact the service and quality center', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1373', '341', '2008-04-28 07:18:11', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1374', '341', '2008-04-28 18:44:11', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1375', '341', '2008-05-01 06:18:39', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1376', '341', '2008-05-01 18:20:00', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1377', '342', '2008-04-28 06:41:16', 'I want to cancel my order number 22113121.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1378', '342', '2008-05-01 13:26:32', 'To cancel your order please contact the service and quality center', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1379', '342', '2008-05-02 07:41:12', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1380', '342', '2008-05-06 17:38:00', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1381', '343', '2008-04-28 06:03:57', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1382', '343', '2008-05-03 15:22:02', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1383', '343', '2008-05-04 08:43:33', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1384', '343', '2008-05-04 15:35:38', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1385', '343', '2008-05-08 12:32:49', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1386', '343', '2008-05-10 15:38:00', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1387', '344', '2008-04-28 07:17:34', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1388', '344', '2008-05-02 17:09:54', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1389', '345', '2008-04-28 07:11:32', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1390', '345', '2008-05-01 14:46:29', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1391', '345', '2008-05-03 12:50:32', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1392', '345', '2008-05-06 17:46:36', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1393', '346', '2008-05-01 12:57:34', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1394', '346', '2008-05-01 13:19:58', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1395', '347', '2008-05-01 12:18:37', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1396', '347', '2008-05-01 15:26:10', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1397', '347', '2008-05-02 08:45:15', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1398', '347', '2008-05-05 18:36:48', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1399', '347', '2008-05-06 08:28:25', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1400', '347', '2008-05-07 17:52:45', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1401', '348', '2008-05-01 09:45:02', 'I want to export my Outlook files to cvs.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1402', '348', '2008-05-01 14:46:08', 'Check the program menu the option to export', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1403', '349', '2008-05-01 10:17:32', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1404', '349', '2008-05-01 16:18:39', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1405', '349', '2008-05-02 10:50:47', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1406', '349', '2008-05-02 13:22:32', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1407', '349', '2008-05-06 10:55:56', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1408', '349', '2008-05-11 13:24:14', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1409', '350', '2008-05-01 11:19:20', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1410', '350', '2008-05-04 16:08:09', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1411', '351', '2008-05-01 07:04:52', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1412', '351', '2008-05-04 17:54:06', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1413', '351', '2008-05-05 11:38:28', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1414', '351', '2008-05-09 13:16:56', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1415', '352', '2008-05-02 10:07:52', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1416', '352', '2008-05-07 16:15:30', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1417', '353', '2008-05-03 10:32:41', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1418', '353', '2008-05-06 14:51:05', 'The order was sent and will be delivered in 2 working days.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1419', '353', '2008-05-08 07:17:00', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1420', '353', '2008-05-13 14:13:32', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1421', '354', '2008-05-03 10:16:16', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1422', '354', '2008-05-04 18:28:40', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1423', '354', '2008-05-08 09:24:52', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1424', '354', '2008-05-08 16:53:10', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1425', '354', '2008-05-13 06:30:24', 'My Firefox browser is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1426', '354', '2008-05-17 13:16:05', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1427', '355', '2008-05-03 10:31:43', 'How can I access a client last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1428', '355', '2008-05-05 18:01:14', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1429', '355', '2008-05-06 11:59:15', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1430', '355', '2008-05-09 17:59:27', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1431', '356', '2008-05-03 10:08:29', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1432', '356', '2008-05-05 16:02:53', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1433', '357', '2008-05-03 11:40:32', 'Access to the site is very slow on weekends.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1434', '357', '2008-05-04 14:55:46', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1435', '357', '2008-05-06 08:54:29', 'I can not download the technical standards manual.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1436', '357', '2008-05-10 15:45:00', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1437', '357', '2008-05-11 10:37:17', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1438', '357', '2008-05-14 13:15:24', 'Sorry. There was an error and it now is corrected.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1439', '358', '2008-05-03 07:56:30', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1440', '358', '2008-05-05 13:39:56', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1441', '359', '2008-05-03 07:02:37', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1442', '359', '2008-05-08 18:10:19', 'Sorry. There was an error and it now is corrected.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1443', '359', '2008-05-10 09:55:08', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1444', '359', '2008-05-10 17:01:12', 'We already provided the fix.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1445', '360', '2008-05-03 11:36:38', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1446', '360', '2008-05-06 13:30:14', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1447', '360', '2008-05-08 09:18:58', 'How to classify the customer by priority?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1448', '360', '2008-05-13 14:06:28', 'Check the user manual the topic How to configure the priority', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1449', '361', '2008-05-03 06:44:49', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1450', '361', '2008-05-08 13:26:07', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1451', '361', '2008-05-13 07:04:08', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1452', '361', '2008-05-18 18:24:45', 'Only at the end of the year, a week before Christmas.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1453', '361', '2008-05-22 11:57:50', 'I made a payment and did not receive an email confirmation', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1454', '361', '2008-05-23 15:45:54', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1455', '362', '2008-05-04 10:04:24', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1456', '362', '2008-05-07 18:10:14', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1457', '362', '2008-05-08 11:52:27', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1458', '362', '2008-05-13 14:31:47', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1459', '362', '2008-05-16 09:29:04', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1460', '362', '2008-05-17 14:25:58', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1461', '363', '2008-05-04 08:58:40', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1462', '363', '2008-05-09 17:38:10', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1463', '364', '2008-05-04 06:41:56', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1464', '364', '2008-05-05 13:46:58', 'Sorry. There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1465', '364', '2008-05-10 08:22:57', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1466', '364', '2008-05-11 18:01:27', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1467', '364', '2008-05-12 12:16:51', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1468', '364', '2008-05-17 18:07:06', 'We already provided the fix.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1469', '365', '2008-05-04 07:10:59', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1470', '365', '2008-05-07 18:41:50', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1471', '366', '2008-05-04 08:00:34', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1472', '366', '2008-05-07 18:19:12', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1473', '366', '2008-05-08 10:28:20', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1474', '366', '2008-05-11 13:35:40', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1475', '367', '2008-05-05 09:55:23', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1476', '367', '2008-05-07 17:13:29', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1477', '368', '2008-05-05 07:56:41', 'I want to cancel my order number 22113121.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1478', '368', '2008-05-06 17:08:22', 'To cancel your order please contact the service and quality center', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1479', '368', '2008-05-10 12:45:10', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1480', '368', '2008-05-11 14:47:56', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1481', '369', '2008-05-05 11:57:46', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1482', '369', '2008-05-10 16:58:14', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1483', '370', '2008-05-05 06:58:31', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1484', '370', '2008-05-06 14:21:30', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1485', '370', '2008-05-10 09:41:42', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1486', '370', '2008-05-14 14:22:24', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1487', '370', '2008-05-17 09:05:05', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1488', '370', '2008-05-20 16:26:13', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1489', '371', '2008-05-05 08:34:34', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1490', '371', '2008-05-06 17:57:57', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1491', '371', '2008-05-07 06:34:22', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1492', '371', '2008-05-11 18:30:36', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1493', '372', '2008-05-05 11:01:43', 'I want to cancel my order number 22113121.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1494', '372', '2008-05-05 17:45:18', 'To cancel your order please contact the service and quality center', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1495', '372', '2008-05-09 11:21:24', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1496', '372', '2008-05-10 15:10:24', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1497', '372', '2008-05-14 10:49:00', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1498', '372', '2008-05-18 17:03:46', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1499', '373', '2008-05-05 09:51:47', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1500', '373', '2008-05-09 18:43:25', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1501', '374', '2008-05-05 06:19:16', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1502', '374', '2008-05-05 16:40:12', 'Only at the end of the year, a week before Christmas.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1503', '374', '2008-05-08 09:13:34', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1504', '374', '2008-05-09 13:08:58', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1505', '374', '2008-05-14 07:42:35', 'I made a payment and did not receive an email confirmation', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1506', '374', '2008-05-14 14:00:25', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1507', '375', '2008-05-05 12:12:59', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1508', '375', '2008-05-06 17:04:17', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1509', '376', '2008-05-05 11:07:02', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1510', '376', '2008-05-09 14:58:38', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1511', '376', '2008-05-10 09:22:54', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1512', '376', '2008-05-11 14:58:31', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1513', '377', '2008-05-05 06:19:16', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1514', '377', '2008-05-08 14:36:33', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1515', '378', '2008-05-05 12:01:18', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1516', '378', '2008-05-07 13:05:15', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1517', '378', '2008-05-09 12:44:39', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1518', '378', '2008-05-10 18:52:04', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1519', '379', '2008-05-05 08:19:55', 'My user has no access to the Costs by departments report.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1520', '379', '2008-05-07 17:26:46', 'This report can now be accessed only by users with manager profile .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1521', '380', '2008-05-05 10:57:20', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1522', '380', '2008-05-09 18:27:03', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1523', '380', '2008-05-12 08:47:32', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1524', '380', '2008-05-16 15:36:59', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1525', '381', '2008-05-05 10:41:03', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1526', '381', '2008-05-05 14:23:30', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1527', '381', '2008-05-06 12:32:36', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1528', '381', '2008-05-09 16:27:21', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1529', '382', '2008-05-05 12:18:42', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1530', '382', '2008-05-07 13:24:39', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1531', '382', '2008-05-12 09:39:57', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1532', '382', '2008-05-14 18:11:35', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1533', '383', '2008-05-05 09:12:27', 'The word program is locking the file during save.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1534', '383', '2008-05-05 14:06:31', 'Make sure there is enough space on disk.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1535', '383', '2008-05-08 07:00:05', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1536', '383', '2008-05-12 17:44:25', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1537', '383', '2008-05-13 08:02:34', 'My Firefox browser is displaying na Javascript error', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1538', '383', '2008-05-17 18:52:04', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1539', '384', '2008-05-06 07:58:45', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1540', '384', '2008-05-11 16:06:31', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1541', '384', '2008-05-12 10:39:06', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1542', '384', '2008-05-14 18:17:41', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1543', '385', '2008-05-06 09:20:47', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1544', '385', '2008-05-10 13:56:29', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1545', '385', '2008-05-14 06:11:27', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1546', '385', '2008-05-18 14:22:23', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1547', '386', '2008-05-06 06:13:36', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1548', '386', '2008-05-11 18:59:13', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1549', '386', '2008-05-15 12:48:37', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1550', '386', '2008-05-16 13:00:40', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1551', '386', '2008-05-17 08:50:24', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1552', '386', '2008-05-17 16:16:34', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1553', '387', '2008-05-06 07:17:41', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1554', '387', '2008-05-08 18:48:05', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1555', '387', '2008-05-09 12:43:42', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1556', '387', '2008-05-14 16:43:05', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1557', '387', '2008-05-19 07:09:53', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1558', '387', '2008-05-20 17:20:48', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1559', '388', '2008-05-06 11:50:45', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1560', '388', '2008-05-06 18:03:22', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1561', '388', '2008-05-09 12:09:31', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1562', '388', '2008-05-10 17:18:24', 'The order was sent and will be delivered in 2 working days.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1563', '389', '2008-05-06 06:35:01', 'I want to cancel my order number 22113121.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1564', '389', '2008-05-08 15:07:17', 'To cancel your order please contact the service and quality center', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1565', '389', '2008-05-10 08:10:51', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1566', '389', '2008-05-13 15:19:15', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1567', '390', '2008-05-06 07:48:47', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1568', '390', '2008-05-07 17:37:25', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1569', '391', '2008-05-06 10:46:59', 'The mouse does not move to the side', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1570', '391', '2008-05-10 14:12:53', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1571', '391', '2008-05-14 06:22:53', 'The HD has the following error message: Reading Error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1572', '391', '2008-05-17 17:38:10', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1573', '392', '2008-05-06 12:36:43', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1574', '392', '2008-05-09 13:24:48', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1575', '392', '2008-05-13 07:01:02', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1576', '392', '2008-05-17 13:13:03', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1577', '392', '2008-05-21 08:00:22', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1578', '392', '2008-05-23 14:16:00', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1579', '393', '2008-05-06 07:27:06', 'My keyboard  is not accepting uppercase.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1580', '393', '2008-05-08 18:25:46', 'Make sure the CapsLock led is on.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1581', '393', '2008-05-11 10:28:56', 'The HD has the following error message: Reading Error', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1582', '393', '2008-05-16 13:28:56', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1583', '394', '2008-05-06 07:15:10', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1584', '394', '2008-05-11 14:28:01', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1585', '395', '2008-05-06 11:40:08', 'The generated  proposals are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1586', '395', '2008-05-11 14:01:36', 'Check your client spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1587', '396', '2008-05-07 09:25:27', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1588', '396', '2008-05-10 13:57:16', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1589', '396', '2008-05-13 08:59:40', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1590', '396', '2008-05-13 14:27:53', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1591', '397', '2008-05-07 09:34:01', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1592', '397', '2008-05-07 16:29:47', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1593', '397', '2008-05-12 08:53:07', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1594', '397', '2008-05-15 18:36:01', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1595', '397', '2008-05-16 06:57:13', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1596', '397', '2008-05-19 17:02:06', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1597', '398', '2008-05-07 10:04:30', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1598', '398', '2008-05-09 18:54:47', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1599', '399', '2008-05-07 07:38:10', 'My battery does not charge any more.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1600', '399', '2008-05-09 14:09:23', 'Please inform the battery model and date of purchase.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1601', '399', '2008-05-14 12:22:18', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1602', '399', '2008-05-14 17:07:42', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1603', '399', '2008-05-18 10:24:23', 'My desktop does not turn on', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1604', '399', '2008-05-18 16:15:51', 'Make sure it is properly connected to the power supply.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1605', '400', '2008-05-07 06:56:40', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1606', '400', '2008-05-07 17:52:04', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1607', '400', '2008-05-12 06:50:05', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1608', '400', '2008-05-15 17:52:12', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1609', '401', '2008-05-07 09:19:57', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1610', '401', '2008-05-10 18:08:09', 'Sorry. There was an error and it now is corrected.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1611', '401', '2008-05-11 10:16:17', 'Customers page is not found from the link on the main menu', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1612', '401', '2008-05-16 18:41:55', 'The problem has been resolved. Please access the site again.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1613', '402', '2008-05-07 11:43:29', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1614', '402', '2008-05-09 17:53:06', 'The order was sent and will be delivered in 2 working days.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1615', '402', '2008-05-11 10:26:15', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1616', '402', '2008-05-11 18:06:13', 'Only at the end of the year, a week before Christmas.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1617', '403', '2008-05-07 09:14:49', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1618', '403', '2008-05-12 16:51:34', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1619', '404', '2008-05-08 06:48:26', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1620', '404', '2008-05-08 13:48:26', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1621', '405', '2008-05-08 10:43:06', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1622', '405', '2008-05-12 16:12:56', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1623', '405', '2008-05-17 11:34:18', 'My desktop does not turn on', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1624', '405', '2008-05-17 18:37:20', 'Make sure it is properly connected to the power supply.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1625', '406', '2008-05-08 12:14:42', 'My desktop does not turn on', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1626', '406', '2008-05-12 17:55:00', 'Make sure it is properly connected to the power supply.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1627', '406', '2008-05-16 11:13:10', 'The HD has the following error message: Reading Error', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1628', '406', '2008-05-20 14:19:08', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1629', '407', '2008-05-08 09:17:24', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1630', '407', '2008-05-11 14:48:45', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1631', '407', '2008-05-15 10:44:49', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1632', '407', '2008-05-15 15:28:52', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1633', '408', '2008-05-08 07:53:31', 'I want to export my Outlook files to cvs.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1634', '408', '2008-05-09 14:18:50', 'Check the program menu the option to export', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1635', '409', '2008-05-09 08:52:08', 'Customers page is not found from the link on the main menu', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1636', '409', '2008-05-12 14:25:45', 'The problem has been resolved. Please access the site again.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1637', '409', '2008-05-17 12:08:09', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1638', '409', '2008-05-22 18:09:43', 'Sorry. There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1639', '409', '2008-05-24 09:46:16', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1640', '409', '2008-05-24 18:29:27', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1641', '410', '2008-05-09 10:32:28', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1642', '410', '2008-05-10 13:20:42', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1643', '411', '2008-05-10 07:39:38', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1644', '411', '2008-05-11 13:55:11', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1645', '411', '2008-05-13 11:12:30', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1646', '411', '2008-05-15 18:43:24', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1647', '412', '2008-05-10 09:11:15', 'My Firefox browser is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1648', '412', '2008-05-12 14:13:20', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1649', '413', '2008-05-10 07:12:17', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1650', '413', '2008-05-13 15:14:03', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1651', '414', '2008-05-10 11:32:59', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1652', '414', '2008-05-14 17:51:48', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1653', '414', '2008-05-19 09:58:39', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1654', '414', '2008-05-20 13:51:58', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1655', '415', '2008-05-10 06:25:45', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1656', '415', '2008-05-13 18:10:41', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1657', '416', '2008-05-10 12:07:07', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1658', '416', '2008-05-11 16:01:37', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1659', '416', '2008-05-16 12:45:32', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1660', '416', '2008-05-17 13:57:51', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1661', '416', '2008-05-22 08:22:34', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1662', '416', '2008-05-25 15:56:18', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1663', '417', '2008-05-10 08:04:19', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1664', '417', '2008-05-11 13:01:12', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1665', '418', '2008-05-10 09:14:18', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1666', '418', '2008-05-13 15:02:18', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1667', '418', '2008-05-16 07:43:02', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1668', '418', '2008-05-19 17:05:19', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1669', '419', '2008-05-10 06:18:55', 'I can not entry more than one phone to a contact.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1670', '419', '2008-05-15 15:47:06', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1671', '420', '2008-05-10 06:38:54', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1672', '420', '2008-05-15 16:00:01', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1673', '420', '2008-05-19 11:36:19', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1674', '420', '2008-05-22 14:56:17', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1675', '421', '2008-05-10 10:05:59', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1676', '421', '2008-05-14 15:06:55', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1677', '421', '2008-05-18 08:51:48', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1678', '421', '2008-05-20 14:18:18', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1679', '422', '2008-05-10 12:24:17', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1680', '422', '2008-05-15 14:52:04', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1681', '422', '2008-05-20 11:05:17', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1682', '422', '2008-05-21 15:41:56', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1683', '423', '2008-05-11 06:58:24', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1684', '423', '2008-05-12 13:26:05', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1685', '423', '2008-05-17 09:20:04', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1686', '423', '2008-05-18 16:56:31', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1687', '423', '2008-05-23 07:00:44', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1688', '423', '2008-05-24 14:16:24', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1689', '424', '2008-05-11 12:21:18', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1690', '424', '2008-05-11 17:31:42', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1691', '424', '2008-05-15 07:35:18', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1692', '424', '2008-05-19 15:46:41', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1693', '425', '2008-05-11 08:50:42', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1694', '425', '2008-05-13 16:55:41', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1695', '425', '2008-05-16 07:13:13', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1696', '425', '2008-05-19 16:49:51', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1697', '426', '2008-05-11 08:04:52', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1698', '426', '2008-05-14 14:44:45', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1699', '427', '2008-05-11 07:50:45', 'The generated  proposals are not being sent by email.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1700', '427', '2008-05-11 14:37:56', 'Check your client spam filter.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1701', '428', '2008-05-11 11:36:23', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1702', '428', '2008-05-16 15:49:34', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1703', '428', '2008-05-20 09:41:31', 'My keyboard  is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1704', '428', '2008-05-20 15:38:45', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1705', '429', '2008-05-12 08:51:52', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1706', '429', '2008-05-13 18:17:46', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', '');
INSERT INTO `ticketmessage` VALUES ('1707', '430', '2008-05-12 10:32:47', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1708', '430', '2008-05-13 14:03:14', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1709', '430', '2008-05-17 08:26:04', 'Customers page is not found from the link on the main menu', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1710', '430', '2008-05-18 16:10:56', 'The problem has been resolved. Please access the site again.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1711', '431', '2008-05-12 09:50:10', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1712', '431', '2008-05-13 15:01:10', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1713', '431', '2008-05-15 09:13:05', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1714', '431', '2008-05-20 15:27:32', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1715', '431', '2008-05-25 11:33:44', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1716', '431', '2008-05-28 14:04:19', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1717', '432', '2008-05-12 08:31:16', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1718', '432', '2008-05-16 17:40:04', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1719', '432', '2008-05-20 12:17:00', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1720', '432', '2008-05-25 15:23:08', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1721', '433', '2008-05-12 10:47:45', 'My user has no access to the Costs by departments report.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1722', '433', '2008-05-12 13:41:03', 'This report can now be accessed only by users with manager profile .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1723', '433', '2008-05-14 07:03:02', 'How can I access a client last orders?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1724', '433', '2008-05-14 13:41:22', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1725', '433', '2008-05-17 07:32:16', 'How to classify the customer by priority?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1726', '433', '2008-05-18 14:32:55', 'Check the user manual the topic How to configure the priority', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1727', '434', '2008-05-12 12:05:19', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1728', '434', '2008-05-14 13:49:04', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1729', '434', '2008-05-16 12:35:25', 'My Firefox browser is displaying na Javascript error', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1730', '434', '2008-05-19 17:29:09', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1731', '435', '2008-05-12 08:44:45', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1732', '435', '2008-05-17 18:00:33', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1733', '436', '2008-05-12 11:36:10', 'Customers page is not found from the link on the main menu', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1734', '436', '2008-05-15 17:13:52', 'The problem has been resolved. Please access the site again.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1735', '436', '2008-05-19 10:29:40', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1736', '436', '2008-05-22 13:47:12', 'We already provided the fix.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1737', '437', '2008-05-12 07:08:29', 'My keyboard  is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1738', '437', '2008-05-15 18:04:53', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1739', '437', '2008-05-18 11:34:49', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1740', '437', '2008-05-18 17:19:06', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1741', '438', '2008-05-12 09:00:50', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1742', '438', '2008-05-17 18:09:09', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1743', '439', '2008-05-12 09:34:25', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1744', '439', '2008-05-14 14:33:25', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1745', '439', '2008-05-16 11:20:21', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1746', '439', '2008-05-20 16:19:53', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1747', '439', '2008-05-23 07:04:26', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1748', '439', '2008-05-27 17:21:04', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1749', '440', '2008-05-12 10:14:00', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1750', '440', '2008-05-14 17:39:13', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1751', '440', '2008-05-19 06:24:17', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1752', '440', '2008-05-21 13:26:56', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1753', '440', '2008-05-23 06:53:01', 'My battery does not charge any more.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1754', '440', '2008-05-28 18:04:07', 'Please inform the battery model and date of purchase.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1755', '441', '2008-05-13 07:26:27', 'Access to the site is very slow on weekends.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1756', '441', '2008-05-17 17:37:54', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1757', '441', '2008-05-18 10:37:48', 'I can not download the technical standards manual.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1758', '441', '2008-05-19 18:51:02', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1759', '441', '2008-05-21 10:57:25', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1760', '441', '2008-05-21 15:35:10', 'We already provided the fix.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1761', '442', '2008-05-13 10:04:05', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1762', '442', '2008-05-16 13:11:02', 'We already provided the fix.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1763', '442', '2008-05-17 08:25:29', 'Customers page is not found from the link on the main menu', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1764', '442', '2008-05-20 14:27:44', 'The problem has been resolved. Please access the site again.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1765', '443', '2008-05-13 12:38:47', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1766', '443', '2008-05-15 15:11:40', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1767', '443', '2008-05-19 06:55:00', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1768', '443', '2008-05-24 16:02:11', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1769', '444', '2008-05-13 10:40:31', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1770', '444', '2008-05-14 18:40:58', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1771', '445', '2008-05-13 08:53:21', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1772', '445', '2008-05-18 15:09:20', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1773', '446', '2008-05-13 12:54:28', 'My user has no access to the Costs by departments report.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1774', '446', '2008-05-13 14:04:48', 'This report can now be accessed only by users with manager profile .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1775', '446', '2008-05-17 10:31:44', 'How can I access a client last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1776', '446', '2008-05-17 15:32:15', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1777', '447', '2008-05-13 07:57:46', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1778', '447', '2008-05-15 18:29:18', 'The order was sent and will be delivered in 2 working days.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1779', '447', '2008-05-18 07:16:38', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1780', '447', '2008-05-22 17:38:52', 'Only at the end of the year, a week before Christmas.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1781', '448', '2008-05-13 06:15:33', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1782', '448', '2008-05-14 13:57:15', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1783', '449', '2008-05-13 07:47:16', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1784', '449', '2008-05-16 13:40:48', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1785', '449', '2008-05-19 07:00:32', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1786', '449', '2008-05-22 18:50:01', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1787', '449', '2008-05-24 06:43:05', 'My Firefox browser is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1788', '449', '2008-05-24 14:22:59', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1789', '450', '2008-05-14 07:36:33', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1790', '450', '2008-05-15 16:14:20', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1791', '450', '2008-05-20 10:10:48', 'My Office does not open, or word or excel ...', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1792', '450', '2008-05-22 15:39:18', 'Please, try reinstalling the program.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1793', '451', '2008-05-14 08:28:17', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1794', '451', '2008-05-19 18:18:37', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1795', '452', '2008-05-14 11:52:02', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1796', '452', '2008-05-15 14:12:23', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1797', '453', '2008-05-14 10:04:21', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1798', '453', '2008-05-15 16:16:02', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1799', '453', '2008-05-17 11:55:31', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1800', '453', '2008-05-22 17:24:09', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1801', '453', '2008-05-23 09:45:46', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1802', '453', '2008-05-26 15:07:44', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1803', '454', '2008-05-14 11:16:11', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1804', '454', '2008-05-16 14:32:02', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1805', '454', '2008-05-21 06:14:41', 'I can not open a message attachment.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1806', '454', '2008-05-21 17:18:24', 'The file was blocked because it is an executable.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1807', '454', '2008-05-22 08:54:24', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1808', '454', '2008-05-25 18:04:59', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1809', '455', '2008-05-14 07:13:11', 'Customers page is not found from the link on the main menu', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1810', '455', '2008-05-18 18:22:26', 'The problem has been resolved. Please access the site again.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1811', '455', '2008-05-19 08:42:30', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1812', '455', '2008-05-23 16:34:17', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1813', '455', '2008-05-27 10:36:11', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1814', '455', '2008-05-28 13:37:40', 'We already provided the fix.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1815', '456', '2008-05-14 06:26:42', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1816', '456', '2008-05-14 14:59:11', 'Sorry. There was an error and it now is corrected.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1817', '456', '2008-05-18 08:41:42', 'I can not download the technical standards manual.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1818', '456', '2008-05-21 14:05:55', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1819', '456', '2008-05-23 11:56:27', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1820', '456', '2008-05-27 18:34:13', 'We already provided the fix.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1821', '457', '2008-05-14 08:24:55', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1822', '457', '2008-05-17 17:49:06', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1823', '458', '2008-05-14 09:15:28', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1824', '458', '2008-05-16 15:18:44', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1825', '458', '2008-05-21 06:09:52', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1826', '458', '2008-05-25 13:48:31', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1827', '459', '2008-05-15 12:37:06', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1828', '459', '2008-05-17 14:28:24', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1829', '459', '2008-05-22 08:18:09', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1830', '459', '2008-05-25 17:44:15', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1831', '460', '2008-05-15 06:26:43', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1832', '460', '2008-05-19 15:43:46', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1833', '461', '2008-05-15 08:05:50', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1834', '461', '2008-05-18 17:03:10', 'Sorry. There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1835', '461', '2008-05-20 10:09:46', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1836', '461', '2008-05-25 15:24:54', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1837', '461', '2008-05-29 11:28:29', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1838', '461', '2008-05-31 15:25:02', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1839', '462', '2008-05-15 06:45:26', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1840', '462', '2008-05-15 18:23:40', 'Only at the end of the year, a week before Christmas.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1841', '462', '2008-05-16 12:48:35', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1842', '462', '2008-05-17 18:23:41', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1843', '462', '2008-05-18 09:17:18', 'I want to cancel my order number 22113121.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1844', '462', '2008-05-19 17:06:01', 'To cancel your order please contact the service and quality center', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1845', '463', '2008-05-16 07:53:48', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1846', '463', '2008-05-16 13:07:30', 'We already provided the fix.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1847', '463', '2008-05-17 09:14:31', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1848', '463', '2008-05-20 14:35:11', 'Sorry. There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1849', '464', '2008-05-16 12:21:30', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1850', '464', '2008-05-18 15:10:15', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1851', '464', '2008-05-20 12:10:01', 'Customers page is not found from the link on the main menu', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1852', '464', '2008-05-20 16:56:26', 'The problem has been resolved. Please access the site again.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1853', '464', '2008-05-24 12:18:49', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1854', '464', '2008-05-28 14:46:57', 'Sorry. There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1855', '465', '2008-05-17 09:34:23', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1856', '465', '2008-05-17 15:43:48', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1857', '466', '2008-05-17 11:04:57', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1858', '466', '2008-05-17 14:23:23', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1859', '466', '2008-05-21 06:55:39', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1860', '466', '2008-05-24 14:09:39', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1861', '466', '2008-05-27 12:18:09', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1862', '466', '2008-05-28 18:21:07', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1863', '467', '2008-05-17 07:53:33', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1864', '467', '2008-05-21 18:08:12', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1865', '467', '2008-05-25 12:51:47', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1866', '467', '2008-05-27 16:51:20', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1867', '468', '2008-05-17 06:23:36', 'My user has no access to the Costs by departments report.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1868', '468', '2008-05-17 15:10:30', 'This report can now be accessed only by users with manager profile .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1869', '468', '2008-05-21 12:25:13', 'I can not entry more than one phone to a contact.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1870', '468', '2008-05-24 14:48:04', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1871', '468', '2008-05-28 06:12:00', 'Customers file display na error in the e-mail.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('1872', '468', '2008-06-02 13:54:18', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1873', '469', '2008-05-17 06:51:47', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1874', '469', '2008-05-19 16:20:47', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1875', '469', '2008-05-24 08:32:41', 'My keyboard  is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1876', '469', '2008-05-28 14:34:13', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1877', '469', '2008-06-02 08:10:11', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1878', '469', '2008-06-04 17:27:59', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1879', '470', '2008-05-17 08:32:09', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1880', '470', '2008-05-20 14:05:51', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1881', '470', '2008-05-25 07:27:25', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1882', '470', '2008-05-30 16:38:33', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1883', '470', '2008-05-31 07:20:46', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1884', '470', '2008-06-01 14:04:53', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1885', '471', '2008-05-17 11:37:05', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1886', '471', '2008-05-20 14:26:53', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1887', '471', '2008-05-21 07:32:34', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1888', '471', '2008-05-21 17:23:02', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1889', '471', '2008-05-22 06:35:28', 'My Firefox browser is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1890', '471', '2008-05-27 15:20:10', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1891', '472', '2008-05-17 11:56:27', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1892', '472', '2008-05-22 18:00:26', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1893', '472', '2008-05-26 11:40:27', 'Customers page is not found from the link on the main menu', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1894', '472', '2008-05-31 16:48:49', 'The problem has been resolved. Please access the site again.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1895', '473', '2008-05-18 06:55:13', 'My Firefox browser is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1896', '473', '2008-05-22 13:16:29', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1897', '473', '2008-05-26 11:47:49', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1898', '473', '2008-05-30 18:54:28', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1899', '473', '2008-05-31 09:41:42', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1900', '473', '2008-06-02 14:56:40', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1901', '474', '2008-05-18 06:21:52', 'I made a payment and did not receive an email confirmation', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1902', '474', '2008-05-23 14:22:23', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1903', '474', '2008-05-28 06:07:29', 'I want to cancel my order number 22113121.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1904', '474', '2008-05-31 15:37:47', 'To cancel your order please contact the service and quality center', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1905', '475', '2008-05-18 12:41:29', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1906', '475', '2008-05-20 16:44:22', 'We already provided the fix.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1907', '475', '2008-05-25 06:01:48', 'Access to the site is very slow on weekends.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1908', '475', '2008-05-29 15:12:56', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1909', '476', '2008-05-18 09:25:03', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1910', '476', '2008-05-21 17:49:28', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1911', '476', '2008-05-24 09:44:13', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1912', '476', '2008-05-26 14:55:11', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1913', '476', '2008-05-31 08:37:34', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('1914', '476', '2008-06-02 18:46:12', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1915', '477', '2008-05-18 06:01:22', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1916', '477', '2008-05-21 17:04:07', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1917', '478', '2008-05-18 10:20:32', 'A friend said he sent me an email but I did not receive', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1918', '478', '2008-05-22 15:00:01', 'Make sure this email is not on the blocked messages list .', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1919', '478', '2008-05-23 08:21:43', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1920', '478', '2008-05-25 16:35:44', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1921', '478', '2008-05-28 06:28:33', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('1922', '478', '2008-05-31 13:09:20', 'The server was out at that time, but is already operational.', null, null, null, '3', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1923', '479', '2008-05-18 11:12:43', 'I can´t write a file in Portuguese.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1924', '479', '2008-05-20 15:40:26', 'Make sure you installed the Portuguese language.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1925', '479', '2008-05-21 07:44:23', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1926', '479', '2008-05-26 14:43:17', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1927', '479', '2008-05-27 09:29:38', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1928', '479', '2008-06-01 13:20:39', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1929', '480', '2008-05-18 08:15:35', 'How can I access a client last orders?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1930', '480', '2008-05-22 18:36:12', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1931', '481', '2008-05-18 11:37:09', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1932', '481', '2008-05-19 13:16:10', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1933', '482', '2008-05-18 08:18:18', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1934', '482', '2008-05-20 15:10:08', 'We already provided the fix.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1935', '482', '2008-05-25 06:48:04', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('1936', '482', '2008-05-30 15:35:27', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1937', '483', '2008-05-18 11:05:18', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1938', '483', '2008-05-20 17:44:43', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1939', '483', '2008-05-25 12:45:11', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('1940', '483', '2008-05-27 18:11:24', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1941', '484', '2008-05-19 11:29:10', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1942', '484', '2008-05-24 16:21:29', 'The warranty  may be extended by an year with the payment of  10% of the value of the goods.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1943', '484', '2008-05-26 10:06:51', 'I want to cancel my order number 22113121.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1944', '484', '2008-05-31 13:04:41', 'To cancel your order please contact the service and quality center', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1945', '484', '2008-06-05 08:14:08', 'I made a payment and did not receive an email confirmation', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1946', '484', '2008-06-09 16:49:52', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1947', '485', '2008-05-19 09:09:50', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1948', '485', '2008-05-23 18:33:32', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1949', '486', '2008-05-19 11:14:09', 'The generated  proposals are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1950', '486', '2008-05-24 16:41:47', 'Check your client spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1951', '486', '2008-05-27 07:11:16', 'How can I access a client last orders?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1952', '486', '2008-05-30 13:05:46', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1953', '486', '2008-05-31 07:53:51', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1954', '486', '2008-06-04 17:50:30', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1955', '487', '2008-05-19 10:12:29', 'My Office does not open, or word or excel ...', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1956', '487', '2008-05-21 13:36:02', 'Please, try reinstalling the program.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1957', '488', '2008-05-19 09:11:00', 'My Firefox browser is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1958', '488', '2008-05-22 17:13:44', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1959', '488', '2008-05-24 07:15:20', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1960', '488', '2008-05-27 17:20:15', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1961', '488', '2008-06-01 06:19:44', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('1962', '488', '2008-06-06 13:21:15', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1963', '489', '2008-05-19 06:25:20', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1964', '489', '2008-05-22 16:54:58', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1965', '489', '2008-05-27 11:46:50', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1966', '489', '2008-05-31 16:31:42', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1967', '489', '2008-06-04 09:27:08', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1968', '489', '2008-06-08 18:34:28', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1969', '490', '2008-05-19 11:04:21', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1970', '490', '2008-05-22 18:34:29', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1971', '490', '2008-05-24 08:39:13', 'My Office does not open, or word or excel ...', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('1972', '490', '2008-05-24 17:15:17', 'Please, try reinstalling the program.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1973', '491', '2008-05-19 10:07:30', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1974', '491', '2008-05-24 18:19:52', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1975', '491', '2008-05-28 08:04:54', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1976', '491', '2008-05-29 13:32:18', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1977', '491', '2008-05-31 12:17:56', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1978', '491', '2008-06-01 15:27:11', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('1979', '492', '2008-05-19 08:22:13', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1980', '492', '2008-05-23 13:37:05', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1981', '493', '2008-05-19 08:13:31', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1982', '493', '2008-05-20 18:29:00', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1983', '493', '2008-05-21 07:13:51', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1984', '493', '2008-05-25 13:54:22', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1985', '493', '2008-05-27 09:19:36', 'My Firefox browser is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('1986', '493', '2008-05-28 13:56:06', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1987', '494', '2008-05-19 12:12:47', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1988', '494', '2008-05-21 16:17:32', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1989', '494', '2008-05-24 08:12:22', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1990', '494', '2008-05-29 16:02:42', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1991', '494', '2008-06-02 09:26:33', 'My keyboard  is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('1992', '494', '2008-06-05 14:38:12', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1993', '495', '2008-05-19 09:09:41', 'Access to the site is very slow on weekends.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1994', '495', '2008-05-19 13:27:55', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1995', '495', '2008-05-21 09:20:05', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('1996', '495', '2008-05-24 14:21:49', 'Sorry. There was an error and it now is corrected.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('1997', '496', '2008-05-19 08:27:12', 'My user has no access to the Costs by departments report.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('1998', '496', '2008-05-20 16:57:19', 'This report can now be accessed only by users with manager profile .', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('1999', '496', '2008-05-24 11:56:49', 'Customers file display na error in the e-mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('2000', '496', '2008-05-28 16:54:12', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('2001', '497', '2008-05-19 12:55:26', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('2002', '497', '2008-05-20 18:01:12', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('2003', '497', '2008-05-24 10:00:22', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('2004', '497', '2008-05-26 18:04:08', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('2005', '498', '2008-05-20 10:55:35', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('2006', '498', '2008-05-25 18:12:11', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('2007', '498', '2008-05-27 07:19:55', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('2008', '498', '2008-05-28 15:10:07', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('2009', '498', '2008-05-29 09:38:08', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page .', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('2010', '498', '2008-05-31 15:55:08', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('2011', '499', '2008-05-20 08:36:00', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('2012', '499', '2008-05-21 16:19:36', 'Sorry. There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('2013', '499', '2008-05-26 09:25:59', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('2014', '499', '2008-05-30 13:41:47', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('2015', '500', '2008-05-20 09:11:54', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('2016', '500', '2008-05-24 13:35:42', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('2017', '500', '2008-05-27 09:38:33', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('2018', '500', '2008-05-29 13:34:15', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14121', '3501', '2009-07-01 12:17:25', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14122', '3501', '2009-07-04 17:16:00', 'Check spam filter.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14123', '3501', '2009-07-06 06:23:39', 'How can I access last orders?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14124', '3501', '2009-07-10 16:46:40', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14125', '3501', '2009-07-11 09:27:19', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14126', '3501', '2009-07-11 14:26:20', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14127', '3502', '2009-07-03 08:29:53', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14128', '3502', '2009-07-07 16:40:40', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14129', '3502', '2009-07-11 12:26:48', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14130', '3502', '2009-07-13 13:40:15', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14131', '3502', '2009-07-18 11:44:33', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14132', '3502', '2009-07-21 17:15:51', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14133', '3503', '2009-07-04 07:21:06', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14134', '3503', '2009-07-06 14:38:37', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14135', '3503', '2009-07-07 08:25:23', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14136', '3503', '2009-07-12 16:19:20', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14137', '3503', '2009-07-17 11:51:42', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14138', '3503', '2009-07-19 14:11:20', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14139', '3504', '2009-07-04 12:45:44', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14140', '3504', '2009-07-08 17:16:19', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14141', '3505', '2009-07-04 09:23:39', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14142', '3505', '2009-07-07 15:16:52', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14143', '3505', '2009-07-11 07:26:47', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14144', '3505', '2009-07-13 18:33:14', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14145', '3505', '2009-07-14 07:26:35', 'My Firefox is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14146', '3505', '2009-07-15 13:22:17', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14147', '3506', '2009-07-04 07:47:30', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14148', '3506', '2009-07-09 16:39:04', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14149', '3507', '2009-07-04 12:40:47', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14150', '3507', '2009-07-09 18:13:18', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14151', '3508', '2009-07-04 10:43:01', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14152', '3509', '2009-07-04 08:30:26', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14153', '3509', '2009-07-05 13:17:43', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14154', '3509', '2009-07-10 12:03:29', 'My Firefox is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14155', '3509', '2009-07-15 15:47:10', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14156', '3510', '2009-07-04 08:19:01', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14157', '3510', '2009-07-09 18:55:28', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14158', '3510', '2009-07-11 08:53:49', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('14159', '3510', '2009-07-16 17:27:08', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14160', '3511', '2009-07-04 10:53:27', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14161', '3511', '2009-07-09 15:16:44', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14162', '3511', '2009-07-10 12:36:16', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14163', '3511', '2009-07-11 13:52:26', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14164', '3512', '2009-07-04 10:20:58', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14165', '3513', '2009-07-04 06:59:03', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14166', '3513', '2009-07-05 16:15:20', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14167', '3514', '2009-07-05 10:58:58', 'I made a payment and did not receive an email confirmation', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14168', '3514', '2009-07-08 13:54:07', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14169', '3514', '2009-07-11 10:35:24', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14170', '3514', '2009-07-11 16:59:17', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14171', '3514', '2009-07-12 07:40:44', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14172', '3515', '2009-07-05 11:39:38', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14173', '3515', '2009-07-06 15:35:41', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14174', '3515', '2009-07-10 06:58:15', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14175', '3515', '2009-07-10 16:13:56', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14176', '3516', '2009-07-05 08:48:59', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14177', '3516', '2009-07-05 16:19:49', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14178', '3517', '2009-07-05 11:49:33', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14179', '3517', '2009-07-07 14:03:50', 'Only at the end of the year, a week before Christmas.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14180', '3517', '2009-07-08 09:28:01', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14181', '3517', '2009-07-08 16:58:20', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14182', '3518', '2009-07-05 10:45:23', 'How can I access last orders?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14183', '3518', '2009-07-10 14:33:10', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14184', '3519', '2009-07-05 10:01:32', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14185', '3519', '2009-07-09 14:55:12', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14186', '3519', '2009-07-14 08:35:48', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14187', '3519', '2009-07-19 17:12:29', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14188', '3519', '2009-07-22 09:52:43', 'My Firefox is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14189', '3519', '2009-07-22 16:21:39', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14190', '3520', '2009-07-05 07:53:30', 'The generated are not being sent by email.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14191', '3520', '2009-07-05 18:07:34', 'Check spam filter.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14192', '3520', '2009-07-09 08:49:23', 'I can not entry more than one phone to a contact.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14193', '3520', '2009-07-09 17:33:26', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14194', '3520', '2009-07-13 10:05:32', 'My user has no access to the Costs by departments report.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14195', '3520', '2009-07-13 14:06:43', 'This report can now be accessed only by users with manager profile .', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14196', '3521', '2009-07-06 09:31:18', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14197', '3521', '2009-07-10 17:04:19', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14198', '3522', '2009-07-06 12:48:12', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14199', '3522', '2009-07-10 15:52:33', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14200', '3522', '2009-07-15 10:29:01', 'The HD has the following error message: Reading Error', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14201', '3523', '2009-07-06 12:35:54', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14202', '3524', '2009-07-06 12:01:14', 'My keyboard is not accepting uppercase.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14203', '3524', '2009-07-11 16:58:50', 'Make sure the CapsLock led is on.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14204', '3524', '2009-07-16 12:40:07', 'My battery does not charge any more.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('14205', '3524', '2009-07-19 14:17:13', 'Please inform the battery model and date of purchase.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14206', '3525', '2009-07-06 12:57:21', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14207', '3525', '2009-07-08 18:33:02', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14208', '3526', '2009-07-06 12:45:11', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14209', '3526', '2009-07-06 17:21:36', 'The warranty 10% of the value of the goods.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14210', '3526', '2009-07-10 10:57:25', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14211', '3526', '2009-07-12 14:56:27', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14212', '3527', '2009-07-06 12:17:05', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14213', '3527', '2009-07-09 14:03:57', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14214', '3527', '2009-07-13 09:40:12', 'My Firefox is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14215', '3527', '2009-07-14 16:07:38', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14216', '3527', '2009-07-16 06:20:40', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14217', '3527', '2009-07-18 18:50:39', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14218', '3528', '2009-07-06 06:33:41', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14219', '3528', '2009-07-07 14:36:37', 'The order was sent and will be delivered in 2 working days.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14220', '3528', '2009-07-10 11:57:03', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14221', '3528', '2009-07-11 14:11:45', 'Only at the end of the year, a week before Christmas.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14222', '3529', '2009-07-06 08:59:04', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14223', '3529', '2009-07-10 18:45:31', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14224', '3529', '2009-07-14 08:21:20', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14225', '3530', '2009-07-06 06:27:17', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14226', '3530', '2009-07-10 13:57:29', 'The problem has been resolved. Please access the site again.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14227', '3530', '2009-07-15 12:15:34', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14228', '3530', '2009-07-19 15:15:16', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14229', '3531', '2009-07-06 11:52:40', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14230', '3531', '2009-07-06 13:56:09', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14231', '3531', '2009-07-10 10:39:07', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14232', '3531', '2009-07-10 16:48:56', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14233', '3531', '2009-07-15 09:20:15', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14234', '3531', '2009-07-20 16:31:54', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14235', '3532', '2009-07-06 07:48:58', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14236', '3532', '2009-07-09 17:13:47', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14237', '3533', '2009-07-06 07:13:16', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14238', '3533', '2009-07-10 18:47:41', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14239', '3534', '2009-07-06 07:14:52', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14240', '3534', '2009-07-07 17:10:37', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14241', '3535', '2009-07-06 12:59:37', 'My battery does not charge any more.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14242', '3535', '2009-07-06 13:46:18', 'Please inform the battery model and date of purchase.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14243', '3535', '2009-07-07 06:51:55', 'The mouse does not move to the side', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14244', '3535', '2009-07-08 14:58:04', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14245', '3536', '2009-07-06 07:31:22', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14246', '3536', '2009-07-07 17:24:10', 'The order was sent and will be delivered in 2 working days.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14247', '3537', '2009-07-07 06:56:21', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14248', '3537', '2009-07-08 18:17:20', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14249', '3537', '2009-07-12 07:41:36', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14250', '3537', '2009-07-16 15:45:38', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14251', '3538', '2009-07-07 07:12:56', 'My Firefox is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14252', '3538', '2009-07-12 14:33:34', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14253', '3538', '2009-07-16 12:44:50', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14254', '3538', '2009-07-20 16:42:14', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14255', '3539', '2009-07-07 11:09:43', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14256', '3539', '2009-07-11 15:41:10', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14257', '3540', '2009-07-07 12:46:01', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14258', '3540', '2009-07-11 18:51:50', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14259', '3540', '2009-07-13 09:56:26', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14260', '3540', '2009-07-18 16:47:43', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14261', '3541', '2009-07-07 09:11:20', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14262', '3541', '2009-07-09 17:51:21', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14263', '3541', '2009-07-11 12:29:55', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14264', '3541', '2009-07-14 14:33:19', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14265', '3542', '2009-07-07 07:40:48', 'Customers file display na error in the e-mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14266', '3542', '2009-07-11 16:19:19', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14267', '3543', '2009-07-07 11:50:26', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14268', '3543', '2009-07-08 13:19:26', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14269', '3544', '2009-07-07 12:10:39', 'My Firefox is displaying na Javascript error', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14270', '3544', '2009-07-07 13:36:36', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14271', '3544', '2009-07-10 10:12:54', 'The word program is locking the file during save.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14272', '3544', '2009-07-11 18:06:42', 'Make sure there is enough space on disk.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14273', '3544', '2009-07-15 10:10:43', 'I can´t write a file in Portuguese.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14274', '3544', '2009-07-16 16:26:45', 'Make sure you installed the Portuguese language.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14275', '3545', '2009-07-07 11:14:26', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14276', '3545', '2009-07-12 17:35:21', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14277', '3545', '2009-07-14 11:58:37', 'The mouse does not move to the side', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14278', '3545', '2009-07-14 15:37:54', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14279', '3546', '2009-07-07 10:31:53', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14280', '3546', '2009-07-11 14:01:16', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14281', '3546', '2009-07-16 12:45:42', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14282', '3546', '2009-07-19 18:08:41', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14283', '3546', '2009-07-20 09:12:14', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14284', '3546', '2009-07-23 13:20:44', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14285', '3547', '2009-07-07 06:44:23', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14286', '3547', '2009-07-08 13:54:14', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14287', '3548', '2009-07-08 12:30:04', 'My Firefox is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14288', '3548', '2009-07-12 15:03:16', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14289', '3549', '2009-07-08 10:36:50', 'My battery does not charge any more.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14290', '3549', '2009-07-13 16:55:06', 'Please inform the battery model and date of purchase.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14291', '3549', '2009-07-16 10:05:55', 'The mouse does not move to the side', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14292', '3549', '2009-07-16 16:07:30', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14293', '3549', '2009-07-17 06:03:51', 'My desktop does not turn on', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14294', '3549', '2009-07-17 16:02:35', 'Make sure it is properly connected to the power supply.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14295', '3550', '2009-07-08 06:39:46', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14296', '3550', '2009-07-10 17:17:14', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14297', '3550', '2009-07-15 10:16:30', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14298', '3550', '2009-07-16 17:48:06', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14299', '3550', '2009-07-17 11:35:08', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14300', '3550', '2009-07-17 13:47:14', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14301', '3551', '2009-07-08 08:24:15', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14302', '3551', '2009-07-13 17:43:29', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14303', '3551', '2009-07-17 08:58:41', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14304', '3551', '2009-07-19 16:56:03', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14305', '3551', '2009-07-24 11:55:03', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14306', '3551', '2009-07-28 14:19:28', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14307', '3552', '2009-07-08 10:04:01', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', '');
INSERT INTO `ticketmessage` VALUES ('14308', '3552', '2009-07-08 15:38:43', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14309', '3553', '2009-07-08 10:55:48', 'How can I access last orders?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14310', '3553', '2009-07-08 14:10:16', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14311', '3553', '2009-07-12 12:40:10', 'How to classify the customer by priority?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14312', '3553', '2009-07-14 17:40:38', 'Check the user manual the topic How to configure the priority', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14313', '3554', '2009-07-08 09:01:49', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14314', '3555', '2009-07-08 08:10:40', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14315', '3555', '2009-07-13 17:23:44', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14316', '3555', '2009-07-14 11:44:42', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14317', '3555', '2009-07-17 14:55:29', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14318', '3556', '2009-07-08 08:25:41', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14319', '3556', '2009-07-11 16:45:03', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14320', '3556', '2009-07-16 11:45:12', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14321', '3556', '2009-07-19 15:49:10', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14322', '3556', '2009-07-20 11:24:49', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14323', '3556', '2009-07-22 13:32:31', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14324', '3557', '2009-07-08 12:48:15', 'My keyboard is not accepting uppercase.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14325', '3557', '2009-07-08 13:54:25', 'Make sure the CapsLock led is on.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14326', '3557', '2009-07-10 08:16:31', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14327', '3557', '2009-07-14 17:48:41', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14328', '3557', '2009-07-16 09:28:55', 'My battery does not charge any more.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14329', '3558', '2009-07-09 08:37:33', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14330', '3558', '2009-07-13 16:53:35', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14331', '3558', '2009-07-16 11:49:55', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14332', '3558', '2009-07-21 14:14:21', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14333', '3559', '2009-07-09 09:12:24', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14334', '3560', '2009-07-09 09:12:25', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14335', '3560', '2009-07-11 17:08:38', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14336', '3560', '2009-07-14 10:40:11', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14337', '3560', '2009-07-17 14:00:30', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14338', '3560', '2009-07-21 07:51:51', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14339', '3560', '2009-07-23 17:16:26', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14340', '3561', '2009-07-10 11:58:14', 'I made a payment and did not receive an email confirmation', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14341', '3561', '2009-07-14 15:04:28', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14342', '3561', '2009-07-16 11:48:42', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14343', '3561', '2009-07-19 13:37:22', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14344', '3561', '2009-07-23 07:51:00', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14345', '3561', '2009-07-26 14:44:33', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14346', '3562', '2009-07-10 09:57:07', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14347', '3562', '2009-07-14 15:38:48', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14348', '3562', '2009-07-15 07:29:44', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14349', '3562', '2009-07-20 15:11:59', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14350', '3563', '2009-07-11 11:27:03', 'My desktop does not turn on', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14351', '3563', '2009-07-16 14:01:44', 'Make sure it is properly connected to the power supply.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14352', '3563', '2009-07-18 12:32:04', 'My battery does not charge any more.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14353', '3563', '2009-07-19 13:26:17', 'Please inform the battery model and date of purchase.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14354', '3564', '2009-07-11 09:05:54', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14355', '3564', '2009-07-13 13:44:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14356', '3565', '2009-07-11 06:50:42', 'How can I access last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14357', '3565', '2009-07-16 18:04:39', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14358', '3565', '2009-07-19 12:12:19', 'How to classify the customer by priority?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14359', '3565', '2009-07-23 16:53:21', 'Check the user manual the topic How to configure the priority', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14360', '3566', '2009-07-11 12:22:37', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14361', '3566', '2009-07-12 18:47:51', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14362', '3566', '2009-07-16 08:28:04', 'How can I access last orders?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14363', '3566', '2009-07-19 13:41:36', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14364', '3566', '2009-07-20 06:03:14', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14365', '3566', '2009-07-20 15:03:57', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14366', '3567', '2009-07-11 10:19:38', 'My user has no access to the Costs by departments report.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14367', '3567', '2009-07-12 16:52:04', 'This report can now be accessed only by users with manager profile .', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14368', '3567', '2009-07-14 09:26:18', 'The generated are not being sent by email.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14369', '3567', '2009-07-16 13:31:40', 'Check spam filter.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14370', '3568', '2009-07-11 06:52:31', 'Customers page is not found from the link on the main menu', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14371', '3568', '2009-07-11 14:42:21', 'The problem has been resolved. Please access the site again.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14372', '3568', '2009-07-13 06:03:44', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14373', '3568', '2009-07-15 17:26:42', 'We already provided the fix.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14374', '3569', '2009-07-11 12:18:47', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14375', '3569', '2009-07-13 17:51:51', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14376', '3569', '2009-07-14 07:26:25', 'How can I access last orders?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14377', '3569', '2009-07-18 15:42:36', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14378', '3569', '2009-07-23 08:10:11', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14379', '3569', '2009-07-23 14:19:27', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14380', '3570', '2009-07-11 06:39:19', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14381', '3570', '2009-07-13 15:18:36', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14382', '3570', '2009-07-15 06:30:08', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14383', '3570', '2009-07-17 14:27:22', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14384', '3571', '2009-07-11 07:54:37', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14385', '3571', '2009-07-12 18:47:48', 'We already provided the fix.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14386', '3571', '2009-07-14 12:34:51', 'Customers page is not found from the link on the main menu', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14387', '3571', '2009-07-19 16:48:38', 'The problem has been resolved. Please access the site again.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14388', '3572', '2009-07-12 09:50:48', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14389', '3572', '2009-07-13 14:08:32', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14390', '3573', '2009-07-12 09:18:05', 'Customers file display na error in the e-mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14391', '3573', '2009-07-17 14:45:51', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14392', '3573', '2009-07-21 11:31:19', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14393', '3573', '2009-07-26 16:27:15', 'Check spam filter.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14394', '3573', '2009-07-31 12:46:05', 'My user has no access to the Costs by departments report.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14395', '3573', '2009-08-02 13:33:53', 'This report can now be accessed only by users with manager profile .', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14396', '3574', '2009-07-12 08:26:47', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14397', '3574', '2009-07-17 18:03:28', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14398', '3574', '2009-07-20 10:41:02', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14399', '3574', '2009-07-23 15:50:36', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14400', '3574', '2009-07-25 10:48:25', 'My Firefox is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14401', '3574', '2009-07-27 16:40:46', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14402', '3575', '2009-07-12 09:09:27', 'Customers page is not found from the link on the main menu', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14403', '3575', '2009-07-17 15:29:57', 'The problem has been resolved. Please access the site again.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14404', '3575', '2009-07-21 11:44:16', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14405', '3575', '2009-07-23 15:34:42', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14406', '3576', '2009-07-12 07:52:57', 'I can not download the technical standards manual.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14407', '3576', '2009-07-13 14:44:21', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14408', '3576', '2009-07-16 08:24:57', 'Customers page is not found from the link on the main menu', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14409', '3576', '2009-07-19 14:32:20', 'The problem has been resolved. Please access the site again.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14410', '3576', '2009-07-22 06:02:19', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14411', '3576', '2009-07-24 15:24:46', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14412', '3577', '2009-07-12 09:08:41', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14413', '3577', '2009-07-12 13:25:49', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14414', '3577', '2009-07-17 11:47:22', 'How can I access last orders?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14415', '3577', '2009-07-20 17:49:11', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14416', '3578', '2009-07-12 07:19:42', 'The generated are not being sent by email.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14417', '3578', '2009-07-13 17:35:46', 'Check spam filter.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14418', '3579', '2009-07-12 12:10:16', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14419', '3579', '2009-07-15 17:05:42', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14420', '3579', '2009-07-19 08:03:20', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14421', '3579', '2009-07-20 17:38:30', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14422', '3579', '2009-07-25 12:18:25', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14423', '3579', '2009-07-28 18:11:45', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14424', '3580', '2009-07-13 06:45:46', 'My battery does not charge any more.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14425', '3580', '2009-07-16 16:11:34', 'Please inform the battery model and date of purchase.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14426', '3580', '2009-07-18 11:54:51', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14427', '3580', '2009-07-20 14:19:11', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14428', '3580', '2009-07-25 12:28:53', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14429', '3580', '2009-07-30 18:36:17', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14430', '3581', '2009-07-13 07:35:53', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14431', '3581', '2009-07-15 18:13:11', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14432', '3581', '2009-07-17 06:38:03', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14433', '3581', '2009-07-22 15:31:43', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14434', '3581', '2009-07-25 11:20:06', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14435', '3581', '2009-07-28 16:56:20', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14436', '3582', '2009-07-13 12:01:31', 'My user has no access to the Costs by departments report.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14437', '3582', '2009-07-18 16:52:38', 'This report can now be accessed only by users with manager profile .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14438', '3582', '2009-07-22 09:55:11', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14439', '3582', '2009-07-25 15:09:43', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14440', '3582', '2009-07-26 09:15:58', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14441', '3582', '2009-07-27 18:37:19', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14442', '3583', '2009-07-13 11:43:10', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14443', '3583', '2009-07-15 16:52:59', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14444', '3584', '2009-07-13 09:19:08', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14445', '3584', '2009-07-14 17:38:45', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14446', '3584', '2009-07-18 09:59:17', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14447', '3585', '2009-07-13 08:11:56', 'My user has no access to the Costs by departments report.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14448', '3585', '2009-07-18 18:41:40', 'This report can now be accessed only by users with manager profile .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14449', '3585', '2009-07-19 07:21:56', 'Customers file display na error in the e-mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14450', '3585', '2009-07-24 14:14:13', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14451', '3585', '2009-07-26 12:58:16', 'How to classify the customer by priority?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14452', '3585', '2009-07-28 16:57:06', 'Check the user manual the topic How to configure the priority', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14453', '3586', '2009-07-13 08:34:27', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14454', '3586', '2009-07-15 16:14:25', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14455', '3587', '2009-07-13 12:22:25', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14456', '3587', '2009-07-16 15:28:27', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14457', '3587', '2009-07-19 10:50:53', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14458', '3587', '2009-07-24 17:08:01', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14459', '3587', '2009-07-28 06:52:07', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14460', '3587', '2009-07-28 14:37:28', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14461', '3588', '2009-07-13 11:39:11', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14462', '3588', '2009-07-14 16:17:45', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14463', '3589', '2009-07-13 12:00:08', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14464', '3589', '2009-07-13 18:05:59', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14465', '3589', '2009-07-15 07:33:14', 'How can I access last orders?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14466', '3589', '2009-07-16 14:46:35', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14467', '3590', '2009-07-13 06:54:31', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14468', '3590', '2009-07-13 16:55:44', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14469', '3590', '2009-07-16 06:44:26', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14470', '3590', '2009-07-16 16:17:39', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14471', '3591', '2009-07-14 06:13:00', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14472', '3591', '2009-07-19 18:34:19', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14473', '3592', '2009-07-14 09:17:51', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14474', '3592', '2009-07-14 15:40:12', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14475', '3592', '2009-07-15 07:47:56', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14476', '3592', '2009-07-15 17:01:11', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14477', '3593', '2009-07-14 08:00:52', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14478', '3593', '2009-07-14 15:38:09', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14479', '3593', '2009-07-16 11:27:56', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14480', '3593', '2009-07-18 14:56:40', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14481', '3594', '2009-07-14 10:46:10', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14482', '3594', '2009-07-19 14:02:28', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14483', '3594', '2009-07-24 09:49:50', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14484', '3594', '2009-07-27 13:02:32', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14485', '3594', '2009-08-01 11:27:52', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14486', '3594', '2009-08-04 15:58:27', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14487', '3595', '2009-07-14 08:28:06', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14488', '3595', '2009-07-18 18:58:21', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14489', '3595', '2009-07-21 09:22:40', 'I can not open a message attachment.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14490', '3595', '2009-07-22 16:25:05', 'The file was blocked because it is an executable.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14491', '3596', '2009-07-14 09:22:01', 'The word program is locking the file during save.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14492', '3596', '2009-07-14 13:10:12', 'Make sure there is enough space on disk.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14493', '3596', '2009-07-15 07:22:59', 'My Office does not open, or word or excel ...', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14494', '3596', '2009-07-20 16:44:28', 'Please, try reinstalling the program.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14495', '3596', '2009-07-21 06:53:16', 'I can´t write a file in Portuguese.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14496', '3596', '2009-07-21 13:06:31', 'Make sure you installed the Portuguese language.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14497', '3597', '2009-07-14 08:29:31', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14498', '3597', '2009-07-19 14:04:21', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14499', '3597', '2009-07-22 07:44:04', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14500', '3597', '2009-07-24 17:18:55', 'The server was out at that time, but is already operational.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14501', '3598', '2009-07-15 10:47:37', 'My user has no access to the Costs by departments report.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14502', '3598', '2009-07-17 15:23:34', 'This report can now be accessed only by users with manager profile .', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14503', '3599', '2009-07-15 08:39:13', 'I can not entry more than one phone to a contact.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14504', '3599', '2009-07-17 17:01:36', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14505', '3599', '2009-07-22 10:21:40', 'My user has no access to the Costs by departments report.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14506', '3599', '2009-07-24 16:31:36', 'This report can now be accessed only by users with manager profile .', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14507', '3600', '2009-07-15 12:55:20', 'I can not entry more than one phone to a contact.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14508', '3600', '2009-07-16 16:36:03', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14509', '3600', '2009-07-20 09:35:53', 'How to classify the customer by priority?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14510', '3600', '2009-07-24 13:53:31', 'Check the user manual the topic How to configure the priority', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14511', '3601', '2009-07-15 06:18:40', 'My desktop does not turn on', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14512', '3601', '2009-07-16 18:40:22', 'Make sure it is properly connected to the power supply.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14513', '3602', '2009-07-15 06:13:43', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14514', '3602', '2009-07-19 18:54:09', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14515', '3603', '2009-07-15 11:05:08', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14516', '3603', '2009-07-17 17:35:02', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14517', '3604', '2009-07-15 06:14:10', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14518', '3604', '2009-07-16 16:56:40', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14519', '3605', '2009-07-15 07:25:34', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14520', '3606', '2009-07-15 08:09:40', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14521', '3606', '2009-07-18 15:38:32', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14522', '3606', '2009-07-19 08:11:11', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14523', '3606', '2009-07-24 13:16:22', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14524', '3607', '2009-07-16 09:45:16', 'The generated are not being sent by email.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14525', '3608', '2009-07-16 12:52:47', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14526', '3608', '2009-07-16 17:26:03', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14527', '3608', '2009-07-19 12:02:18', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14528', '3608', '2009-07-19 15:22:38', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14529', '3608', '2009-07-24 11:47:31', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14530', '3608', '2009-07-26 15:12:30', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14531', '3609', '2009-07-16 12:32:16', 'I can´t write a file in Portuguese.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14532', '3609', '2009-07-20 17:50:02', 'Make sure you installed the Portuguese language.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14533', '3610', '2009-07-16 06:15:38', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14534', '3610', '2009-07-19 18:51:20', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14535', '3610', '2009-07-21 12:38:26', 'How can I access last orders?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14536', '3610', '2009-07-24 13:34:26', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14537', '3610', '2009-07-28 12:26:14', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14538', '3610', '2009-08-01 18:59:01', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14539', '3611', '2009-07-18 09:33:40', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14540', '3611', '2009-07-18 18:01:14', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14541', '3611', '2009-07-23 07:38:38', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14542', '3611', '2009-07-24 17:26:21', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14543', '3611', '2009-07-25 07:22:16', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14544', '3611', '2009-07-29 14:52:12', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14545', '3612', '2009-07-18 07:21:33', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14546', '3612', '2009-07-21 16:16:18', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14547', '3613', '2009-07-18 11:35:00', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14548', '3613', '2009-07-20 17:50:24', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14549', '3614', '2009-07-18 11:17:59', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14550', '3614', '2009-07-19 17:52:54', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14551', '3614', '2009-07-24 12:16:04', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14552', '3614', '2009-07-27 13:16:25', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14553', '3615', '2009-07-18 10:49:41', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14554', '3615', '2009-07-22 14:13:44', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14555', '3615', '2009-07-23 06:30:55', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14556', '3615', '2009-07-24 13:26:35', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14557', '3615', '2009-07-28 08:06:16', 'My user has no access to the Costs by departments report.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14558', '3615', '2009-08-01 13:35:33', 'This report can now be accessed only by users with manager profile .', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14559', '3616', '2009-07-18 06:59:12', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14560', '3616', '2009-07-21 16:25:35', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14561', '3616', '2009-07-24 06:27:28', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14562', '3616', '2009-07-27 16:52:18', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14563', '3616', '2009-07-30 08:22:04', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14564', '3616', '2009-08-01 17:56:00', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14565', '3617', '2009-07-18 06:29:19', 'My Firefox is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14566', '3617', '2009-07-18 17:06:19', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14567', '3617', '2009-07-23 09:35:06', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14568', '3617', '2009-07-26 14:17:21', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14569', '3618', '2009-07-18 06:00:21', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14570', '3618', '2009-07-23 17:47:37', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14571', '3618', '2009-07-26 12:59:16', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14572', '3618', '2009-07-26 17:22:38', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14573', '3619', '2009-07-18 06:17:57', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14574', '3619', '2009-07-22 18:19:13', 'The warranty 10% of the value of the goods.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14575', '3620', '2009-07-18 06:02:33', 'The HD has the following error message: Reading Error', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14576', '3620', '2009-07-20 13:13:11', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14577', '3620', '2009-07-24 08:05:33', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('14578', '3620', '2009-07-26 15:33:11', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14579', '3620', '2009-07-29 11:14:28', 'My desktop does not turn on', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('14580', '3620', '2009-07-29 17:54:52', 'Make sure it is properly connected to the power supply.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14581', '3621', '2009-07-18 11:27:45', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14582', '3621', '2009-07-18 15:04:12', 'We already provided the fix.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14583', '3622', '2009-07-18 07:45:36', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14584', '3622', '2009-07-19 13:39:41', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14585', '3623', '2009-07-19 07:47:59', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14586', '3623', '2009-07-19 18:49:20', 'Sorry.There was an error and it now is corrected.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14587', '3623', '2009-07-23 10:02:03', 'Customers page is not found from the link on the main menu', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14588', '3623', '2009-07-23 14:30:35', 'The problem has been resolved. Please access the site again.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14589', '3624', '2009-07-19 10:04:05', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14590', '3624', '2009-07-24 13:14:58', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14591', '3624', '2009-07-25 11:37:22', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14592', '3624', '2009-07-30 16:05:06', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14593', '3624', '2009-08-01 08:04:48', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14594', '3625', '2009-07-19 09:05:31', 'How to classify the customer by priority?', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14595', '3625', '2009-07-20 14:50:03', 'Check the user manual the topic How to configure the priority', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14596', '3625', '2009-07-25 06:08:14', 'The generated are not being sent by email.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14597', '3625', '2009-07-28 17:47:25', 'Check spam filter.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14598', '3626', '2009-07-19 10:05:02', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14599', '3626', '2009-07-24 15:28:18', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14600', '3627', '2009-07-19 12:00:15', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14601', '3627', '2009-07-23 17:47:45', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14602', '3627', '2009-07-26 10:17:41', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14603', '3627', '2009-07-27 18:59:52', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14604', '3627', '2009-07-29 06:46:08', 'My keyboard is not accepting uppercase.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14605', '3627', '2009-08-01 13:41:29', 'Make sure the CapsLock led is on.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14606', '3628', '2009-07-19 10:35:24', 'My Office does not open, or word or excel ...', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14607', '3628', '2009-07-21 16:20:41', 'Please, try reinstalling the program.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14608', '3628', '2009-07-24 07:46:52', 'My Firefox is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14609', '3628', '2009-07-29 13:49:47', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14610', '3628', '2009-08-02 10:16:47', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14611', '3629', '2009-07-20 11:40:35', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14612', '3629', '2009-07-25 17:41:24', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14613', '3629', '2009-07-28 11:10:03', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14614', '3630', '2009-07-20 11:51:57', 'My Office does not open, or word or excel ...', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14615', '3630', '2009-07-22 17:56:52', 'Please, try reinstalling the program.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14616', '3631', '2009-07-20 10:56:28', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14617', '3631', '2009-07-20 18:57:48', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14618', '3631', '2009-07-24 07:47:14', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14619', '3631', '2009-07-25 17:37:47', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14620', '3631', '2009-07-27 11:49:32', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14621', '3631', '2009-07-31 15:00:27', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14622', '3632', '2009-07-20 07:37:20', 'I want to export my Outlook files to cvs.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14623', '3632', '2009-07-20 13:27:55', 'Check the program menu the option to export', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14624', '3633', '2009-07-20 07:00:47', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14625', '3633', '2009-07-21 18:06:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14626', '3633', '2009-07-23 12:01:08', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14627', '3633', '2009-07-23 13:57:06', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14628', '3634', '2009-07-20 12:29:38', 'My user has no access to the Costs by departments report.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14629', '3634', '2009-07-25 18:04:19', 'This report can now be accessed only by users with manager profile .', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14630', '3635', '2009-07-20 06:15:03', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14631', '3635', '2009-07-25 18:04:48', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14632', '3636', '2009-07-20 07:19:39', 'My keyboard is not accepting uppercase.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14633', '3636', '2009-07-25 15:44:19', 'Make sure the CapsLock led is on.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14634', '3636', '2009-07-29 11:00:40', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14635', '3636', '2009-08-01 16:07:23', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14636', '3636', '2009-08-06 10:25:07', 'My desktop does not turn on', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14637', '3636', '2009-08-11 18:55:14', 'Make sure it is properly connected to the power supply.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14638', '3637', '2009-07-20 08:30:30', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14639', '3637', '2009-07-25 15:44:57', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14640', '3638', '2009-07-20 08:29:28', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14641', '3638', '2009-07-22 14:24:26', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14642', '3639', '2009-07-20 12:54:38', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14643', '3639', '2009-07-20 17:38:48', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14644', '3639', '2009-07-22 10:07:37', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14645', '3639', '2009-07-22 13:27:41', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14646', '3640', '2009-07-20 10:23:21', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14647', '3640', '2009-07-25 17:35:01', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14648', '3641', '2009-07-20 12:14:58', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14649', '3641', '2009-07-20 16:45:59', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14650', '3641', '2009-07-23 07:41:12', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14651', '3641', '2009-07-27 13:39:27', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14652', '3641', '2009-07-28 07:24:56', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14653', '3642', '2009-07-20 09:18:51', 'How can I access last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14654', '3642', '2009-07-20 16:39:46', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14655', '3642', '2009-07-25 12:10:06', 'The generated are not being sent by email.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14656', '3642', '2009-07-26 17:42:15', 'Check spam filter.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14657', '3642', '2009-07-27 10:56:50', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14658', '3642', '2009-07-30 17:36:15', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14659', '3643', '2009-07-20 10:36:09', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14660', '3644', '2009-07-20 07:04:27', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14661', '3644', '2009-07-20 16:22:57', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14662', '3644', '2009-07-24 08:26:25', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14663', '3644', '2009-07-27 14:54:55', 'The warranty 10% of the value of the goods.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14664', '3645', '2009-07-20 11:22:34', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14665', '3645', '2009-07-22 17:03:53', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14666', '3645', '2009-07-23 09:12:02', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14667', '3645', '2009-07-28 13:26:06', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14668', '3646', '2009-07-21 06:56:38', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14669', '3646', '2009-07-23 16:40:07', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14670', '3646', '2009-07-25 12:11:55', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14671', '3647', '2009-07-21 06:54:08', 'My Office does not open, or word or excel ...', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14672', '3647', '2009-07-21 14:29:31', 'Please, try reinstalling the program.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14673', '3648', '2009-07-21 06:10:15', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14674', '3648', '2009-07-25 17:42:21', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14675', '3649', '2009-07-21 08:59:42', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14676', '3649', '2009-07-22 14:40:04', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14677', '3649', '2009-07-23 07:06:32', 'My keyboard is not accepting uppercase.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14678', '3649', '2009-07-26 13:05:31', 'Make sure the CapsLock led is on.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14679', '3650', '2009-07-21 07:26:17', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14680', '3650', '2009-07-22 15:59:00', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14681', '3651', '2009-07-21 11:10:27', 'I can not download the technical standards manual.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14682', '3651', '2009-07-23 14:29:36', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14683', '3652', '2009-07-21 06:59:38', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14684', '3652', '2009-07-23 16:30:07', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14685', '3652', '2009-07-25 07:16:03', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14686', '3652', '2009-07-29 14:27:39', 'The server was out at that time, but is already operational.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14687', '3652', '2009-07-31 09:23:58', 'A friend said he sent me an email but I did not receive', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14688', '3652', '2009-08-02 16:21:04', 'Make sure this email is not on the blocked messages list .', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14689', '3653', '2009-07-21 10:58:24', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14690', '3653', '2009-07-25 15:48:18', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14691', '3654', '2009-07-21 09:37:51', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14692', '3654', '2009-07-26 15:20:54', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14693', '3654', '2009-07-30 12:56:11', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14694', '3654', '2009-08-02 17:39:04', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14695', '3654', '2009-08-07 11:39:12', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14696', '3654', '2009-08-08 17:11:42', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14697', '3655', '2009-07-21 07:31:51', 'My Office does not open, or word or excel ...', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14698', '3655', '2009-07-21 13:53:57', 'Please, try reinstalling the program.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14699', '3656', '2009-07-21 12:25:23', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14700', '3656', '2009-07-23 13:31:46', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14701', '3657', '2009-07-21 10:17:04', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14702', '3657', '2009-07-23 14:50:20', 'Sorry.There was an error and it now is corrected.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14703', '3658', '2009-07-21 11:49:46', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14704', '3658', '2009-07-23 14:30:06', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14705', '3659', '2009-07-22 10:07:44', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14706', '3659', '2009-07-23 14:56:36', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14707', '3659', '2009-07-28 07:09:00', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14708', '3659', '2009-07-28 14:43:55', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14709', '3659', '2009-07-30 09:22:32', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14710', '3659', '2009-08-03 13:29:54', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14711', '3660', '2009-07-22 11:28:57', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14712', '3660', '2009-07-24 16:16:40', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14713', '3661', '2009-07-22 06:26:40', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14714', '3661', '2009-07-24 14:34:21', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14715', '3662', '2009-07-22 11:44:41', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14716', '3662', '2009-07-23 17:44:34', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14717', '3662', '2009-07-24 12:53:49', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14718', '3662', '2009-07-28 17:25:22', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14719', '3663', '2009-07-22 09:05:53', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14720', '3663', '2009-07-23 15:58:49', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14721', '3663', '2009-07-25 08:10:08', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14722', '3664', '2009-07-22 12:53:34', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14723', '3664', '2009-07-27 13:03:00', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14724', '3665', '2009-07-22 07:37:28', 'I can not download the technical standards manual.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14725', '3665', '2009-07-25 18:15:34', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14726', '3666', '2009-07-22 12:00:54', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14727', '3666', '2009-07-25 14:49:29', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14728', '3667', '2009-07-22 10:42:32', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14729', '3667', '2009-07-26 17:26:43', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14730', '3667', '2009-07-27 10:53:18', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14731', '3667', '2009-08-01 15:09:59', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14732', '3667', '2009-08-06 06:59:47', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14733', '3667', '2009-08-07 13:49:51', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14734', '3668', '2009-07-22 09:54:02', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14735', '3668', '2009-07-23 18:36:09', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14736', '3668', '2009-07-26 11:45:37', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14737', '3668', '2009-07-31 13:40:25', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14738', '3669', '2009-07-23 12:27:03', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14739', '3669', '2009-07-27 17:05:50', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14740', '3670', '2009-07-24 11:39:57', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14741', '3671', '2009-07-24 06:18:35', 'I can not download the technical standards manual.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14742', '3671', '2009-07-28 13:49:32', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14743', '3671', '2009-07-31 07:34:06', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14744', '3671', '2009-08-01 18:42:58', 'Sorry.There was an error and it now is corrected.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14745', '3672', '2009-07-25 12:02:47', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14746', '3672', '2009-07-25 17:41:52', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14747', '3673', '2009-07-25 11:56:56', 'How to classify the customer by priority?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14748', '3673', '2009-07-29 18:45:20', 'Check the user manual the topic How to configure the priority', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14749', '3673', '2009-08-01 09:37:51', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14750', '3673', '2009-08-06 15:19:42', 'Check spam filter.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14751', '3673', '2009-08-11 10:02:11', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14752', '3673', '2009-08-15 17:59:58', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14753', '3674', '2009-07-25 12:12:38', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14754', '3674', '2009-07-28 18:15:46', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14755', '3675', '2009-07-25 09:06:30', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14756', '3675', '2009-07-29 16:03:29', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14757', '3675', '2009-08-03 11:58:06', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14758', '3675', '2009-08-07 14:30:49', 'Only at the end of the year, a week before Christmas.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14759', '3675', '2009-08-08 06:57:34', 'I made a payment and did not receive an email confirmation', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14760', '3675', '2009-08-09 17:08:09', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14761', '3676', '2009-07-25 09:27:21', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14762', '3677', '2009-07-25 09:53:40', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14763', '3677', '2009-07-26 16:40:00', 'Sorry.There was an error and it now is corrected.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14764', '3678', '2009-07-25 07:23:55', 'The word program is locking the file during save.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14765', '3678', '2009-07-27 18:29:26', 'Make sure there is enough space on disk.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14766', '3678', '2009-08-01 12:44:20', 'I can´t write a file in Portuguese.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14767', '3678', '2009-08-05 14:17:06', 'Make sure you installed the Portuguese language.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14768', '3678', '2009-08-09 11:18:19', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14769', '3678', '2009-08-10 15:16:54', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14770', '3679', '2009-07-25 08:47:56', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14771', '3679', '2009-07-27 13:40:02', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14772', '3680', '2009-07-25 11:27:28', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14773', '3680', '2009-07-30 15:55:02', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14774', '3681', '2009-07-26 08:42:47', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14775', '3681', '2009-07-28 16:09:09', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14776', '3681', '2009-08-01 08:43:40', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14777', '3681', '2009-08-04 16:57:50', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14778', '3681', '2009-08-05 09:24:07', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14779', '3682', '2009-07-26 12:30:06', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14780', '3682', '2009-07-30 17:30:06', 'Only at the end of the year, a week before Christmas.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14781', '3682', '2009-08-01 12:07:50', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14782', '3682', '2009-08-04 13:54:23', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14783', '3683', '2009-07-26 07:54:27', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14784', '3683', '2009-07-31 13:43:24', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14785', '3683', '2009-08-01 06:46:39', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14786', '3683', '2009-08-02 14:59:12', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14787', '3683', '2009-08-04 09:39:08', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14788', '3683', '2009-08-06 14:39:39', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14789', '3684', '2009-07-26 11:24:25', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14790', '3684', '2009-07-26 18:52:28', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14791', '3684', '2009-07-28 08:27:32', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14792', '3684', '2009-07-30 13:14:12', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14793', '3685', '2009-07-26 07:24:00', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14794', '3685', '2009-07-30 13:01:54', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14795', '3685', '2009-07-31 07:07:54', 'My keyboard is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14796', '3685', '2009-08-05 16:06:28', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14797', '3685', '2009-08-07 07:39:19', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14798', '3685', '2009-08-08 18:03:05', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14799', '3686', '2009-07-26 10:32:58', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14800', '3686', '2009-07-27 15:57:16', 'Sorry.There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14801', '3686', '2009-08-01 07:31:05', 'Access to the site is very slow on weekends.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14802', '3686', '2009-08-02 16:54:05', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14803', '3687', '2009-07-26 12:43:58', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14804', '3687', '2009-07-30 17:52:51', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14805', '3687', '2009-08-01 07:03:58', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14806', '3687', '2009-08-02 18:33:25', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', '');
INSERT INTO `ticketmessage` VALUES ('14807', '3687', '2009-08-03 09:07:57', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14808', '3687', '2009-08-06 15:24:30', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14809', '3688', '2009-07-26 06:06:59', 'My Firefox is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14810', '3688', '2009-07-29 16:46:11', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14811', '3688', '2009-07-31 06:14:47', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14812', '3688', '2009-08-03 15:17:33', 'Make sure you installed the Portuguese language.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14813', '3689', '2009-07-26 06:54:31', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14814', '3690', '2009-07-27 12:45:05', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14815', '3690', '2009-08-01 17:09:10', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14816', '3690', '2009-08-06 12:29:25', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14817', '3690', '2009-08-11 14:22:45', 'Sorry.There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14818', '3690', '2009-08-14 06:24:53', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14819', '3691', '2009-07-27 11:57:10', 'I can´t write a file in Portuguese.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14820', '3691', '2009-07-30 15:29:21', 'Make sure you installed the Portuguese language.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14821', '3691', '2009-08-02 08:11:13', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14822', '3691', '2009-08-03 14:20:43', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14823', '3692', '2009-07-27 12:55:02', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14824', '3692', '2009-07-27 15:55:51', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14825', '3692', '2009-07-29 10:16:12', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14826', '3692', '2009-08-03 17:32:47', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14827', '3692', '2009-08-04 09:21:47', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14828', '3692', '2009-08-09 18:37:58', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14829', '3693', '2009-07-27 07:25:11', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14830', '3693', '2009-07-31 16:53:34', 'The file was blocked because it is an executable.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14831', '3694', '2009-07-27 09:22:16', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14832', '3694', '2009-07-31 15:13:53', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14833', '3695', '2009-07-27 09:59:03', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14834', '3696', '2009-07-27 12:25:08', 'I want to export my Outlook files to cvs.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14835', '3696', '2009-08-01 15:19:04', 'Check the program menu the option to export', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14836', '3696', '2009-08-05 10:47:33', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14837', '3696', '2009-08-07 13:18:42', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14838', '3697', '2009-07-27 10:41:09', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14839', '3697', '2009-07-28 17:01:32', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14840', '3698', '2009-07-27 10:26:38', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14841', '3698', '2009-07-28 16:43:47', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14842', '3699', '2009-07-27 06:43:52', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14843', '3699', '2009-07-30 13:19:17', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14844', '3699', '2009-08-03 11:34:04', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14845', '3699', '2009-08-06 18:52:18', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14846', '3700', '2009-07-27 10:09:58', 'Customers page is not found from the link on the main menu', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14847', '3700', '2009-07-29 14:41:49', 'The problem has been resolved. Please access the site again.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14848', '3700', '2009-07-30 10:01:36', 'Access to the site is very slow on weekends.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14849', '3700', '2009-08-03 18:33:42', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14850', '3701', '2009-07-27 08:51:28', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14851', '3701', '2009-07-30 16:38:44', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14852', '3701', '2009-08-04 07:27:04', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14853', '3701', '2009-08-05 14:14:00', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14854', '3702', '2009-07-27 09:37:47', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14855', '3702', '2009-07-30 18:02:20', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14856', '3702', '2009-08-02 11:19:31', 'I can not entry more than one phone to a contact.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14857', '3702', '2009-08-05 16:51:56', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14858', '3703', '2009-07-27 09:52:22', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14859', '3703', '2009-07-30 17:31:26', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14860', '3704', '2009-07-27 11:38:35', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14861', '3704', '2009-07-30 15:54:46', 'The warranty 10% of the value of the goods.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14862', '3705', '2009-07-27 11:51:14', 'The generated are not being sent by email.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14863', '3705', '2009-07-29 16:15:23', 'Check spam filter.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14864', '3705', '2009-08-03 06:29:14', 'Customers file display na error in the e-mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14865', '3705', '2009-08-05 15:35:22', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14866', '3705', '2009-08-07 12:40:07', 'I can not entry more than one phone to a contact.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14867', '3706', '2009-07-27 06:43:41', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14868', '3706', '2009-07-29 14:48:01', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14869', '3707', '2009-07-27 08:45:05', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14870', '3707', '2009-07-27 17:00:14', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14871', '3707', '2009-07-28 07:13:18', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('14872', '3707', '2009-07-31 14:38:57', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14873', '3708', '2009-07-27 12:27:37', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14874', '3709', '2009-07-28 09:07:07', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14875', '3709', '2009-07-31 16:29:03', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14876', '3709', '2009-08-05 09:03:12', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14877', '3709', '2009-08-09 16:37:21', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14878', '3710', '2009-07-28 11:23:49', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14879', '3710', '2009-07-31 17:56:09', 'Sorry.There was an error and it now is corrected.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14880', '3710', '2009-08-04 11:04:55', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14881', '3710', '2009-08-05 16:02:59', 'We already provided the fix.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14882', '3710', '2009-08-09 11:44:41', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14883', '3710', '2009-08-09 18:10:38', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14884', '3711', '2009-07-28 07:24:14', 'I can not download the technical standards manual.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14885', '3711', '2009-07-29 13:16:53', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14886', '3711', '2009-08-01 07:18:13', 'Customers page is not found from the link on the main menu', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14887', '3711', '2009-08-06 16:01:31', 'The problem has been resolved. Please access the site again.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14888', '3712', '2009-07-28 08:14:24', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14889', '3712', '2009-07-30 13:57:43', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14890', '3712', '2009-08-04 10:45:41', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14891', '3713', '2009-07-28 08:06:43', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14892', '3713', '2009-08-02 15:21:22', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14893', '3713', '2009-08-04 12:45:07', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14894', '3713', '2009-08-04 18:56:18', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14895', '3713', '2009-08-05 07:23:38', 'I can´t sync my mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14896', '3713', '2009-08-06 15:52:38', 'The server was out at that time, but is already operational.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14897', '3714', '2009-07-28 08:40:08', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14898', '3714', '2009-07-30 14:17:17', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14899', '3714', '2009-08-02 06:02:03', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14900', '3714', '2009-08-05 17:53:22', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14901', '3715', '2009-07-28 09:58:39', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14902', '3715', '2009-08-02 17:26:57', 'Sorry.There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14903', '3715', '2009-08-06 11:41:31', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14904', '3715', '2009-08-11 18:20:07', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14905', '3716', '2009-07-28 12:47:44', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14906', '3716', '2009-08-02 18:12:54', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14907', '3716', '2009-08-07 09:10:38', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14908', '3716', '2009-08-07 15:28:59', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14909', '3717', '2009-07-29 06:50:15', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14910', '3717', '2009-08-01 17:12:58', 'Only at the end of the year, a week before Christmas.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14911', '3717', '2009-08-04 11:41:09', 'I want to cancel my order number 22113121.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14912', '3717', '2009-08-08 13:22:29', 'To cancel your order please contact the service and quality center', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14913', '3718', '2009-07-29 12:52:43', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14914', '3718', '2009-08-02 18:23:19', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14915', '3718', '2009-08-03 07:05:39', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14916', '3718', '2009-08-08 16:08:25', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14917', '3718', '2009-08-09 06:49:42', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('14918', '3718', '2009-08-09 13:03:16', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14919', '3719', '2009-07-29 07:13:39', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14920', '3719', '2009-08-02 13:08:33', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14921', '3719', '2009-08-03 08:49:48', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14922', '3719', '2009-08-05 16:43:23', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14923', '3720', '2009-07-29 08:07:44', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14924', '3720', '2009-08-01 17:30:45', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14925', '3720', '2009-08-02 07:53:31', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14926', '3720', '2009-08-07 13:46:42', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('14927', '3721', '2009-07-29 08:38:44', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14928', '3721', '2009-07-29 16:17:58', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14929', '3721', '2009-08-02 07:17:04', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14930', '3721', '2009-08-03 15:55:19', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14931', '3722', '2009-07-29 07:58:19', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14932', '3723', '2009-07-29 08:35:53', 'My desktop does not turn on', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14933', '3723', '2009-07-31 15:16:53', 'Make sure it is properly connected to the power supply.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14934', '3723', '2009-08-01 06:42:51', 'My keyboard is not accepting uppercase.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14935', '3723', '2009-08-02 14:09:42', 'Make sure the CapsLock led is on.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14936', '3724', '2009-07-30 11:45:23', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14937', '3724', '2009-07-31 16:47:54', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14938', '3724', '2009-08-03 06:19:56', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14939', '3724', '2009-08-04 14:34:52', 'The order was sent and will be delivered in 2 working days.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14940', '3725', '2009-07-30 10:32:52', 'The generated are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14941', '3725', '2009-08-01 13:08:20', 'Check spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14942', '3725', '2009-08-04 12:39:26', 'My user has no access to the Costs by departments report.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14943', '3725', '2009-08-09 15:04:21', 'This report can now be accessed only by users with manager profile .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14944', '3726', '2009-07-30 12:58:13', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14945', '3726', '2009-08-03 16:02:24', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14946', '3726', '2009-08-08 12:57:29', 'My keyboard is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14947', '3726', '2009-08-13 13:29:24', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14948', '3726', '2009-08-16 09:58:54', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14949', '3726', '2009-08-21 17:23:01', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14950', '3727', '2009-07-30 07:43:23', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14951', '3727', '2009-08-02 13:08:24', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14952', '3727', '2009-08-05 11:02:45', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14953', '3727', '2009-08-10 16:24:48', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14954', '3728', '2009-08-01 11:01:57', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14955', '3728', '2009-08-04 15:12:26', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14956', '3728', '2009-08-09 08:04:58', 'I want to cancel my order number 22113121.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14957', '3728', '2009-08-12 16:07:31', 'To cancel your order please contact the service and quality center', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14958', '3729', '2009-08-01 07:04:51', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14959', '3729', '2009-08-06 16:52:43', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14960', '3729', '2009-08-08 12:29:55', 'The HD has the following error message: Reading Error', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('14961', '3730', '2009-08-01 08:23:43', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14962', '3730', '2009-08-06 14:32:34', 'The server was out at that time, but is already operational.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14963', '3730', '2009-08-10 09:08:53', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('14964', '3731', '2009-08-01 11:53:35', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14965', '3731', '2009-08-03 13:03:53', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14966', '3731', '2009-08-05 09:28:18', 'My keyboard is not accepting uppercase.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14967', '3732', '2009-08-01 11:34:34', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14968', '3732', '2009-08-04 15:33:11', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14969', '3732', '2009-08-05 08:32:38', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14970', '3732', '2009-08-05 15:27:38', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14971', '3732', '2009-08-09 06:24:00', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14972', '3732', '2009-08-09 17:06:07', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14973', '3733', '2009-08-01 08:15:29', 'The mouse does not move to the side', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14974', '3733', '2009-08-01 14:54:48', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14975', '3733', '2009-08-05 11:57:29', 'My battery does not charge any more.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('14976', '3733', '2009-08-05 15:46:39', 'Please inform the battery model and date of purchase.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14977', '3734', '2009-08-01 10:51:07', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14978', '3734', '2009-08-03 14:39:25', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14979', '3734', '2009-08-07 07:27:06', 'Access to the site is very slow on weekends.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('14980', '3734', '2009-08-08 14:59:48', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14981', '3735', '2009-08-01 06:08:03', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14982', '3735', '2009-08-02 13:57:08', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14983', '3735', '2009-08-07 07:52:46', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14984', '3735', '2009-08-12 15:39:30', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14985', '3735', '2009-08-13 10:13:32', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('14986', '3735', '2009-08-16 17:21:15', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14987', '3736', '2009-08-01 12:48:24', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14988', '3736', '2009-08-01 18:13:01', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14989', '3736', '2009-08-03 07:00:21', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('14990', '3736', '2009-08-08 14:19:42', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14991', '3737', '2009-08-02 10:21:41', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14992', '3737', '2009-08-04 13:06:19', 'Check spam filter.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('14993', '3738', '2009-08-02 09:59:33', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14994', '3738', '2009-08-03 16:20:44', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14995', '3738', '2009-08-04 12:04:32', 'My Firefox is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('14996', '3738', '2009-08-07 16:27:23', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14997', '3739', '2009-08-02 12:25:21', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('14998', '3739', '2009-08-02 13:40:50', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('14999', '3739', '2009-08-03 10:46:24', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15000', '3739', '2009-08-06 16:11:48', 'The warranty 10% of the value of the goods.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15001', '3739', '2009-08-10 09:55:36', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15002', '3739', '2009-08-12 13:19:04', 'The order was sent and will be delivered in 2 working days.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15003', '3740', '2009-08-02 12:16:06', 'My Firefox is displaying na Javascript error', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15004', '3740', '2009-08-04 18:14:55', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15005', '3740', '2009-08-09 10:44:46', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15006', '3740', '2009-08-13 18:37:33', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15007', '3741', '2009-08-02 11:10:09', 'My user has no access to the Costs by departments report.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15008', '3741', '2009-08-05 18:51:47', 'This report can now be accessed only by users with manager profile .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15009', '3741', '2009-08-10 11:06:33', 'How can I access last orders?', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15010', '3742', '2009-08-02 12:32:28', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15011', '3742', '2009-08-02 17:14:52', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15012', '3742', '2009-08-06 08:00:09', 'I want to cancel my order number 22113121.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15013', '3742', '2009-08-10 15:21:29', 'To cancel your order please contact the service and quality center', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15014', '3743', '2009-08-02 12:10:17', 'The generated are not being sent by email.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15015', '3743', '2009-08-06 18:37:46', 'Check spam filter.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15016', '3743', '2009-08-07 07:36:15', 'How can I access last orders?', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15017', '3743', '2009-08-08 17:21:49', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15018', '3743', '2009-08-12 07:58:56', 'Customers file display na error in the e-mail.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15019', '3743', '2009-08-13 18:05:04', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15020', '3744', '2009-08-02 09:27:02', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15021', '3744', '2009-08-02 14:07:52', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15022', '3744', '2009-08-06 10:46:38', 'My user has no access to the Costs by departments report.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15023', '3744', '2009-08-11 18:26:47', 'This report can now be accessed only by users with manager profile .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15024', '3744', '2009-08-15 06:02:16', 'How can I access last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15025', '3745', '2009-08-02 08:45:20', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15026', '3745', '2009-08-02 17:42:36', 'Sorry.There was an error and it now is corrected.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15027', '3746', '2009-08-02 09:19:21', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15028', '3746', '2009-08-03 17:12:04', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15029', '3746', '2009-08-05 06:36:28', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15030', '3746', '2009-08-08 14:05:01', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15031', '3747', '2009-08-02 12:48:52', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15032', '3747', '2009-08-06 15:53:37', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15033', '3747', '2009-08-10 12:04:41', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15034', '3747', '2009-08-15 15:22:41', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15035', '3748', '2009-08-03 09:18:37', 'My user has no access to the Costs by departments report.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15036', '3748', '2009-08-04 18:03:37', 'This report can now be accessed only by users with manager profile .', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15037', '3748', '2009-08-07 10:42:21', 'How to classify the customer by priority?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15038', '3748', '2009-08-09 17:09:36', 'Check the user manual the topic How to configure the priority', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15039', '3748', '2009-08-11 11:55:49', 'Customers file display na error in the e-mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15040', '3749', '2009-08-03 11:46:15', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15041', '3749', '2009-08-07 15:24:14', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15042', '3749', '2009-08-11 10:53:55', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15043', '3749', '2009-08-14 15:40:46', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15044', '3749', '2009-08-19 09:35:12', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15045', '3750', '2009-08-03 07:49:31', 'My desktop does not turn on', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15046', '3750', '2009-08-06 18:17:46', 'Make sure it is properly connected to the power supply.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15047', '3750', '2009-08-10 06:59:02', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15048', '3750', '2009-08-10 14:37:12', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15049', '3750', '2009-08-11 08:44:33', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15050', '3750', '2009-08-12 18:12:18', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15051', '3751', '2009-08-03 11:05:15', 'The HD has the following error message: Reading Error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15052', '3751', '2009-08-03 18:31:42', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15053', '3751', '2009-08-08 06:53:41', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15054', '3751', '2009-08-08 14:27:34', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15055', '3752', '2009-08-03 09:47:44', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15056', '3752', '2009-08-05 16:30:24', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15057', '3752', '2009-08-07 09:33:12', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15058', '3752', '2009-08-10 16:40:36', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15059', '3752', '2009-08-14 10:12:02', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15060', '3752', '2009-08-18 16:00:41', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15061', '3753', '2009-08-03 12:11:06', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15062', '3753', '2009-08-08 15:24:05', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15063', '3754', '2009-08-03 12:13:34', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15064', '3754', '2009-08-03 17:42:24', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15065', '3755', '2009-08-03 07:58:39', 'I made a payment and did not receive an email confirmation', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15066', '3755', '2009-08-07 13:45:40', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15067', '3756', '2009-08-03 11:09:21', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15068', '3756', '2009-08-08 14:28:56', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15069', '3756', '2009-08-11 11:11:04', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15070', '3756', '2009-08-16 13:04:15', 'Check the program menu the option to export', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15071', '3756', '2009-08-20 12:47:50', 'My Firefox is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15072', '3756', '2009-08-23 16:24:58', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15073', '3757', '2009-08-03 11:09:08', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15074', '3757', '2009-08-05 13:00:14', 'Make sure you installed the Portuguese language.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15075', '3758', '2009-08-03 10:46:07', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15076', '3758', '2009-08-04 15:14:57', 'Only at the end of the year, a week before Christmas.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15077', '3759', '2009-08-03 11:37:52', 'My keyboard is not accepting uppercase.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15078', '3760', '2009-08-03 12:51:34', 'My keyboard is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15079', '3761', '2009-08-03 09:32:45', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15080', '3761', '2009-08-03 13:54:24', 'Make sure you installed the Portuguese language.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15081', '3762', '2009-08-03 10:04:39', 'How can I access last orders?', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15082', '3762', '2009-08-04 13:58:30', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15083', '3762', '2009-08-09 11:41:49', 'How to classify the customer by priority?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15084', '3762', '2009-08-14 15:27:30', 'Check the user manual the topic How to configure the priority', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15085', '3762', '2009-08-15 08:49:11', 'I can not entry more than one phone to a contact.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15086', '3762', '2009-08-19 18:59:45', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15087', '3763', '2009-08-03 09:52:01', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15088', '3763', '2009-08-07 17:36:42', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15089', '3764', '2009-08-03 07:30:08', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15090', '3764', '2009-08-03 17:22:39', 'We already provided the fix.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15091', '3765', '2009-08-04 07:27:04', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15092', '3765', '2009-08-08 18:55:38', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15093', '3765', '2009-08-10 07:21:54', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15094', '3765', '2009-08-14 17:42:23', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15095', '3765', '2009-08-16 06:59:52', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15096', '3765', '2009-08-21 15:16:52', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15097', '3766', '2009-08-04 09:21:16', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15098', '3766', '2009-08-09 13:29:54', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15099', '3766', '2009-08-13 08:52:50', 'My Firefox is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15100', '3766', '2009-08-18 18:18:22', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15101', '3766', '2009-08-19 08:12:20', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15102', '3766', '2009-08-22 15:38:12', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15103', '3767', '2009-08-04 12:17:11', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15104', '3767', '2009-08-05 13:46:49', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15105', '3767', '2009-08-10 11:50:06', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15106', '3767', '2009-08-14 18:17:09', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15107', '3768', '2009-08-04 11:38:14', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15108', '3769', '2009-08-04 11:34:45', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15109', '3769', '2009-08-04 16:16:17', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15110', '3769', '2009-08-08 09:55:38', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15111', '3769', '2009-08-08 17:05:58', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15112', '3769', '2009-08-11 12:07:16', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15113', '3769', '2009-08-15 14:45:16', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15114', '3770', '2009-08-04 08:33:33', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15115', '3770', '2009-08-07 14:29:28', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15116', '3770', '2009-08-11 07:19:05', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15117', '3770', '2009-08-13 15:45:47', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15118', '3771', '2009-08-04 08:07:09', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15119', '3771', '2009-08-09 18:01:43', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15120', '3772', '2009-08-04 08:06:59', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15121', '3772', '2009-08-07 13:38:57', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15122', '3773', '2009-08-04 12:11:20', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15123', '3773', '2009-08-08 14:31:54', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15124', '3773', '2009-08-13 11:07:08', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15125', '3774', '2009-08-05 12:35:05', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15126', '3774', '2009-08-05 13:05:32', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15127', '3774', '2009-08-08 07:43:13', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15128', '3774', '2009-08-08 15:46:22', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15129', '3775', '2009-08-05 07:05:57', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15130', '3776', '2009-08-05 12:01:44', 'I can not entry more than one phone to a contact.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15131', '3776', '2009-08-05 16:30:18', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15132', '3777', '2009-08-05 11:03:42', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15133', '3777', '2009-08-06 18:58:49', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15134', '3778', '2009-08-05 07:39:18', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15135', '3778', '2009-08-09 13:35:58', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15136', '3779', '2009-08-05 06:44:14', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15137', '3780', '2009-08-05 06:02:59', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15138', '3780', '2009-08-09 17:38:03', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15139', '3780', '2009-08-10 08:05:17', 'My keyboard is not accepting uppercase.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15140', '3780', '2009-08-12 17:17:00', 'Make sure the CapsLock led is on.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15141', '3780', '2009-08-14 08:14:33', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15142', '3780', '2009-08-17 16:33:22', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15143', '3781', '2009-08-05 07:08:54', 'I can´t sync my mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15144', '3781', '2009-08-07 18:30:31', 'The server was out at that time, but is already operational.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15145', '3781', '2009-08-10 10:03:28', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15146', '3781', '2009-08-15 18:25:59', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15147', '3782', '2009-08-06 09:09:34', 'I can´t write a file in Portuguese.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15148', '3783', '2009-08-06 12:16:49', 'I want to cancel my order number 22113121.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15149', '3783', '2009-08-07 18:15:11', 'To cancel your order please contact the service and quality center', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15150', '3783', '2009-08-08 08:37:30', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15151', '3783', '2009-08-09 14:39:14', 'The order was sent and will be delivered in 2 working days.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15152', '3783', '2009-08-11 11:04:03', 'I made a payment and did not receive an email confirmation', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15153', '3783', '2009-08-16 16:33:38', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15154', '3784', '2009-08-07 06:50:54', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15155', '3784', '2009-08-07 14:28:08', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15156', '3784', '2009-08-12 11:37:25', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15157', '3784', '2009-08-12 13:15:42', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15158', '3784', '2009-08-13 09:23:43', 'I can´t write a file in Portuguese.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15159', '3785', '2009-08-08 06:08:21', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15160', '3786', '2009-08-08 06:27:38', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15161', '3786', '2009-08-10 18:23:00', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15162', '3786', '2009-08-14 08:04:04', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15163', '3787', '2009-08-08 10:07:38', 'Customers file display na error in the e-mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15164', '3788', '2009-08-08 11:30:30', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15165', '3788', '2009-08-09 14:09:03', 'The file was blocked because it is an executable.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15166', '3789', '2009-08-08 11:34:00', 'The mouse does not move to the side', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15167', '3789', '2009-08-08 13:46:46', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15168', '3789', '2009-08-11 11:41:42', 'My keyboard is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15169', '3789', '2009-08-16 17:03:34', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15170', '3789', '2009-08-21 09:10:44', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15171', '3790', '2009-08-08 07:58:24', 'The generated are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15172', '3790', '2009-08-13 15:14:51', 'Check spam filter.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15173', '3791', '2009-08-08 09:40:18', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15174', '3791', '2009-08-13 15:11:06', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15175', '3791', '2009-08-18 12:47:49', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15176', '3791', '2009-08-23 13:48:43', 'Please inform the battery model and date of purchase.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15177', '3791', '2009-08-26 06:37:23', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15178', '3792', '2009-08-08 11:33:09', 'My Firefox is displaying na Javascript error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15179', '3792', '2009-08-12 15:02:19', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15180', '3793', '2009-08-08 10:32:22', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15181', '3793', '2009-08-11 14:55:00', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15182', '3794', '2009-08-09 08:40:03', 'My Office does not open, or word or excel ...', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15183', '3794', '2009-08-11 14:19:22', 'Please, try reinstalling the program.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15184', '3795', '2009-08-09 12:02:15', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15185', '3796', '2009-08-09 12:12:48', 'How to classify the customer by priority?', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15186', '3796', '2009-08-10 18:21:52', 'Check the user manual the topic How to configure the priority', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15187', '3796', '2009-08-11 06:27:02', 'How can I access last orders?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15188', '3796', '2009-08-15 18:00:57', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15189', '3796', '2009-08-18 06:39:16', 'The generated are not being sent by email.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15190', '3796', '2009-08-20 14:34:29', 'Check spam filter.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15191', '3797', '2009-08-09 12:06:26', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15192', '3797', '2009-08-11 17:42:41', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15193', '3798', '2009-08-09 10:45:30', 'I can not open a message attachment.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15194', '3799', '2009-08-09 07:52:57', 'The HD has the following error message: Reading Error', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15195', '3799', '2009-08-14 16:24:24', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15196', '3799', '2009-08-17 12:10:57', 'The mouse does not move to the side', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15197', '3799', '2009-08-20 15:30:58', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15198', '3800', '2009-08-09 10:47:53', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15199', '3800', '2009-08-13 13:23:58', 'Only at the end of the year, a week before Christmas.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15200', '3800', '2009-08-17 08:51:36', 'I made a payment and did not receive an email confirmation', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15201', '3801', '2009-08-09 06:06:39', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15202', '3802', '2009-08-09 09:18:51', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15203', '3803', '2009-08-09 09:55:13', 'My Firefox is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15204', '3803', '2009-08-09 17:57:58', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15205', '3804', '2009-08-09 10:34:35', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15206', '3804', '2009-08-12 17:08:18', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15207', '3804', '2009-08-17 08:12:18', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15208', '3804', '2009-08-18 13:16:33', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15209', '3804', '2009-08-21 08:09:40', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15210', '3804', '2009-08-26 16:45:18', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15211', '3805', '2009-08-09 10:45:35', 'My battery does not charge any more.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15212', '3805', '2009-08-09 14:04:20', 'Please inform the battery model and date of purchase.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15213', '3806', '2009-08-09 06:15:25', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15214', '3807', '2009-08-10 12:46:22', 'I want to cancel my order number 22113121.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15215', '3807', '2009-08-13 17:19:36', 'To cancel your order please contact the service and quality center', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15216', '3807', '2009-08-16 07:10:17', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15217', '3807', '2009-08-17 15:11:33', 'Only at the end of the year, a week before Christmas.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15218', '3807', '2009-08-22 11:22:03', 'I made a payment and did not receive an email confirmation', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15219', '3807', '2009-08-22 13:43:33', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15220', '3808', '2009-08-10 06:34:09', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15221', '3808', '2009-08-10 15:49:10', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15222', '3808', '2009-08-13 11:59:12', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15223', '3808', '2009-08-17 15:33:27', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15224', '3808', '2009-08-21 12:57:59', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15225', '3808', '2009-08-25 17:12:13', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15226', '3809', '2009-08-10 06:48:48', 'How to classify the customer by priority?', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15227', '3809', '2009-08-10 16:28:13', 'Check the user manual the topic How to configure the priority', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15228', '3810', '2009-08-10 12:48:00', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15229', '3810', '2009-08-14 15:43:00', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15230', '3810', '2009-08-16 08:49:24', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15231', '3810', '2009-08-21 16:07:22', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15232', '3811', '2009-08-10 12:32:55', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15233', '3811', '2009-08-15 17:05:58', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15234', '3811', '2009-08-17 11:00:28', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15235', '3811', '2009-08-20 17:08:10', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15236', '3811', '2009-08-21 07:12:05', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15237', '3811', '2009-08-24 17:13:38', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15238', '3812', '2009-08-10 06:19:41', 'Customers page is not found from the link on the main menu', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15239', '3812', '2009-08-10 14:21:26', 'The problem has been resolved. Please access the site again.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15240', '3813', '2009-08-10 11:19:45', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15241', '3814', '2009-08-10 12:08:23', 'My battery does not charge any more.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15242', '3815', '2009-08-10 06:25:40', 'The generated are not being sent by email.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15243', '3815', '2009-08-14 15:17:23', 'Check spam filter.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15244', '3815', '2009-08-19 08:24:14', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15245', '3815', '2009-08-19 14:00:09', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15246', '3815', '2009-08-23 10:26:59', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15247', '3816', '2009-08-10 12:58:14', 'I can not download the technical standards manual.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15248', '3816', '2009-08-11 17:21:41', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15249', '3816', '2009-08-13 09:54:24', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15250', '3816', '2009-08-17 18:50:33', 'We already provided the fix.', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15251', '3817', '2009-08-10 08:45:12', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15252', '3817', '2009-08-12 15:51:33', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15253', '3818', '2009-08-10 06:17:48', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15254', '3819', '2009-08-10 12:16:28', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15255', '3819', '2009-08-11 13:39:05', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15256', '3819', '2009-08-13 09:16:45', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15257', '3819', '2009-08-18 13:44:27', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15258', '3819', '2009-08-21 10:51:43', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15259', '3819', '2009-08-21 14:09:11', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15260', '3820', '2009-08-10 06:58:13', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15261', '3820', '2009-08-12 16:06:44', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15262', '3821', '2009-08-10 06:05:13', 'My Firefox is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15263', '3821', '2009-08-11 17:24:27', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15264', '3821', '2009-08-13 11:30:39', 'The word program is locking the file during save.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15265', '3821', '2009-08-15 15:50:21', 'Make sure there is enough space on disk.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15266', '3822', '2009-08-10 06:23:05', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15267', '3822', '2009-08-14 14:11:53', 'We already provided the fix.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15268', '3822', '2009-08-17 09:49:41', 'I can not download the technical standards manual.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15269', '3822', '2009-08-21 13:19:20', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15270', '3822', '2009-08-25 06:08:56', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15271', '3823', '2009-08-11 10:15:03', 'The generated are not being sent by email.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15272', '3823', '2009-08-15 17:24:17', 'Check spam filter.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15273', '3824', '2009-08-11 10:08:30', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15274', '3825', '2009-08-11 12:01:59', 'How can I access last orders?', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15275', '3825', '2009-08-15 13:04:24', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15276', '3825', '2009-08-16 06:42:16', 'My user has no access to the Costs by departments report.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15277', '3825', '2009-08-21 17:33:12', 'This report can now be accessed only by users with manager profile .', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15278', '3826', '2009-08-11 09:14:14', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15279', '3826', '2009-08-11 16:53:40', 'Sorry.There was an error and it now is corrected.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15280', '3826', '2009-08-13 06:10:25', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15281', '3826', '2009-08-13 18:12:35', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15282', '3826', '2009-08-16 07:43:38', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15283', '3826', '2009-08-20 15:04:49', 'We already provided the fix.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15284', '3827', '2009-08-11 10:42:46', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15285', '3827', '2009-08-11 15:21:49', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15286', '3827', '2009-08-16 06:00:36', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15287', '3827', '2009-08-18 15:45:19', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15288', '3827', '2009-08-19 12:24:16', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15289', '3827', '2009-08-19 16:05:38', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15290', '3828', '2009-08-11 09:50:54', 'I can not download the technical standards manual.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15291', '3828', '2009-08-16 14:35:19', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15292', '3829', '2009-08-11 07:54:41', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15293', '3829', '2009-08-16 16:22:45', 'Check the program menu the option to export', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15294', '3829', '2009-08-17 08:34:35', 'The word program is locking the file during save.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15295', '3829', '2009-08-17 14:06:26', 'Make sure there is enough space on disk.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15296', '3830', '2009-08-11 08:45:44', 'The generated are not being sent by email.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15297', '3831', '2009-08-11 08:49:12', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15298', '3831', '2009-08-15 15:56:28', 'The order was sent and will be delivered in 2 working days.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15299', '3831', '2009-08-19 08:56:48', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15300', '3831', '2009-08-21 17:34:39', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15301', '3832', '2009-08-12 07:40:04', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15302', '3832', '2009-08-17 18:29:47', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15303', '3833', '2009-08-12 10:48:24', 'How can I access last orders?', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15304', '3833', '2009-08-13 14:22:06', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15305', '3833', '2009-08-18 06:39:46', 'The generated are not being sent by email.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', '');
INSERT INTO `ticketmessage` VALUES ('15306', '3833', '2009-08-23 18:01:16', 'Check spam filter.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15307', '3833', '2009-08-27 11:53:05', 'How to classify the customer by priority?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15308', '3833', '2009-09-02 15:11:38', 'Check the user manual the topic How to configure the priority', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15309', '3834', '2009-08-12 06:34:04', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15310', '3834', '2009-08-16 17:15:31', 'Only at the end of the year, a week before Christmas.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15311', '3834', '2009-08-18 08:50:02', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15312', '3834', '2009-08-19 15:45:48', 'The warranty 10% of the value of the goods.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15313', '3834', '2009-08-20 09:38:38', 'I want to cancel my order number 22113121.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15314', '3835', '2009-08-12 11:59:24', 'Customers page is not found from the link on the main menu', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15315', '3835', '2009-08-16 14:00:26', 'The problem has been resolved. Please access the site again.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15316', '3835', '2009-08-20 11:46:02', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15317', '3835', '2009-08-22 13:23:18', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15318', '3836', '2009-08-12 08:24:56', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15319', '3836', '2009-08-16 15:15:45', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15320', '3836', '2009-08-21 07:59:38', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15321', '3836', '2009-08-23 13:12:48', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15322', '3836', '2009-08-26 06:45:21', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15323', '3836', '2009-08-30 14:00:18', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15324', '3837', '2009-08-12 09:32:22', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15325', '3837', '2009-08-17 14:30:18', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15326', '3838', '2009-08-12 08:06:12', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15327', '3838', '2009-08-17 15:28:37', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15328', '3839', '2009-08-12 12:05:12', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15329', '3839', '2009-08-12 15:44:06', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15330', '3840', '2009-08-12 10:45:13', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15331', '3840', '2009-08-16 16:01:06', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15332', '3841', '2009-08-12 11:59:42', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15333', '3841', '2009-08-14 17:17:53', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15334', '3842', '2009-08-12 11:42:14', 'The word program is locking the file during save.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15335', '3842', '2009-08-14 14:58:29', 'Make sure there is enough space on disk.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15336', '3842', '2009-08-16 06:45:35', 'I want to export my Outlook files to cvs.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15337', '3843', '2009-08-13 06:56:02', 'Access to the site is very slow on weekends.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15338', '3843', '2009-08-16 14:50:03', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15339', '3843', '2009-08-20 09:27:48', 'I can not download the technical standards manual.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15340', '3844', '2009-08-13 06:38:22', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15341', '3844', '2009-08-15 13:45:24', 'We already provided the fix.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15342', '3845', '2009-08-13 12:32:55', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15343', '3845', '2009-08-17 14:41:19', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15344', '3845', '2009-08-19 09:42:44', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15345', '3845', '2009-08-20 16:21:23', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15346', '3846', '2009-08-13 11:55:02', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15347', '3846', '2009-08-16 16:52:48', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15348', '3846', '2009-08-17 07:24:08', 'My desktop does not turn on', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15349', '3846', '2009-08-20 14:57:39', 'Make sure it is properly connected to the power supply.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15350', '3846', '2009-08-22 08:53:55', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15351', '3846', '2009-08-27 13:09:16', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15352', '3847', '2009-08-13 09:29:32', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15353', '3848', '2009-08-13 12:32:14', 'My Firefox is displaying na Javascript error', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15354', '3848', '2009-08-18 13:32:56', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15355', '3848', '2009-08-23 07:50:40', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15356', '3848', '2009-08-28 13:58:27', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15357', '3848', '2009-08-30 10:45:34', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15358', '3848', '2009-09-04 13:43:31', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15359', '3849', '2009-08-15 09:04:36', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15360', '3849', '2009-08-19 13:42:30', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15361', '3849', '2009-08-24 07:51:02', 'A friend said he sent me an email but I did not receive', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15362', '3849', '2009-08-29 15:15:37', 'Make sure this email is not on the blocked messages list .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15363', '3849', '2009-09-01 10:01:55', 'I can not open a message attachment.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15364', '3850', '2009-08-15 09:31:23', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15365', '3850', '2009-08-16 14:22:46', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15366', '3850', '2009-08-21 07:58:16', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15367', '3850', '2009-08-23 16:06:39', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15368', '3850', '2009-08-27 08:12:33', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15369', '3850', '2009-08-29 18:36:33', 'Make sure it is properly connected to the power supply.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15370', '3851', '2009-08-15 06:30:41', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15371', '3851', '2009-08-15 15:25:31', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15372', '3851', '2009-08-19 07:50:19', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15373', '3851', '2009-08-24 17:15:49', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15374', '3851', '2009-08-26 10:18:39', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15375', '3851', '2009-08-30 13:06:22', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15376', '3852', '2009-08-15 09:11:19', 'I want to export my Outlook files to cvs.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15377', '3852', '2009-08-17 14:28:07', 'Check the program menu the option to export', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15378', '3852', '2009-08-19 11:37:59', 'I can´t write a file in Portuguese.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15379', '3852', '2009-08-24 18:40:13', 'Make sure you installed the Portuguese language.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15380', '3852', '2009-08-26 08:04:10', 'My Firefox is displaying na Javascript error', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15381', '3852', '2009-08-27 14:26:25', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15382', '3853', '2009-08-15 12:11:36', 'The mouse does not move to the side', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15383', '3853', '2009-08-17 14:18:07', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15384', '3854', '2009-08-15 11:17:53', 'I can not download the technical standards manual.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15385', '3854', '2009-08-16 13:35:46', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15386', '3854', '2009-08-19 08:10:58', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15387', '3854', '2009-08-22 16:24:57', 'Sorry.There was an error and it now is corrected.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15388', '3855', '2009-08-15 10:23:40', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15389', '3855', '2009-08-16 18:53:31', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15390', '3856', '2009-08-15 08:09:26', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15391', '3856', '2009-08-18 15:53:42', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15392', '3857', '2009-08-15 07:04:09', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15393', '3857', '2009-08-15 17:41:22', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15394', '3858', '2009-08-16 10:48:58', 'I can´t sync my mail.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15395', '3858', '2009-08-20 14:30:06', 'The server was out at that time, but is already operational.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15396', '3858', '2009-08-21 11:55:31', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15397', '3858', '2009-08-21 13:45:06', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15398', '3858', '2009-08-26 08:57:44', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15399', '3858', '2009-09-01 15:48:07', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15400', '3859', '2009-08-16 08:18:54', 'A friend said he sent me an email but I did not receive', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15401', '3859', '2009-08-18 17:30:56', 'Make sure this email is not on the blocked messages list .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15402', '3859', '2009-08-19 08:28:56', 'I can´t sync my mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15403', '3859', '2009-08-21 16:34:25', 'The server was out at that time, but is already operational.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15404', '3859', '2009-08-23 10:19:28', 'I can not open a message attachment.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15405', '3859', '2009-08-24 13:49:39', 'The file was blocked because it is an executable.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15406', '3860', '2009-08-16 08:59:08', 'My desktop does not turn on', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15407', '3861', '2009-08-16 09:44:47', 'My keyboard is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15408', '3861', '2009-08-21 18:47:23', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15409', '3861', '2009-08-26 08:33:51', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15410', '3861', '2009-08-29 15:57:44', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15411', '3862', '2009-08-16 08:02:26', 'My Firefox is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15412', '3862', '2009-08-19 14:34:09', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15413', '3862', '2009-08-21 09:38:37', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15414', '3862', '2009-08-22 18:21:09', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15415', '3862', '2009-08-23 08:51:27', 'My Office does not open, or word or excel ...', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15416', '3862', '2009-08-28 16:07:40', 'Please, try reinstalling the program.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15417', '3863', '2009-08-16 07:41:45', 'The word program is locking the file during save.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15418', '3863', '2009-08-19 18:53:55', 'Make sure there is enough space on disk.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15419', '3863', '2009-08-23 08:02:00', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15420', '3863', '2009-08-24 16:14:28', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15421', '3863', '2009-08-27 07:15:20', 'My Firefox is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15422', '3864', '2009-08-16 10:21:38', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15423', '3864', '2009-08-17 16:56:34', 'Make sure it is properly connected to the power supply.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15424', '3865', '2009-08-16 09:55:00', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15425', '3866', '2009-08-16 10:43:14', 'My Firefox is displaying na Javascript error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15426', '3867', '2009-08-16 07:53:46', 'I can not entry more than one phone to a contact.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15427', '3867', '2009-08-18 13:34:09', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15428', '3867', '2009-08-22 08:34:39', 'How to classify the customer by priority?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15429', '3867', '2009-08-27 13:53:14', 'Check the user manual the topic How to configure the priority', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15430', '3868', '2009-08-17 09:34:45', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15431', '3868', '2009-08-19 16:38:08', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15432', '3869', '2009-08-17 12:02:12', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15433', '3869', '2009-08-20 16:15:22', 'We already provided the fix.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15434', '3869', '2009-08-22 12:37:01', 'Customers page is not found from the link on the main menu', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15435', '3869', '2009-08-24 16:35:36', 'The problem has been resolved. Please access the site again.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15436', '3869', '2009-08-28 07:52:05', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15437', '3870', '2009-08-17 08:11:30', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15438', '3870', '2009-08-19 16:27:33', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15439', '3870', '2009-08-22 06:53:49', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15440', '3870', '2009-08-26 13:07:46', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15441', '3871', '2009-08-17 10:57:40', 'My keyboard is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15442', '3871', '2009-08-20 17:15:40', 'Make sure the CapsLock led is on.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15443', '3871', '2009-08-22 07:06:05', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15444', '3871', '2009-08-24 14:50:16', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15445', '3871', '2009-08-26 11:31:05', 'My battery does not charge any more.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15446', '3871', '2009-09-01 18:34:16', 'Please inform the battery model and date of purchase.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15447', '3872', '2009-08-17 09:16:50', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15448', '3873', '2009-08-17 07:28:43', 'My Firefox is displaying na Javascript error', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15449', '3873', '2009-08-18 13:40:59', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15450', '3873', '2009-08-23 06:43:04', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15451', '3873', '2009-08-28 17:54:39', 'Check the program menu the option to export', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15452', '3874', '2009-08-17 11:20:18', 'The generated are not being sent by email.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15453', '3874', '2009-08-17 14:37:44', 'Check spam filter.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15454', '3874', '2009-08-21 10:43:59', 'How can I access last orders?', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15455', '3874', '2009-08-21 18:41:56', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15456', '3875', '2009-08-17 06:30:04', 'I made a payment and did not receive an email confirmation', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15457', '3875', '2009-08-21 16:13:19', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15458', '3875', '2009-08-23 12:25:00', 'I want to cancel my order number 22113121.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15459', '3875', '2009-08-28 18:08:57', 'To cancel your order please contact the service and quality center', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15460', '3875', '2009-09-03 09:00:42', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15461', '3875', '2009-09-06 17:30:02', 'The warranty 10% of the value of the goods.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15462', '3876', '2009-08-17 07:18:19', 'My user has no access to the Costs by departments report.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15463', '3876', '2009-08-21 16:05:26', 'This report can now be accessed only by users with manager profile .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15464', '3876', '2009-08-25 11:05:16', 'Customers file display na error in the e-mail.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15465', '3876', '2009-08-29 13:06:07', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15466', '3877', '2009-08-17 08:26:19', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15467', '3877', '2009-08-22 16:02:40', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15468', '3877', '2009-08-27 09:04:26', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15469', '3877', '2009-09-01 15:07:35', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15470', '3878', '2009-08-17 12:38:03', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15471', '3878', '2009-08-18 13:58:38', 'Make sure there is enough space on disk.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15472', '3879', '2009-08-17 09:26:04', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15473', '3879', '2009-08-22 15:47:06', 'Sorry.There was an error and it now is corrected.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15474', '3879', '2009-08-23 09:41:24', 'I can not download the technical standards manual.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15475', '3879', '2009-08-23 18:44:58', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15476', '3879', '2009-08-24 07:24:23', 'Access to the site is very slow on weekends.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15477', '3879', '2009-08-29 17:09:35', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15478', '3880', '2009-08-17 12:40:39', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15479', '3880', '2009-08-18 18:57:19', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15480', '3880', '2009-08-19 11:14:53', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15481', '3880', '2009-08-21 18:19:22', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15482', '3881', '2009-08-17 09:21:27', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15483', '3881', '2009-08-21 18:43:21', 'Sorry.There was an error and it now is corrected.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15484', '3881', '2009-08-23 09:40:04', 'I can not download the technical standards manual.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15485', '3881', '2009-08-28 18:52:44', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15486', '3882', '2009-08-17 10:55:58', 'I want to export my Outlook files to cvs.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15487', '3883', '2009-08-17 07:37:31', 'The mouse does not move to the side', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15488', '3883', '2009-08-20 16:50:02', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15489', '3883', '2009-08-21 07:53:56', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15490', '3883', '2009-08-23 14:51:59', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15491', '3884', '2009-08-18 10:31:33', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15492', '3884', '2009-08-22 18:54:59', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15493', '3885', '2009-08-18 06:47:05', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15494', '3885', '2009-08-23 13:02:42', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15495', '3886', '2009-08-18 07:53:22', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15496', '3886', '2009-08-21 18:31:07', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15497', '3887', '2009-08-18 09:39:53', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15498', '3887', '2009-08-21 13:52:40', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15499', '3887', '2009-08-25 10:22:43', 'The mouse does not move to the side', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15500', '3887', '2009-08-26 13:25:31', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15501', '3887', '2009-08-30 06:17:19', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15502', '3888', '2009-08-18 09:24:33', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15503', '3888', '2009-08-22 14:29:39', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15504', '3888', '2009-08-26 08:17:28', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15505', '3888', '2009-08-28 15:28:06', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15506', '3888', '2009-09-03 06:45:04', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15507', '3889', '2009-08-18 12:20:58', 'How to classify the customer by priority?', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15508', '3889', '2009-08-18 15:04:00', 'Check the user manual the topic How to configure the priority', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15509', '3889', '2009-08-21 11:44:20', 'Customers file display na error in the e-mail.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15510', '3889', '2009-08-23 14:11:01', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15511', '3889', '2009-08-24 06:46:36', 'The generated are not being sent by email.', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15512', '3889', '2009-08-25 13:03:34', 'Check spam filter.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15513', '3890', '2009-08-18 12:18:52', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15514', '3890', '2009-08-22 17:20:11', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15515', '3891', '2009-08-18 09:14:46', 'I can not download the technical standards manual.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15516', '3891', '2009-08-22 13:54:51', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15517', '3891', '2009-08-24 11:50:14', 'Customers page is not found from the link on the main menu', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15518', '3891', '2009-08-24 13:33:49', 'The problem has been resolved. Please access the site again.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15519', '3891', '2009-08-27 09:29:36', 'Access to the site is very slow on weekends.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15520', '3891', '2009-08-29 15:53:04', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15521', '3892', '2009-08-18 10:06:40', 'My desktop does not turn on', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15522', '3893', '2009-08-18 08:12:15', 'The mouse does not move to the side', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15523', '3894', '2009-08-18 10:35:57', 'A friend said he sent me an email but I did not receive', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15524', '3894', '2009-08-22 17:49:34', 'Make sure this email is not on the blocked messages list .', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15525', '3894', '2009-08-27 10:57:12', 'I can not open a message attachment.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15526', '3894', '2009-08-29 13:54:40', 'The file was blocked because it is an executable.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15527', '3895', '2009-08-18 07:46:54', 'My keyboard is not accepting uppercase.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15528', '3896', '2009-08-18 08:17:40', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15529', '3896', '2009-08-23 16:55:28', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15530', '3896', '2009-08-28 11:55:32', 'The mouse does not move to the side', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15531', '3896', '2009-09-02 17:31:30', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15532', '3897', '2009-08-19 07:14:02', 'Access to the site is very slow on weekends.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15533', '3897', '2009-08-22 13:48:20', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15534', '3897', '2009-08-24 09:35:43', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15535', '3898', '2009-08-19 10:51:55', 'The site seemed to be hacked. It is displaying some strange pictures on the customers page.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15536', '3898', '2009-08-19 13:23:45', 'We already provided the fix.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15537', '3898', '2009-08-21 07:18:36', 'I can not download the technical standards manual.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15538', '3898', '2009-08-26 15:40:03', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15539', '3898', '2009-08-30 10:16:46', 'Customers page is not found from the link on the main menu', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15540', '3899', '2009-08-19 06:02:34', 'I can´t sync my mail.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15541', '3899', '2009-08-20 18:41:01', 'The server was out at that time, but is already operational.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15542', '3900', '2009-08-19 09:17:09', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15543', '3900', '2009-08-22 18:19:33', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15544', '3900', '2009-08-25 10:45:54', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15545', '3900', '2009-08-28 14:08:13', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15546', '3901', '2009-08-19 08:59:36', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15547', '3901', '2009-08-22 14:47:42', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15548', '3901', '2009-08-25 07:36:20', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15549', '3901', '2009-08-29 15:50:03', 'The file was blocked because it is an executable.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15550', '3902', '2009-08-19 08:43:35', 'My keyboard is not accepting uppercase.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15551', '3902', '2009-08-22 13:12:22', 'Make sure the CapsLock led is on.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15552', '3902', '2009-08-24 06:45:59', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15553', '3902', '2009-08-24 17:22:29', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15554', '3903', '2009-08-19 06:45:45', 'I want to export my Outlook files to cvs.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15555', '3903', '2009-08-20 15:27:10', 'Check the program menu the option to export', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15556', '3903', '2009-08-23 10:15:20', 'The word program is locking the file during save.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15557', '3904', '2009-08-19 06:33:43', 'My battery does not charge any more.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15558', '3904', '2009-08-24 16:53:49', 'Please inform the battery model and date of purchase.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15559', '3904', '2009-08-29 06:31:54', 'My desktop does not turn on', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15560', '3905', '2009-08-19 08:38:23', 'I can not open a message attachment.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15561', '3905', '2009-08-24 15:41:19', 'The file was blocked because it is an executable.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15562', '3905', '2009-08-27 09:14:32', 'A friend said he sent me an email but I did not receive', null, null, null, '6', 'REQUEST', null, null, null, 'RETURNED', ''), ('15563', '3905', '2009-08-30 15:34:25', 'Make sure this email is not on the blocked messages list .', null, null, null, '6', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15564', '3906', '2009-08-19 11:06:45', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15565', '3906', '2009-08-20 18:39:38', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15566', '3906', '2009-08-24 07:37:12', 'Customers page is not found from the link on the main menu', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15567', '3906', '2009-08-24 18:52:19', 'The problem has been resolved. Please access the site again.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15568', '3906', '2009-08-29 07:33:54', 'Access to the site is very slow on weekends.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15569', '3906', '2009-09-03 16:07:07', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15570', '3907', '2009-08-20 08:03:15', 'Customers page is not found from the link on the main menu', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15571', '3907', '2009-08-22 15:20:18', 'The problem has been resolved. Please access the site again.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15577', '3909', '2009-08-20 06:07:03', 'Access to the site is very slow on weekends.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15578', '3909', '2009-08-22 18:54:25', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '6', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15579', '3910', '2009-08-20 12:41:25', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15580', '3910', '2009-08-21 17:34:01', 'The order was sent and will be delivered in 2 working days.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15581', '3911', '2009-08-20 06:35:30', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15582', '3911', '2009-08-20 17:42:12', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15583', '3911', '2009-08-21 07:47:18', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15584', '3911', '2009-08-22 13:44:29', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15585', '3912', '2009-08-20 06:42:36', 'Access to the site is very slow on weekends.', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15586', '3912', '2009-08-23 16:44:30', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '7', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15587', '3913', '2009-08-21 09:52:46', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15588', '3913', '2009-08-26 16:10:31', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15589', '3913', '2009-09-01 12:33:54', 'My Office does not open, or word or excel ...', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15590', '3913', '2009-09-02 15:30:47', 'Please, try reinstalling the program.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15591', '3913', '2009-09-06 10:01:20', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15592', '3913', '2009-09-09 16:24:12', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15593', '3914', '2009-08-22 12:49:06', 'The HD has the following error message: Reading Error', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15594', '3914', '2009-08-22 18:17:44', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15595', '3915', '2009-08-22 11:19:19', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15596', '3915', '2009-08-26 16:53:14', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15597', '3916', '2009-08-22 11:14:34', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15598', '3916', '2009-08-26 16:15:39', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15599', '3916', '2009-08-28 07:34:18', 'The HD has the following error message: Reading Error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15600', '3917', '2009-08-22 07:39:59', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15601', '3917', '2009-08-23 15:33:42', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15602', '3917', '2009-08-28 08:59:47', 'The mouse does not move to the side', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15603', '3917', '2009-08-28 13:07:18', 'Make sure the mouse is not dirty and contact the hardware support.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15604', '3918', '2009-08-22 07:15:39', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15605', '3918', '2009-08-23 16:17:46', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15606', '3919', '2009-08-22 11:14:09', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15607', '3919', '2009-08-26 13:07:14', 'Only at the end of the year, a week before Christmas.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15608', '3919', '2009-09-01 10:26:27', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15609', '3919', '2009-09-05 13:08:25', 'The warranty 10% of the value of the goods.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15610', '3920', '2009-08-22 10:08:21', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15611', '3920', '2009-08-25 14:10:50', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15612', '3920', '2009-08-28 07:54:15', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15613', '3920', '2009-09-03 18:17:01', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15614', '3920', '2009-09-08 11:39:25', 'I can not open a message attachment.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15615', '3920', '2009-09-12 13:47:59', 'The file was blocked because it is an executable.', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15616', '3921', '2009-08-22 12:50:32', 'Access to the site is very slow on weekends.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15617', '3921', '2009-08-27 16:31:38', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15618', '3921', '2009-09-02 06:51:25', 'Customers page is not found from the link on the main menu', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15619', '3921', '2009-09-06 15:19:07', 'The problem has been resolved. Please access the site again.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15620', '3921', '2009-09-09 11:45:12', 'I can not download the technical standards manual.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15621', '3921', '2009-09-09 18:17:16', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15622', '3922', '2009-08-22 11:32:04', 'I want to export my Outlook files to cvs.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15623', '3922', '2009-08-22 14:09:39', 'Check the program menu the option to export', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15624', '3923', '2009-08-22 10:48:23', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15625', '3923', '2009-08-26 16:38:37', 'Sorry.There was an error and it now is corrected.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15626', '3923', '2009-08-27 08:49:00', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15627', '3923', '2009-08-27 13:32:16', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15628', '3923', '2009-08-29 06:32:33', 'Customers page is not found from the link on the main menu', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15629', '3923', '2009-08-30 18:42:50', 'The problem has been resolved. Please access the site again.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15630', '3924', '2009-08-23 07:38:13', 'I can´t sync my mail.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15631', '3924', '2009-08-26 14:27:01', 'The server was out at that time, but is already operational.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15632', '3924', '2009-08-29 09:43:51', 'A friend said he sent me an email but I did not receive', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15633', '3924', '2009-08-29 18:24:22', 'Make sure this email is not on the blocked messages list .', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15634', '3925', '2009-08-23 09:01:28', 'I can´t write a file in Portuguese.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15635', '3925', '2009-08-25 17:46:46', 'Make sure you installed the Portuguese language.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15636', '3925', '2009-08-28 09:41:42', 'My Firefox is displaying na Javascript error', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15637', '3925', '2009-08-29 15:47:36', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15638', '3925', '2009-09-01 06:02:48', 'I want to export my Outlook files to cvs.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15639', '3926', '2009-08-23 08:34:54', 'My Firefox is displaying na Javascript error', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15640', '3926', '2009-08-26 18:58:59', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15641', '3927', '2009-08-23 06:41:31', 'A friend said he sent me an email but I did not receive', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15642', '3927', '2009-08-23 18:32:29', 'Make sure this email is not on the blocked messages list .', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15643', '3928', '2009-08-23 09:03:41', 'My user has no access to the Costs by departments report.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15644', '3928', '2009-08-28 17:46:40', 'This report can now be accessed only by users with manager profile .', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15645', '3928', '2009-09-03 11:39:15', 'I can not entry more than one phone to a contact.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15646', '3929', '2009-08-23 09:03:57', 'My Office does not open, or word or excel ...', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15647', '3929', '2009-08-27 14:59:53', 'Please, try reinstalling the program.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15648', '3929', '2009-08-28 09:36:18', 'The word program is locking the file during save.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15649', '3929', '2009-08-30 16:34:14', 'Make sure there is enough space on disk.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15650', '3930', '2009-08-23 08:49:12', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15651', '3930', '2009-08-24 16:14:47', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15652', '3930', '2009-08-28 12:53:47', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15653', '3930', '2009-08-30 18:04:47', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15654', '3930', '2009-09-04 11:12:55', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15655', '3931', '2009-08-23 11:46:22', 'My desktop does not turn on', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15656', '3931', '2009-08-23 17:35:25', 'Make sure it is properly connected to the power supply.', null, null, null, '9', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15657', '3932', '2009-08-23 07:03:49', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15658', '3932', '2009-08-23 13:21:50', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15659', '3932', '2009-08-28 06:42:58', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15660', '3932', '2009-08-29 14:12:35', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15661', '3932', '2009-09-03 07:01:07', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15662', '3932', '2009-09-08 16:41:26', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15663', '3933', '2009-08-23 11:03:03', 'My user has no access to the Costs by departments report.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15664', '3934', '2009-08-23 12:53:46', 'I can not download the technical standards manual.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15665', '3934', '2009-08-28 15:56:01', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15666', '3934', '2009-08-29 10:02:53', 'Customers page is not found from the link on the main menu', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15667', '3934', '2009-08-30 14:01:52', 'The problem has been resolved. Please access the site again.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15668', '3934', '2009-09-01 08:55:19', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15669', '3934', '2009-09-02 15:04:38', 'Sorry.There was an error and it now is corrected.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15670', '3935', '2009-08-23 06:34:13', 'Customers page is not found from the link on the main menu', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15671', '3935', '2009-08-25 15:18:19', 'The problem has been resolved. Please access the site again.', null, null, null, '8', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15672', '3936', '2009-08-23 08:10:28', 'Access to the site is very slow on weekends.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15673', '3936', '2009-08-28 16:48:00', 'This acorre due to the larger data traffic during the weekend.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15674', '3936', '2009-09-02 08:18:18', 'I can not download the technical standards manual.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15675', '3936', '2009-09-04 13:59:53', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '5', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15676', '3937', '2009-08-23 09:58:38', 'My desktop does not turn on', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15677', '3937', '2009-08-28 15:02:24', 'Make sure it is properly connected to the power supply.', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15678', '3938', '2009-08-24 08:24:51', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15679', '3938', '2009-08-27 16:56:26', 'Only at the end of the year, a week before Christmas.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15680', '3938', '2009-08-29 10:50:42', 'I want to cancel my order number 22113121.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15681', '3938', '2009-09-02 14:04:21', 'To cancel your order please contact the service and quality center', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15682', '3939', '2009-08-24 10:25:55', 'I can´t write a file in Portuguese.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15683', '3940', '2009-08-24 10:49:13', 'The HD has the following error message: Reading Error', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15684', '3940', '2009-08-25 17:52:29', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15685', '3940', '2009-08-30 11:55:01', 'My battery does not charge any more.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15686', '3940', '2009-09-03 17:44:07', 'Please inform the battery model and date of purchase.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15687', '3941', '2009-08-24 12:44:26', 'I want to export my Outlook files to cvs.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15688', '3941', '2009-08-29 18:48:05', 'Check the program menu the option to export', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15689', '3941', '2009-09-01 06:25:07', 'The word program is locking the file during save.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15690', '3941', '2009-09-04 17:56:46', 'Make sure there is enough space on disk.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15691', '3942', '2009-08-24 06:04:49', 'My Firefox is displaying na Javascript error', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15692', '3942', '2009-08-26 14:39:06', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15693', '3942', '2009-09-01 11:10:56', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15694', '3942', '2009-09-05 13:01:40', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15695', '3942', '2009-09-06 06:39:40', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15696', '3942', '2009-09-10 15:31:04', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15697', '3943', '2009-08-24 08:38:53', 'The generated are not being sent by email.', null, null, null, '6', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15698', '3943', '2009-08-28 18:34:14', 'Check spam filter.', null, null, null, '6', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15699', '3944', '2009-08-24 10:15:29', 'My battery does not charge any more.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15700', '3944', '2009-08-25 18:38:19', 'Please inform the battery model and date of purchase.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15701', '3945', '2009-08-24 11:51:51', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15702', '3945', '2009-08-26 13:26:00', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15703', '3945', '2009-09-01 12:26:52', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15704', '3945', '2009-09-02 14:34:35', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15705', '3946', '2009-08-24 12:08:22', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15706', '3946', '2009-08-29 18:28:40', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15707', '3946', '2009-08-30 07:52:38', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15708', '3946', '2009-09-01 16:58:47', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15709', '3947', '2009-08-24 09:19:43', 'I want to cancel my order number 22113121.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15710', '3947', '2009-08-27 14:32:16', 'To cancel your order please contact the service and quality center', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15711', '3948', '2009-08-24 12:02:28', 'I can not download the technical standards manual.', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15712', '3948', '2009-08-25 14:20:38', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15713', '3949', '2009-08-25 09:49:44', 'My Office does not open, or word or excel ...', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15714', '3949', '2009-08-27 16:33:01', 'Please, try reinstalling the program.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15715', '3950', '2009-08-25 11:34:17', 'I made a payment and did not receive an email confirmation', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15716', '3950', '2009-08-30 16:12:11', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15717', '3950', '2009-09-05 12:21:58', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15718', '3950', '2009-09-07 15:43:32', 'The warranty 10% of the value of the goods.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15719', '3950', '2009-09-10 11:08:40', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15720', '3950', '2009-09-15 14:34:38', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15721', '3951', '2009-08-25 12:26:30', 'I can´t sync my mail.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15722', '3951', '2009-08-29 16:16:14', 'The server was out at that time, but is already operational.', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15723', '3951', '2009-09-03 11:56:00', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15724', '3951', '2009-09-05 18:08:16', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15725', '3951', '2009-09-06 10:14:17', 'I can not open a message attachment.', null, null, null, '2', 'REQUEST', null, null, null, 'RETURNED', ''), ('15726', '3951', '2009-09-08 18:58:56', 'The file was blocked because it is an executable.', null, null, null, '2', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15727', '3952', '2009-08-25 11:13:19', 'I want to cancel my order number 22113121.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15728', '3953', '2009-08-25 09:04:13', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15729', '3953', '2009-08-29 16:31:53', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15730', '3954', '2009-08-25 06:16:51', 'A friend said he sent me an email but I did not receive', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15731', '3954', '2009-08-27 14:28:34', 'Make sure this email is not on the blocked messages list .', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15732', '3954', '2009-08-29 07:23:40', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15733', '3954', '2009-09-02 17:03:20', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15734', '3954', '2009-09-05 10:23:54', 'I can not open a message attachment.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15735', '3955', '2009-08-25 10:47:20', 'I can´t write a file in Portuguese.', null, null, null, '1', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15736', '3955', '2009-08-26 17:00:22', 'Make sure you installed the Portuguese language.', null, null, null, '1', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15737', '3955', '2009-09-01 08:58:31', 'I want to export my Outlook files to cvs.', null, null, null, '1', 'REQUEST', null, null, null, 'RETURNED', ''), ('15738', '3955', '2009-09-04 14:45:59', 'Check the program menu the option to export', null, null, null, '1', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15739', '3956', '2009-08-25 08:20:16', 'A friend said he sent me an email but I did not receive', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15740', '3956', '2009-08-25 18:39:54', 'Make sure this email is not on the blocked messages list .', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15741', '3956', '2009-08-29 11:19:32', 'I can not open a message attachment.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15742', '3956', '2009-09-02 13:18:43', 'The file was blocked because it is an executable.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15743', '3956', '2009-09-03 07:02:55', 'I can´t sync my mail.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15744', '3957', '2009-08-25 11:11:45', 'The word program is locking the file during save.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15745', '3957', '2009-08-30 14:47:58', 'Make sure there is enough space on disk.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15746', '3957', '2009-09-01 11:12:50', 'I want to export my Outlook files to cvs.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15747', '3958', '2009-08-25 11:28:00', 'I can´t write a file in Portuguese.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15748', '3958', '2009-08-25 13:00:29', 'Make sure you installed the Portuguese language.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15749', '3959', '2009-08-25 11:52:57', 'I want know the next date for the mobile Nokia N95 sale', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15750', '3959', '2009-08-26 15:13:04', 'Only at the end of the year, a week before Christmas.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15751', '3959', '2009-08-27 10:34:15', 'I made a payment and did not receive an email confirmation', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15752', '3959', '2009-08-28 15:43:25', 'Our billing system does not send email confirmation for security reasons. Sign in to my shopping portal.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15753', '3959', '2009-09-02 08:35:48', 'How does the extended warranty for laptops and netbooks works?', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15754', '3959', '2009-09-03 18:31:18', 'The warranty 10% of the value of the goods.', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15755', '3960', '2009-08-26 09:11:47', 'I can´t sync my mail.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15756', '3960', '2009-08-29 14:29:20', 'The server was out at that time, but is already operational.', null, null, null, '10', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15757', '3961', '2009-08-26 07:32:31', 'I can´t sync my mail.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15758', '3961', '2009-08-27 17:31:32', 'The server was out at that time, but is already operational.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15759', '3961', '2009-09-01 12:49:08', 'I can not open a message attachment.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15760', '3961', '2009-09-04 17:55:52', 'The file was blocked because it is an executable.', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15761', '3961', '2009-09-05 12:55:12', 'A friend said he sent me an email but I did not receive', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15762', '3961', '2009-09-10 15:43:55', 'Make sure this email is not on the blocked messages list .', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15763', '3962', '2009-08-26 08:22:14', 'The HD has the following error message: Reading Error', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15764', '3962', '2009-08-30 17:56:42', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15765', '3962', '2009-09-05 08:57:13', 'My battery does not charge any more.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15766', '3962', '2009-09-05 15:40:18', 'Please inform the battery model and date of purchase.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15767', '3962', '2009-09-08 11:15:35', 'My keyboard is not accepting uppercase.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15768', '3962', '2009-09-09 15:16:23', 'Make sure the CapsLock led is on.', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15769', '3963', '2009-08-26 09:41:07', 'I want to cancel my order number 22113121.', null, null, null, '8', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15770', '3963', '2009-08-26 13:20:51', 'To cancel your order please contact the service and quality center', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15771', '3963', '2009-08-28 09:27:16', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15772', '3963', '2009-08-29 18:48:46', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '8', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15773', '3963', '2009-09-03 12:24:01', 'So far I have not received the goods I bought, the order was 11223131.', null, null, null, '8', 'REQUEST', null, null, null, 'RETURNED', ''), ('15774', '3963', '2009-09-04 13:39:10', 'The order was sent and will be delivered in 2 working days.', null, null, null, '8', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15775', '3964', '2009-08-26 08:07:27', 'My keyboard is not accepting uppercase.', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15776', '3964', '2009-08-26 15:07:36', 'Make sure the CapsLock led is on.', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15777', '3965', '2009-08-26 10:14:06', 'The HD has the following error message: Reading Error', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15778', '3965', '2009-09-01 16:47:22', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15779', '3966', '2009-08-26 12:42:01', 'I can not entry more than one phone to a contact.', null, null, null, '9', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15780', '3966', '2009-09-01 14:21:04', 'Try updating the contacts list. It is possible that this field need to added.', null, null, null, '9', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15781', '3966', '2009-09-05 11:49:21', 'Customers file display na error in the e-mail.', null, null, null, '9', 'REQUEST', null, null, null, 'RETURNED', ''), ('15782', '3966', '2009-09-10 15:25:24', 'Check the entry format. It should be: abc@abc.abc', null, null, null, '9', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15783', '3967', '2009-08-26 08:20:27', 'My Office does not open, or word or excel ...', null, null, null, '7', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15784', '3967', '2009-09-01 17:32:57', 'Please, try reinstalling the program.', null, null, null, '7', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15785', '3967', '2009-09-04 11:37:47', 'My Firefox is displaying na Javascript error', null, null, null, '7', 'REQUEST', null, null, null, 'RETURNED', ''), ('15786', '3967', '2009-09-04 16:17:11', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '7', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15787', '3968', '2009-08-26 07:46:02', 'How to classify the customer by priority?', null, null, null, '5', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15788', '3968', '2009-08-28 18:16:06', 'Check the user manual the topic How to configure the priority', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15789', '3968', '2009-08-29 12:42:58', 'My user has no access to the Costs by departments report.', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15790', '3968', '2009-09-02 15:45:51', 'This report can now be accessed only by users with manager profile .', null, null, null, '5', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15791', '3968', '2009-09-07 09:06:59', 'How can I access last orders?', null, null, null, '5', 'REQUEST', null, null, null, 'RETURNED', ''), ('15792', '3968', '2009-09-10 16:12:20', 'In the Reports menu open the subfolder Customers and click on Last Orders.', null, null, null, '5', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15793', '3969', '2009-08-26 11:42:41', 'The generated are not being sent by email.', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15794', '3969', '2009-08-30 15:41:27', 'Check spam filter.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15795', '3969', '2009-09-02 07:49:38', 'How to classify the customer by priority?', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15796', '3969', '2009-09-04 17:31:21', 'Check the user manual the topic How to configure the priority', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15797', '3970', '2009-08-26 12:16:52', 'I want to cancel my order number 22113121.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15798', '3970', '2009-08-26 15:35:37', 'To cancel your order please contact the service and quality center', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15799', '3970', '2009-08-27 10:34:42', 'Can I pay my purchase in 12 instalments using the Visa?', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15800', '3970', '2009-08-29 18:46:06', 'The payment with 12 instalments is only allowed on mastercard', null, null, null, '4', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15801', '3971', '2009-08-29 07:58:38', 'My Firefox is displaying na Javascript error', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15802', '3971', '2009-09-01 15:15:28', 'Provavalmente an error occurred on the page you were accessing.', null, null, null, '4', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15803', '3972', '2009-08-29 08:08:35', 'A friend said he sent me an email but I did not receive', null, null, null, '2', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15804', '3972', '2009-09-02 13:08:46', 'Make sure this email is not on the blocked messages list .', null, null, null, '2', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15805', '3973', '2009-08-29 06:09:13', 'I can´t write a file in Portuguese.', null, null, null, '4', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15806', '3973', '2009-09-02 14:03:19', 'Make sure you installed the Portuguese language.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15807', '3973', '2009-09-06 08:53:03', 'The word program is locking the file during save.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15808', '3973', '2009-09-09 15:15:14', 'Make sure there is enough space on disk.', null, null, null, '4', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15809', '3973', '2009-09-11 10:07:38', 'I want to export my Outlook files to cvs.', null, null, null, '4', 'REQUEST', null, null, null, 'RETURNED', ''), ('15810', '3974', '2009-08-29 09:32:28', 'I can not download the technical standards manual.', null, null, null, '10', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15811', '3974', '2009-09-01 17:49:04', 'The file was temporarily removed for review. Soon it will be available for download.', null, null, null, '10', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15812', '3974', '2009-09-03 10:54:23', 'I can not connect to the phone that is displayed on the contacts page. It is always busy.', null, null, null, '10', 'REQUEST', null, null, null, 'RETURNED', ''), ('15813', '3974', '2009-09-05 14:44:59', 'Sorry.There was an error and it now is corrected.', null, null, null, '10', 'RESPONSE', null, null, null, 'CLOSED', ''), ('15814', '3975', '2009-08-29 09:05:51', 'The HD has the following error message: Reading Error', null, null, null, '3', 'REQUEST', null, null, null, 'UNASSIGNED', ''), ('15815', '3975', '2009-08-30 16:25:30', 'Run the scandisk program and inform technical suuport the messages.', null, null, null, '3', 'RESPONSE', null, null, null, 'REPLIED', ''), ('15816', '3975', '2009-09-01 11:55:46', 'My battery does not charge any more.', null, null, null, '3', 'REQUEST', null, null, null, 'RETURNED', ''), ('15817', '3975', '2009-09-04 16:27:22', 'Please inform the battery model and date of purchase.', null, null, null, '3', 'RESPONSE', null, null, null, 'SOLVED', ''), ('15851', '3932', '2009-09-07 09:43:17', '<p>To cancel your order please contact the service and quality center</p><p>----------------------------</p>', '', '', '', '1', 'RESPONSE', '', '', '', 'REPLIED', ''), ('15852', '3908', '2009-10-08 16:59:44', '<p>----------------------------</p> <p>Raymond Voltz</p>', '', '', '', '1', 'RESPONSE', '', '', '', 'REPLIED', ''), ('15853', '3962', '2009-10-29 15:21:48', '<p>teste</p> <p>&nbsp;</p>', '', '', '', null, 'REQUEST', '', '', '', 'RETURNED', ''), ('15854', '3908', '2010-03-25 11:17:07', '<p>The server was out at that time, but is already operational.</p><p>----------------------------</p> <p>Raymond Voltz</p>', 0x6148523063446F764C3364336479357762334A305957786A59574975593239744C3270765A32397A4C7A397162326468636A3169595778736232397558326C75583246666432467A644756735957356B4451706F644852774F69387661474636626D397A4C6D39795A79396E4C584E336158526A61433171623264764C77304B6148523063446F764C3252685A6D78686543356A62323076593239756447567564433932615756334C7A51324D7938784F5339735957356E4C48567A4C773D3D, '', '', '1', 'RESPONSE', 'aaaaa.txt', '', '', 'CLOSED', '<p>teste</p>');

-- ----------------------------
-- Table structure for `ticketpriority`
-- ----------------------------

create table `ticketpriority` (
  `ticketpriorityid` int(11) not null,
  `priorityname` varchar(30) default null,
  `priorityicon` blob,
  primary key (`ticketpriorityid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ticketpriority
-- ----------------------------
INSERT INTO `ticketpriority` VALUES ('1', 'HIGH', 0x2A6E6D2A6956424F5277304B47676F414141414E53556845556741414142494141414153434159414141456879623742414141414358424957584D414146784741414263526745556C454E42414141414358524657485244623231745A5735304141434A4B6F30474141414338556C45515652346E473155793035545552533959655341507941535152466145497051775949557859475271496A5038416D4F624D4A554A5359455552366C494B69497945755169434B434D324D644F4345365264474A6B6B67496D6F675553726D7635566E6E334573686F636C4F6D3750335757667474646575426B4454726E31736B4E2F38735A49417976766A30486853474636414F45786A4A735373356730626D50737455706D4E382F4346663872626F594C374F756F6D54427762744F4472584653516D63304A7247774168543047536E76583557474B4246455231504969426F6F654769683761754C454D77766177645A4E384E4D316136463851427A7361306F6775323054687A7031464438794A4561557242683772733871304C3233762B44537049326143527358586F6D594243355041585676544E4B50536A7165646C334331497961386F3246663542765641785A71427A6353484C4F46695259544F362B626B4F2B572F4C59524E6D547543774B2B694B62494C483964785049456553385959584D526C5072507976705A49504A5A74326769696D75324E47725534596B6666346C69514D5858777653307741626B6D703557333974515A4E48376267534A6A68736F576F556B496A356B54586B6469674F662B4B794F5A775A553457564978614C626D6D353754485A3164777963504F646962666662566B593648656B5A70476E4C59594439315437524A795A743348346751472F65447251623671696E4A5A565A4E784A494B74464655352F745A48667063744A2B6E734E56555164306873544F77727A496A726F6C4F4F4445696C4943644934525072494853714433714938556964487A445165734468444A417645425A386F3343325959343130423463763772714342315072502B47304D4144315A4A417A64543069654A66326D644B4A56494E4770735A3035636B784345665A34463258646F4F766333564C6377614E51715775764444785678686E4D5161636536366B33584C5A4349646D6F324A6758596C456F4C774F4E52645838756F684138747267476D723244445551482B73414E576A4F77457242754A4A494B387A4F39652B74534D476D6A35596B68327450504E4E7A664C476577734E555574616D6A4D6C6D4C5332432B52706A636D78635263344F75346641576C7A416B335071336C7631382F763642666F53375957796D70656B683767726843512B304A4137737953304764797A70616549455036596A74675157525A6D6476353034696D693555344E61776A494A4A466F7269345734652F5230654A7548435539757756723475577967574C4B6D4777732B4D473074556152535547506542344B63565A7A744175433772627767626470575838422B366A545A4964355639774141414141456C46546B5375516D4343), ('2', 'MEDIUM', 0x2A6E6D2A6956424F5277304B47676F414141414E53556845556741414142494141414153434159414141456879623742414141414358424957584D414146784741414263526745556C454E42414141414358524657485244623231745A5735304141434A4B6F30474141414339556C45515652346E4731557930755555527A39634E58432F3043537443786636596976314D6B78625245743746305374476758677443412B7951517333794F705A69704F576C6157506B7161424E443053614D4669354B776B4C42586F734B5452322F312B6D653335335063654548502B626A3374383933376E6E6E4E38594141796A396D32442F504B6C37726B442F2B4136444B376B645378424C535A784A38686449365064784D734646305A71347A7838485974794F706837783052526E3458445951652B726D38614D7255356973774F45336B394667373172636C69676F446F43686A5A495176357652624B3774756F664F6A41324E2B3669594E644A763573415034687462436E4B59725A5A566357432B3561676845684B396175712B3830364F3772483346757773584A4A79374F50464D31415A79664169354F323651664554706B54686A2F5052766538336F4A4B482F676F434B3845656438514A476F6E625478355464513147746A61743546735470554E7241755451466661424D6B7476646D464F6C746D334A4A49764F6969665876745852797766686C76614B4B435A37596B5A6F7053306966656B7269774E6C4A52586F473449564572637A573553316F33763951767933434249596456493043677067542B6F6573547331682B385047696847485464654D72505A5655414B763058523055386D415270536D6A4C5A56374C75314B59317371427930704B6C5166627030304E5A4E36533072534C6B5252585859676C2B356C7830796B5850624643634C5651696B69546F6B4E30616C4D61314649374B5253546B53467151414A556969696379525A79714C326149386F6C4E4D7A43517573446C4662656171417A375675464E786A7A3253447071767A6E714342784C725A334638314259395765524D58526C656173736B556730476D526F7A6C5566486F424C6C676D63393267322B727055744B566D2B626F4C5A4F44466D342F516A477A586A4469354E4F4C673837654B43636C64534E6B4C54315076516D68614A514E6D64327066743370517152704F6658497A4F755A6A3747546630315664744B6F7541355550726361444D6D48654D3733624175686B626C764A7938612F4B31726A4F2F6F76504F744C306C4741536251386F6F335656624F4D73304C6F72453561455955484E5130572F4A517A7039346676514E4D62522F51726A4F6C5832682B2F576A43742B59646B674C4E43514D344C41546B7A5A4D653559535949794678734E795133394575484F2F616E45556C57493346735747755472356F4C756B30553970676F5667644B474D382B395856314A6239695561554356763359517249656F3468674D414F784C435845686A4F34773444754E4C41426232685A2F77462B4A5531484649324A614141414141424A52553545726B4A6767673D3D), ('3', 'LOW', 0x2A6E6D2A6956424F5277304B47676F414141414E53556845556741414142494141414153434159414141456879623742414141414358424957584D414146784741414263526745556C454E42414141414358524657485244623231745A5735304141434A4B6F30474141414339456C45515652346E47315553552B545552543977736F462F34424942455767494253684D6B70524D444573694D596878702F67796961735449794E6B5769566F525145456374516D574B694973344C7353516145364A7870635A7067596D4773434345536D6D2F36666A4F652F316151336A4A54647633376A76763348505072515A413038363939637450666C6C4C4141326A63576A6371516A2B67746A4D34596D50703170786A343632475174616673645875494E4C387261762F4B614F3845636242794D573348312F4647522B5145434A5654466F6F475A345132356D53524156587130305A4B4279794544396D496E4455774A3062316353725245445662634E4E49794C6A56315845796A735473492F6238704E596B544A6972486A2F4B494333586E354330374E326A68323338614A68794A6D67644E7A774E6E484A756C484A5230793339656E777A316767455657337A486C473431334C5452464E6A4F634377554A7272674F724D6142433638736D56772F4570644A586E636F43524C6266543242496B484F465654494C4453372F594F53546861594B64594A71706A6C694230394D326449307363666B446877387045672F51526751564974563966764E44547239792F596B725233776B4C7A4E43415279304A2F55644B724F4F792F5A6544356478753149367136706B6D4C535A65306B7034594B454646767945546E346D6B6C6F695A5470524A78643078374C6D52524744427773395634504D4B594E6D41527A78644E327171704B4C4F64655264533643674D346E2B64356255717178666C353330444273716954726B64695453695879364E4B5344546A6B556B556865537044444A744A48546C4D5A3942626C6B54716C784D7A684270507A78474735754F4157696473467A35676A3363486D6937754F344E37733976646F6E54616C6E67787970713448424F2B6173436D645344566F5A47704D5637624D51446A4B427538367450337576765730356F367271443342364B3458507A4939534C74736B6B327A3054692B6F55516955476D763667746A4B79434232457943306F46624152764834786B6756367033744B3872614F446C4E78764C4D6544496D414461424A364B333231544A70625767452B69727A5668532F6155594E4C61446C4278563079326A625041316E482B6574366F506A744C654149583536323066703655666E586854476D2B677343793941426E6859436346774A795A6F59574C56783562556C5073467A3634762B476C4964576C4C6C5466787252584445535279643031496E44537046634E6144444D36696A576C796F70543248786573636163476957526973375A36425844564755596C42443653386C4A55615474383241377264774871646F575838413261355466324447724B614141414141456C46546B5375516D4343);

-- ----------------------------
-- Table structure for `ticketstatus`
-- ----------------------------

create table `ticketstatus` (
  `statusid` varchar(30) not null,
  `statusname` varchar(255) default null,
  `statusicon` blob,
  `displayorder` int(11) default null,
  primary key (`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ticketstatus
-- ----------------------------
INSERT INTO `ticketstatus` VALUES ('ASSIGNED', 'OPERATOR ASSIGNED', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A547741414147595355524256486A6170464E4C69734A41454B32453443662B5144656965414842525A6A784668374143795465776F57334D463741413369484C444B444F316575464E464634734966476E39547230616C462B4C4132504453546457726C3953726A6E613958756D6470554767355836727353716A7957677772467473794267772B6F7A526E64683150736A4134584B35554C31654A392F3362634D774F6F56436F5A6A5035796D645467747873396C59792B5853437350515070314F626562326D43733545654167655A356E6D36627056696F56797556796B6A79667A37496E6B306B716C3873514C45366E553565354350667730472F4571715A706E564B70524B6C555367536641546C777745584E512B42345044617A32577752622B4C7A533441444C6D6F6541717A6579475179644467632F68514142317A5550447A67684457667A326D3733524C374941547338586863504544526272656A39586F744F3170426A536F67687131574B777143344F5863593745594A52494A715645466871787163573859325573426A50623242554E316A414E2B7334556B4F79794F50317438523651316643567131436E3046377A5142745142754B336948676348584E536F39324155525646374D706E5166722B58506D45676476574D48446A676F6B5964493956717452363737497A48343856734E704F4A364C6F7577426B78354D41423939366D2F4579664C66646650394E58312F6B566547663943444141477A517876726733616C3441414141415355564F524B35435949493D, '2'), ('CLOSED', 'TICKET CLOSED', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A547741414147595355524256486A61704A4D3771734A514549624847462B4662305452306B4B777977597355376B414E324463685957374D473741425969466D78417342473146555242556850694D33766E6E616A6758524F4636344D38357A487A7A4A35795A2B4F37334F33327A664443776256754E6C566B315670566C50474A44566F2F565A5932666F47565A704F4E77753933494E45306144416231514344517975667A7557773253346C4551734474646D75735669746A73566A554C35644C6B396B4F73354954672B76315376312B7678364E5275315371555470644671537275764B7A6E46524D706E4D545359546D316D454F33686F443743736156717257437853504234587731644344677859314867472F466D3154436154693856694F4C3856474C436F38517A59765A704B70656838506E383041414D574E643464634D4C59372F653058713870464170524A424B526E532B55486E6B366E5535304F42786B52773431716F4630776E456332753132622F734F5577673171734751445978774F507878634D44675A61685232396A6A48687546516F4765632F4671386531544D42696B2B5877754E576F587572505A62496C3741494250314858396A78424444677859314B687A4D4434656A303065457470734E76496D763938767533704744677859314B68747045716C307547527455616A305849366E5172385844676A68687759734B6A7866715A476F2F47766E366E6462763861664C4E2B424267416B6134793669574B52616B41414141415355564F524B35435949493D, '6'), ('REPLIED', 'REPLIED BY STAFF', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A5477414141454F5355524256486A617A464F39436F4E41444D354264326D48766F5675676F4F694C51584279616D76306734644F765A525369636651476846423366667746586F4A503767634D3046746444547056333651666879756553376E446B5A3578782B4166735067583234763650766F4433514E6838353539346B334859335741696E367A72484D41784930355234414B36705059784A4172684854414A74327771526B552F7245336942783233626869694B344C4138534B643772666357614A714769676665587266636456306F79354A69596A317841376F754364523150566F59686E66663936456F43736F53516C4D496773415A4F366971696F6F464332525A426F71696B4A2F6E2B6154416B437431594A726D4A6B6B5372716F716961412F4E38484837446651645A33466363773154614F595A566E7373787233353666516A3437684248672F5A756C346B54732B704E567839645644656C36652F2F49762F494B5841414D414C4C4339716C487437627741414141415355564F524B35435949493D, '3'), ('RETURNED', 'RETURNED BY CUSTOMER', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A547741414145625355524256486A6131464F39696F4E41454A36466534484C30776771616A6751556C6E6C56584A64726B68786A334B6B736B726A6752457442447439413075466743442B594C45337332516C5A4C3072637333647744433738383138376E79374D7334352F4D625933794459666D362F77392B75666D7368756F312B507234636E53664B544E4D456D71597033576D61376A487345574D334F5A74714B644A6545497A6A434C766E6E554B774754646757525A4555635250336F6B64716F4F6F705139536E416D4759516A5848327437615961326251554A346C7A58645961316F706E69544E44337665313533714949645630544471377267752F37346256652B457A51645232555A666D6A326B56526944704A494E6679424F636743425A484D4177446D715952424C68326B69546879676C7748736330546155356A6D4E655652586B655136494D7A6D376F6F46553974346F6E32555A6963676B666E384C34694774586C63505061544C2B3856682F2F396E2B684A67414557397866772B30712B704141414141456C46546B5375516D4343, '4'), ('SOLVED', 'TICKET SOLVED', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A547741414147775355524256486A6170464F3569674A42454B3252386343624551394D4451537A2B51474E4E444A64454459657632456A41365039686A56654544593130736776454177454D52454555547A7777674F767256657237675469777470516445333365362F726466556F352F4F5A6E686B4B424E4A6661664E61676950486B6558514C32734E6A6770486D614E3142645A65617151694F5A314F6C4D6C6B71467174476C61727452694E52695068634A6A38667238415A374F5A5068774F3958362F622B7A332B774A6A53347A39725344316D554A75654479656A336738546F4641344736356B386D45327530324C5A664C50482B5736713931736D446A6544776D4C425A4C4D52614C6B632F6E6F385068634465774277797734494172416C78574C68674D527278654C2F4B4841517977344E774557443272615272746472732F4259414246687877315573462B6D67306F6D36335330366E6B2F67755A4C626237654964705056364465387975317775345A674663412B305743786F5042342F374C764E5A694F487779456373304344543950686237566150525277753931534754673341665A54345237726F564349464557524737383356465556613477566A726D4363712F584D3769434350784241492F4C504C68314972445A62496978413342755857442F72653132573767384576474A4D6A4762632B774241797734356A5A534D706B73385A504E4E35764E516166546F666C384C7163696B474D4E653841416537557054316C37302F37314D303366707A38437A347876415159414870387A6C4D354A77497341414141415355564F524B35435949493D, '5'), ('UNASSIGNED', 'WAITING REPLY', 0x2A6E6D2A6956424F5277304B47676F414141414E535568455567414141424141414141514341594141414166382F3968414141414247644254554541414B2F494E77574B3651414141426C30525668305532396D64486468636D554151575276596D5567535731685A3256535A57466B6558484A5A5477414141484A5355524256486A61704A4F3953794E52464D58506D4845797953537277537845524243624C47346836617A38437751725162415354486F374B347574747250585773676957416E37483469777345487745306C456438566F4A6D5178452F4F64385A36334D597751557569447733317A372B2F63334A63336F376D75693438736A51317965356F334E794E614669324945743163526E5167536F764F587348704A666C784E72684B4D32595A6B376E3930667643373157335776676870617753393879785271624C4B712B6134474A58545A4130492F48747A37507273474A7A66636574354939514F4E35437258535A6B7365644C797375686C686F74325673582F6862394F736172476763614A5836696A55795A4A56486C6D725162474935504445664334314E79594D395547544930744E7230477068595351576831752F452B68686F4D695170596465765474426F6C6E366863652F5032454578324345787956476F6676443675797465686D4E5A78754E3872334549677772716A7A6542764A484F4B672F33614A696E772B3864393277594A6A6D66342B6E515562542F596E41707768717A75415878777846494B7A79394272496551377931376E45354A51466E785A4357784C396C6B2F583451384F34383931546E6D387435432B796472355A3665436F415752426A4F414E324B4F4E544A6B36656B316B447339713155376D36635A472B58534530796A686F432F72714A337A786F5A737652347278474C69396770466A75706F384E712F75545977622B69672B476869684C337A4C464768757A724B645772764C6678766F397036587633572F6A4965684667414E53614964705A326332304141414141456C46546B5375516D4343, '1');

-- ----------------------------
-- View structure for `view_customer_tickets_category`
-- ----------------------------

create view `view_customer_tickets_category` as select `ticket`.`categoryid` as `categoryid`,count(`ticket`.`categoryid`) as `tickets`,`ticket`.`customerid` as `customerid` from `ticket` group by `ticket`.`categoryid`,`ticket`.`customerid` ;

-- ----------------------------
-- View structure for `view_customer_tickets_status`
-- ----------------------------

create view `view_customer_tickets_status` as select `ticket`.`statusid` as `statusid`,count(`ticket`.`statusid`) as `tickets`,`ticket`.`customerid` as `customerid` from `ticket` group by `ticket`.`statusid`,`ticket`.`customerid` ;

-- ----------------------------
-- View structure for `view_last_articles`
-- ----------------------------

create view `view_last_articles` as select `kb_articles`.`articlesid` as `articlesid`,`kb_articles`.`categoryid` as `categoryid`,`kb_articles`.`articlesubject` as `articlesubject`,`kb_articles`.`articletypeid` as `articletypeid`,`kb_articles`.`articleview` as `articleview`,`kb_articles`.`votesqty` as `votesqty`,`kb_articles`.`votestotal` as `votestotal`,`kb_articles`.`articledate` as `articledate` from `kb_articles` order by `kb_articles`.`articledate` desc limit 0,5 ;

-- ----------------------------
-- View structure for `view_status_template`
-- ----------------------------

create view `view_status_template` as select `ticketstatus`.`statusid` as `statusid`,`ticketstatus`.`statusname` as `statusname` from `ticketstatus` union select 'forgetpwd' as `statusid`,'forget password' as `statusname` union select 'forgettrack' as `statusid`,'forget tracking id' as `statusname` order by 2 ;

-- ----------------------------
-- View structure for `view_top_articles`
-- ----------------------------

create view `view_top_articles` as select `kb_articles`.`articlesid` as `articlesid`,`kb_articles`.`categoryid` as `categoryid`,`kb_articles`.`articlesubject` as `articlesubject`,`kb_articles`.`articletypeid` as `articletypeid`,`kb_articles`.`articleview` as `articleview`,`kb_articles`.`votesqty` as `votesqty`,`kb_articles`.`votestotal` as `votestotal`,`kb_articles`.`articledate` as `articledate` from `kb_articles` order by `kb_articles`.`articleview` desc limit 0,5 ;

-- ----------------------------
-- View structure for `vw_tickets_by_currentyear`
-- ----------------------------

create view `vw_tickets_by_currentyear` as select `ticket`.`ticketid` as `ticketid`,`ticket`.`ticketpriorityid` as `ticketpriorityid`,`ticket`.`statusid` as `statusid`,`ticket`.`ownerid` as `ownerid`,`ticket`.`customerid` as `customerid`,year(`ticket`.`ticketdate`) as `year`,`ticket`.`categoryid` as `categoryid`,`ticket`.`subject` as `subject`,`ticket`.`ticketdate` as `ticketdate`,`ticket`.`customerrating` as `customerrating`,`ticket`.`customercomments` as `customercomments`,`ticket`.`ticketlastupdate` as `ticketlastupdate`,`ticket`.`ticketlastreplier` as `ticketlastreplier`,`ticket`.`tickettrack` as `tickettrack` from `ticket` ;

-- ----------------------------
-- View structure for `vw_time_answer`
-- ----------------------------

create view `vw_time_answer` as select `ticket`.`ticketid` as `ticketid`,`ticket`.`ownerid` as `ownerid`,`ticket`.`categoryid` as `categoryid`,`customer`.`customeremail` as `customeremail`,`customer`.`customername` as `customername`,`customer`.`customerphone` as `customerphone`,(case when ((to_days(`ticket`.`ticketlastupdate`) - to_days(`ticket`.`ticketdate`)) <= 1) then ' 0 - 24 hrs' when ((to_days(`ticket`.`ticketlastupdate`) - to_days(`ticket`.`ticketdate`)) between 1.000001 and 2) then '24 - 48 hrs' when ((to_days(`ticket`.`ticketlastupdate`) - to_days(`ticket`.`ticketdate`)) between 2.000001 and 7) then '2 - 7 days ' when ((to_days(`ticket`.`ticketlastupdate`) - to_days(`ticket`.`ticketdate`)) between 7.000001 and 15) then '7 - 15 days' when ((to_days(`ticket`.`ticketlastupdate`) - to_days(`ticket`.`ticketdate`)) > 15) then '> 15 days' end) as `timeelapsedanswer` from (((((`ticket` left join `customer` on((`ticket`.`customerid` = `customer`.`customerid`))) left join `staff` on((`ticket`.`ownerid` = `staff`.`staffid`))) join `ticketstatus` on((`ticket`.`statusid` = `ticketstatus`.`statusid`))) join `ticketpriority` on((`ticket`.`ticketpriorityid` = `ticketpriority`.`ticketpriorityid`))) join `categories` on((`ticket`.`categoryid` = `categories`.`categoryid`))) where ((`ticket`.`statusid` = 'closed') or (`ticket`.`statusid` = 'solved')) order by `ticket`.`ticketdate` desc ;
