SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Sequence structure for sec_groups_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS sec_groups_seq;
CREATE SEQUENCE sec_groups_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_activities_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_activities_seq;
CREATE SEQUENCE tb_activities_seq START WITH 105 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_activities_type_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_activities_type_seq;
CREATE SEQUENCE tb_activities_type_seq START WITH 27 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_contacts_emails_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_contacts_emails_seq;
CREATE SEQUENCE tb_contacts_emails_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_contacts_phones_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_contacts_phones_seq;
CREATE SEQUENCE tb_contacts_phones_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_contacts_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_contacts_seq;
CREATE SEQUENCE tb_contacts_seq START WITH 17 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_deal_steps_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_deal_steps_seq;
CREATE SEQUENCE tb_deal_steps_seq START WITH 16 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_deals_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_deals_seq;
CREATE SEQUENCE tb_deals_seq START WITH 66 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_emails_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_emails_seq;
CREATE SEQUENCE tb_emails_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_files_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_files_seq;
CREATE SEQUENCE tb_files_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_lead_source_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_lead_source_seq;
CREATE SEQUENCE tb_lead_source_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_organization_fields_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_organization_fields_seq;
CREATE SEQUENCE tb_organization_fields_seq START WITH 5 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_organizations_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_organizations_seq;
CREATE SEQUENCE tb_organizations_seq START WITH 9 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_products_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_products_seq;
CREATE SEQUENCE tb_products_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_sellers_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_sellers_seq;
CREATE SEQUENCE tb_sellers_seq START WITH 9 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tbl_mandrill_emails_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tbl_mandrill_emails_seq;
CREATE SEQUENCE tbl_mandrill_emails_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tbl_mandrill_groups_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tbl_mandrill_groups_seq;
CREATE SEQUENCE tbl_mandrill_groups_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tbl_mandrill_info_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tbl_mandrill_info_seq;
CREATE SEQUENCE tbl_mandrill_info_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tbl_mandrill_templates_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tbl_mandrill_templates_seq;
CREATE SEQUENCE tbl_mandrill_templates_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Table structure for sec_apps
-- ----------------------------
CREATE TABLE `sec_apps` (
`app_name`  varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`app_type`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`description`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`app_name`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of sec_apps
-- ----------------------------
BEGIN;
INSERT INTO `sec_apps` VALUES ('app_change_pswd', 'contr', 'Security Application'), ('app_form_edit_users', 'form', 'Security Application'), ('app_form_sec_apps', 'form', 'Security Application'), ('app_form_sec_groups', 'form', 'Security Application'), ('app_form_sec_groups_apps', 'form', 'Security Application'), ('app_grid_sec_apps', 'cons', 'Security Application'), ('app_grid_sec_groups', 'cons', 'Security Application'), ('app_grid_sec_users', 'cons', 'Security Application'), ('app_grid_sec_users_groups', 'form', 'Security Application'), ('app_Login', 'contr', 'Security Application'), ('app_menu', 'menu', 'Security Application'), ('app_retrieve_pswd', 'contr', 'Security Application'), ('app_search_sec_groups', 'filter', 'Security Application'), ('app_sync_apps', 'contr', 'Security Application'), ('blank_pipeline', 'blank', ''), ('blank_pipeline_ajax', 'blank', ''), ('ctrl_mandrill_send_mail', 'contr', ''), ('form_tb_activities', 'form', ''), ('form_tb_activities_type', 'form', ''), ('form_tb_contacts', 'form', ''), ('form_tb_contacts_emails', 'form', ''), ('form_tb_contacts_phones', 'form', ''), ('form_tb_deals', 'form', ''), ('form_tb_deals_copy', 'form', null), ('form_tb_deals_x_products', 'form', null), ('form_tb_deal_steps', 'form', ''), ('form_tb_lead_source', 'form', ''), ('form_tb_organizations', 'form', ''), ('form_tb_organization_fields', 'form', ''), ('form_tb_participants', 'form', null), ('form_tb_products', 'form', ''), ('form_tb_sellers', 'form', ''), ('grid_tb_activities_history_org', 'cons', null), ('grid_tb_contacts', 'cons', ''), ('grid_tb_deals', 'cons', ''), ('grid_tb_organizations', 'cons', ''), ('grid_tb_products', 'cons', ''), ('grid_tb_sellers', 'cons', ''), ('list_tbl_mandrill_info', 'cons', ''), ('list_tbl_mandrill_templates', 'cons', ''), ('report_tb_deals_history', 'cons', null), ('repport_tb_deals', 'cons', null), ('tbl_mandrill_info', 'form', ''), ('tbl_mandrill_templates', 'form', '');
COMMIT;

-- ----------------------------
-- Table structure for sec_groups
-- ----------------------------
CREATE TABLE `sec_groups` (
`group_id`  int(11) NOT NULL AUTO_INCREMENT ,
`description`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`group_id`),
UNIQUE INDEX `description` (`description`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=3

;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------
BEGIN;
INSERT INTO `sec_groups` VALUES ('1', 'Administrator'), ('2', 'Seller');
COMMIT;

-- ----------------------------
-- Table structure for sec_groups_apps
-- ----------------------------
CREATE TABLE `sec_groups_apps` (
`group_id`  int(11) NOT NULL ,
`app_name`  varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`priv_access`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_insert`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_delete`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_update`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_export`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_print`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`group_id`, `app_name`),
FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
FOREIGN KEY (`app_name`) REFERENCES `sec_apps` (`app_name`) ON DELETE CASCADE ON UPDATE RESTRICT,
INDEX `sec_groups_apps_ibfk_2` (`app_name`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------
BEGIN;
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'app_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_grid_sec_apps', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_groups', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_users', 'Y', '', '', '', 'Y', 'Y'), ('1', 'app_grid_sec_users_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'app_Login', 'Y', '', '', '', '', ''), ('1', 'app_menu', 'Y', '', '', '', '', ''), ('1', 'app_retrieve_pswd', 'Y', '', '', '', '', ''), ('1', 'app_search_sec_groups', 'Y', '', '', '', '', ''), ('1', 'app_sync_apps', 'Y', '', '', '', '', ''), ('1', 'blank_pipeline', 'Y', '', '', '', '', ''), ('1', 'blank_pipeline_ajax', 'Y', '', '', '', '', ''), ('1', 'ctrl_mandrill_send_mail', 'Y', '', '', '', '', ''), ('1', 'form_tb_activities', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_activities_type', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts_emails', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_contacts_phones', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals_copy', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deals_x_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_deal_steps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_lead_source', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_organizations', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_organization_fields', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_participants', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'form_tb_sellers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'grid_tb_activities_history_org', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_organizations', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_products', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_sellers', 'Y', '', '', '', 'Y', 'Y'), ('1', 'list_tbl_mandrill_info', 'Y', '', '', '', 'Y', 'Y'), ('1', 'list_tbl_mandrill_templates', 'Y', '', '', '', 'Y', 'Y'), ('1', 'report_tb_deals_history', 'Y', '', '', '', 'Y', 'Y'), ('1', 'repport_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('1', 'tbl_mandrill_info', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('1', 'tbl_mandrill_templates', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('2', 'app_form_edit_users', '', '', '', '', '', ''), ('2', 'app_form_sec_apps', '', '', '', '', '', ''), ('2', 'app_form_sec_groups', '', '', '', '', '', ''), ('2', 'app_form_sec_groups_apps', '', '', '', '', '', ''), ('2', 'app_grid_sec_apps', '', '', '', '', '', ''), ('2', 'app_grid_sec_groups', '', '', '', '', '', ''), ('2', 'app_grid_sec_users', '', '', '', '', '', ''), ('2', 'app_grid_sec_users_groups', '', '', '', '', '', ''), ('2', 'app_Login', 'Y', '', '', '', '', ''), ('2', 'app_menu', 'Y', '', '', '', '', ''), ('2', 'app_retrieve_pswd', 'Y', '', '', '', '', ''), ('2', 'app_search_sec_groups', '', '', '', '', '', ''), ('2', 'app_sync_apps', '', '', '', '', '', ''), ('2', 'blank_pipeline', 'Y', '', '', '', '', ''), ('2', 'blank_pipeline_ajax', 'Y', '', '', '', '', ''), ('2', 'ctrl_mandrill_send_mail', 'Y', '', '', '', '', ''), ('2', 'form_tb_activities', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_activities_type', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts_emails', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_contacts_phones', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals_copy', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deals_x_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_deal_steps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_lead_source', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_organizations', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_organization_fields', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_participants', null, null, null, null, null, null), ('2', 'form_tb_products', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'form_tb_sellers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y'), ('2', 'grid_tb_activities_history_org', null, null, null, null, null, null), ('2', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_deals', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_organizations', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_products', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_sellers', 'Y', '', '', '', 'Y', 'Y'), ('2', 'list_tbl_mandrill_info', '', '', '', '', '', ''), ('2', 'list_tbl_mandrill_templates', '', '', '', '', '', ''), ('2', 'report_tb_deals_history', null, null, null, null, null, null), ('2', 'repport_tb_deals', null, null, null, null, null, null), ('2', 'tbl_mandrill_info', '', '', '', '', '', ''), ('2', 'tbl_mandrill_templates', '', '', '', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
CREATE TABLE `sec_users` (
`login`  varchar(255) NOT NULL ,
`pswd`  varchar(255) NOT NULL ,
`name`  varchar(64) NULL DEFAULT NULL ,
`email`  varchar(255) NULL DEFAULT NULL ,
`active`  varchar(1) NULL DEFAULT NULL ,
`activation_code`  varchar(32) NULL DEFAULT NULL ,
`priv_admin`  varchar(1) NULL DEFAULT NULL ,
  `mfa` VARCHAR(255),
  `picture` LONGBLOB,
PRIMARY KEY (`login`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
BEGIN;
INSERT INTO `sec_users` VALUES ('admin', 'admin', 'Admin', 'admin@admin.com', 'Y', null, 'Y', null, null), ('carlos', 'carlos', 'Carlos', 'carlos@scriptcase.net', 'Y', null, 'Y', null, null), ('harry', 'harry', 'Harry', 'harry@scriptcase.net', 'Y', null, 'Y', null, null), ('john', '1234', 'John', 'john@scriptcase.net', 'Y', null, 'Y', null, null), ('marcia', 'marcia', 'Marcia', 'marcia@scriptcase.net', 'Y', null, 'Y', null, null), ('maria', 'maria', 'Maria', 'maria@scriptcase.net', 'Y', null, 'Y', null, null), ('mark', '1234', 'Mark', 'mark@scriptcase.net', 'Y', null, 'Y', null, null), ('matheus', '1234', 'Matheus', 'mts@scriptcase.net', 'Y', null, 'Y', null, null), ('paul', 'paul', 'Paul', 'paul@scriptcase.net', 'Y', null, 'Y', null, null);
COMMIT;

-- ----------------------------
-- Table structure for sec_users_groups
-- ----------------------------
CREATE TABLE `sec_users_groups` (
`login`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`group_id`  int(11) NOT NULL ,
PRIMARY KEY (`login`, `group_id`),
FOREIGN KEY (`login`) REFERENCES `sec_users` (`login`) ON DELETE CASCADE ON UPDATE RESTRICT,
FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
INDEX `sec_users_groups_ibfk_2` (`group_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------
BEGIN;
INSERT INTO `sec_users_groups` VALUES ('admin', '1'), ('carlos', '2'), ('harry', '2'), ('john', '2'), ('marcia', '2'), ('maria', '2'), ('mark', '2'), ('matheus', '2'), ('paul', '2');
COMMIT;

-- ----------------------------
-- Table structure for tb_activities
-- ----------------------------
CREATE TABLE `tb_activities` (
`activities_id`  int(11) NOT NULL AUTO_INCREMENT ,
`activities_type_id`  int(11) NOT NULL ,
`activities_title`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`deals_id`  int(11) NOT NULL ,
`sellers_id`  int(11) NOT NULL ,
`activities_notes`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`activities_date`  date NULL DEFAULT NULL ,
`activities_time`  time NULL DEFAULT NULL ,
`activities_done`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`activities_id`),
FOREIGN KEY (`activities_type_id`) REFERENCES `tb_activities_type` (`activities_type_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`deals_id`) REFERENCES `tb_deals` (`deals_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`sellers_id`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_activities_tb_activities_type1_idx` (`activities_type_id`) USING BTREE ,
INDEX `fk_tb_activities_tb_deals1_idx` (`deals_id`) USING BTREE ,
INDEX `fk_tb_activities_tb_sellers1_idx` (`sellers_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=105

;

-- ----------------------------
-- Records of tb_activities
-- ----------------------------
BEGIN;
INSERT INTO `tb_activities` VALUES ('1', '2', 'Schedule a presentation', '2', '2', 'Didn\'t answer', '2018-07-26', '10:00:00', 'Y'), ('2', '2', 'Schedule a presentation', '2', '2', 'New try', '2018-07-30', '11:00:00', 'Y'), ('3', '3', 'Meeting', '3', '2', '', '2018-06-14', '16:00:00', 'N'), ('4', '1', 'Write proposal', '7', '2', '', '2018-07-27', '10:00:00', 'N'), ('5', '2', 'Call', '11', '2', '', '2018-07-27', '10:00:00', 'Y'), ('6', '3', 'In Loco', '11', '1', '', '2018-08-20', '14:00:00', 'N'), ('7', '2', 'Call', '8', '2', '', '2018-07-18', '09:00:00', 'Y'), ('8', '2', 'Schedule a presentation', '8', '2', '', '2018-07-20', '10:00:00', 'Y'), ('9', '1', 'Presentation', '8', '2', '', '2018-07-24', '16:00:00', 'N'), ('17', '2', 'Call', '3', '2', '', '2018-06-15', '14:00:00', 'Y'), ('18', '4', 'Email', '3', '2', '', '2018-06-15', '16:00:00', 'Y'), ('19', '5', 'Presentation', '3', '2', '', '2018-06-22', '16:00:00', 'Y'), ('20', '2', 'Call', '1', '2', '', '2018-07-01', '10:00:00', 'Y'), ('21', '4', 'Email', '1', '2', '', '2018-07-01', '12:00:00', 'Y'), ('22', '6', 'Lunch ', '1', '2', '', '2018-07-04', '13:00:00', 'Y'), ('23', '3', 'Meeting', '1', '2', '', '2018-07-10', '16:00:00', 'Y'), ('24', '2', 'Call', '1', '2', '', '2018-07-16', '09:00:00', 'Y'), ('25', '2', 'Call', '1', '2', '', '2018-07-18', '09:00:00', 'N'), ('26', '1', 'Task', '1', '2', '', '2018-07-20', '14:00:00', 'Y'), ('27', '3', 'Meeting', '1', '2', '', '2018-07-31', '10:00:00', 'Y'), ('28', '2', 'Call', '1', '2', '', '2018-08-03', '14:00:00', 'N'), ('29', '4', 'Email', '1', '2', '', '2018-08-09', null, 'N'), ('30', '6', 'Lunch', '1', '2', '', '2018-08-13', '12:00:00', 'N'), ('31', '2', 'Call', '9', '2', '', '2018-07-26', '14:00:00', 'Y'), ('32', '4', 'Email', '9', '2', '', '2018-07-27', '09:00:00', 'Y'), ('33', '2', 'Call', '9', '2', '', '2018-07-30', '16:00:00', 'N'), ('34', '5', 'Presentation', '9', '2', '', '2018-08-01', '16:00:00', 'Y'), ('35', '4', 'Email', '9', '2', '', '2018-08-01', '18:00:00', 'Y'), ('36', '1', 'Task', '9', '2', '', '2018-08-02', '09:00:00', 'Y'), ('37', '6', 'Lunch', '9', '2', '', '2018-08-06', '12:00:00', 'N'), ('38', '2', 'Call', '9', '2', '', '2018-08-17', '16:00:00', 'Y'), ('39', '5', 'Presentation', '9', '2', '', '2018-09-08', '09:00:00', 'N'), ('40', '4', 'Email', '9', '2', '', '2018-08-09', '14:00:00', 'N'), ('41', '2', 'Call', '9', '2', '', '2018-08-17', '10:00:00', 'N'), ('42', '6', 'Lunch', '9', '2', '', '2018-08-20', '12:00:00', 'N'), ('43', '2', 'Call', '17', '3', '', '2018-08-09', '10:00:00', 'Y'), ('44', '4', 'Email', '17', '3', '', '2018-08-13', '14:00:00', 'N'), ('45', '6', 'Lunch', '17', '3', '', '2018-08-14', '12:00:00', 'N'), ('46', '3', 'Meeting', '17', '3', '', '2018-08-14', '14:00:00', 'N'), ('47', '1', 'Task', '17', '3', '', '2018-08-16', '16:00:00', 'N'), ('48', '3', 'Meeting', '17', '3', '', '2018-08-17', '16:00:00', 'N'), ('49', '2', 'Call', '17', '3', '', '2018-08-20', '10:00:00', 'N'), ('50', '4', 'Email', '17', '3', '', '2018-08-20', '14:00:00', 'N'), ('51', '5', 'Presentation', '17', '3', '', '2018-08-22', '16:00:00', 'N'), ('52', '2', 'Call', '6', '2', '', '2018-07-20', '10:00:00', 'Y'), ('53', '4', 'Email', '6', '2', '', '2018-07-20', '14:00:00', 'Y'), ('54', '4', 'Email', '6', '2', '', '2018-07-23', '09:00:00', 'Y'), ('55', '3', 'Meeting', '6', '2', '', '2018-07-26', '10:00:00', 'Y'), ('56', '6', 'Lunch', '6', '2', '', '2018-07-27', '12:00:00', 'Y'), ('57', '2', 'Call', '6', '2', '', '2018-07-30', '10:00:00', 'N'), ('58', '3', 'Meeting', '6', '2', '', '2018-07-31', '14:00:00', 'Y'), ('59', '5', 'Presentation', '6', '2', '', '2018-08-02', '14:00:00', 'Y'), ('60', '2', 'Call', '6', '2', '', '2018-08-03', '09:00:00', 'N'), ('61', '6', 'Lunch', '6', '2', '', '2018-08-10', '12:00:00', 'Y'), ('62', '2', 'Call', '6', '2', '', '2018-08-14', '14:00:00', 'N'), ('63', '3', 'Meeting', '6', '2', '', '2018-08-15', '14:00:00', 'N'), ('64', '1', 'Task', '6', '2', '', '2018-08-15', '16:00:00', 'N'), ('65', '5', 'Presentation', '6', '2', '', '2018-08-17', '14:00:00', 'N'), ('66', '4', 'Email', '6', '2', '', '2018-08-21', '10:00:00', 'N'), ('67', '2', 'Call', '6', '2', '', '2018-08-22', '14:00:00', 'N'), ('68', '2', 'Call', '6', '2', '', '2018-08-23', '10:00:00', 'N'), ('69', '6', 'Lunch', '6', '2', '', '2018-08-24', '12:00:00', 'N'), ('70', '3', 'Meeting', '6', '2', '', '2018-08-27', '14:00:00', 'N'), ('71', '5', 'Presentation', '6', '2', '', '2018-08-29', '16:00:00', 'N'), ('72', '1', 'Task', '6', '2', '', '2018-08-30', '10:00:00', 'N'), ('73', '2', 'Cal', '11', '2', '', '2018-08-30', '10:00:00', 'N'), ('74', '6', 'Lunch', '11', '2', '', '2018-09-12', '12:00:00', 'N'), ('75', '3', 'In Loco', '11', '2', '', '2018-09-19', '16:00:00', 'N'), ('76', '2', 'Call', '11', '2', '', '2018-11-09', '10:00:00', 'N'), ('77', '5', 'Presentation', '11', '2', '', '2018-11-23', '14:00:00', 'N'), ('78', '1', 'Task', '11', '2', '', '2018-12-14', '09:00:00', 'N'), ('79', '3', 'Meeting', '11', '2', '', '2018-12-28', '14:00:00', 'N'), ('80', '2', 'Skype', '10', '1', '', '2018-07-30', '10:00:00', 'Y'), ('81', '4', 'Briefing', '10', '1', '', '2018-07-31', '14:00:00', 'Y'), ('82', '4', 'Email', '10', '3', '', '2018-08-01', '09:00:00', 'Y'), ('83', '6', 'Lunch', '10', '1', '', '2018-08-03', '12:00:00', 'Y'), ('84', '3', 'In Loco', '10', '1', '', '2018-08-03', '14:00:00', 'Y'), ('85', '5', 'Presentation', '10', '1', '', '2018-08-17', '16:00:00', 'N'), ('86', '1', 'Task', '10', '1', '', '2018-08-17', '18:00:00', 'N'), ('87', '4', 'Email', '10', '1', '', '2018-08-20', '10:00:00', 'N'), ('88', '3', 'In Loco', '10', '1', '', '2018-08-22', '14:00:00', 'N'), ('89', '2', 'Call', '10', '2', '', '2018-09-14', '10:00:00', 'N'), ('90', '4', 'Email', '10', '1', '', '2018-09-17', '09:00:00', 'N'), ('91', '3', 'In Loco', '10', '1', '', '2018-10-05', '14:00:00', 'N'), ('92', '4', 'Email', '10', '1', '', '2018-10-17', '09:00:00', 'N'), ('93', '1', 'Task', '10', '1', '', '2018-10-19', '10:00:00', 'N'), ('94', '2', 'Call', '10', '1', '', '2018-10-25', '14:00:00', 'N'), ('95', '3', 'In Loco', '10', '1', '', '2018-10-31', '10:00:00', 'N'), ('96', '14', 'Llamada', '30', '8', '', '2018-08-18', '10:00:00', 'N'), ('97', '16', 'Schedule a presentation', '13', '5', '', '2018-08-16', '15:00:00', 'N'), ('98', '17', 'Presentación', '24', '3', '', '2018-09-22', '10:00:00', 'N'), ('99', '10', 'Proposta', '53', '4', '', '2018-09-20', '10:00:00', 'N'), ('101', '8', 'Aguardando resposta', '39', '4', '', '2018-11-20', '09:00:00', 'N'), ('102', '16', 'Schedule a presentation', '64', '5', '', '2018-08-29', '10:00:00', 'Y'), ('103', '17', 'Presentación', '64', '6', '', '2018-10-10', '10:00:00', 'N'), ('104', '14', 'Call', '25', '4', '', '2018-09-04', '11:00:00', 'N');
COMMIT;

-- ----------------------------
-- Table structure for tb_activities_type
-- ----------------------------
CREATE TABLE `tb_activities_type` (
`activities_type_id`  int(11) NOT NULL AUTO_INCREMENT ,
`activities_type_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`activities_type_lang`  varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`activities_type_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=27

;

-- ----------------------------
-- Records of tb_activities_type
-- ----------------------------
BEGIN;
INSERT INTO `tb_activities_type` VALUES ('1', 'Task', 'en_us'), ('2', 'Call', 'en_us'), ('3', 'Meeting', 'en_us'), ('4', 'Email', 'en_us'), ('5', 'Presentation', 'en_us'), ('6', 'Lunch', 'en_us'), ('7', 'Tarefa', 'pt_br'), ('8', 'Telefonema', 'pt_br'), ('9', 'Reunião', 'pt_br'), ('10', 'E-mail', 'pt_br'), ('11', 'Apresentação', 'pt_br'), ('12', 'Almoço', 'pt_br'), ('13', 'Tarea', 'es'), ('14', 'Llamada', 'es'), ('15', 'Reunión', 'es'), ('16', 'E-mail', 'es'), ('17', 'Presentación', 'es'), ('18', 'Almuerzo', 'es'), ('22', 'Tarea', 'es'), ('26', 'Visita', 'pt_br');
COMMIT;

-- ----------------------------
-- Table structure for tb_contacts
-- ----------------------------
CREATE TABLE `tb_contacts` (
`contact_id`  int(11) NOT NULL AUTO_INCREMENT ,
`organization_id`  int(11) NOT NULL ,
`contact_name`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`contact_title`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`contact_email`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`contact_phone`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`lead_source_id`  int(11) NOT NULL ,
PRIMARY KEY (`contact_id`),
FOREIGN KEY (`lead_source_id`) REFERENCES `tb_lead_source` (`lead_source_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`organization_id`) REFERENCES `tb_organizations` (`organization_id`) ON DELETE CASCADE ON UPDATE CASCADE,
INDEX `fk_tb_contacts_tb_organizations1_idx` (`organization_id`) USING BTREE ,
INDEX `fk_tb_contacts_tb_lead_source1_idx` (`lead_source_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=17

;

-- ----------------------------
-- Records of tb_contacts
-- ----------------------------
BEGIN;
INSERT INTO `tb_contacts` VALUES ('1', '1', 'Victor', 'CIO', '', '', '1'), ('2', '1', 'Laurence', 'CFO', '', '', '3'), ('4', '4', 'Mark Zukemberg', 'Owner', '', '', '2'), ('5', '3', 'Sergey Brin', 'Owner', '', '', '5'), ('6', '3', ' Larry Page', 'Owner', '', '', '5'), ('7', '1', 'Márcia Araújo', 'Sales Manager', '', '', '12'), ('8', '5', 'Thiago', 'Owner', '', '', '8'), ('9', '6', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('10', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('11', '7', 'Federico', 'Sales Director', '', '', '3'), ('12', '8', 'Billy Gate', 'CEO', '', '', '12'), ('13', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8'), ('15', '4', 'Alex Sanchez', 'CFO', '', '', '10'), ('16', '5', 'FRANCISCO RICARDO', 'jdiretor', '', '', '8');
COMMIT;

-- ----------------------------
-- Table structure for tb_contacts_emails
-- ----------------------------
CREATE TABLE `tb_contacts_emails` (
`contacts_emails_id`  int(11) NOT NULL AUTO_INCREMENT ,
`contacts_emails_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`contact_id`  int(11) NOT NULL ,
PRIMARY KEY (`contacts_emails_id`),
FOREIGN KEY (`contact_id`) REFERENCES `tb_contacts` (`contact_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_contacts_emails_tb_contacts1_idx` (`contact_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_contacts_emails
-- ----------------------------
BEGIN;
INSERT INTO `tb_contacts_emails` VALUES ('1', 'vitor@scriptcase.net', '1'), ('2', 'victor@scriptcase.net', '1'), ('3', 'laur@scriptcase.net', '2'), ('5', 'mark@facebook.com', '4'), ('6', 'sergey@gmail.com', '5'), ('7', 'larry@gmail.com', '6'), ('8', 'marcia@scriptcase.net', '7'), ('9', 'marcia@scriptcase.net', '8'), ('10', 'maria@scriptcase.net', '10'), ('11', 'federico@scriptcase.net', '11'), ('12', 'billy@microsoftware.com', '12');
COMMIT;

-- ----------------------------
-- Table structure for tb_contacts_phones
-- ----------------------------
CREATE TABLE `tb_contacts_phones` (
`contacts_phones_id`  int(11) NOT NULL AUTO_INCREMENT ,
`contacts_phones_number`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`contact_id`  int(11) NOT NULL ,
PRIMARY KEY (`contacts_phones_id`),
FOREIGN KEY (`contact_id`) REFERENCES `tb_contacts` (`contact_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_contacs_phones_tb_contacts1_idx` (`contact_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_contacts_phones
-- ----------------------------
BEGIN;
INSERT INTO `tb_contacts_phones` VALUES ('1', '1111222222', '1'), ('2', '1234567890', '1'), ('3', '551112225544', '2'), ('4', '5511444552211', '2'), ('6', '+1333024985', '4'), ('7', '+1556398785', '5'), ('8', '+1325879547', '6'), ('9', '+558154857967', '7'), ('10', '+558518459776', '10'), ('11', '+558123658974', '11'), ('12', '+1-800-925-0609', '12');
COMMIT;

-- ----------------------------
-- Table structure for tb_deal_steps
-- ----------------------------
CREATE TABLE `tb_deal_steps` (
`deal_steps_id`  int(11) NOT NULL AUTO_INCREMENT ,
`deal_steps_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`deal_steps_lang`  varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`deal_steps_order`  int(2) NULL DEFAULT NULL ,
PRIMARY KEY (`deal_steps_id`),
FOREIGN KEY (`deal_steps_lang`) REFERENCES `tb_languages` (`lang_id`) ON DELETE CASCADE ON UPDATE CASCADE,
INDEX `tb_deal_steps_ibfk_1` (`deal_steps_lang`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=16

;

-- ----------------------------
-- Records of tb_deal_steps
-- ----------------------------
BEGIN;
INSERT INTO `tb_deal_steps` VALUES ('1', 'Lead in', 'en_us', '1'), ('2', 'Contact Made', 'en_us', '2'), ('3', 'In Progress', 'en_us', '3'), ('4', 'Proposal Made', 'en_us', '4'), ('5', 'In Negotiation', 'en_us', '5'), ('6', 'Sem Contato', 'pt_br', '1'), ('7', 'Contato Feito', 'pt_br', '2'), ('8', 'Em Progresso', 'pt_br', '3'), ('9', 'Proposta Enviada', 'pt_br', '4'), ('10', 'Em Negociação', 'pt_br', '5'), ('11', 'Sin Contacto', 'es', '1'), ('12', 'Contacto Hecho', 'es', '2'), ('13', 'En Progreso', 'es', '3'), ('14', 'Propuesta Enviada', 'es', '4'), ('15', 'En Negociacion', 'es', '5');
COMMIT;

-- ----------------------------
-- Table structure for tb_deals
-- ----------------------------
CREATE TABLE `tb_deals` (
`deals_id`  int(11) NOT NULL AUTO_INCREMENT ,
`deals_title`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`deal_steps_id`  int(11) NULL DEFAULT NULL ,
`deal_value`  decimal(9,2) NULL DEFAULT NULL ,
`deal_start`  date NULL DEFAULT NULL ,
`deal_end`  date NULL DEFAULT NULL ,
`deal_expected_close`  date NULL DEFAULT NULL ,
`contact_id`  int(11) NULL DEFAULT NULL ,
`owner_seller`  int(11) NULL DEFAULT NULL ,
`deal_evaluation`  int(11) NULL DEFAULT NULL ,
`deal_won`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`deal_lang`  varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`deals_id`),
FOREIGN KEY (`contact_id`) REFERENCES `tb_contacts` (`contact_id`) ON DELETE SET NULL ON UPDATE SET NULL,
FOREIGN KEY (`deal_steps_id`) REFERENCES `tb_deal_steps` (`deal_steps_id`) ON DELETE SET NULL ON UPDATE SET NULL,
FOREIGN KEY (`owner_seller`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE SET NULL ON UPDATE SET NULL,
INDEX `fk_tb_deals_tb_deal_stages1_idx` (`deal_steps_id`) USING BTREE ,
INDEX `fk_tb_deals_tb_contacts1_idx` (`contact_id`) USING BTREE ,
INDEX `fk_tb_deals_tb_sellers1_idx` (`owner_seller`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=66

;

-- ----------------------------
-- Records of tb_deals
-- ----------------------------
BEGIN;
INSERT INTO `tb_deals` VALUES ('1', 'Deal 1', '1', '30000.00', '2018-06-01', null, '2018-08-31', '2', '2', '3', 'O', 'en_us'), ('2', 'Deal 2', '4', '10000.00', '2018-06-25', null, '2018-10-31', '1', '3', '3', 'O', 'en_us'), ('3', 'Deal 3', '2', '5000.00', '2018-06-14', '2018-06-22', '2018-06-22', '1', '1', '3', 'N', 'en_us'), ('6', 'Deal 6', '3', '8000.00', '2018-07-20', null, '2018-08-31', '1', '2', '3', 'O', 'en_us'), ('7', 'Deal 7', '4', '5000.00', '2018-07-23', '2018-08-15', '2018-08-15', '1', '2', '2', 'Y', 'en_us'), ('8', 'Deal 8', '5', '20000.00', '2018-07-16', null, '2018-10-16', '1', '2', '4', 'O', 'en_us'), ('9', 'Deal 9', '1', '10000.00', '2018-07-26', null, '2018-09-10', '1', '2', '3', 'O', 'en_us'), ('10', 'Deal 10', '4', '50000.00', '2018-07-30', null, '2018-10-31', '1', '1', '5', 'O', 'en_us'), ('11', 'New Deal', '3', '10000.00', '2018-07-26', null, '2018-12-21', '1', '2', '3', 'O', 'en_us'), ('12', 'Novo negócio', '9', '100000.00', '2018-08-07', null, '2018-08-08', '2', '2', '3', 'O', 'pt_br'), ('13', 'Negocio', '14', '745.00', '2018-04-07', null, '2018-08-31', '2', '2', '0', 'O', 'es'), ('14', 'Negocio X', '14', '50000.00', '2018-07-09', null, '2018-10-30', '6', '6', '0', 'O', 'es'), ('15', 'Novo Negócio 1', '7', '699.00', '2018-04-09', null, '2018-10-30', '2', '2', '0', 'O', 'pt_br'), ('16', 'Novo Negócio 2', '8', '1995.00', '2018-07-09', '2018-08-21', '2018-08-30', '2', '1', '0', 'Y', 'pt_br'), ('17', 'New Deal 3', '2', '32385.20', '2018-01-09', null, '2018-09-30', '2', '3', '4', 'O', 'en_us'), ('18', 'Novo Negócio 3', '6', '4893.00', '2018-01-13', null, '2019-03-21', '2', '2', '4', 'O', 'pt_br'), ('19', 'Novo Negócio 4', '8', '898.00', '2018-02-13', null, '2019-04-24', '2', '2', '1', 'O', 'pt_br'), ('20', 'Novo Negócio 5', '6', '1990.00', '2018-08-13', null, '2018-09-29', '4', '5', '2', 'O', 'pt_br'), ('21', 'New Deal 3', '1', '5000.00', '2018-07-09', '2018-08-21', '2018-08-30', '2', '4', '3', 'Y', 'en_us'), ('22', 'New Deal 4', '1', '20000.00', '2018-08-13', null, '2018-10-30', '5', '1', '4', 'O', 'en_us'), ('23', 'New license', '4', '699.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'en_us'), ('24', 'Nuevo Negocio 2', '15', '10000.00', '2018-08-14', null, '2018-09-29', '6', '6', '1', 'O', 'es'), ('25', 'Nuevo Negocio 3', '11', '3000.00', '2018-08-14', null, '2019-03-21', '6', '6', '1', 'O', 'es'), ('26', 'Nuevo Negocio 4', '11', '20000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'es'), ('27', 'Nuevo Negocio 5', '13', '5000.00', '2018-08-14', null, '2018-12-21', '6', '6', '2', 'O', 'es'), ('29', 'Negocio', '12', '13000.00', '2018-08-01', null, '2018-12-21', '6', '6', '4', 'O', 'es'), ('30', 'Negocio Teste', '12', '699.00', '2018-08-14', null, '2018-08-31', '7', '6', '4', 'O', 'es'), ('32', 'Nueva oportunidad 3', '11', '30000.00', '2018-08-20', null, '2019-03-21', '2', '4', '3', 'O', 'es'), ('37', 'Nova oportunidade 6', '9', '2000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'pt_br'), ('38', 'Nova oportunidade 7', '10', '2000.00', '2018-01-21', '2018-03-20', '2018-03-30', '2', '6', '3', 'Y', 'pt_br'), ('39', 'Nova oportunidade 8', '10', '10000.00', '2018-08-21', null, '2018-11-30', '2', '4', '3', 'O', 'pt_br'), ('40', 'Nova oportunidade 3', '10', '3000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'pt_br'), ('42', 'Nova oportunidade 7', '7', '20000.00', '2018-08-21', null, '2018-08-31', null, null, null, 'O', 'pt_br'), ('44', 'Nova oportunidade 8', '8', '5000.00', '2018-05-14', '2018-05-23', '2018-05-03', '5', '2', '3', 'Y', 'pt_br'), ('46', 'Nova oportunidade 9', '10', '13000.00', '2018-08-01', '2018-08-08', '2018-08-17', '8', '6', '0', 'N', 'es'), ('48', 'Nova oportunidade 9', '10', '699.00', '2017-11-01', '2017-12-13', '2017-11-30', '9', '6', '1', 'Y', 'pt_br'), ('49', 'Nova oportunidade 6', '10', '30000.00', '2017-12-22', '2018-01-21', '2018-01-21', '8', '6', '0', 'Y', 'pt_br'), ('50', 'Nova oportunidade 7', '8', '45000.00', '2018-04-10', '2018-06-20', '2018-06-20', '12', '6', '0', 'Y', 'pt_br'), ('51', 'Nova oportunidade 8', '6', '8000.00', '2018-08-01', '2018-08-08', '2018-08-17', '8', '6', '0', 'N', 'pt_br'), ('52', 'Nova oportunidade 5', '6', '5000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'pt_br'), ('53', 'Nova oportunidade 6', '8', '20000.00', '2018-08-22', null, '2018-09-30', '8', '6', '0', 'O', 'pt_br'), ('54', 'Nova oportunidade 7', '9', '10000.00', '2018-06-01', '2018-06-30', '2018-06-20', '7', '1', '3', 'N', 'en_us'), ('55', 'Nova oportunidade 7', '9', '10000.00', '2018-05-01', '2018-06-05', '2018-06-12', '12', '6', '0', 'Y', 'pt_br'), ('59', 'Nova oportunidade 5', '10', '2000.00', '2018-08-23', null, '2018-11-30', '12', '8', '0', 'O', 'pt_br'), ('61', 'Nova oportunidade 7', '8', '10000.00', '2018-08-23', null, '2018-08-23', '15', '8', '3', 'O', 'pt_br'), ('64', 'Nueva oportunidad 3', '12', '50000.00', '2018-08-29', null, '2018-08-29', '2', '4', '5', 'O', 'es'), ('65', 'Nueva oportunidad 4', '11', '50000.00', '2018-08-29', null, '2018-12-15', '4', '4', '5', 'O', 'es');
COMMIT;

-- ----------------------------
-- Table structure for tb_deals_x_products
-- ----------------------------
CREATE TABLE `tb_deals_x_products` (
`deals_id`  int(11) NOT NULL ,
`product_id`  int(11) NOT NULL ,
`unit_value`  decimal(9,2) NULL DEFAULT NULL ,
`qty`  int(5) NULL DEFAULT NULL ,
`discount`  decimal(9,2) NULL DEFAULT NULL ,
`total_value`  decimal(9,2) NULL DEFAULT NULL ,
PRIMARY KEY (`deals_id`, `product_id`),
FOREIGN KEY (`deals_id`) REFERENCES `tb_deals` (`deals_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`product_id`) REFERENCES `tb_products` (`product_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_deals_has_tb_products_tb_products1_idx` (`product_id`) USING BTREE ,
INDEX `fk_tb_deals_has_tb_products_tb_deals1_idx` (`deals_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_deals_x_products
-- ----------------------------
BEGIN;
INSERT INTO `tb_deals_x_products` VALUES ('1', '1', '10000.00', '1', '1000.00', '9000.00'), ('1', '2', '10000.00', '1', '2000.00', '8000.00'), ('1', '3', '12000.00', '1', '2000.00', '10000.00'), ('1', '4', '5000.00', '1', '2000.00', '3000.00'), ('2', '1', '399.00', '10', '0.00', '3990.00'), ('2', '2', '5000.00', '1', '0.00', '5000.00'), ('2', '3', '99.00', '8', '400.00', '392.00'), ('2', '4', '699.00', '1', '0.00', '699.00'), ('3', '1', '3000.00', '1', '0.00', '3000.00'), ('3', '2', '1000.00', '1', '0.00', '1000.00'), ('3', '3', '500.00', '1', '0.00', '500.00'), ('3', '4', '500.00', '1', '0.00', '500.00'), ('6', '1', '1000.00', '1', '200.00', '800.00'), ('6', '2', '400.00', '1', '200.00', '200.00'), ('6', '3', '2000.00', '1', '1000.00', '1000.00'), ('6', '4', '3000.00', '1', '0.00', '3000.00'), ('9', '1', '5000.00', '1', '0.00', '5000.00'), ('9', '2', '4000.00', '1', '0.00', '4000.00'), ('9', '3', '1000.00', '1', '0.00', '1000.00'), ('10', '1', '399.00', '22', '0.00', '8778.00'), ('10', '2', '25000.00', '1', '0.00', '25000.00'), ('10', '3', '99.00', '10', '0.00', '990.00'), ('10', '4', '699.00', '22', '0.00', '15378.00'), ('11', '1', '399.00', '2', '0.00', '798.00'), ('11', '2', '2000.00', '1', '0.00', '2000.00'), ('11', '3', '99.00', '3', '0.00', '297.00'), ('11', '4', '699.00', '10', '0.00', '6990.00'), ('13', '8', '149.00', '5', '0.00', '745.00'), ('15', '4', '699.00', '1', '0.00', '699.00'), ('16', '1', '399.00', '5', '0.00', '1995.00'), ('17', '1', '399.00', '15', '85.00', '5900.00'), ('17', '2', '1199.00', '15', '2985.00', '15000.00'), ('17', '3', '99.00', '15', '0.00', '1485.00'), ('17', '4', '699.00', '15', '485.00', '10000.00'), ('18', '4', '699.00', '7', '0.00', '4893.00'), ('19', '2', '199.00', '1', '0.00', '199.00'), ('19', '4', '699.00', '1', '0.00', '699.00'), ('20', '2', '199.00', '10', '0.00', '1990.00'), ('25', '7', '125.00', '1', '0.00', '125.00');
COMMIT;

-- ----------------------------
-- Table structure for tb_emails
-- ----------------------------
CREATE TABLE `tb_emails` (
`email_id`  int(11) NOT NULL AUTO_INCREMENT ,
`deals_id`  int(11) NOT NULL ,
`sellers_id`  int(11) NOT NULL ,
`email_sent`  date NULL DEFAULT NULL ,
`email_from`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email_to`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email_cc`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email_bcc`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email_subject`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email_body`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`email_id`),
FOREIGN KEY (`deals_id`) REFERENCES `tb_deals` (`deals_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`sellers_id`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_emails_tb_deals1_idx` (`deals_id`) USING BTREE ,
INDEX `fk_tb_emails_tb_sellers1_idx` (`sellers_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=1

;

-- ----------------------------
-- Records of tb_emails
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for tb_files
-- ----------------------------
CREATE TABLE `tb_files` (
`files_id`  int(11) NOT NULL AUTO_INCREMENT ,
`files_name`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`deals_id`  int(11) NOT NULL ,
`files_binary`  blob NULL ,
`login`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`files_id`),
FOREIGN KEY (`deals_id`) REFERENCES `tb_deals` (`deals_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_files_tb_deals1_idx` (`deals_id`) USING BTREE ,
INDEX `fk_tb_files_tb_sellers1_idx` (`login`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=1

;

-- ----------------------------
-- Records of tb_files
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for tb_languages
-- ----------------------------
CREATE TABLE `tb_languages` (
`lang_id`  varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`lang_descr`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`lang_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_languages
-- ----------------------------
BEGIN;
INSERT INTO `tb_languages` VALUES ('en_us', 'English'), ('es', 'Español'), ('pt_br', 'Português');
COMMIT;

-- ----------------------------
-- Table structure for tb_lead_source
-- ----------------------------
CREATE TABLE `tb_lead_source` (
`lead_source_id`  int(11) NOT NULL AUTO_INCREMENT ,
`lead_source_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`lead_source_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_lead_source
-- ----------------------------
BEGIN;
INSERT INTO `tb_lead_source` VALUES ('1', 'Website'), ('2', 'Social Media'), ('3', 'Email Marketing'), ('4', 'Event'), ('5', 'Paid Ads'), ('6', 'Organic Search'), ('7', 'Blogs'), ('8', 'Affiliate / Partner Programs'), ('9', 'Inbound Phone Calls'), ('10', 'Outbound Sales'), ('11', 'Referrals'), ('12', 'Personal Network');
COMMIT;

-- ----------------------------
-- Table structure for tb_organization_fields
-- ----------------------------
CREATE TABLE `tb_organization_fields` (
`organization_fields_id`  int(11) NOT NULL AUTO_INCREMENT ,
`organization_fields_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`organization_fields_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tb_organization_fields
-- ----------------------------
BEGIN;
INSERT INTO `tb_organization_fields` VALUES ('1', 'IT'), ('2', 'Marketing'), ('3', 'Financing'), ('4', 'Bank');
COMMIT;

-- ----------------------------
-- Table structure for tb_organizations
-- ----------------------------
CREATE TABLE `tb_organizations` (
`organization_id`  int(11) NOT NULL AUTO_INCREMENT ,
`organization_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`organization_fields_id`  int(11) NOT NULL ,
`organization_address`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`organization_city`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`organization_country`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`organization_owner`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`organization_id`),
FOREIGN KEY (`organization_fields_id`) REFERENCES `tb_organization_fields` (`organization_fields_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`organization_owner`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_organizations_tb_oragnization_fields_idx` (`organization_fields_id`) USING BTREE ,
INDEX `organization_owner` (`organization_owner`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=9

;

-- ----------------------------
-- Records of tb_organizations
-- ----------------------------
BEGIN;
INSERT INTO `tb_organizations` VALUES ('1', 'Netmake', '1', 'Kennedy 1001, Olinda-PE', null, 'BRA', '1'), ('2', 'Test Company', '2', 'Centro, Recife-PE', null, 'BRA', '1'), ('3', 'Coogle LLC', '1', 'Menlo Park, Califórnia', null, 'USA', '3'), ('4', 'MasterCompany', '1', 'Cambridge, Massachusetts, EUA', null, 'USA', '3'), ('5', 'Mapple', '1', 'RUA MAXIMINO CAMARGO N° 137, BARRA MANSA', null, 'BRA', '4'), ('6', 'Ramazon', '1', 'Fifth Avenue,105', null, 'USA', '2'), ('7', 'Scriptcase inc. ', '1', 'Rua Professor Otávio de Freitas, 256', null, 'BRA', '8'), ('8', 'Microsoftware', '1', '231 Good Hope Ave. ', 'Palo Alto', 'USA', '3');
COMMIT;

-- ----------------------------
-- Table structure for tb_organizations_x_sellers
-- ----------------------------
CREATE TABLE `tb_organizations_x_sellers` (
`organization_id`  int(11) NOT NULL ,
`sellers_id`  int(11) NOT NULL ,
PRIMARY KEY (`organization_id`, `sellers_id`),
FOREIGN KEY (`organization_id`) REFERENCES `tb_organizations` (`organization_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`sellers_id`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_organizations_has_tb_sellers_tb_sellers1_idx` (`sellers_id`) USING BTREE ,
INDEX `fk_tb_organizations_has_tb_sellers_tb_organizations1_idx` (`organization_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_organizations_x_sellers
-- ----------------------------
BEGIN;
INSERT INTO `tb_organizations_x_sellers` VALUES ('1', '2'), ('3', '2'), ('4', '2'), ('4', '5'), ('6', '4'), ('6', '6'), ('7', '4'), ('7', '5');
COMMIT;

-- ----------------------------
-- Table structure for tb_participants
-- ----------------------------
CREATE TABLE `tb_participants` (
`sellers_id`  int(11) NOT NULL ,
`deals_id`  int(11) NOT NULL ,
PRIMARY KEY (`sellers_id`, `deals_id`),
FOREIGN KEY (`deals_id`) REFERENCES `tb_deals` (`deals_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`sellers_id`) REFERENCES `tb_sellers` (`sellers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_sellers_has_tb_deals_tb_deals1_idx` (`deals_id`) USING BTREE ,
INDEX `fk_tb_sellers_has_tb_deals_tb_sellers1_idx` (`sellers_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_participants
-- ----------------------------
BEGIN;
INSERT INTO `tb_participants` VALUES ('1', '2'), ('1', '11'), ('1', '13'), ('1', '29'), ('2', '3'), ('2', '16'), ('2', '29'), ('3', '10'), ('3', '13'), ('3', '16'), ('3', '29'), ('4', '29'), ('5', '29'), ('7', '29'), ('8', '13'), ('8', '29');
COMMIT;

-- ----------------------------
-- Table structure for tb_products
-- ----------------------------
CREATE TABLE `tb_products` (
`product_id`  int(11) NOT NULL AUTO_INCREMENT ,
`product_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`product_price`  decimal(9,2) NOT NULL ,
PRIMARY KEY (`product_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_products
-- ----------------------------
BEGIN;
INSERT INTO `tb_products` VALUES ('1', 'Scriptcase PE', '399.00'), ('2', 'Scriptcase BI', '199.00'), ('3', 'Tech Support Plan', '99.00'), ('4', 'Scriptcase Lifetime License', '999.00'), ('5', 'Scriptcase Annual Subscription', '599.00'), ('6', 'Hosting Plan', '59.00'), ('7', 'Consulting hour', '125.00'), ('8', 'Online course', '149.00'), ('9', 'On demand course', '49.00'), ('10', 'Dedicated Server', '99.00'), ('11', 'VPS hoost CLOUD', '59.00'), ('12', 'VPS Set up', '50.00');
COMMIT;

-- ----------------------------
-- Table structure for tb_sellers
-- ----------------------------
CREATE TABLE `tb_sellers` (
`sellers_id`  int(11) NOT NULL AUTO_INCREMENT ,
`sellers_name`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`login`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`sellers_email`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`sellers_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=9

;

-- ----------------------------
-- Records of tb_sellers
-- ----------------------------
BEGIN;
INSERT INTO `tb_sellers` VALUES ('1', 'Matheus', 'matheus', 'mts@scriptcase.net'), ('2', 'John', 'john', 'john@scriptcase.net'), ('3', 'Mark', 'mark', 'mark@scriptcase.net'), ('4', 'Marcia', 'marcia', 'marcia@scriptcase.net'), ('5', 'Maria', 'maria', 'maria@scriptcase.net'), ('6', 'Carlos', 'carlos', 'carlos@scriptcase.net'), ('7', 'Paul', 'paul', 'paul@scriptcase.net'), ('8', 'Harry', 'harry', 'harry@scriptcase.net');
COMMIT;

-- ----------------------------
-- Table structure for tbl_mandrill_emails
-- ----------------------------
CREATE TABLE `tbl_mandrill_emails` (
`id`  int(11) NOT NULL AUTO_INCREMENT ,
`email`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=1

;

-- ----------------------------
-- Records of tbl_mandrill_emails
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for tbl_mandrill_groups
-- ----------------------------
CREATE TABLE `tbl_mandrill_groups` (
`id`  int(11) NOT NULL AUTO_INCREMENT ,
`group_name`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=1

;

-- ----------------------------
-- Records of tbl_mandrill_groups
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for tbl_mandrill_info
-- ----------------------------
CREATE TABLE `tbl_mandrill_info` (
`id`  int(11) NOT NULL AUTO_INCREMENT ,
`api_key`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=1

;

-- ----------------------------
-- Records of tbl_mandrill_info
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for tbl_mandrill_templates
-- ----------------------------
CREATE TABLE `tbl_mandrill_templates` (
`id`  int(11) NOT NULL AUTO_INCREMENT ,
`template_name`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`slug_name`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`from_email`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`from_name`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`subject`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`publish`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`labels`  varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`msgcode`  longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`msgtext`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=3

;

-- ----------------------------
-- Records of tbl_mandrill_templates
-- ----------------------------
BEGIN;
INSERT INTO `tbl_mandrill_templates` VALUES ('1', 'Welcome email', '', 'sales@myorganization.com', 'Mark', 'Welcome to our community!', '0', '3', '<p>test email</p>', ''), ('2', 'Announcement', '', 'sales@scriptcase.net', 'Sales Department', 'New version', '1', '', '<p style=\"text-align: center;\"><strong>Announcement of New Version</strong></p>\n<p style=\"text-align: center;\"> </p>\n<p style=\"text-align: left;\">There is a new version released!</p>', 'Announcement of New Version');
COMMIT;

-- ----------------------------
-- Auto increment value for sec_groups
-- ----------------------------
ALTER TABLE `sec_groups` AUTO_INCREMENT=3;

-- ----------------------------
-- Auto increment value for tb_activities
-- ----------------------------
ALTER TABLE `tb_activities` AUTO_INCREMENT=105;

-- ----------------------------
-- Auto increment value for tb_activities_type
-- ----------------------------
ALTER TABLE `tb_activities_type` AUTO_INCREMENT=27;

-- ----------------------------
-- Auto increment value for tb_contacts
-- ----------------------------
ALTER TABLE `tb_contacts` AUTO_INCREMENT=17;

-- ----------------------------
-- Auto increment value for tb_contacts_emails
-- ----------------------------
ALTER TABLE `tb_contacts_emails` AUTO_INCREMENT=13;

-- ----------------------------
-- Auto increment value for tb_contacts_phones
-- ----------------------------
ALTER TABLE `tb_contacts_phones` AUTO_INCREMENT=13;

-- ----------------------------
-- Auto increment value for tb_deal_steps
-- ----------------------------
ALTER TABLE `tb_deal_steps` AUTO_INCREMENT=16;

-- ----------------------------
-- Auto increment value for tb_deals
-- ----------------------------
ALTER TABLE `tb_deals` AUTO_INCREMENT=66;

-- ----------------------------
-- Auto increment value for tb_emails
-- ----------------------------
ALTER TABLE `tb_emails` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for tb_files
-- ----------------------------
ALTER TABLE `tb_files` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for tb_lead_source
-- ----------------------------
ALTER TABLE `tb_lead_source` AUTO_INCREMENT=13;

-- ----------------------------
-- Auto increment value for tb_organization_fields
-- ----------------------------
ALTER TABLE `tb_organization_fields` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tb_organizations
-- ----------------------------
ALTER TABLE `tb_organizations` AUTO_INCREMENT=9;

-- ----------------------------
-- Auto increment value for tb_products
-- ----------------------------
ALTER TABLE `tb_products` AUTO_INCREMENT=13;

-- ----------------------------
-- Auto increment value for tb_sellers
-- ----------------------------
ALTER TABLE `tb_sellers` AUTO_INCREMENT=9;

-- ----------------------------
-- Auto increment value for tbl_mandrill_emails
-- ----------------------------
ALTER TABLE `tbl_mandrill_emails` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for tbl_mandrill_groups
-- ----------------------------
ALTER TABLE `tbl_mandrill_groups` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for tbl_mandrill_info
-- ----------------------------
ALTER TABLE `tbl_mandrill_info` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for tbl_mandrill_templates
-- ----------------------------
ALTER TABLE `tbl_mandrill_templates` AUTO_INCREMENT=3;



-- ----------------------------
-- New Security Module
-- ----------------------------

INSERT INTO `sec_apps` VALUES ('app_settings',	'contr',	'Security Application');

INSERT INTO `sec_groups_apps` VALUES ('1',	'app_settings',	'Y',	'Y',	'Y',	'Y',	'Y',	'Y');
INSERT INTO `sec_groups_apps` VALUES ('2',	'app_settings',	'N',	'N',	'N',	'N',	'N',	'N');

CREATE TABLE `sec_settings` (
    `set_name` varchar(255) NOT NULL,
    `set_value` varchar(255) NULL,
    PRIMARY KEY (`set_name`)
);

INSERT INTO `sec_settings` VALUES ('session_expire',	'M');
INSERT INTO `sec_settings` VALUES ('remember_me',	'Y');
INSERT INTO `sec_settings` VALUES ('cookie_expiration_time',	'30');
INSERT INTO `sec_settings` VALUES ('retrieve_password',	'Y');
INSERT INTO `sec_settings` VALUES ('new_users',	'Y');
INSERT INTO `sec_settings` VALUES ('brute_force',	'Y');
INSERT INTO `sec_settings` VALUES ('brute_force_time_block',	'10');
INSERT INTO `sec_settings` VALUES ('brute_force_attempts',	'10');
INSERT INTO `sec_settings` VALUES ('enable_2fa',	'Y');
INSERT INTO `sec_settings` VALUES ('enable_2fa_expiration_time',	'300');